/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers.operation;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.AnchorURL;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.ResponseHeader;
import net.yacy.cora.storage.Files;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.retrieval.Request;
import net.yacy.crawler.retrieval.Response;
import net.yacy.document.Document;
import net.yacy.document.parser.tarParser;
import net.yacy.kelondro.io.CharBuffer;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.OS;
import net.yacy.peers.Network;
import net.yacy.peers.operation.yacyUpdateLocation;
import net.yacy.peers.operation.yacyVersion;
import net.yacy.search.Switchboard;
import net.yacy.server.serverCore;
import net.yacy.utils.CryptoLib;
import net.yacy.utils.SignatureOutputStream;
import net.yacy.utils.tarTools;

public final class yacyRelease
extends yacyVersion {
    private static Map<yacyUpdateLocation, DevAndMainVersions> latestReleases = new ConcurrentHashMap<yacyUpdateLocation, DevAndMainVersions>();
    public static final List<yacyUpdateLocation> latestReleaseLocations = new ArrayList<yacyUpdateLocation>();
    public static String startParameter = "";
    private MultiProtocolURL url;
    private File releaseFile;
    private PublicKey publicKey;

    public yacyRelease(MultiProtocolURL url) {
        super(url.getFileName(), url.getHost());
        this.url = url;
    }

    private yacyRelease(MultiProtocolURL url, PublicKey publicKey) {
        this(url);
        this.publicKey = publicKey;
    }

    public yacyRelease(File releaseFile) {
        super(releaseFile.getName(), null);
        this.releaseFile = releaseFile;
    }

    public MultiProtocolURL getUrl() {
        return this.url;
    }

    public static final yacyRelease rulebasedUpdateInfo(boolean manual) {
        Switchboard sb = Switchboard.getSwitchboard();
        String process = sb.getConfig("update.process", "manual");
        if (!manual && !process.equals("auto")) {
            Network.log.info("rulebasedUpdateInfo: not an automatic update selected");
            return null;
        }
        long cycle = Math.max(1L, sb.getConfigLong("update.cycle", 168L)) * 60L * 60L * 1000L;
        long timeLookup = sb.getConfigLong("update.time.lookup", System.currentTimeMillis());
        if (!manual && timeLookup + cycle > System.currentTimeMillis()) {
            Network.log.info("rulebasedUpdateInfo: too early for a lookup for a new release (timeLookup = " + timeLookup + ", cycle = " + cycle + ", now = " + System.currentTimeMillis() + ")");
            return null;
        }
        DevAndMainVersions releases = yacyRelease.allReleases(true, sb.getConfig("update.onlySignedFiles", "1").equals("1"));
        yacyRelease latestmain = releases.main.isEmpty() ? null : releases.main.last();
        yacyRelease latestdev = releases.dev.isEmpty() ? null : releases.dev.last();
        String concept = sb.getConfig("update.concept", "any");
        String blacklist = sb.getConfig("update.blacklist", "");
        if (manual || concept.equals("any")) {
            if (!(latestdev == null || latestmain != null && latestdev.compareTo(latestmain) <= 0 || Double.toString(latestdev.getReleaseNr()).matches(blacklist))) {
                if (latestdev.compareTo(yacyRelease.thisVersion()) <= 0) {
                    Network.log.info("rulebasedUpdateInfo: latest dev " + latestdev.getName() + " is not more recent than installed release " + yacyRelease.thisVersion().getName());
                    return null;
                }
                return latestdev;
            }
            if (latestmain != null) {
                if (Double.toString(latestmain.getReleaseNr()).matches(blacklist)) {
                    Network.log.info("rulebasedUpdateInfo: latest dev " + (latestdev == null ? "null" : latestdev.getName()) + " matches with blacklist '" + blacklist + "'");
                    return null;
                }
                if (latestmain.compareTo(yacyRelease.thisVersion()) <= 0) {
                    Network.log.info("rulebasedUpdateInfo: latest main " + latestmain.getName() + " is not more recent than installed release (1) " + yacyRelease.thisVersion().getName());
                    return null;
                }
                return latestmain;
            }
        }
        if (concept.equals("main") && latestmain != null) {
            if (Double.toString(latestmain.getReleaseNr()).matches(blacklist)) {
                Network.log.info("rulebasedUpdateInfo: latest main " + latestmain.getName() + " matches with blacklist'" + blacklist + "'");
                return null;
            }
            if (latestmain.compareTo(yacyRelease.thisVersion()) <= 0) {
                Network.log.info("rulebasedUpdateInfo: latest main " + latestmain.getName() + " is not more recent than installed release (2) " + yacyRelease.thisVersion().getName());
                return null;
            }
            return latestmain;
        }
        Network.log.info("rulebasedUpdateInfo: failed to find more recent release");
        return null;
    }

    public static DevAndMainVersions allReleases(boolean force, boolean onlySigned) {
        TreeSet<yacyRelease> alldev = new TreeSet<yacyRelease>();
        TreeSet<yacyRelease> allmain = new TreeSet<yacyRelease>();
        for (yacyUpdateLocation updateLocation : latestReleaseLocations) {
            if (onlySigned && updateLocation.getPublicKey() == null) continue;
            DevAndMainVersions versions = yacyRelease.getReleases(updateLocation, force);
            if (versions != null && versions.dev != null) {
                alldev.addAll(versions.dev);
            }
            if (versions == null || versions.main == null) continue;
            allmain.addAll(versions.main);
        }
        return new DevAndMainVersions(alldev, allmain);
    }

    private static DevAndMainVersions getReleases(yacyUpdateLocation location, boolean force) {
        DevAndMainVersions locLatestRelease = latestReleases.get(location);
        if ((force || locLatestRelease == null) && (locLatestRelease = yacyRelease.allReleaseFrom(location)) != null) {
            latestReleases.put(location, locLatestRelease);
        }
        return locLatestRelease;
    }

    private static DevAndMainVersions allReleaseFrom(yacyUpdateLocation location) {
        Document scraper;
        String initialThreadName = Thread.currentThread().getName();
        try {
            DigestURL uri = location.getLocationURL();
            Thread.currentThread().setName("allReleaseFrom - host " + uri.getHost());
            scraper = Switchboard.getSwitchboard().loader.loadDocument(uri, CacheStrategy.NOCACHE, null, ClientIdentification.yacyInternetCrawlerAgent);
        }
        catch (IOException e) {
            Thread.currentThread().setName(initialThreadName);
            return null;
        }
        Collection<AnchorURL> anchors = scraper.getAnchors();
        TreeSet<yacyRelease> mainReleases = new TreeSet<yacyRelease>();
        TreeSet<yacyRelease> devReleases = new TreeSet<yacyRelease>();
        for (DigestURL digestURL : anchors) {
            try {
                yacyRelease release = new yacyRelease(digestURL, location.getPublicKey());
                if (release.isMainRelease()) {
                    mainReleases.add(release);
                    continue;
                }
                devReleases.add(release);
            }
            catch (RuntimeException e) {}
        }
        Switchboard.getSwitchboard().setConfig("update.time.lookup", System.currentTimeMillis());
        Thread.currentThread().setName(initialThreadName);
        return new DevAndMainVersions(devReleases, mainReleases);
    }

    public File downloadRelease() {
        File storagePath = Switchboard.getSwitchboard().releasePath;
        File download = null;
        String name = this.getUrl().getFileName();
        byte[] signatureBytes = null;
        try {
            FileOutputStream fileOutStream;
            Response response;
            Request request;
            if (this.publicKey != null) {
                request = Switchboard.getSwitchboard().loader.request(new DigestURL(this.getUrl().toString() + ".sig"), true, false);
                response = Switchboard.getSwitchboard().loader.load(request, CacheStrategy.NOCACHE, Integer.MAX_VALUE, null, ClientIdentification.yacyInternetCrawlerAgent);
                byte[] signatureData = null;
                if (response != null && response.validResponseStatus()) {
                    signatureData = response.getContent();
                }
                if (signatureData == null) {
                    ConcurrentLog.warn("yacyVersion", "download of signature " + this.getUrl().toString() + " failed. ignoring signature file.");
                } else {
                    signatureBytes = Base64Order.standardCoder.decode(UTF8.String(signatureData).trim());
                }
            }
            if ((response = Switchboard.getSwitchboard().loader.load(request = Switchboard.getSwitchboard().loader.request(new DigestURL(this.getUrl().toString()), true, false), CacheStrategy.NOCACHE, Integer.MAX_VALUE, null, ClientIdentification.yacyInternetCrawlerAgent)) == null) {
                throw new IOException("Could not get a response");
            }
            if (!response.validResponseStatus()) {
                throw new IOException("HTTP response status code : " + response.getStatus());
            }
            ResponseHeader header = response.getResponseHeader();
            boolean unzipped = header.gzip() && header.mime().toLowerCase(Locale.ROOT).equals("application/x-tar");
            download = unzipped && name.endsWith(".tar.gz") ? new File(storagePath, name.substring(0, name.length() - 3)) : new File(storagePath, name);
            if (this.publicKey != null && signatureBytes != null) {
                try {
                    fileOutStream = new FileOutputStream(download);
                    try (SignatureOutputStream verifyOutput = new SignatureOutputStream(fileOutStream, "SHA1withDSA", this.publicKey);
                         BufferedOutputStream bufferedStream = new BufferedOutputStream(verifyOutput);){
                        FileUtils.copy(response.getContent(), (OutputStream)bufferedStream);
                        if (!verifyOutput.verify(signatureBytes)) {
                            throw new IOException("Bad Signature!");
                        }
                    }
                    finally {
                        fileOutStream.close();
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException("No such algorithm");
                }
                catch (SignatureException e) {
                    throw new IOException("Signature exception");
                }
                File signatureFile = new File(download.getAbsoluteFile() + ".sig");
                FileUtils.copy(UTF8.getBytes(Base64Order.standardCoder.encode(signatureBytes)), signatureFile);
                if (!signatureFile.exists() || signatureFile.length() == 0L) {
                    throw new IOException("create signature file failed");
                }
            } else {
                fileOutStream = new FileOutputStream(download);
                try (BufferedOutputStream downloadOutStream = new BufferedOutputStream(fileOutStream);){
                    FileUtils.copy(response.getContent(), (OutputStream)downloadOutStream);
                }
                finally {
                    fileOutStream.close();
                }
            }
            if (!download.exists() || download.length() == 0L) {
                throw new IOException("wget of url " + this.getUrl() + " failed");
            }
            if (download.getName().endsWith("tar.gz") && tarParser.isTar(download)) {
                String ts = download.getAbsoluteFile().toString();
                File tar = new File(ts.substring(0, ts.length() - 3));
                download.renameTo(tar);
                download = tar;
            }
        }
        catch (IOException e) {
            ConcurrentLog.severe("yacyVersion", "download of " + this.getName() + " failed: " + e.getMessage());
            if (download != null && download.exists()) {
                FileUtils.deletedelete(download);
                if (download.exists()) {
                    ConcurrentLog.warn("yacyVersion", "could not delete file " + download);
                }
            }
            download = null;
        }
        this.releaseFile = download;
        Switchboard.getSwitchboard().setConfig("update.time.download", System.currentTimeMillis());
        return this.releaseFile;
    }

    public boolean checkSignature() {
        if (this.releaseFile != null) {
            try {
                CharBuffer signBuffer = new CharBuffer(this.getSignatureFile());
                byte[] signByteBuffer = Base64Order.standardCoder.decode(signBuffer.toString().trim());
                signBuffer.close();
                CryptoLib cl2 = new CryptoLib();
                for (yacyUpdateLocation updateLocation : latestReleaseLocations) {
                    try {
                        if (!cl2.verifySignature(updateLocation.getPublicKey(), new FileInputStream(this.releaseFile), signByteBuffer)) continue;
                        return true;
                    }
                    catch (InvalidKeyException invalidKeyException) {
                    }
                    catch (SignatureException signatureException) {
                    }
                }
            }
            catch (IOException iOException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return false;
    }

    public static void restart() {
        Switchboard sb = Switchboard.getSwitchboard();
        if (OS.isWindows) {
            File startType = new File(sb.getDataPath(), "DATA/yacy.noconsole".replace("/", File.separator));
            String starterFile = "startYACY_debug.bat";
            if (startType.exists()) {
                starterFile = "startYACY.bat";
            }
            if (startParameter.startsWith("-gui")) {
                starterFile = starterFile + " " + startParameter;
            }
            try {
                ConcurrentLog.info("RESTART", "INITIATED");
                String script = "@echo off" + serverCore.CRLF_STRING + "title YaCy restarter" + serverCore.CRLF_STRING + "set loading=YACY RESTARTER" + serverCore.CRLF_STRING + "echo %loading%" + serverCore.CRLF_STRING + "cd \"" + sb.getDataPath().toString() + "/DATA/RELEASE/".replace("/", File.separator) + "\"" + serverCore.CRLF_STRING + ":WAIT" + serverCore.CRLF_STRING + "set loading=%loading%." + serverCore.CRLF_STRING + "cls" + serverCore.CRLF_STRING + "echo %loading%" + serverCore.CRLF_STRING + "ping -n 2 127.0.0.1 >nul" + serverCore.CRLF_STRING + "IF exist ..\\yacy.running goto WAIT" + serverCore.CRLF_STRING + "cd \"" + sb.getAppPath().toString() + "\"" + serverCore.CRLF_STRING + "start /MIN CMD /C " + starterFile + serverCore.CRLF_STRING;
                File scriptFile = new File(sb.getDataPath(), "DATA/RELEASE/restart.bat".replace("/", File.separator));
                OS.deployScript(scriptFile, script);
                ConcurrentLog.info("RESTART", "wrote restart-script to " + scriptFile.getAbsolutePath());
                OS.execAsynchronous(scriptFile);
                ConcurrentLog.info("RESTART", "script is running");
                sb.terminate(10L, "windows restart");
            }
            catch (IOException e) {
                ConcurrentLog.severe("RESTART", "restart failed", e);
            }
        }
        if (OS.canExecUnix) {
            try {
                ConcurrentLog.info("RESTART", "INITIATED");
                String script = "#!/bin/sh" + serverCore.LF_STRING + "cd " + sb.getDataPath() + "/DATA/RELEASE/" + serverCore.LF_STRING + "while [ -f ../yacy.running ]; do" + serverCore.LF_STRING + "sleep 1" + serverCore.LF_STRING + "done" + serverCore.LF_STRING + "cd " + sb.getAppPath() + serverCore.LF_STRING + "nohup ./startYACY.sh " + (startParameter.startsWith("-gui") ? startParameter : "") + " > /dev/null" + serverCore.LF_STRING;
                File scriptFile = new File(sb.getDataPath(), "DATA/RELEASE/restart.sh");
                OS.deployScript(scriptFile, script);
                ConcurrentLog.info("RESTART", "wrote restart-script to " + scriptFile.getAbsolutePath());
                OS.execAsynchronous(scriptFile);
                ConcurrentLog.info("RESTART", "script is running");
                sb.terminate(10L, "unix restart");
            }
            catch (IOException e) {
                ConcurrentLog.severe("RESTART", "restart failed", e);
            }
        }
    }

    public static boolean deployRelease(File releaseFile) {
        boolean restartTriggered = false;
        try {
            Switchboard sb = Switchboard.getSwitchboard();
            ConcurrentLog.info("UPDATE", "INITIATED");
            try {
                tarTools.unTar(tarTools.getInputStream(releaseFile), sb.getDataPath() + "/DATA/RELEASE/".replace("/", File.separator));
            }
            catch (Exception e) {
                throw new IOException("Could not untar release file", e);
            }
            String script = null;
            String scriptFileName = null;
            if (OS.isMacArchitecture) {
                File InfoPlistSource = new File(sb.getDataPath(), "DATA/RELEASE/yacy/addon/YaCy.app/Contents/Info.plist");
                File InfoPlistDestination = new File(sb.getAppPath(), "addon/YaCy.app/Contents/Info.plist");
                if (InfoPlistSource.exists() && InfoPlistDestination.exists()) {
                    Files.copy(InfoPlistSource, InfoPlistDestination);
                    ConcurrentLog.info("UPDATE", "replaced Info.plist");
                }
            }
            if (OS.isWindows) {
                File startType = new File(sb.getDataPath(), "DATA/yacy.noconsole".replace("/", File.separator));
                String starterFile = "startYACY_debug.bat";
                if (startType.exists()) {
                    starterFile = "startYACY.bat";
                }
                if (startParameter.startsWith("-gui")) {
                    starterFile = starterFile + " " + startParameter;
                }
                script = "@echo off" + serverCore.CRLF_STRING + "title YaCy updater" + serverCore.CRLF_STRING + "set loading=YACY UPDATER" + serverCore.CRLF_STRING + "echo %loading%" + serverCore.CRLF_STRING + "cd \"" + sb.getDataPath().toString() + "/DATA/RELEASE/".replace("/", File.separator) + "\"" + serverCore.CRLF_STRING + ":WAIT" + serverCore.CRLF_STRING + "set loading=%loading%." + serverCore.CRLF_STRING + "cls" + serverCore.CRLF_STRING + "echo %loading%" + serverCore.CRLF_STRING + "ping -n 2 127.0.0.1 >nul" + serverCore.CRLF_STRING + "IF exist ..\\yacy.running goto WAIT" + serverCore.CRLF_STRING + "IF not exist yacy goto NODATA" + serverCore.CRLF_STRING + "cd yacy" + serverCore.CRLF_STRING + "del /Q \"" + sb.getAppPath().toString() + "\\lib\\*\"  >nul" + serverCore.CRLF_STRING + "xcopy *.* \"" + sb.getAppPath().toString() + "\" /E /Y >nul" + serverCore.CRLF_STRING + "cd .." + serverCore.CRLF_STRING + "rd yacy /S /Q" + serverCore.CRLF_STRING + "goto END" + serverCore.CRLF_STRING + ":NODATA" + serverCore.CRLF_STRING + "echo YACY UPDATER ERROR: NO UPDATE SOURCE FILES ON FILESYSTEM" + serverCore.CRLF_STRING + "pause" + serverCore.CRLF_STRING + ":END" + serverCore.CRLF_STRING + "cd \"" + sb.getAppPath().toString() + "\"" + serverCore.CRLF_STRING + "start /MIN CMD /C " + starterFile + serverCore.CRLF_STRING;
                scriptFileName = "update.bat";
            } else {
                script = "#!/bin/sh" + serverCore.LF_STRING + "cd " + sb.getDataPath() + "/DATA/RELEASE/" + serverCore.LF_STRING + "while [ -f ../yacy.running ]; do" + serverCore.LF_STRING + "sleep 1" + serverCore.LF_STRING + "done" + serverCore.LF_STRING + "rm " + sb.getAppPath().toString() + "/lib/*" + serverCore.LF_STRING + "cp -Rf yacy/* " + sb.getAppPath().toString() + serverCore.LF_STRING + "rm -Rf yacy" + serverCore.LF_STRING + "cd " + sb.getAppPath().toString() + serverCore.LF_STRING + "chmod 755 *.sh" + serverCore.LF_STRING + "chmod 755 bin/*.sh" + serverCore.LF_STRING + "nohup ./startYACY.sh " + (startParameter.startsWith("-gui") ? startParameter : "") + " > /dev/null" + serverCore.LF_STRING;
                scriptFileName = "update.sh";
            }
            File scriptFile = new File(sb.getDataPath(), "DATA/RELEASE/".replace("/", File.separator) + scriptFileName);
            OS.deployScript(scriptFile, script);
            ConcurrentLog.info("UPDATE", "wrote update-script to " + scriptFile.getAbsolutePath());
            OS.execAsynchronous(scriptFile);
            restartTriggered = true;
            ConcurrentLog.info("UPDATE", "script is running");
            sb.setConfig("update.time.deploy", System.currentTimeMillis());
            sb.terminate(10L, "auto-deploy for " + releaseFile.getName());
        }
        catch (IOException e) {
            ConcurrentLog.severe("UPDATE", "update failed", e);
        }
        return restartTriggered;
    }

    public static void main(String[] args) {
        System.out.println(yacyRelease.thisVersion());
        float base = 0.53f;
        String blacklist = "....[123]";
        for (int i = 0; i < 20; ++i) {
            String test2 = Float.toString(0.53f + (float)i / 1000.0f);
            System.out.println(test2 + " is " + (test2.matches("....[123]") ? "blacklisted" : " not blacklisted"));
        }
    }

    public static boolean deleteOldDownloads(File filesPath, int deleteAfterDays) {
        String[] downloaded = filesPath.list();
        boolean deletedSomeFiles = false;
        TreeSet<yacyVersion> downloadedreleases = new TreeSet<yacyVersion>();
        for (String element : downloaded) {
            try {
                yacyVersion release = new yacyVersion(element, null);
                downloadedreleases.add(release);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (!downloadedreleases.isEmpty()) {
            ConcurrentLog.fine("STARTUP", "deleting downloaded releases older than " + deleteAfterDays + " days");
            yacyVersion latest = (yacyVersion)downloadedreleases.last();
            downloadedreleases.remove(latest);
            boolean keepMain = !latest.isMainRelease();
            long now = System.currentTimeMillis();
            long deleteAfterMillis = (long)deleteAfterDays * 24L * 60L * 60000L;
            String lastMain = null;
            for (yacyVersion aVersion : downloadedreleases) {
                File downloadedFile;
                String filename = aVersion.getName();
                if (keepMain && aVersion.isMainRelease()) {
                    if (lastMain != null) {
                        filename = lastMain;
                    }
                    lastMain = aVersion.getName();
                }
                if (now - (downloadedFile = new File(filesPath + File.separator + filename)).lastModified() <= deleteAfterMillis) continue;
                FileUtils.deletedelete(downloadedFile);
                FileUtils.deletedelete(new File(downloadedFile.getAbsolutePath() + ".sig"));
                if (downloadedFile.exists()) {
                    ConcurrentLog.warn("STARTUP", "cannot delete old release " + downloadedFile.getAbsolutePath());
                    continue;
                }
                deletedSomeFiles = true;
            }
        }
        return deletedSomeFiles;
    }

    public File getReleaseFile() {
        return this.releaseFile;
    }

    public File getSignatureFile() {
        return new File(this.releaseFile.getAbsoluteFile() + ".sig");
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public static final class DevAndMainVersions {
        public TreeSet<yacyRelease> dev;
        public TreeSet<yacyRelease> main;

        public DevAndMainVersions(TreeSet<yacyRelease> dev, TreeSet<yacyRelease> main) {
            this.dev = dev;
            this.main = main;
        }
    }
}

