/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers.graphics;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.feed.Hit;
import net.yacy.cora.document.feed.RSSMessage;
import net.yacy.cora.federate.yacy.Distribution;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.peers.EventChannel;
import net.yacy.peers.RemoteSearch;
import net.yacy.peers.Seed;
import net.yacy.peers.SeedDB;
import net.yacy.peers.graphics.EncodedImage;
import net.yacy.search.Switchboard;
import net.yacy.search.query.SearchEvent;
import net.yacy.search.query.SearchEventCache;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public class NetworkGraph {
    private static final double DOUBLE_LONG_MAX_VALUE = 9.223372036854776E18;
    public static EncodedImage buffer = null;
    private static int shortestName = 10;
    private static int longestName = 30;
    public static final long COL_BACKGROUND = 0xFFFFFFL;
    public static final long COL_DHTCIRCLE = 16408L;
    private static final long COL_HEADLINE = 0xFFFFFFL;
    private static final long COL_ACTIVE_DOT = 64L;
    private static final long COL_ACTIVE_LINE = 0x113322L;
    private static final long COL_ACTIVE_TEXT = 0x226644L;
    private static final long COL_PASSIVE_DOT = 0x201010L;
    private static final long COL_PASSIVE_LINE = 0x443333L;
    private static final long COL_PASSIVE_TEXT = 0x663333L;
    private static final long COL_POTENTIAL_DOT = 8192L;
    private static final long COL_POTENTIAL_LINE = 0x224422L;
    private static final long COL_POTENTIAL_TEXT = 0x336633L;
    private static final long COL_MYPEER_DOT = 0xFF0000L;
    private static final long COL_MYPEER_LINE = 0xFFAAAAL;
    private static final long COL_MYPEER_TEXT = 0xFFCCCCL;
    private static final long COL_DHTOUT = 0x440000L;
    private static final long COL_DHTIN = 34816L;
    private static final long COL_BORDER = 0L;
    private static final long COL_NORMAL_TEXT = 0L;
    private static final long COL_LOAD_BG = 0xF7F7F7L;
    private static final int LEGEND_BOX_SIZE = 10;
    private static BufferedImage peerloadPicture = null;
    private static long peerloadPictureDate = 0L;

    private NetworkGraph() {
    }

    public static void clearcache() {
        buffer = null;
    }

    public static RasterPlotter getSearchEventPicture(SeedDB seedDB, String eventID, int coronaangle, int cyc) {
        double angle;
        SearchEvent event = SearchEventCache.getEvent(eventID);
        if (event == null) {
            return null;
        }
        List<RemoteSearch> primarySearches = event.getPrimarySearchThreads();
        if (primarySearches == null) {
            return null;
        }
        RasterPlotter eventPicture = NetworkGraph.getNetworkPicture(seedDB, 640, 480, 300, 300, 9000, coronaangle, -1L, Switchboard.getSwitchboard().getConfig("network.unit.name", "unspecified"), Switchboard.getSwitchboard().getConfig("network.unit.description", "unspecified"), 0xFFFFFFL, cyc);
        int cr = Math.min(eventPicture.getWidth(), eventPicture.getHeight()) / 5 - 20;
        int cx = eventPicture.getWidth() / 2;
        int cy = eventPicture.getHeight() / 2;
        for (RemoteSearch primarySearche : primarySearches) {
            if (primarySearche == null) continue;
            eventPicture.setColor(primarySearche.isAlive() ? 0xFF0000L : 65280L);
            angle = (double)cyc + 360.0 * ((double)Distribution.horizontalDHTPosition(UTF8.getBytes(primarySearche.target().hash)) / 9.223372036854776E18);
            eventPicture.arcLine(cx, cy, cr - 20, cr, angle, true, null, null, -1, -1, -1, false);
        }
        Iterator<byte[]> i = event.query.getQueryGoal().getIncludeHashes().iterator();
        eventPicture.setColor(0x888888L);
        while (i.hasNext()) {
            byte[] wordHash = i.next();
            for (int verticalPosition = 0; verticalPosition < seedDB.scheme.verticalPartitions(); ++verticalPosition) {
                long position = seedDB.scheme.verticalDHTPosition(wordHash, verticalPosition);
                angle = (double)cyc + 360.0 * ((double)position / 9.223372036854776E18);
                eventPicture.arcLine(cx, cy, cr - 20, cr, angle, true, null, null, -1, -1, -1, false);
            }
        }
        return eventPicture;
    }

    public static RasterPlotter getNetworkPicture(SeedDB seedDB, int width, int height, int passiveLimit, int potentialLimit, int maxCount, int coronaangle, long communicationTimeout, String networkName, String networkTitle, long bgcolor, int cyc) {
        return NetworkGraph.drawNetworkPicture(seedDB, width, height, passiveLimit, potentialLimit, maxCount, coronaangle, communicationTimeout, networkName, networkTitle, bgcolor, cyc);
    }

    private static RasterPlotter drawNetworkPicture(SeedDB seedDB, int width, int height, int passiveLimit, int potentialLimit, int maxCount, int coronaangle, long communicationTimeout, String networkName, String networkTitle, long color_back, int cyc) {
        long lastseen;
        Seed seed;
        RasterPlotter.DrawMode drawMode = RasterPlotter.darkColor(color_back) ? RasterPlotter.DrawMode.MODE_ADD : RasterPlotter.DrawMode.MODE_SUB;
        RasterPlotter networkPicture = new RasterPlotter(width, height, drawMode, color_back);
        if (seedDB == null) {
            return networkPicture;
        }
        int maxradius = Math.min(width / 2, height * 3 / 5);
        int innerradius = maxradius * 4 / 10;
        int outerradius = maxradius - 20;
        networkPicture.setColor(16408L);
        networkPicture.arc(width / 2, height / 2, innerradius - 20, innerradius + 20, 100);
        int count = 0;
        int totalCount = 0;
        Iterator<Seed> e = seedDB.seedsConnected(true, false, null, 0.0);
        while (e.hasNext() && count < maxCount) {
            seed = e.next();
            if (seed == null) {
                ConcurrentLog.warn("NetworkGraph", "connected seed == null");
                continue;
            }
            if (seed.hash.startsWith("AD")) continue;
            new drawNetworkPicturePeerJob(networkPicture, width / 2, height / 2, innerradius, outerradius, seed, 64L, 0x113322L, 0x226644L, coronaangle, cyc).draw();
            ++count;
        }
        totalCount += count;
        count = 0;
        e = seedDB.seedsSortedDisconnected(false, "LastSeen");
        while (e.hasNext() && count < maxCount) {
            seed = e.next();
            if (seed == null) {
                ConcurrentLog.warn("NetworkGraph", "disconnected seed == null");
                continue;
            }
            lastseen = Math.abs((System.currentTimeMillis() - seed.getLastSeenUTC()) / 1000L / 60L);
            if (lastseen > (long)passiveLimit) break;
            new drawNetworkPicturePeerJob(networkPicture, width / 2, height / 2, innerradius, outerradius, seed, 0x201010L, 0x443333L, 0x663333L, coronaangle, cyc).draw();
            ++count;
        }
        totalCount += count;
        count = 0;
        e = seedDB.seedsSortedPotential(false, "LastSeen");
        while (e.hasNext() && count < maxCount) {
            seed = e.next();
            if (seed == null) {
                ConcurrentLog.warn("NetworkGraph", "potential seed == null");
                continue;
            }
            lastseen = Math.abs((System.currentTimeMillis() - seed.getLastSeenUTC()) / 1000L / 60L);
            if (lastseen > (long)potentialLimit) break;
            new drawNetworkPicturePeerJob(networkPicture, width / 2, height / 2, innerradius, outerradius, seed, 8192L, 0x224422L, 0x336633L, coronaangle, cyc).draw();
            ++count;
        }
        totalCount += count;
        new drawNetworkPicturePeerJob(networkPicture, width / 2, height / 2, innerradius, outerradius, seedDB.mySeed(), 0xFF0000L, 0xFFAAAAL, 0xFFCCCCL, coronaangle, cyc).draw();
        if (communicationTimeout >= 0L) {
            Hit event2;
            Date horizon = new Date(System.currentTimeMillis() - communicationTimeout);
            Iterator<RSSMessage> iterator = EventChannel.channels(EventChannel.DHTRECEIVE).iterator();
            while (iterator.hasNext() && (event2 = (Hit)iterator.next()) != null) {
                if (event2.getPubDate() == null || !event2.getPubDate().after(horizon)) continue;
                NetworkGraph.drawNetworkPictureDHT(networkPicture, width / 2, height / 2, innerradius, seedDB.mySeed(), seedDB.get(event2.getLink()), 34816L, coronaangle, false, cyc);
            }
            for (Hit event2 : EventChannel.channels(EventChannel.DHTSEND)) {
                if (event2 == null || event2.getPubDate() == null || !event2.getPubDate().after(horizon)) continue;
                NetworkGraph.drawNetworkPictureDHT(networkPicture, width / 2, height / 2, innerradius, seedDB.mySeed(), seedDB.get(event2.getLink()), 0x440000L, coronaangle, true, cyc);
            }
        }
        networkPicture.setColor(0xFFFFFFL);
        PrintTool.print(networkPicture, 2, 6, 0, "YACY NETWORK '" + networkName.toUpperCase() + "'", -1, 100);
        PrintTool.print(networkPicture, 2, 14, 0, networkTitle.toUpperCase(), -1, 80);
        PrintTool.print(networkPicture, width - 2, 6, 0, "SNAPSHOT FROM " + new Date().toString().toUpperCase(), 1, 80);
        PrintTool.print(networkPicture, width - 2, 14, 0, "DRAWING OF " + totalCount + " SELECTED PEERS", 1, 80);
        return networkPicture;
    }

    private static void drawNetworkPictureDHT(RasterPlotter img, int centerX, int centerY, int innerradius, Seed mySeed, Seed otherSeed, long colorLine, int coronaangle, boolean out, int cyc) {
        int angleMy = cyc + (int)(360.0 * (double)Distribution.horizontalDHTPosition(ASCII.getBytes(mySeed.hash)) / 9.223372036854776E18);
        int angleOther = cyc + (int)(360.0 * (double)Distribution.horizontalDHTPosition(ASCII.getBytes(otherSeed.hash)) / 9.223372036854776E18);
        img.arcLine(centerX, centerY, innerradius, innerradius - 20, angleMy, !out, colorLine, null, 12, coronaangle < 0 ? -1 : coronaangle / 30, 2, true);
        img.arcLine(centerX, centerY, innerradius, innerradius - 20, angleOther, out, colorLine, null, 12, coronaangle < 0 ? -1 : coronaangle / 30, 2, true);
        img.arcConnect(centerX, centerY, innerradius - 20, angleMy, angleOther, out, colorLine, 100, null, 100, 12, coronaangle < 0 ? -1 : coronaangle / 30, 2, true, otherSeed.getName(), colorLine, 100);
    }

    private static void drawCorona(RasterPlotter img, int centerX, int centerY, int innerradius, int waveradius, double angle, int dotsize, int strength, int coronaangle, boolean inside, boolean split, int r, int g, int b) {
        double ca = Math.PI * 2 * (double)coronaangle / 360.0;
        if (strength > 20) {
            strength = 20;
        }
        int segments = 72;
        for (int radius = 0; radius < waveradius; ++radius) {
            double wave = (double)(waveradius - radius) * (double)strength * (1.0 + Math.sin(50.26548245743669 * (double)radius / (double)waveradius + (inside ? ca : -ca))) / 2.0 / (double)waveradius;
            img.setColor(((long)((double)r * wave) & 0xFFL) << 16 | ((long)((double)g * wave) & 0xFFL) << 8 | (long)((double)b * wave) & 0xFFL);
            if (split) {
                for (int i = 0; i < 72; ++i) {
                    int a = (coronaangle + 360 * i) / 72;
                    img.arcArc(centerX, centerY, innerradius, angle, dotsize + radius, dotsize + radius, a, a + 2);
                }
                continue;
            }
            img.arcArc(centerX, centerY, innerradius, angle, dotsize + radius, dotsize + radius, 100);
        }
    }

    public static BufferedImage getPeerLoadPicture(long maxAge, int width, int height, CircleThreadPiece[] pieces, CircleThreadPiece fillRest) {
        if (peerloadPicture == null || System.currentTimeMillis() - peerloadPictureDate > maxAge) {
            NetworkGraph.drawPeerLoadPicture(width, height, pieces, fillRest);
        }
        return peerloadPicture;
    }

    private static void drawPeerLoadPicture(int width, int height, CircleThreadPiece[] pieces, CircleThreadPiece fillRest) {
        int i;
        peerloadPicture = new BufferedImage(width, height, 1);
        Graphics2D g = peerloadPicture.createGraphics();
        g.setBackground(Color.decode("0x16250871"));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.clearRect(0, 0, width, height);
        int circ_w = Math.min(width, height) - 20;
        int circ_x = width - circ_w - 10;
        int circ_y = 10;
        int curr_angle = 0;
        for (i = 0; i < pieces.length; ++i) {
            g.setColor(pieces[i].getColor());
            g.fillArc(circ_x, 10, circ_w, circ_w, curr_angle, pieces[i].getAngle());
            curr_angle += pieces[i].getAngle();
            NetworkGraph.drawLegendLine(g, 5, height - 5 - 15 * i, pieces[i].getPieceName() + " (" + pieces[i].getFractionPercent() + " %)", pieces[i].getColor());
        }
        g.setColor(fillRest.getColor());
        g.fillArc(circ_x, 10, circ_w, circ_w, curr_angle, 360 - curr_angle);
        NetworkGraph.drawLegendLine(g, 5, height - 5 - 15 * i, fillRest.getPieceName() + " (" + fillRest.getFractionPercent() + " %)", fillRest.getColor());
        g.setColor(Color.decode("0x0"));
        g.drawArc(circ_x, 10, circ_w, circ_w, 0, 360);
        peerloadPictureDate = System.currentTimeMillis();
    }

    private static void drawLegendLine(Graphics2D g, int x, int y, String caption, Color item_color) {
        g.setColor(item_color);
        g.fillRect(x, y - 10, 10, 10);
        g.setColor(Color.decode("0x0"));
        g.drawRect(x, y - 10, 10, 10);
        g.setColor(Color.decode("0x0"));
        g.drawChars(caption.toCharArray(), 0, caption.length(), x + 10 + 5, y);
    }

    private static class drawNetworkPicturePeerJob {
        private final RasterPlotter img;
        private final int centerX;
        private final int centerY;
        private final int innerradius;
        private final int outerradius;
        private final int coronaangle;
        private final Seed seed;
        private final long colorDot;
        private final long colorLine;
        private final long colorText;
        private final double cyc;

        public drawNetworkPicturePeerJob(RasterPlotter img, int centerX, int centerY, int innerradius, int outerradius, Seed seed, long colorDot, long colorLine, long colorText, int coronaangle, double cyc) {
            this.img = img;
            this.centerX = centerX;
            this.centerY = centerY;
            this.innerradius = innerradius;
            this.outerradius = outerradius;
            this.coronaangle = coronaangle;
            this.seed = seed;
            this.colorDot = colorDot;
            this.colorLine = colorLine;
            this.colorText = colorText;
            this.cyc = cyc;
        }

        public void draw() {
            String name = this.seed.getName().toUpperCase();
            if (name.length() < shortestName) {
                shortestName = name.length();
            }
            if (name.length() > longestName) {
                longestName = name.length();
            }
            double angle = this.cyc + 360.0 * (double)Distribution.horizontalDHTPosition(ASCII.getBytes(this.seed.hash)) / 9.223372036854776E18;
            int linelength = 20 + this.outerradius * (20 * (name.length() - shortestName) / (longestName - shortestName) + Math.abs(this.seed.hash.hashCode() % 20)) / 80;
            if (linelength > this.outerradius) {
                linelength = this.outerradius;
            }
            int dotsize = 2 + (int)(this.seed.getLinkCount() / 2000000L);
            if (this.colorDot == 0xFF0000L) {
                dotsize += 4;
            }
            if (dotsize > 18) {
                dotsize = 18;
            }
            this.img.setColor(this.colorDot);
            this.img.arcDot(this.centerX, this.centerY, this.innerradius, angle, dotsize);
            this.img.arcLine(this.centerX, this.centerY, this.innerradius + 18, this.innerradius + linelength, angle, true, this.colorLine, 0x444444L, 12, this.coronaangle / 30, 0, true);
            this.img.setColor(this.colorText);
            PrintTool.arcPrint(this.img, this.centerX, this.centerY, this.innerradius + linelength, angle, name, 100);
            int ppmx = Math.min(this.seed.getPPM() / 20, 10);
            if (this.coronaangle >= 0 && ppmx > 0) {
                NetworkGraph.drawCorona(this.img, this.centerX, this.centerY, this.innerradius, this.innerradius * 2 / 5, angle, dotsize, ppmx, this.coronaangle, true, false, 2, 2, 2);
            }
            int qphx = Math.min((int)(this.seed.getQPM() * 15.0f), 8);
            if (this.coronaangle >= 0 && qphx > 0) {
                NetworkGraph.drawCorona(this.img, this.centerX, this.centerY, this.innerradius, this.innerradius / 2, angle, dotsize, qphx, this.coronaangle, false, true, 10, 60, 10);
            }
        }
    }

    public static class CircleThreadPiece {
        private final String pieceName;
        private final Color color;
        private long execTime = 0L;
        private float fraction = 0.0f;

        public CircleThreadPiece(String pieceName, Color color) {
            this.pieceName = pieceName;
            this.color = color;
        }

        public int getAngle() {
            return Math.round(360.0f * this.fraction);
        }

        public int getFractionPercent() {
            return Math.round(100.0f * this.fraction);
        }

        public Color getColor() {
            return this.color;
        }

        public long getExecTime() {
            return this.execTime;
        }

        public String getPieceName() {
            return this.pieceName;
        }

        public void addExecTime(long execTime) {
            this.execTime += execTime;
        }

        public void reset() {
            this.execTime = 0L;
            this.fraction = 0.0f;
        }

        public void setExecTime(long execTime) {
            this.execTime = execTime;
        }

        public void setFraction(long totalBusyTime) {
            this.fraction = (float)this.execTime / (float)totalBusyTime;
        }
    }
}

