/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.federate.yacy.Distribution;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.protocol.ResponseHeader;
import net.yacy.cora.protocol.http.HTTPClient;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.MapDataMining;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.kelondroException;
import net.yacy.peers.Network;
import net.yacy.peers.NewsPool;
import net.yacy.peers.PeerActions;
import net.yacy.peers.Seed;
import net.yacy.peers.operation.yacySeedUploader;
import net.yacy.search.Switchboard;
import net.yacy.server.http.AlternativeDomainNames;
import net.yacy.server.serverCore;
import net.yacy.server.serverSwitch;

public final class SeedDB
implements AlternativeDomainNames {
    private static final int dhtActivityMagic = 32;
    public static final String DBFILE_OWN_SEED = "mySeed.txt";
    public static final String[] sortFields = new String[]{"LCount", "RCount", "ICount", "Uptime", "Version", "LastSeen"};
    public static final String[] longaccFields = new String[]{"LCount", "ICount", "ISpeed"};
    public static final String[] doubleaccFields = new String[]{"RSpeed"};
    private File seedActiveDBFile;
    private File seedPassiveDBFile;
    private File seedPotentialDBFile;
    private File myOwnSeedFile;
    private MapDataMining seedActiveDB;
    private MapDataMining seedPassiveDB;
    private MapDataMining seedPotentialDB;
    protected int lastSeedUpload_seedDBSize = 0;
    public long lastSeedUpload_timeStamp = System.currentTimeMillis();
    protected String lastSeedUpload_myIP = "";
    public PeerActions peerActions;
    public NewsPool newsPool;
    private int netRedundancy;
    public Distribution scheme;
    private Seed mySeed;
    private final Map<Long, Integer> sizeActiveSince_result = new ConcurrentHashMap<Long, Integer>();
    private final Map<Long, Long> sizeActiveSince_time = new ConcurrentHashMap<Long, Long>();

    public SeedDB(File networkRoot, String seedActiveDBFileName, String seedPassiveDBFileName, String seedPotentialDBFileName, File myOwnSeedFile, int redundancy, int partitionExponent, boolean useTailCache, boolean exceed134217727) {
        this.seedActiveDBFile = new File(networkRoot, seedActiveDBFileName);
        this.seedPassiveDBFile = new File(networkRoot, seedPassiveDBFileName);
        this.seedPotentialDBFile = new File(networkRoot, seedPotentialDBFileName);
        this.mySeed = null;
        this.myOwnSeedFile = myOwnSeedFile;
        this.netRedundancy = redundancy;
        this.scheme = new Distribution(partitionExponent);
        this.seedActiveDB = SeedDB.openSeedTable(this.seedActiveDBFile);
        this.seedPassiveDB = SeedDB.openSeedTable(this.seedPassiveDBFile);
        this.seedPotentialDB = SeedDB.openSeedTable(this.seedPotentialDBFile);
        this.removeMySeed();
        this.lastSeedUpload_seedDBSize = this.sizeConnected();
        this.newsPool = new NewsPool(networkRoot, useTailCache, exceed134217727);
        this.peerActions = new PeerActions(this, this.newsPool);
    }

    public void relocate(File newNetworkRoot, int redundancy, int partitionExponent, boolean useTailCache, boolean exceed134217727) {
        this.seedActiveDB.close();
        this.seedPassiveDB.close();
        this.seedPotentialDB.close();
        this.newsPool.close();
        this.peerActions.close();
        this.seedActiveDBFile = new File(newNetworkRoot, this.seedActiveDBFile.getName());
        this.seedPassiveDBFile = new File(newNetworkRoot, this.seedPassiveDBFile.getName());
        this.seedPotentialDBFile = new File(newNetworkRoot, this.seedPotentialDBFile.getName());
        String peername = this.myName();
        this.mySeed = null;
        this.myOwnSeedFile = new File(newNetworkRoot, DBFILE_OWN_SEED);
        this.netRedundancy = redundancy;
        this.scheme = new Distribution(partitionExponent);
        this.seedActiveDB = SeedDB.openSeedTable(this.seedActiveDBFile);
        this.seedPassiveDB = SeedDB.openSeedTable(this.seedPassiveDBFile);
        this.seedPotentialDB = SeedDB.openSeedTable(this.seedPotentialDBFile);
        this.initMySeed();
        this.mySeed.setName(peername);
        this.removeMySeed();
        this.lastSeedUpload_seedDBSize = this.sizeConnected();
        this.newsPool = new NewsPool(newNetworkRoot, useTailCache, exceed134217727);
        this.peerActions = new PeerActions(this, this.newsPool);
    }

    private synchronized void initMySeed() {
        if (this.mySeed != null) {
            return;
        }
        if (this.myOwnSeedFile.length() > 0L) {
            try {
                this.mySeed = Seed.load(this.myOwnSeedFile);
                if (this.mySeed == null) {
                    throw new IOException("current seed is null");
                }
            }
            catch (IOException e) {
                ConcurrentLog.severe("SEEDDB", "could not load stored mySeed.txt from " + this.myOwnSeedFile.toString() + ": " + e.getMessage() + ". creating new seed.", e);
                this.mySeed = Seed.genLocalSeed(this);
                try {
                    this.mySeed.save(this.myOwnSeedFile);
                }
                catch (IOException ee) {
                    ConcurrentLog.severe("SEEDDB", "error saving mySeed.txt (1) to " + this.myOwnSeedFile.toString() + ": " + ee.getMessage(), ee);
                    ConcurrentLog.logException(ee);
                    System.exit(-1);
                }
            }
        } else {
            ConcurrentLog.info("SEEDDB", "could not find stored mySeed.txt at " + this.myOwnSeedFile.toString() + ": . creating new seed.");
            this.mySeed = Seed.genLocalSeed(this);
            try {
                this.mySeed.save(this.myOwnSeedFile);
            }
            catch (IOException ee) {
                ConcurrentLog.severe("SEEDDB", "error saving mySeed.txt (2) to " + this.myOwnSeedFile.toString() + ": " + ee.getMessage(), ee);
                ConcurrentLog.logException(ee);
                System.exit(-1);
            }
        }
        this.mySeed.setIPs(Switchboard.getSwitchboard().myPublicIPs());
        this.mySeed.put("PeerType", "virgin");
    }

    public int redundancy() {
        if (this.mySeed.isVirgin()) {
            return 1;
        }
        return this.netRedundancy;
    }

    public boolean mySeedIsDefined() {
        return this.mySeed != null;
    }

    public Seed mySeed() {
        if (this.mySeed == null) {
            if (this.sizeConnected() == 0) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.initMySeed();
        }
        return this.mySeed;
    }

    public void setMyName(String name) {
        this.mySeed().setName(name);
    }

    @Override
    public String myAlternativeAddress() {
        return this.mySeed().getName() + ".yacy";
    }

    @Deprecated
    public String myIP() {
        return this.mySeed().getIP();
    }

    @Override
    public Set<String> myIPs() {
        return this.mySeed().getIPs();
    }

    @Override
    public int myPort() {
        return this.mySeed().getPort();
    }

    @Override
    public String myName() {
        return this.mySeed().getName();
    }

    @Override
    public String myID() {
        return this.mySeed().hash;
    }

    public synchronized void removeMySeed() {
        if (this.seedActiveDB.isEmpty() && this.seedPassiveDB.isEmpty() && this.seedPotentialDB.isEmpty()) {
            return;
        }
        if (this.mySeed == null) {
            this.initMySeed();
        }
        try {
            byte[] mySeedHash = ASCII.getBytes(this.mySeed.hash);
            this.seedActiveDB.delete(mySeedHash);
            this.seedPassiveDB.delete(mySeedHash);
            this.seedPotentialDB.delete(mySeedHash);
        }
        catch (IOException e) {
            ConcurrentLog.warn("yacySeedDB", "could not remove hash (" + e.getClass() + "): " + e.getMessage());
        }
    }

    public void saveMySeed() {
        try {
            this.mySeed().save(this.myOwnSeedFile);
        }
        catch (IOException e) {
            ConcurrentLog.warn("yacySeedDB", "could not save mySeed '" + this.myOwnSeedFile + "': " + e.getMessage());
        }
    }

    public boolean noDHTActivity() {
        return this.sizeConnected() <= 32;
    }

    private static synchronized MapDataMining openSeedTable(File seedDBFile) {
        File parentDir = new File(seedDBFile.getParent());
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            ConcurrentLog.warn("yacySeedDB", "could not create directories for " + seedDBFile.getParent());
        }
        try {
            return new MapDataMining(seedDBFile, 12, Base64Order.enhancedCoder, 524288, 500, sortFields, longaccFields, doubleaccFields);
        }
        catch (Exception e) {
            FileUtils.deletedelete(seedDBFile);
            try {
                return new MapDataMining(seedDBFile, 12, Base64Order.enhancedCoder, 524288, 500, sortFields, longaccFields, doubleaccFields);
            }
            catch (IOException e1) {
                ConcurrentLog.logException(e1);
                System.exit(-1);
                return null;
            }
        }
    }

    private synchronized MapDataMining resetSeedTable(MapDataMining seedDB, File seedDBFile) {
        Network.log.warn("seed-db " + seedDBFile.toString() + " reset (on-the-fly)");
        seedDB.close();
        FileUtils.deletedelete(seedDBFile);
        if (seedDBFile.exists()) {
            ConcurrentLog.warn("yacySeedDB", "could not delete file " + seedDBFile);
        }
        seedDB = SeedDB.openSeedTable(seedDBFile);
        return seedDB;
    }

    public synchronized void resetActiveTable() {
        this.seedActiveDB = this.resetSeedTable(this.seedActiveDB, this.seedActiveDBFile);
    }

    private synchronized void resetPassiveTable() {
        this.seedPassiveDB = this.resetSeedTable(this.seedPassiveDB, this.seedPassiveDBFile);
    }

    private synchronized void resetPotentialTable() {
        this.seedPotentialDB = this.resetSeedTable(this.seedPotentialDB, this.seedPotentialDBFile);
    }

    public void close() {
        if (this.seedActiveDB != null) {
            this.seedActiveDB.close();
        }
        if (this.seedPassiveDB != null) {
            this.seedPassiveDB.close();
        }
        if (this.seedPotentialDB != null) {
            this.seedPotentialDB.close();
        }
        this.newsPool.close();
        this.peerActions.close();
    }

    public Iterator<Seed> seedsSortedConnected(boolean up, String field) {
        return new seedEnum(up, field, this.seedActiveDB);
    }

    public Iterator<Seed> seedsSortedDisconnected(boolean up, String field) {
        return new seedEnum(up, field, this.seedPassiveDB);
    }

    public Iterator<Seed> seedsSortedPotential(boolean up, String field) {
        return new seedEnum(up, field, this.seedPotentialDB);
    }

    public TreeSet<byte[]> clusterHashes(String clusterdefinition) {
        String[] addresses = clusterdefinition.isEmpty() ? new String[]{} : CommonPattern.COMMA.split(clusterdefinition);
        TreeSet<byte[]> clustermap = new TreeSet<byte[]>(Base64Order.enhancedCoder);
        for (String addresse : addresses) {
            Seed seed;
            int p = addresse.indexOf(61);
            String yacydom = p >= 0 ? addresse.substring(0, p) : addresse;
            if (yacydom.endsWith(".yacyh")) {
                String hash = Seed.hexHash2b64Hash(yacydom.substring(0, yacydom.length() - 6));
                seed = this.get(hash);
                if (seed == null) {
                    Network.log.warn("cluster peer '" + yacydom + "' was not found.");
                    continue;
                }
                clustermap.add(ASCII.getBytes(hash));
                continue;
            }
            if (yacydom.endsWith(".yacy")) {
                seed = this.lookupByName(yacydom.substring(0, yacydom.length() - 5));
                if (seed == null) {
                    Network.log.warn("cluster peer '" + yacydom + "' was not found.");
                    continue;
                }
                clustermap.add(ASCII.getBytes(seed.hash));
                continue;
            }
            Network.log.warn("cluster peer '" + addresse + "' has wrong syntax. the name must end with .yacy or .yacyh");
        }
        return clustermap;
    }

    public Iterator<Seed> seedsConnected(boolean up, boolean rot, byte[] firstHash, double minVersion) {
        return new seedEnum(up, rot, firstHash == null ? null : firstHash, null, this.seedActiveDB, minVersion);
    }

    public Iterator<Seed> seedsDisconnected(boolean up, boolean rot, byte[] firstHash, double minVersion) {
        return new seedEnum(up, rot, firstHash == null ? null : firstHash, null, this.seedPassiveDB, minVersion);
    }

    public Seed anySeedVersion(double minVersion) {
        Iterator<Seed> e = this.seedsConnected(true, true, Seed.randomHash(), minVersion);
        return e.next();
    }

    public int sizeActiveSince(long limitMinutes) {
        long now = System.currentTimeMillis();
        Integer s0 = this.sizeActiveSince_result.get(limitMinutes);
        Long t0 = this.sizeActiveSince_time.get(limitMinutes);
        if (s0 == null || t0 == null || now - t0 > 60000L) {
            int s1 = this.sizeActiveSinceInt(limitMinutes);
            this.sizeActiveSince_result.put(limitMinutes, s1);
            this.sizeActiveSince_time.put(limitMinutes, now);
            return s1;
        }
        return s0;
    }

    private int sizeActiveSinceInt(long limitMinutes) {
        Seed seed;
        int c = this.seedActiveDB.size();
        Iterator<Seed> i = this.seedsSortedDisconnected(false, "LastSeen");
        while (i.hasNext()) {
            seed = i.next();
            if (seed == null) continue;
            if (Math.abs((System.currentTimeMillis() - seed.getLastSeenUTC()) / 1000L / 60L) > limitMinutes) break;
            ++c;
        }
        i = this.seedsSortedPotential(false, "LastSeen");
        while (i.hasNext()) {
            seed = i.next();
            if (seed == null) continue;
            if (Math.abs((System.currentTimeMillis() - seed.getLastSeenUTC()) / 1000L / 60L) > limitMinutes) break;
            ++c;
        }
        return c;
    }

    public int sizeConnected() {
        return this.seedActiveDB.size();
    }

    public int sizeDisconnected() {
        return this.seedPassiveDB.size();
    }

    public int sizePotential() {
        return this.seedPotentialDB.size();
    }

    public long countActiveURL() {
        return this.seedActiveDB.getLongAcc("LCount");
    }

    public long countActiveRWI() {
        return this.seedActiveDB.getLongAcc("ICount");
    }

    public long countActivePPM() {
        return this.seedActiveDB.getLongAcc("ISpeed");
    }

    public float countActiveQPM() {
        return this.seedActiveDB.getFloatAcc("RSpeed");
    }

    public long countPassiveURL() {
        return this.seedPassiveDB.getLongAcc("LCount");
    }

    public long countPassiveRWI() {
        return this.seedPassiveDB.getLongAcc("ICount");
    }

    public long countPotentialURL() {
        return this.seedPotentialDB.getLongAcc("LCount");
    }

    public long countPotentialRWI() {
        return this.seedPotentialDB.getLongAcc("ICount");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnected(Seed seed) {
        if (seed.isProper(false) != null) {
            return;
        }
        ConcurrentMap<String, String> seedPropMap = seed.getMap();
        SeedDB seedDB = this;
        synchronized (seedDB) {
            try {
                this.seedActiveDB.insert(ASCII.getBytes(seed.hash), seedPropMap);
                this.seedPassiveDB.delete(ASCII.getBytes(seed.hash));
                this.seedPotentialDB.delete(ASCII.getBytes(seed.hash));
            }
            catch (Exception e) {
                Network.log.severe("ERROR add: seed.db corrupt (" + e.getMessage() + "); resetting seed.db", e);
                this.resetActiveTable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDisconnected(Seed seed) {
        if (seed.isProper(false) != null) {
            return;
        }
        SeedDB seedDB = this;
        synchronized (seedDB) {
            try {
                this.seedActiveDB.delete(ASCII.getBytes(seed.hash));
                this.seedPotentialDB.delete(ASCII.getBytes(seed.hash));
            }
            catch (Exception e) {
                ConcurrentLog.warn("yacySeedDB", "could not remove hash (" + e.getClass() + "): " + e.getMessage());
            }
            try {
                ConcurrentMap<String, String> seedPropMap = seed.getMap();
                this.seedPassiveDB.insert(ASCII.getBytes(seed.hash), seedPropMap);
            }
            catch (Exception e) {
                Network.log.severe("ERROR add: seed.db corrupt (" + e.getMessage() + "); resetting seed.db", e);
                this.resetPassiveTable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPotential(Seed seed) {
        if (seed.isProper(false) != null) {
            return;
        }
        ConcurrentMap<String, String> seedPropMap = seed.getMap();
        SeedDB seedDB = this;
        synchronized (seedDB) {
            try {
                this.seedActiveDB.delete(ASCII.getBytes(seed.hash));
                this.seedPassiveDB.delete(ASCII.getBytes(seed.hash));
            }
            catch (Exception e) {
                ConcurrentLog.warn("yacySeedDB", "could not remove hash (" + e.getClass() + "): " + e.getMessage());
            }
            try {
                this.seedPotentialDB.insert(ASCII.getBytes(seed.hash), seedPropMap);
            }
            catch (Exception e) {
                Network.log.severe("ERROR add: seed.db corrupt (" + e.getMessage() + "); resetting seed.db", e);
                this.resetPotentialTable();
            }
        }
    }

    public synchronized void removeDisconnected(String peerHash) {
        if (peerHash == null) {
            return;
        }
        try {
            this.seedPassiveDB.delete(ASCII.getBytes(peerHash));
        }
        catch (IOException e) {
            ConcurrentLog.warn("yacySeedDB", "could not remove hash (" + e.getClass() + "): " + e.getMessage());
        }
    }

    public synchronized void removePotential(String peerHash) {
        if (peerHash == null) {
            return;
        }
        try {
            this.seedPotentialDB.delete(ASCII.getBytes(peerHash));
        }
        catch (IOException e) {
            ConcurrentLog.warn("yacySeedDB", "could not remove hash (" + e.getClass() + "): " + e.getMessage());
        }
    }

    public boolean hasConnected(byte[] hash) {
        return this.seedActiveDB.containsKey(hash);
    }

    public boolean hasDisconnected(byte[] hash) {
        return this.seedPassiveDB.containsKey(hash);
    }

    public boolean hasPotential(byte[] hash) {
        return this.seedPotentialDB.containsKey(hash);
    }

    private Seed get(String hash, MapDataMining database) {
        if (hash == null || hash.isEmpty()) {
            return null;
        }
        if (this.mySeed != null && hash.equals(this.mySeed.hash)) {
            return this.mySeed;
        }
        ConcurrentHashMap<String, String> entry2 = new ConcurrentHashMap<String, String>();
        try {
            Map<String, String> map = database.get(ASCII.getBytes(hash));
            if (map == null) {
                return null;
            }
            entry2.putAll(map);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            return null;
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
            return null;
        }
        return new Seed(hash, entry2);
    }

    private Seed get(byte[] hash, MapDataMining database) {
        if (hash == null || hash.length == 0) {
            return null;
        }
        if (this.mySeed != null && ASCII.String(hash).equals(this.mySeed.hash)) {
            return this.mySeed;
        }
        ConcurrentHashMap<String, String> entry2 = new ConcurrentHashMap<String, String>();
        try {
            Map<String, String> map = database.get(hash);
            if (map == null) {
                return null;
            }
            entry2.putAll(map);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            return null;
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
            return null;
        }
        return new Seed(ASCII.String(hash), entry2);
    }

    public Seed getConnected(String hash) {
        return this.get(hash, this.seedActiveDB);
    }

    public Seed getConnected(byte[] hash) {
        return this.get(hash, this.seedActiveDB);
    }

    public Seed getDisconnected(String hash) {
        return this.get(hash, this.seedPassiveDB);
    }

    public Seed getDisconnected(byte[] hash) {
        return this.get(hash, this.seedPassiveDB);
    }

    public Seed getPotential(String hash) {
        return this.get(hash, this.seedPotentialDB);
    }

    public Seed getPotential(byte[] hash) {
        return this.get(hash, this.seedPotentialDB);
    }

    public Seed get(String hash) {
        Seed seed = this.getConnected(hash);
        if (seed == null) {
            seed = this.getDisconnected(hash);
        }
        if (seed == null) {
            seed = this.getPotential(hash);
        }
        return seed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnected(Seed seed) {
        if (seed.isProper(false) != null) {
            return;
        }
        ConcurrentMap<String, String> seedPropMap = seed.getMap();
        SeedDB seedDB = this;
        synchronized (seedDB) {
            if (this.seedActiveDB.containsKey(ASCII.getBytes(seed.hash))) {
                try {
                    this.seedActiveDB.insert(ASCII.getBytes(seed.hash), seedPropMap);
                }
                catch (Exception e) {
                    Network.log.severe("ERROR add: seed.db corrupt (" + e.getMessage() + "); resetting seed.db", e);
                    this.resetActiveTable();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDisconnected(Seed seed) {
        if (seed.isProper(false) != null) {
            return;
        }
        ConcurrentMap<String, String> seedPropMap = seed.getMap();
        SeedDB seedDB = this;
        synchronized (seedDB) {
            if (this.seedPassiveDB.containsKey(ASCII.getBytes(seed.hash))) {
                try {
                    this.seedPassiveDB.insert(ASCII.getBytes(seed.hash), seedPropMap);
                }
                catch (Exception e) {
                    Network.log.severe("ERROR add: seed.db corrupt (" + e.getMessage() + "); resetting seed.db", e);
                    this.resetActiveTable();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePotential(Seed seed) {
        if (seed.isProper(false) != null) {
            return;
        }
        ConcurrentMap<String, String> seedPropMap = seed.getMap();
        SeedDB seedDB = this;
        synchronized (seedDB) {
            if (this.seedPotentialDB.containsKey(ASCII.getBytes(seed.hash))) {
                try {
                    this.seedPotentialDB.insert(ASCII.getBytes(seed.hash), seedPropMap);
                }
                catch (Exception e) {
                    Network.log.severe("ERROR add: seed.db corrupt (" + e.getMessage() + "); resetting seed.db", e);
                    this.resetActiveTable();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Seed lookupByName(String peerName) {
        Seed seed;
        Collection<byte[]> idx22;
        if (peerName.endsWith(".yacy")) {
            peerName = peerName.substring(0, peerName.length() - 5);
        }
        if (peerName.equals("localpeer")) {
            if (this.mySeed == null) {
                this.initMySeed();
            }
            return this.mySeed;
        }
        peerName = peerName.toLowerCase();
        String name = Seed.checkPeerName(peerName);
        SeedDB seedDB = this;
        synchronized (seedDB) {
            try {
                idx22 = this.seedActiveDB.select("Name", name);
                for (byte[] pk : idx22) {
                    seed = this.getConnected(pk);
                    if (seed == null) continue;
                    return seed;
                }
            }
            catch (IOException idx22) {
                // empty catch block
            }
        }
        seedDB = this;
        synchronized (seedDB) {
            try {
                idx22 = this.seedPassiveDB.select("Name", name);
                for (byte[] pk : idx22) {
                    seed = this.getDisconnected(pk);
                    if (seed == null) continue;
                    return seed;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.mySeed == null) {
            this.initMySeed();
        }
        if ((name = this.mySeed.getName().toLowerCase()).equals(peerName)) {
            return this.mySeed;
        }
        return null;
    }

    public Seed lookupByIPs(Set<String> peerIPs, int port, boolean lookupConnected, boolean lookupDisconnected, boolean lookupPotential) {
        for (String i : peerIPs) {
            Seed s = this.lookupByIP(Domains.dnsResolve(i), port, lookupConnected, lookupDisconnected, lookupPotential);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public Seed lookupByIP(InetAddress peerIP, int port, boolean lookupConnected, boolean lookupDisconnected, boolean lookupPotential) {
        Collection<byte[]> idx2;
        if (peerIP == null) {
            return null;
        }
        if (Domains.isThisHostIP(peerIP)) {
            if (this.mySeed == null) {
                this.initMySeed();
            }
            if (port > 0 && this.mySeed.getPort() == port) {
                return this.mySeed;
            }
        }
        Seed seed = null;
        String ipString = peerIP.getHostAddress();
        if (lookupConnected) {
            try {
                idx2 = this.seedActiveDB.select("IP", ipString);
                for (byte[] pk : idx2) {
                    seed = this.getConnected(pk);
                    if (seed == null || port > 0 && seed.getPort() != port) continue;
                    return seed;
                }
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        if (lookupDisconnected) {
            try {
                idx2 = this.seedPassiveDB.select("IP", ipString);
                for (byte[] pk : idx2) {
                    seed = this.getDisconnected(pk);
                    if (seed == null || port > 0 && seed.getPort() != port) continue;
                    return seed;
                }
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        if (lookupPotential) {
            try {
                idx2 = this.seedPotentialDB.select("IP", ipString);
                for (byte[] pk : idx2) {
                    seed = this.getPotential(pk);
                    if (seed == null || port > 0 && seed.getPort() != port) continue;
                    return seed;
                }
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        if (this.mySeed == null || !this.mySeed.getIPs().contains(ipString)) {
            return null;
        }
        int p = this.mySeed.getPort();
        if (port > 0 && p != port) {
            return null;
        }
        return this.mySeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> storeSeedList(File seedFile, boolean addMySeed) throws IOException {
        PrintWriter pw = null;
        ArrayList<String> v = new ArrayList<String>(this.seedActiveDB.size() + 1);
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(seedFile)));
            ArrayList<Seed> seedlist2 = this.getSeedlist(Integer.MAX_VALUE, addMySeed, false, 0.0f);
            for (Seed seed : seedlist2) {
                String line = seed.genSeedStr(null);
                v.add(line);
                pw.print(line + serverCore.CRLF_STRING);
            }
            pw.flush();
        }
        finally {
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (Exception exception) {}
            }
        }
        return v;
    }

    public ArrayList<Seed> getSeedlist(int maxcount, boolean addMySeed, boolean nodeonly, float minversion) {
        Seed ys;
        ArrayList<Seed> v = new ArrayList<Seed>(this.seedActiveDB.size() + 1000);
        if (addMySeed) {
            v.add(this.mySeed);
        }
        Iterator<Seed> se = this.seedsConnected(true, false, null, minversion);
        while (se.hasNext() && v.size() < maxcount) {
            ys = se.next();
            if (ys == null || nodeonly && !ys.getFlagRootNode()) continue;
            v.add(ys);
        }
        se = this.seedsDisconnected(true, false, null, 0.0);
        long timeout = System.currentTimeMillis() - 86400000L;
        while (se.hasNext() && v.size() < maxcount) {
            ys = se.next();
            if (ys == null || ys.getLastSeenUTC() < timeout || nodeonly && !ys.getFlagRootNode()) continue;
            v.add(ys);
        }
        StringBuilder encoded = new StringBuilder(1024);
        for (Seed seed : v) {
            encoded.append(seed.genSeedStr(null)).append(serverCore.CRLF_STRING);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String uploadSeedList(yacySeedUploader uploader, serverSwitch sb, SeedDB seedDB, DigestURL seedURL) throws Exception {
        String log;
        block13: {
            if (seedURL == null) {
                throw new NullPointerException("UPLOAD - Error: URL not given");
            }
            log = null;
            File seedFile = null;
            try {
                Iterator<String> check;
                String errorMsg;
                seedFile = File.createTempFile("seedFile", ".txt", seedDB.myOwnSeedFile.getParentFile());
                if (Network.log.isFine()) {
                    Network.log.fine("SaveSeedList: Storing seedlist into tempfile " + seedFile.toString());
                }
                ArrayList<String> uv = this.storeSeedList(seedFile, true);
                if (Network.log.isFine()) {
                    Network.log.fine("SaveSeedList: Trying to upload seed-file, " + seedFile.length() + " bytes, " + uv.size() + " entries.");
                }
                log = uploader.uploadSeedFile(sb, seedFile);
                if (Network.log.isFine()) {
                    Network.log.fine("SaveSeedList: Trying to download seed-file '" + seedURL + "'.");
                }
                if ((errorMsg = SeedDB.checkCache(uv, check = SeedDB.downloadSeedFile(seedURL))) == null) {
                    log = log + "UPLOAD CHECK - Success: the result vectors are equal" + serverCore.CRLF_STRING;
                    break block13;
                }
                throw new Exception("UPLOAD CHECK - Error: the result vector is different. " + errorMsg + serverCore.CRLF_STRING);
            }
            finally {
                if (seedFile != null) {
                    try {
                        FileUtils.deletedelete(seedFile);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return log;
    }

    private static Iterator<String> downloadSeedFile(DigestURL seedURL) throws IOException {
        RequestHeader reqHeader = new RequestHeader();
        reqHeader.put("Pragma", "no-cache");
        reqHeader.put("Cache-Control", "no-cache, no-store");
        reqHeader.put("User-Agent", ClientIdentification.yacyInternetCrawlerAgent.userAgent);
        byte[] content = null;
        try (HTTPClient client = new HTTPClient(ClientIdentification.yacyInternetCrawlerAgent);){
            client.setHeader(reqHeader.entrySet());
            try {
                content = client.GETbytes(seedURL, null, null, false);
            }
            catch (Exception e) {
                throw new IOException("Unable to download seed file '" + seedURL + "'. " + e.getMessage());
            }
            if (client.getHttpResponse().getStatusLine().getStatusCode() != 200) {
                throw new IOException("Server returned status: " + client.getHttpResponse().getStatusLine());
            }
        }
        try {
            content = FileUtils.uncompressGZipArray(content);
            return FileUtils.strings(content);
        }
        catch (Exception e) {
            throw new IOException("Unable to uncompress seed file '" + seedURL + "'. " + e.getMessage());
        }
    }

    private static String checkCache(ArrayList<String> uv, Iterator<String> check) {
        if (check == null || uv == null) {
            if (Network.log.isFine()) {
                Network.log.fine("SaveSeedList: Local and uploades seed-list are different");
            }
            return "Entry count is different: uv.size() = " + (uv == null ? "null" : Integer.toString(uv.size()));
        }
        if (Network.log.isFine()) {
            Network.log.fine("SaveSeedList: Comparing local and uploades seed-list entries ...");
        }
        for (int i = 0; check.hasNext() && i < uv.size(); ++i) {
            if (uv.get(i).equals(check.next())) continue;
            return "Element at position " + i + " is different.";
        }
        return null;
    }

    @Override
    public String resolve(String host) {
        String subdom = null;
        if (host.endsWith(".yacyh")) {
            Set<String> ips;
            Seed seed;
            String hash;
            int p = host.indexOf(46);
            if (p > 0 && p != host.length() - 6) {
                subdom = host.substring(0, p);
                host = host.substring(p + 1);
            }
            if ((hash = host.substring(0, host.length() - 6)).length() > 12) {
                hash = Seed.hexHash2b64Hash(hash);
            }
            if ((seed = this.getConnected(hash)) == null) {
                if (this.mySeed == null) {
                    this.initMySeed();
                }
                if (hash.equals(this.mySeed.hash)) {
                    seed = this.mySeed;
                } else {
                    return null;
                }
            }
            if ((ips = seed.getIPs()).isEmpty()) {
                return null;
            }
            return seed.getPublicAddress(ips.iterator().next()) + (subdom == null ? "" : "/" + subdom);
        }
        if (host.endsWith(".yacy")) {
            String domain;
            Seed seed;
            int p = host.indexOf(46);
            if (p > 0 && p != host.length() - 5) {
                subdom = host.substring(0, p);
                host = host.substring(p + 1);
            }
            if ((seed = this.lookupByName(domain = host.substring(0, host.length() - 5).toLowerCase(Locale.ROOT))) == null) {
                return null;
            }
            if (this.mySeed == null) {
                this.initMySeed();
            }
            if (seed == this.mySeed && !seed.isOnline()) {
                Set<String> ips = Switchboard.getSwitchboard().myPublicIPs();
                if (ips.isEmpty()) {
                    return null;
                }
                return ips.iterator().next() + ":" + Switchboard.getSwitchboard().getLocalPort() + (subdom == null ? "" : "/" + subdom);
            }
            Set<String> ips = seed.getIPs();
            if (ips.isEmpty()) {
                return null;
            }
            return seed.getPublicAddress(ips.iterator().next()) + (subdom == null ? "" : "/" + subdom);
        }
        return null;
    }

    public void loadSeedListConcurrently(final String seedListFileURL, final AtomicInteger scc, final int timeout, final boolean checkAge) {
        Thread seedLoader = new Thread("SeedDB.loadSeedListConcurrently"){

            @Override
            public void run() {
                try (HTTPClient client = new HTTPClient(ClientIdentification.yacyInternetCrawlerAgent, timeout);){
                    DigestURL url = new DigestURL(seedListFileURL);
                    RequestHeader reqHeader = new RequestHeader();
                    reqHeader.put("Pragma", "no-cache");
                    reqHeader.put("Cache-Control", "no-cache, no-store");
                    client.setHeader(reqHeader.entrySet());
                    client.HEADResponse(url.toNormalform(false), false);
                    int statusCode = client.getHttpResponse().getStatusLine().getStatusCode();
                    ResponseHeader header = new ResponseHeader(statusCode, client.getHttpResponse().getAllHeaders());
                    if (checkAge) {
                        if (header.lastModified() == null) {
                            Network.log.warn("BOOTSTRAP: seed-list URL " + seedListFileURL + " not usable, last-modified is missing");
                            return;
                        }
                        if (header.age() > 86400000L && scc.get() > 0) {
                            Network.log.info("BOOTSTRAP: seed-list URL " + seedListFileURL + " too old (" + header.age() / 86400000L + " days)");
                            return;
                        }
                    }
                    scc.incrementAndGet();
                    byte[] content = client.GETbytes(url, null, null, false);
                    Iterator<String> enu = FileUtils.strings(content);
                    int lc = 0;
                    int uptodatec = 0;
                    int outdatedc = 0;
                    while (enu.hasNext()) {
                        try {
                            Seed ys = Seed.genRemoteSeed(enu.next(), false, null);
                            if (ys == null || SeedDB.this.mySeedIsDefined() && SeedDB.this.mySeed().hash.equals(ys.hash)) continue;
                            long lastseen = Math.abs((System.currentTimeMillis() - ys.getLastSeenUTC()) / 1000L / 60L);
                            if (lastseen < 240L) {
                                ++uptodatec;
                            } else {
                                ++outdatedc;
                            }
                            if (lastseen >= 240L && lc >= 10 || !SeedDB.this.peerActions.connectPeer(ys, false)) continue;
                            ++lc;
                        }
                        catch (Throwable e) {
                            Network.log.info("BOOTSTRAP: bad seed from " + seedListFileURL + ": " + e.getMessage());
                        }
                    }
                    Network.log.info("BOOTSTRAP: " + lc + " seeds from seed-list URL " + seedListFileURL + ", AGE=" + header.age() / 3600000L + "h, uptodatec = " + uptodatec + ", outdatedc = " + outdatedc);
                }
                catch (IOException e) {
                    Network.log.info("BOOTSTRAP: failed (1) to load seeds from seed-list URL " + seedListFileURL + ": " + e.getMessage());
                }
                catch (Exception e) {
                    Network.log.severe("BOOTSTRAP: failed (2) to load seeds from seed-list URL " + seedListFileURL + ": " + e.getMessage(), e);
                }
            }
        };
        seedLoader.start();
    }

    private class seedEnum
    implements Iterator<Seed> {
        private Iterator<Map.Entry<byte[], Map<String, String>>> it;
        private Seed nextSeed;
        private final MapDataMining database;
        private double minVersion;

        private seedEnum(boolean up, boolean rot, byte[] firstKey, byte[] secondKey, MapDataMining database, double minVersion) {
            this.database = database;
            this.minVersion = minVersion;
            try {
                double version2;
                this.it = firstKey == null ? database.entries(up, rot) : database.entries(up, rot, firstKey, secondKey);
                do {
                    this.nextSeed = this.internalNext();
                } while (this.nextSeed != null && !((version2 = this.nextSeed.getVersion().doubleValue()) >= this.minVersion) && version2 != 0.0);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                Network.log.severe("ERROR seedLinEnum: seed.db corrupt (" + e.getMessage() + "); resetting seed.db", e);
                if (database == SeedDB.this.seedActiveDB) {
                    SeedDB.this.seedActiveDB = SeedDB.this.resetSeedTable(SeedDB.this.seedActiveDB, SeedDB.this.seedActiveDBFile);
                }
                if (database == SeedDB.this.seedPassiveDB) {
                    SeedDB.this.seedPassiveDB = SeedDB.this.resetSeedTable(SeedDB.this.seedPassiveDB, SeedDB.this.seedPassiveDBFile);
                }
                this.it = null;
            }
            catch (kelondroException e) {
                ConcurrentLog.logException(e);
                Network.log.severe("ERROR seedLinEnum: seed.db corrupt (" + e.getMessage() + "); resetting seed.db", e);
                if (database == SeedDB.this.seedActiveDB) {
                    SeedDB.this.seedActiveDB = SeedDB.this.resetSeedTable(SeedDB.this.seedActiveDB, SeedDB.this.seedActiveDBFile);
                }
                if (database == SeedDB.this.seedPassiveDB) {
                    SeedDB.this.seedPassiveDB = SeedDB.this.resetSeedTable(SeedDB.this.seedPassiveDB, SeedDB.this.seedPassiveDBFile);
                }
                this.it = null;
            }
        }

        private seedEnum(boolean up, String field, MapDataMining database) {
            this.database = database;
            try {
                this.it = database.entries(up, field);
                this.nextSeed = this.internalNext();
            }
            catch (kelondroException e) {
                ConcurrentLog.logException(e);
                Network.log.severe("ERROR seedLinEnum: seed.db corrupt (" + e.getMessage() + "); resetting seed.db", e);
                if (database == SeedDB.this.seedActiveDB) {
                    SeedDB.this.seedActiveDB = SeedDB.this.resetSeedTable(SeedDB.this.seedActiveDB, SeedDB.this.seedActiveDBFile);
                }
                if (database == SeedDB.this.seedPassiveDB) {
                    SeedDB.this.seedPassiveDB = SeedDB.this.resetSeedTable(SeedDB.this.seedPassiveDB, SeedDB.this.seedPassiveDBFile);
                }
                if (database == SeedDB.this.seedPotentialDB) {
                    SeedDB.this.seedPotentialDB = SeedDB.this.resetSeedTable(SeedDB.this.seedPotentialDB, SeedDB.this.seedPotentialDBFile);
                }
                this.it = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextSeed != null;
        }

        private Seed internalNext() {
            if (this.it == null || !this.it.hasNext()) {
                return null;
            }
            try {
                while (this.it.hasNext()) {
                    Map.Entry<byte[], Map<String, String>> dna;
                    try {
                        dna = this.it.next();
                    }
                    catch (OutOfMemoryError e) {
                        ConcurrentLog.logException(e);
                        dna = null;
                    }
                    assert (dna != null);
                    if (dna == null || dna.getKey() == null) continue;
                    return new Seed(dna);
                }
                return null;
            }
            catch (Exception e) {
                ConcurrentLog.logException(e);
                Network.log.severe("ERROR internalNext: seed.db corrupt (" + e.getMessage() + "); resetting seed.db", e);
                if (this.database == SeedDB.this.seedActiveDB) {
                    SeedDB.this.seedActiveDB = SeedDB.this.resetSeedTable(SeedDB.this.seedActiveDB, SeedDB.this.seedActiveDBFile);
                }
                if (this.database == SeedDB.this.seedPassiveDB) {
                    SeedDB.this.seedPassiveDB = SeedDB.this.resetSeedTable(SeedDB.this.seedPassiveDB, SeedDB.this.seedPassiveDBFile);
                }
                if (this.database == SeedDB.this.seedPotentialDB) {
                    SeedDB.this.seedPotentialDB = SeedDB.this.resetSeedTable(SeedDB.this.seedPotentialDB, SeedDB.this.seedPotentialDBFile);
                }
                return null;
            }
        }

        @Override
        public Seed next() {
            Seed seed = this.nextSeed;
            try {
                double version2;
                do {
                    this.nextSeed = this.internalNext();
                } while (this.nextSeed != null && !((version2 = this.nextSeed.getVersion().doubleValue()) >= this.minVersion) && version2 != 0.0);
            }
            catch (kelondroException e) {
                ConcurrentLog.logException(e);
                Network.log.severe("seed-db emergency reset", e);
                this.database.clear();
                this.nextSeed = null;
                return null;
            }
            return seed;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

