/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.yacy.Distribution;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.Digest;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.sorting.ClusteredScoreMap;
import net.yacy.cora.storage.HandleSet;
import net.yacy.kelondro.data.word.Word;
import net.yacy.kelondro.util.MapTools;
import net.yacy.kelondro.util.OS;
import net.yacy.peers.Network;
import net.yacy.peers.SeedDB;
import net.yacy.peers.operation.yacyVersion;
import net.yacy.search.Switchboard;
import net.yacy.utils.Bitfield;
import net.yacy.utils.crypt;

public class Seed
implements Cloneable,
Comparable<Seed>,
Comparator<Seed> {
    public static String ANON_PREFIX = "agent";
    public static final int maxsize = 16000;
    public static final String INDEX_OUT = "sI";
    public static final String INDEX_IN = "rI";
    public static final String URL_OUT = "sU";
    public static final String URL_IN = "rU";
    public static final String PEERTYPE_VIRGIN = "virgin";
    public static final String PEERTYPE_JUNIOR = "junior";
    public static final String PEERTYPE_MENTEE = "mentee";
    public static final String PEERTYPE_SENIOR = "senior";
    public static final String PEERTYPE_MENTOR = "mentor";
    public static final String PEERTYPE_PRINCIPAL = "principal";
    public static final String PEERTYPE = "PeerType";
    private static final String FLAGS = "Flags";
    public static final String FLAGSZERO = "    ";
    public static final String VERSION = "Version";
    public static final String YOURTYPE = "yourtype";
    public static final String LASTSEEN = "LastSeen";
    private static final String USPEED = "USpeed";
    public static final String NAME = "Name";
    public static final String HASH = "Hash";
    private static final String BDATE = "BDate";
    public static final String UTC = "UTC";
    private static final String PEERTAGS = "Tags";
    public static final String ISPEED = "ISpeed";
    public static final String RSPEED = "RSpeed";
    public static final String UPTIME = "Uptime";
    public static final String LCOUNT = "LCount";
    public static final String NCOUNT = "NCount";
    public static final String RCOUNT = "RCount";
    public static final String ICOUNT = "ICount";
    public static final String SCOUNT = "SCount";
    public static final String CCOUNT = "CCount";
    public static final String IP = "IP";
    public static final String IP6 = "IP6";
    public static final String PORT = "Port";
    public static final String PORTSSL = "PortSSL";
    public static final String SEEDLISTURL = "seedURL";
    public static final String NEWS = "news";
    public static final String DCT = "dct";
    public static final String SOLRAVAILABLE = "SorlAvail";
    private static final String ZERO = "0";
    private static final int FLAG_DIRECT_CONNECT = 0;
    private static final int FLAG_ACCEPT_REMOTE_CRAWL = 1;
    private static final int FLAG_ACCEPT_REMOTE_INDEX = 2;
    private static final int FLAG_ROOT_NODE = 3;
    private static final int FLAG_SSL_AVAILABLE = 4;
    public static final String DFLT_NETWORK_UNIT = "freeworld";
    public static final String DFLT_NETWORK_GROUP = "";
    private static final Random random = new Random(System.currentTimeMillis());
    public final String hash;
    private final ConcurrentMap<String, String> dna;
    private long birthdate;
    Bitfield bitfield = null;
    private static final Pattern tp = Pattern.compile("<|>");

    private static ConcurrentMap<String, String> map2concurrentMap(Map<String, String> dna0) {
        ConcurrentHashMap<String, String> dna = new ConcurrentHashMap<String, String>();
        dna.putAll(dna0);
        return dna;
    }

    public Seed(Map.Entry<byte[], Map<String, String>> dna0) {
        this(UTF8.String(dna0.getKey()), dna0.getValue() instanceof ConcurrentMap ? (ConcurrentMap<String, String>)dna0.getValue() : Seed.map2concurrentMap(dna0.getValue()));
    }

    public Seed(String theHash, ConcurrentMap<String, String> theDna) {
        assert (theHash != null);
        this.hash = theHash;
        this.dna = theDna;
        String flags = (String)this.dna.get(FLAGS);
        if (flags == null) {
            flags = FLAGSZERO;
        }
        while (flags.length() < 4) {
            flags = flags + " ";
        }
        this.dna.put(FLAGS, flags);
        this.dna.put(NAME, Seed.checkPeerName(this.get(NAME, "&empty;")));
        this.birthdate = -1L;
    }

    private Seed(String theHash) {
        this.dna = new ConcurrentHashMap<String, String>();
        this.hash = theHash;
        this.dna.put(NAME, Seed.defaultPeerName());
        this.dna.put(ISPEED, ZERO);
        this.dna.put(RSPEED, ZERO);
        this.dna.put(UPTIME, ZERO);
        this.dna.put(LCOUNT, ZERO);
        this.dna.put(NCOUNT, ZERO);
        this.dna.put(RCOUNT, ZERO);
        this.dna.put(ICOUNT, ZERO);
        this.dna.put(SCOUNT, ZERO);
        this.dna.put(CCOUNT, ZERO);
        this.dna.put(VERSION, ZERO);
        this.dna.put(IP, DFLT_NETWORK_GROUP);
        this.dna.put(PORT, "&empty;");
        this.dna.put(USPEED, ZERO);
        this.dna.put(FLAGS, FLAGSZERO);
        this.setFlagDirectConnect(false);
        this.setFlagAcceptRemoteCrawl(true);
        this.setFlagAcceptRemoteIndex(true);
        this.setUnusedFlags();
        this.dna.put(INDEX_OUT, ZERO);
        this.dna.put(INDEX_IN, ZERO);
        this.dna.put(URL_OUT, ZERO);
        this.dna.put(URL_IN, ZERO);
        this.dna.put(BDATE, GenericFormatter.SHORT_SECOND_FORMATTER.format());
        this.dna.put(LASTSEEN, (String)this.dna.get(BDATE));
        this.dna.put(UTC, GenericFormatter.UTCDiffString());
        this.dna.put(PEERTYPE, PEERTYPE_VIRGIN);
        this.birthdate = System.currentTimeMillis();
    }

    public static String checkPeerName(String name) {
        name = tp.matcher(name).replaceAll("_");
        return name;
    }

    private static String defaultPeerName() {
        Random r = new Random(System.currentTimeMillis());
        char[] n = new char[7];
        for (int i = 0; i < 7; ++i) {
            n[i] = i % 2 == 1 ? "aeiou".charAt(r.nextInt(5)) : "bdfghklmnprst".charAt(r.nextInt(13));
        }
        return ANON_PREFIX + "-" + new String(n) + "-" + OS.infoKey() + "-" + Network.speedKey;
    }

    public static boolean isDefaultPeerName(String name) {
        return name.startsWith("_anon");
    }

    private Set<String> getIPv6Entries() {
        String ip6s = (String)this.dna.get(IP6);
        Set<String> set = Collections.synchronizedSet(new HashSet());
        if (ip6s == null) {
            return set;
        }
        StringTokenizer st = new StringTokenizer(ip6s, "|");
        while (st.hasMoreTokens()) {
            set.add(Domains.chopZoneID(st.nextToken().trim()));
        }
        return set;
    }

    @Deprecated
    public final String getIP() {
        String ipx = (String)this.dna.get(IP);
        if (ipx != null && !ipx.isEmpty()) {
            return Domains.chopZoneID(ipx);
        }
        Set<String> ip6s = this.getIPv6Entries();
        if (ip6s != null && ip6s.size() > 0) {
            return ip6s.iterator().next();
        }
        return null;
    }

    public final Set<String> getIPs() {
        LinkedHashSet<String> h = new LinkedHashSet<String>();
        String ipx = (String)this.dna.get(IP);
        Set<String> ip6s = this.getIPv6Entries();
        if (ipx != null && !ipx.isEmpty()) {
            h.add(Domains.chopZoneID(ipx));
        }
        h.addAll(ip6s);
        return h;
    }

    public final int countIPs() {
        String ipx = (String)this.dna.get(IP);
        Set<String> ip6s = this.getIPv6Entries();
        if (ip6s == null || ip6s.size() == 0) {
            return ipx == null || ipx.isEmpty() ? 0 : 1;
        }
        return ipx == null || ipx.isEmpty() ? ip6s.size() : ip6s.size() + 1;
    }

    public final boolean removeIP(String ip) {
        String ipx = Domains.chopZoneID((String)this.dna.get(IP));
        Set<String> ip6s = this.getIPv6Entries();
        if (ip6s == null || ip6s.size() == 0) {
            if (ipx != null && !ipx.isEmpty() && ipx.equals(ip)) {
                this.dna.put(IP, DFLT_NETWORK_GROUP);
                return true;
            }
            return false;
        }
        if (ip6s != null && ip6s.contains(ip)) {
            ip6s.remove(ip);
            this.dna.put(IP6, MapTools.set2string(ip6s, "|", false));
            return true;
        }
        if (ipx != null && !ipx.isEmpty() && ipx.equals(ip)) {
            ipx = ip6s.iterator().next();
            this.dna.put(IP, Domains.chopZoneID(ipx));
            ip6s.remove(ipx);
            this.dna.put(IP6, MapTools.set2string(ip6s, "|", false));
            return true;
        }
        return false;
    }

    public boolean clash(Set<String> ips) {
        Set<String> myIPs = this.getIPs();
        for (String s : ips) {
            if (!myIPs.contains(s) || !Seed.isProperIP(s)) continue;
            return true;
        }
        return false;
    }

    public final String getPeerType() {
        return this.get(PEERTYPE, DFLT_NETWORK_GROUP);
    }

    public final String orVirgin() {
        return this.get(PEERTYPE, PEERTYPE_VIRGIN);
    }

    public final String orJunior() {
        return this.get(PEERTYPE, PEERTYPE_JUNIOR);
    }

    public final String orSenior() {
        return this.get(PEERTYPE, PEERTYPE_SENIOR);
    }

    public final String orPrincipal() {
        return this.get(PEERTYPE, PEERTYPE_PRINCIPAL);
    }

    public final String get(String key, String dflt) {
        Object o = this.dna.get(key);
        if (o == null) {
            return dflt;
        }
        return (String)o;
    }

    public final float getFloat(String key, float dflt) {
        Object o = this.dna.get(key);
        if (o == null) {
            return dflt;
        }
        if (o instanceof String) {
            try {
                return Float.parseFloat((String)o);
            }
            catch (NumberFormatException e) {
                return dflt;
            }
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        return dflt;
    }

    public final long getLong(String key, long dflt) {
        Object o = this.dna.get(key);
        if (o == null) {
            return dflt;
        }
        if (o instanceof String) {
            try {
                return Long.parseLong((String)o);
            }
            catch (NumberFormatException e) {
                return dflt;
            }
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        return dflt;
    }

    public final void setIP(String ip) {
        if (!Seed.isProperIP(ip = Domains.chopZoneID(ip))) {
            return;
        }
        String oldIP = (String)this.dna.get(IP);
        String oldIP6 = (String)this.dna.get(IP6);
        if (!(oldIP != null && oldIP.length() != 0 || oldIP6 != null && oldIP6.length() != 0)) {
            this.dna.put(IP, ip);
        } else if (oldIP == null || !oldIP.equals(ip)) {
            if (oldIP == null || oldIP.length() == 0 || ip.indexOf(58) == 0) {
                this.dna.put(IP, ip);
            } else {
                this.dna.put(IP6, ip);
            }
        }
    }

    public final void setPort(Integer port) {
        if (!Seed.isProperPort(port)) {
            return;
        }
        this.dna.put(PORT, String.valueOf(port));
    }

    public final void setIPs(Set<String> ips) {
        HashSet<String> ipv6 = new HashSet<String>();
        HashSet<String> ipv4 = new HashSet<String>();
        for (String ip : ips) {
            if (!Seed.isProperIP(ip)) continue;
            if (ip.indexOf(58) >= 0) {
                ipv6.add(ip);
                continue;
            }
            ipv4.add(ip);
        }
        if (ipv4.size() == 0) {
            if (ipv6.size() == 1) {
                this.dna.put(IP, (String)ipv6.iterator().next());
                this.dna.put(IP6, DFLT_NETWORK_GROUP);
            } else if (ipv6.size() > 1) {
                this.dna.put(IP, DFLT_NETWORK_GROUP);
                this.dna.put(IP6, MapTools.set2string(ipv6, "|", false));
            }
        } else {
            this.dna.put(IP, Domains.chopZoneID((String)ipv4.iterator().next()));
            this.dna.put(IP6, MapTools.set2string(ipv6, "|", false));
        }
    }

    public final void setPort(String port) {
        this.dna.put(PORT, port);
    }

    public final void setType(String type) {
        this.dna.put(PEERTYPE, type);
    }

    public final void setJunior() {
        this.dna.put(PEERTYPE, PEERTYPE_JUNIOR);
    }

    public final void setSenior() {
        this.dna.put(PEERTYPE, PEERTYPE_SENIOR);
    }

    public final void setPrincipal() {
        this.dna.put(PEERTYPE, PEERTYPE_PRINCIPAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(String key, String value) {
        ConcurrentMap<String, String> concurrentMap = this.dna;
        synchronized (concurrentMap) {
            this.dna.put(key, value);
        }
    }

    public final ConcurrentMap<String, String> getMap() {
        return this.dna;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setName(String name) {
        ConcurrentMap<String, String> concurrentMap = this.dna;
        synchronized (concurrentMap) {
            this.dna.put(NAME, Seed.checkPeerName(name));
        }
    }

    public final String getName() {
        return Seed.checkPeerName(this.get(NAME, "&empty;"));
    }

    public final String getHexHash() {
        return Seed.b64Hash2hexHash(this.hash);
    }

    public final void incSI(int count) {
        String v = (String)this.dna.get(INDEX_OUT);
        if (v == null) {
            v = ZERO;
        }
        this.dna.put(INDEX_OUT, Long.toString(Long.parseLong(v) + (long)count));
    }

    public final void incRI(int count) {
        String v = (String)this.dna.get(INDEX_IN);
        if (v == null) {
            v = ZERO;
        }
        this.dna.put(INDEX_IN, Long.toString(Long.parseLong(v) + (long)count));
    }

    public final void incSU(int count) {
        String v = (String)this.dna.get(URL_OUT);
        if (v == null) {
            v = ZERO;
        }
        this.dna.put(URL_OUT, Long.toString(Long.parseLong(v) + (long)count));
    }

    public final void incRU(int count) {
        String v = (String)this.dna.get(URL_IN);
        if (v == null) {
            v = ZERO;
        }
        this.dna.put(URL_IN, Long.toString(Long.parseLong(v) + (long)count));
    }

    public final void resetCounters() {
        this.dna.put(INDEX_OUT, ZERO);
        this.dna.put(INDEX_IN, ZERO);
        this.dna.put(URL_OUT, ZERO);
        this.dna.put(URL_IN, ZERO);
    }

    public static String b64Hash2octalHash(String b64Hash) {
        return Digest.encodeOctal(Base64Order.enhancedCoder.decode(b64Hash));
    }

    public static String b64Hash2hexHash(String b64Hash) {
        if (b64Hash.length() > 12) {
            return DFLT_NETWORK_GROUP;
        }
        return Digest.encodeHex(Base64Order.enhancedCoder.decode(b64Hash));
    }

    public static String hexHash2b64Hash(String hexHash) {
        return Base64Order.enhancedCoder.encode(Digest.decodeHex(hexHash));
    }

    public final Double getVersion() {
        try {
            return Double.parseDouble(this.get(VERSION, ZERO));
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public final int getRevision() {
        return yacyVersion.revision(this.get(VERSION, ZERO));
    }

    public final String getPublicAddress(InetAddress ip) {
        if (ip == null) {
            throw new RuntimeException("ip == NULL");
        }
        String port = (String)this.dna.get(PORT);
        if (port == null || port.length() < 2 || port.length() > 5) {
            throw new RuntimeException("port not wellformed: " + port);
        }
        StringBuilder sb = new StringBuilder();
        if (ip instanceof Inet6Address) {
            sb.append('[').append(ip.getHostAddress()).append(']');
        } else {
            sb.append(ip.getHostAddress());
        }
        sb.append(':');
        sb.append(port);
        return sb.toString();
    }

    public final String getPublicAddress(String ip) {
        if (ip == null) {
            throw new RuntimeException("ip == NULL");
        }
        String port = (String)this.dna.get(PORT);
        StringBuilder sb = new StringBuilder(ip.length() + 8);
        if (ip.indexOf(58) >= 0) {
            if (!ip.startsWith("[")) {
                sb.append('[');
            }
            sb.append(ip);
            if (!ip.endsWith("]")) {
                sb.append(']');
            }
        } else {
            sb.append(ip);
        }
        if (port == null || port.length() < 2 || port.length() > 5) {
            Network.log.severe("port not wellformed for peer" + this.getName() + ": " + port == null ? "null" : port);
        } else {
            sb.append(':');
            sb.append(port);
        }
        return sb.toString();
    }

    public final String getPublicURL(String ip, boolean preferHTTPS) throws RuntimeException {
        String port;
        String scheme;
        if (ip == null) {
            throw new RuntimeException("ip == NULL");
        }
        if (preferHTTPS && this.getFlagSSLAvailable()) {
            scheme = "https://";
            port = (String)this.dna.get(PORTSSL);
        } else {
            scheme = "http://";
            port = (String)this.dna.get(PORT);
        }
        StringBuilder sb = new StringBuilder(scheme.length() + ip.length() + 8);
        sb.append(scheme);
        if (ip.indexOf(58) >= 0) {
            if (!ip.startsWith("[")) {
                sb.append('[');
            }
            sb.append(ip);
            if (!ip.endsWith("]")) {
                sb.append(']');
            }
        } else {
            sb.append(ip);
        }
        if (port == null || port.length() < 2 || port.length() > 5) {
            Network.log.severe(preferHTTPS ? "https" : ("http  port not wellformed for peer" + this.getName() + ": " + port == null ? "null" : port));
        } else {
            sb.append(':');
            sb.append(port);
        }
        return sb.toString();
    }

    public final MultiProtocolURL getPublicMultiprotocolURL(String ip, boolean preferHTTPS) throws RuntimeException, MalformedURLException {
        return new MultiProtocolURL(this.getPublicURL(ip, preferHTTPS));
    }

    public final int getPort() {
        String port = (String)this.dna.get(PORT);
        if (port == null) {
            return -1;
        }
        return Integer.parseInt(port);
    }

    public final void setLastSeenUTC() {
        try {
            this.dna.put(LASTSEEN, GenericFormatter.FORMAT_SHORT_SECOND.format(Instant.now()));
        }
        catch (DateTimeException e) {
            this.dna.put(LASTSEEN, GenericFormatter.SHORT_SECOND_FORMATTER.format(new Date()));
        }
    }

    public final long getLastSeenUTC() {
        try {
            long t;
            String lastSeenStr = this.get(LASTSEEN, "20040101000000");
            try {
                t = LocalDateTime.parse(lastSeenStr, GenericFormatter.FORMAT_SHORT_SECOND).toInstant(ZoneOffset.UTC).toEpochMilli();
            }
            catch (RuntimeException e) {
                GenericFormatter my_SHORT_SECOND_FORMATTER = new GenericFormatter(GenericFormatter.newShortSecondFormat(), 1000L);
                t = my_SHORT_SECOND_FORMATTER.parse(lastSeenStr, 0).getTime().getTime();
            }
            return t;
        }
        catch (ParseException e) {
            return System.currentTimeMillis() - 86400000L;
        }
        catch (NumberFormatException e) {
            return System.currentTimeMillis() - 86400000L;
        }
    }

    public final boolean isLastSeenTimeout(long milliseconds) {
        long d = Math.abs(System.currentTimeMillis() - this.getLastSeenUTC());
        return d > milliseconds;
    }

    public final long getBirthdate() {
        long b;
        if (this.birthdate > 0L) {
            return this.birthdate;
        }
        String bdateStr = this.get(BDATE, "20040101000000");
        try {
            b = LocalDateTime.parse(bdateStr, GenericFormatter.FORMAT_SHORT_SECOND).toInstant(ZoneOffset.UTC).toEpochMilli();
        }
        catch (RuntimeException e) {
            try {
                GenericFormatter my_SHORT_SECOND_FORMATTER = new GenericFormatter(GenericFormatter.newShortSecondFormat(), 1000L);
                b = my_SHORT_SECOND_FORMATTER.parse(bdateStr, 0).getTime().getTime();
            }
            catch (ParseException pe) {
                b = System.currentTimeMillis();
            }
        }
        this.birthdate = b;
        return this.birthdate;
    }

    public final int getAge() {
        return (int)Math.abs((System.currentTimeMillis() - this.getBirthdate()) / 1000L / 60L / 60L / 24L);
    }

    public void setPeerTags(Set<String> keys) {
        this.dna.put(PEERTAGS, MapTools.set2string(keys, "|", false));
    }

    public Set<String> getPeerTags() {
        return MapTools.string2set(this.get(PEERTAGS, "*"), "|");
    }

    public boolean matchPeerTags(HandleSet searchHashes) {
        String peertags = this.get(PEERTAGS, DFLT_NETWORK_GROUP);
        if (peertags.equals("*")) {
            return true;
        }
        Set<String> tags = MapTools.string2set(peertags, "|");
        Iterator<String> i = tags.iterator();
        while (i.hasNext()) {
            if (!searchHashes.has(Word.word2hash(i.next()))) continue;
            return true;
        }
        return false;
    }

    public int getPPM() {
        try {
            return Integer.parseInt(this.get(ISPEED, ZERO));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public float getQPM() {
        try {
            return Float.parseFloat(this.get(RSPEED, ZERO));
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public final long getLinkCount() {
        try {
            return this.getLong(LCOUNT, 0L);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public final long getWordCount() {
        try {
            return this.getLong(ICOUNT, 0L);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private boolean getFlag(int flag) {
        if (this.bitfield == null) {
            String flags = this.get(FLAGS, FLAGSZERO);
            this.bitfield = new Bitfield(ASCII.getBytes(flags));
        }
        return this.bitfield.get(flag);
    }

    private void setFlag(int flag, boolean value) {
        String flags = this.get(FLAGS, FLAGSZERO);
        if (flags.length() != 4) {
            flags = FLAGSZERO;
        }
        Bitfield f = new Bitfield(ASCII.getBytes(flags));
        f.set(flag, value);
        this.dna.put(FLAGS, UTF8.String(f.getBytes()));
        this.bitfield = null;
    }

    public final void setFlagDirectConnect(boolean value) {
        this.setFlag(0, value);
    }

    public final boolean getFlagDirectConnect() {
        return this.getFlag(0);
    }

    public final void setFlagAcceptRemoteCrawl(boolean value) {
        this.setFlag(1, value);
    }

    public final boolean getFlagAcceptRemoteCrawl() {
        return this.getFlag(1);
    }

    public final void setFlagAcceptRemoteIndex(boolean value) {
        this.setFlag(2, value);
    }

    public final boolean getFlagAcceptRemoteIndex() {
        return this.getFlag(2);
    }

    public final void setFlagRootNode(boolean value) {
        this.setFlag(3, value);
    }

    public final boolean getFlagRootNode() {
        double v = this.getVersion();
        if (v < 1.02009142) {
            return false;
        }
        return this.getFlag(3);
    }

    public final void setFlagSSLAvailable(boolean value) {
        this.setFlag(4, value);
    }

    public final boolean getFlagSSLAvailable() {
        if (this.getVersion() < 1.5) {
            return false;
        }
        return this.getFlag(4);
    }

    public final void setFlagSolrAvailable(boolean value) {
        if (value) {
            this.dna.put(SOLRAVAILABLE, "OK");
        } else {
            this.dna.put(SOLRAVAILABLE, "NA");
        }
    }

    public final boolean getFlagSolrAvailable() {
        String solravail = (String)this.dna.get(SOLRAVAILABLE);
        boolean my = solravail != null && "NA".equals(solravail);
        return !my;
    }

    public final void setUnusedFlags() {
        for (int i = 5; i < 20; ++i) {
            this.setFlag(i, false);
        }
    }

    public final boolean isType(String type) {
        return this.get(PEERTYPE, DFLT_NETWORK_GROUP).equals(type);
    }

    public final boolean isVirgin() {
        return this.get(PEERTYPE, DFLT_NETWORK_GROUP).equals(PEERTYPE_VIRGIN);
    }

    public final boolean isJunior() {
        return this.get(PEERTYPE, DFLT_NETWORK_GROUP).equals(PEERTYPE_JUNIOR);
    }

    public final boolean isSenior() {
        return this.get(PEERTYPE, DFLT_NETWORK_GROUP).equals(PEERTYPE_SENIOR);
    }

    public final boolean isPrincipal() {
        return this.get(PEERTYPE, DFLT_NETWORK_GROUP).equals(PEERTYPE_PRINCIPAL);
    }

    public final boolean isPotential() {
        return this.isVirgin() || this.isJunior();
    }

    public final boolean isActive() {
        return this.isSenior() || this.isPrincipal();
    }

    public final boolean isOnline() {
        return this.isSenior() || this.isPrincipal();
    }

    public final boolean isOnline(String type) {
        return type.equals(PEERTYPE_SENIOR) || type.equals(PEERTYPE_PRINCIPAL);
    }

    public long nextLong(Random random, long n) {
        return Math.abs(random.nextLong()) % n;
    }

    private static byte[] bestGap(SeedDB seedDB) {
        long right;
        long gap8;
        long gapx;
        byte[] randomHash = Seed.randomHash();
        if (seedDB == null || seedDB.sizeConnected() <= 2) {
            return randomHash;
        }
        TreeMap<Long, String> gaps = Seed.hashGaps(seedDB);
        String interval = null;
        while (!gaps.isEmpty()) {
            interval = gaps.remove(gaps.lastKey());
            if (!random.nextBoolean()) continue;
        }
        if (interval == null) {
            return Seed.randomHash();
        }
        long left = Distribution.horizontalDHTPosition(ASCII.getBytes(interval.substring(0, 12)));
        long gappos = Long.MAX_VALUE - left >= (gapx = (gap8 = Distribution.horizontalDHTDistance(left, right = Distribution.horizontalDHTPosition(ASCII.getBytes(interval.substring(12)))) >> 3) + Math.abs(random.nextLong()) % (6L * gap8)) ? left + gapx : left - Long.MAX_VALUE + gapx;
        byte[] computedHash = Distribution.positionToHash(gappos);
        byte[] combined = new byte[12];
        System.arraycopy(computedHash, 0, combined, 0, 2);
        System.arraycopy(randomHash, 2, combined, 2, 10);
        if (combined[0] == 65 || combined[1] == 68) {
            combined[1] = randomHash[1];
        }
        while (seedDB.hasConnected(combined) || seedDB.hasDisconnected(combined) || seedDB.hasPotential(combined)) {
            combined = Seed.randomHash();
        }
        return combined;
    }

    private static TreeMap<Long, String> hashGaps(SeedDB seedDB) {
        long l;
        TreeMap<Long, String> gaps = new TreeMap<Long, String>();
        if (seedDB == null) {
            return gaps;
        }
        Iterator<Seed> i = seedDB.seedsConnected(true, false, null, 0.0);
        Seed s0 = null;
        Seed first = null;
        while (i.hasNext()) {
            Seed s1 = i.next();
            if (s0 == null) {
                first = s0 = s1;
                continue;
            }
            l = Distribution.horizontalDHTDistance(Distribution.horizontalDHTPosition(ASCII.getBytes(s0.hash)), Distribution.horizontalDHTPosition(ASCII.getBytes(s1.hash)));
            gaps.put(l, s0.hash + s1.hash);
            s0 = s1;
        }
        if (first != null && s0 != null) {
            l = Distribution.horizontalDHTDistance(Distribution.horizontalDHTPosition(ASCII.getBytes(s0.hash)), Distribution.horizontalDHTPosition(ASCII.getBytes(first.hash)));
            gaps.put(l, s0.hash + first.hash);
        }
        return gaps;
    }

    public static Seed genLocalSeed(SeedDB db) {
        String hashs = ASCII.String(Seed.bestGap(db));
        Network.log.info("init: OWN SEED = " + hashs);
        Seed newSeed = new Seed(hashs);
        int port = Switchboard.getSwitchboard().getPublicPort("port", 8090);
        newSeed.dna.put(NAME, Seed.defaultPeerName());
        newSeed.dna.put(PORT, Integer.toString(port));
        return newSeed;
    }

    public static byte[] randomHash() {
        String hash = Base64Order.enhancedCoder.encode(Digest.encodeMD5Raw(Long.toString(random.nextLong()))).substring(0, 6) + Base64Order.enhancedCoder.encode(Digest.encodeMD5Raw(Long.toString(random.nextLong()))).substring(0, 6);
        return ASCII.getBytes(hash);
    }

    public static Seed genRemoteSeed(String seedStr, boolean ownSeed, String patchIP) throws IOException {
        if (seedStr == null) {
            throw new IOException("seedStr == null");
        }
        if (seedStr.isEmpty()) {
            throw new IOException("seedStr.isEmpty()");
        }
        String seed = crypt.simpleDecode(seedStr);
        if (seed == null) {
            throw new IOException("seed == null");
        }
        if (seed.isEmpty()) {
            throw new IOException("seed.isEmpty()");
        }
        ConcurrentHashMap<String, String> dna = MapTools.string2map(seed, ",");
        String hash = dna.remove(HASH);
        if (hash == null) {
            throw new IOException("hash == null");
        }
        Seed resultSeed = new Seed(hash, dna);
        String testResult = resultSeed.isProper(ownSeed);
        if (testResult != null && patchIP != null) {
            resultSeed.setIP(patchIP);
            testResult = resultSeed.isProper(ownSeed);
        }
        if (testResult != null) {
            throw new IOException("seed is not proper (" + testResult + "): " + resultSeed);
        }
        return resultSeed;
    }

    public final String isProper(boolean checkOwnIP) {
        block13: {
            String seedURL;
            if (this.hash == null) {
                return "hash is null";
            }
            if (this.hash.length() != 12) {
                return "wrong hash length (" + this.hash.length() + ")";
            }
            String peerName = (String)this.dna.get(NAME);
            if (peerName == null) {
                return "no peer name given";
            }
            this.dna.put(NAME, Seed.checkPeerName(peerName));
            String peerType = this.getPeerType();
            if (peerType == null || !peerType.equals(PEERTYPE_VIRGIN) && !peerType.equals(PEERTYPE_JUNIOR) && !peerType.equals(PEERTYPE_SENIOR) && !peerType.equals(PEERTYPE_PRINCIPAL)) {
                return "invalid peerType '" + peerType + "'";
            }
            if (!checkOwnIP) {
                Set<String> ips = this.getIPs();
                if (ips.isEmpty()) {
                    return "no IP at all";
                }
                for (String ip : ips) {
                    if (Seed.isProperIP(ip)) continue;
                    Network.log.severe("not a proper IP " + ip + " peer : " + this.getName() + "ips " + ips);
                    return "not a proper IP " + ip;
                }
            }
            if ((seedURL = (String)this.dna.get(SEEDLISTURL)) != null && !seedURL.isEmpty()) {
                if (!seedURL.startsWith("http://") && !seedURL.startsWith("https://")) {
                    return "wrong protocol for seedURL";
                }
                try {
                    URL url = new URL(seedURL);
                    String host = url.getHost();
                    if (!Domains.isIntranet(host)) break block13;
                    if (Switchboard.getSwitchboard().isIntranetMode()) {
                        if (Domains.isLocalhost(host)) {
                            return "seedURL on local host rejected (" + host + ")";
                        }
                        break block13;
                    }
                    return "seedURL in local network rejected (" + host + ")";
                }
                catch (MalformedURLException e) {
                    return "seedURL malformed";
                }
            }
        }
        return null;
    }

    public static final boolean isProperIP(String ipString) {
        if (ipString == null) {
            return false;
        }
        if (ipString.length() < 3) {
            return false;
        }
        if (Switchboard.getSwitchboard().isAllIPMode()) {
            return true;
        }
        boolean islocal = Domains.isLocal(ipString, null);
        return islocal == Switchboard.getSwitchboard().isIntranetMode();
    }

    public static final boolean isProperPort(Integer port) {
        if (port <= 0) {
            return false;
        }
        return port <= 65535;
    }

    public final String toString() {
        ConcurrentHashMap<String, String> copymap = new ConcurrentHashMap<String, String>();
        copymap.putAll(this.dna);
        copymap.put(HASH, this.hash);
        String s = MapTools.map2string(copymap, ",", true);
        return s;
    }

    public final String genSeedStr(String key) {
        String r = this.toString();
        String z = crypt.simpleEncode(r, key, 'z');
        String b = crypt.simpleEncode(r, key, 'b');
        return b.length() < z.length() ? b : z;
    }

    public final void save(File f) throws IOException {
        String out = crypt.simpleEncode(this.toString(), null, 'p');
        FileWriter fw = new FileWriter(f);
        fw.write(out, 0, out.length());
        fw.close();
    }

    public static Seed load(File f) throws IOException {
        FileReader fr = new FileReader(f);
        char[] b = new char[(int)f.length()];
        fr.read(b, 0, b.length);
        fr.close();
        Seed mySeed = Seed.genRemoteSeed(new String(b), true, null);
        assert (mySeed != null);
        mySeed.dna.put(IP, DFLT_NETWORK_GROUP);
        return mySeed;
    }

    public final Seed clone() {
        ConcurrentHashMap<String, String> ndna = new ConcurrentHashMap<String, String>();
        ndna.putAll(this.dna);
        return new Seed(this.hash, ndna);
    }

    @Override
    public int compareTo(Seed arg0) {
        int o2;
        int o1 = this.hashCode();
        if (o1 > (o2 = arg0.hashCode())) {
            return 1;
        }
        if (o2 > o1) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        return (int)(Base64Order.enhancedCoder.cardinal(this.hash) & Integer.MAX_VALUE);
    }

    @Override
    public int compare(Seed o1, Seed o2) {
        return o1.compareTo(o2);
    }

    @Override
    public boolean equals(Object other) {
        return this.hash.equals(((Seed)other).hash);
    }

    public static void main(String[] args) {
        ClusteredScoreMap<Integer> s = new ClusteredScoreMap<Integer>(true);
        for (int i = 0; i < 10000; ++i) {
            byte[] b = Seed.randomHash();
            s.inc(0xFF & Base64Order.enhancedCoder.decodeByte(b[0]));
        }
        Iterator i = s.keys(false);
        while (i.hasNext()) {
            System.out.println(i.next());
        }
    }
}

