/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.feed.RSSFeed;
import net.yacy.cora.document.feed.RSSMessage;
import net.yacy.cora.document.feed.RSSReader;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.solr.connector.RemoteSolrConnector;
import net.yacy.cora.federate.solr.connector.SolrConnector;
import net.yacy.cora.federate.solr.instance.RemoteInstance;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.Digest;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.http.HTTPClient;
import net.yacy.cora.sorting.ClusteredScoreMap;
import net.yacy.cora.sorting.ReversibleScoreMap;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.ByteBuffer;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.crawler.data.ResultURLs;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.kelondro.data.word.WordReference;
import net.yacy.kelondro.data.word.WordReferenceFactory;
import net.yacy.kelondro.data.word.WordReferenceVars;
import net.yacy.kelondro.rwi.Reference;
import net.yacy.kelondro.rwi.ReferenceContainer;
import net.yacy.kelondro.rwi.ReferenceContainerCache;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.peers.Accessible;
import net.yacy.peers.EventChannel;
import net.yacy.peers.Network;
import net.yacy.peers.PeerActions;
import net.yacy.peers.Seed;
import net.yacy.peers.SeedDB;
import net.yacy.peers.graphics.ProfilingGraph;
import net.yacy.peers.graphics.WebStructureGraph;
import net.yacy.repository.Blacklist;
import net.yacy.search.EventTracker;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Segment;
import net.yacy.search.query.SearchEvent;
import net.yacy.search.query.SecondarySearchSuperviser;
import net.yacy.search.schema.CollectionSchema;
import net.yacy.search.snippet.TextSnippet;
import net.yacy.server.serverCore;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.utils.crypt;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public final class Protocol {
    public static AtomicInteger metadataRetrievalRunning = new AtomicInteger(0);

    public static Map<String, String> hello(Seed mySeed, PeerActions peerActions, MultiProtocolURL targetBaseURL, String targetHash) {
        String seedStr;
        String error;
        String mytype;
        String seed;
        Map<String, String> result = null;
        String salt = crypt.randomSalt();
        long responseTime = Long.MAX_VALUE;
        byte[] content = null;
        try (HTTPClient httpClient = new HTTPClient(ClientIdentification.yacyInternetCrawlerAgent, 30000);){
            LinkedHashMap<String, ContentBody> parts = Protocol.basicRequestParts(Switchboard.getSwitchboard(), null, salt);
            parts.put("count", (ContentBody)UTF8.StringBody("20"));
            parts.put("magic", (ContentBody)UTF8.StringBody(Long.toString(Network.magic)));
            parts.put("seed", (ContentBody)UTF8.StringBody(mySeed.genSeedStr(salt)));
            long start = System.currentTimeMillis();
            content = httpClient.POSTbytes(new MultiProtocolURL(targetBaseURL, "/yacy/hello.html"), Seed.b64Hash2hexHash(targetHash) + ".yacyh", parts, false, true);
            responseTime = System.currentTimeMillis() - start;
            result = FileUtils.table(content);
        }
        catch (Exception e) {
            if (Thread.currentThread().isInterrupted()) {
                Network.log.info("yacyClient.hello thread '" + Thread.currentThread().getName() + "' interrupted.");
                return null;
            }
            Network.log.info("yacyClient.hello thread '" + Thread.currentThread().getName() + "', peer " + targetBaseURL + "; exception: " + e.getMessage());
            result = null;
        }
        if (result == null || result.size() == 0) {
            Network.log.info("yacyClient.hello result error: " + (result == null ? "result null" : "result=" + result.toString()));
            return null;
        }
        Network.log.info("yacyClient.hello thread '" + Thread.currentThread().getName() + "' contacted peer at " + targetBaseURL + ", received " + (content == null ? "null" : Integer.valueOf(content.length)) + " bytes, time = " + responseTime + " milliseconds");
        Seed otherPeer = null;
        if (targetHash != null && targetHash.length() > 0 && (seed = result.get("seed0")) != null) {
            if (seed.length() > 16000) {
                Network.log.info("hello/client 0: rejected contacting seed; too large (" + seed.length() + " > " + 16000 + ")");
            } else {
                try {
                    String host = Domains.stripToHostName(targetBaseURL.getHost());
                    InetAddress ie = Domains.dnsResolve(host);
                    otherPeer = Seed.genRemoteSeed(seed, false, ie.getHostAddress());
                    if (!otherPeer.hash.equals(targetHash)) {
                        Network.log.info("yacyClient.hello: consistency error: otherPeer.hash = " + otherPeer.hash + ", otherHash = " + targetHash);
                        return null;
                    }
                }
                catch (IOException e) {
                    Network.log.info("yacyClient.hello: consistency error: other seed bad:" + e.getMessage() + ", seed=" + seed);
                    return null;
                }
            }
        }
        if ((mytype = result.get("yourtype")) == null) {
            mytype = "";
        }
        if (serverCore.useStaticIP) {
            mySeed.setIPs(Switchboard.getSwitchboard().myPublicIPs());
        } else {
            String myIP = result.get("yourip");
            if (myIP == null) {
                Network.log.info("yacyClient.hello result error: Peer sent incompleet hello message (key yourip is missing)");
                return null;
            }
            HashSet<String> h = new HashSet<String>();
            for (String s : CommonPattern.COMMA.split(myIP)) {
                if (s.length() <= 0 || !Seed.isProperIP(s)) continue;
                h.add(s);
            }
            if (h.size() > 0) {
                mySeed.setIPs(h);
            }
        }
        mySeed.setFlagRootNode((mytype.equals("senior") || mytype.equals("principal")) && Switchboard.getSwitchboard().index.fulltext().connectedLocalSolr() && responseTime < 1000L && Domains.isThisHostIP(mySeed.getIPs()));
        Accessible accessible = new Accessible();
        if (mytype.equals("senior") || mytype.equals("principal")) {
            accessible.IWasAccessed = true;
            if (mySeed.isPrincipal()) {
                mytype = "principal";
            }
        } else {
            accessible.IWasAccessed = false;
        }
        accessible.lastUpdated = System.currentTimeMillis();
        Network.amIAccessibleDB.put(targetHash, accessible);
        if (mytype.equalsIgnoreCase("junior")) {
            Network.log.info("yacyClient.hello: Peer '" + (otherPeer == null ? "unknown" : otherPeer.getName()) + "' reported us as junior.");
        } else if (mytype.equalsIgnoreCase("senior") || mytype.equalsIgnoreCase("principal")) {
            if (Network.log.isFine()) {
                Network.log.fine("yacyClient.hello: Peer '" + (otherPeer == null ? "unknown" : otherPeer.getName()) + "' reported us as " + mytype + ", accepted other peer.");
            }
        } else {
            if (Network.log.isFine()) {
                Network.log.fine("yacyClient.hello: Peer '" + (otherPeer == null ? "unknown" : otherPeer.getName()) + "' reported us as " + mytype + ", rejecting other peer.");
            }
            return null;
        }
        if (mySeed.orVirgin().equals("virgin")) {
            mySeed.put("PeerType", mytype);
        }
        if ((error = mySeed.isProper(true)) != null) {
            Network.log.warn("yacyClient.hello mySeed error - not proper: " + error);
            return null;
        }
        int i = 0;
        int connectedBefore = peerActions.sizeConnected();
        while ((seedStr = result.get("seed" + i++)) != null) {
            if (seedStr.length() > 16000) {
                Network.log.info("hello/client: rejected contacting seed; too large (" + seedStr.length() + " > " + 16000 + ")");
                continue;
            }
            try {
                Seed s;
                if (i == 1) {
                    String host = Domains.stripToHostName(targetBaseURL.getHost());
                    InetAddress ia = Domains.dnsResolve(host);
                    if (ia == null) continue;
                    host = ia.getHostAddress();
                    s = Seed.genRemoteSeed(seedStr, false, host);
                } else {
                    s = Seed.genRemoteSeed(seedStr, false, null);
                }
                peerActions.peerArrival(s, i == 1);
            }
            catch (IOException e) {
                Network.log.info("hello/client: rejected contacting seed; bad (" + e.getMessage() + ")");
            }
        }
        int connectedAfter = peerActions.sizeConnected();
        EventTracker.update(EventTracker.EClass.PEERPING, new ProfilingGraph.EventPing(mySeed.getName(), targetHash, true, connectedAfter - connectedBefore), false);
        return result;
    }

    public static long[] queryRWICount(MultiProtocolURL targetBaseURL, Seed target, int timeout) {
        String salt = crypt.randomSalt();
        try {
            LinkedHashMap<String, ContentBody> parts = Protocol.basicRequestParts(Switchboard.getSwitchboard(), target.hash, salt);
            parts.put("object", (ContentBody)UTF8.StringBody("rwicount"));
            parts.put("env", (ContentBody)UTF8.StringBody(""));
            Post post = new Post(targetBaseURL, target.hash, "/yacy/query.html", parts, timeout);
            Map<String, String> result = FileUtils.table(post.result);
            if (result == null || result.isEmpty()) {
                return new long[]{-1L, -1L};
            }
            String resp = result.get("response");
            if (resp == null) {
                return new long[]{-1L, -1L};
            }
            String magic = result.get("magic");
            if (magic == null) {
                magic = "0";
            }
            try {
                return new long[]{Long.parseLong(resp), Long.parseLong(magic)};
            }
            catch (NumberFormatException e) {
                return new long[]{-1L, -1L};
            }
        }
        catch (Exception e) {
            if (Network.log.isFine()) {
                Network.log.fine("yacyClient.queryRWICount error:" + e.getMessage());
            }
            return new long[]{-1L, -1L};
        }
    }

    public static RSSFeed queryRemoteCrawlURLs(SeedDB seedDB, Seed target, int maxCount, long maxTime, boolean preferHttps) {
        RSSFeed feed2;
        if (target == null) {
            return null;
        }
        int targetCount = Integer.parseInt(target.get("RCount", "0"));
        if (targetCount <= 0) {
            Network.log.warn("yacyClient.queryRemoteCrawlURLs wrong peer '" + target.getName() + "' selected: not enough links available");
            return null;
        }
        String salt = crypt.randomSalt();
        LinkedHashMap<String, ContentBody> parts = Protocol.basicRequestParts(Switchboard.getSwitchboard(), target.hash, salt);
        parts.put("call", (ContentBody)UTF8.StringBody("remotecrawl"));
        parts.put("count", (ContentBody)UTF8.StringBody(Integer.toString(maxCount)));
        parts.put("time", (ContentBody)UTF8.StringBody(Long.toString(maxTime)));
        RSSReader reader = null;
        try (HTTPClient httpClient = new HTTPClient(ClientIdentification.yacyInternetCrawlerAgent, (int)maxTime);){
            for (String ip : target.getIPs()) {
                MultiProtocolURL targetBaseURL = null;
                try {
                    byte[] result;
                    targetBaseURL = target.getPublicMultiprotocolURL(ip, preferHttps);
                    try {
                        result = httpClient.POSTbytes(new MultiProtocolURL(targetBaseURL, "/yacy/urls.xml"), target.getHexHash() + ".yacyh", parts, false, true);
                    }
                    catch (IOException e) {
                        if (targetBaseURL.isHTTPS()) {
                            targetBaseURL = target.getPublicMultiprotocolURL(ip, false);
                            result = httpClient.POSTbytes(new MultiProtocolURL(targetBaseURL, "/yacy/urls.xml"), target.getHexHash() + ".yacyh", parts, false, true);
                            if (result != null) {
                                Protocol.markSSLUnavailableOnPeer(seedDB, target, ip, "yacyClient.queryRemoteCrawlURLs");
                            }
                        }
                        throw e;
                    }
                    reader = RSSReader.parse(10000, result);
                }
                catch (MalformedURLException e) {
                    Network.log.warn("yacyClient.queryRemoteCrawlURLs malformed target URL for peer '" + target.getName() + "' on address : " + ip);
                }
                catch (IOException e) {
                    reader = null;
                    Network.log.warn("yacyClient.queryRemoteCrawlURLs failed asking peer '" + target.getName() + "': probably bad response from remote peer (1), reader == null");
                }
                if (reader != null) {
                    break;
                }
                target.put("RCount", "0");
                seedDB.peerActions.interfaceDeparture(target, ip);
            }
        }
        catch (IOException e) {
            Network.log.warn(e);
        }
        RSSFeed rSSFeed = feed2 = reader == null ? null : reader.getFeed();
        if (feed2 == null) {
            Network.log.warn("yacyClient.queryRemoteCrawlURLs failed asking peer '" + target.getName() + "': probably bad response from remote peer (2)");
            target.put("RCount", "0");
            seedDB.updateConnected(target);
            return null;
        }
        target.put("RCount", Integer.toString(Math.max(0, targetCount - feed2.size())));
        seedDB.updateConnected(target);
        return feed2;
    }

    protected static int primarySearch(SearchEvent event, String wordhashes, String excludehashes, String language, Classification.ContentDomain contentdom, boolean strictContentDom, int count, long time, int maxDistance, int partitions, Seed target, SecondarySearchSuperviser secondarySearchSuperviser, Blacklist blacklist) throws InterruptedException {
        long timestamp = System.currentTimeMillis();
        event.addExpectedRemoteReferences(count);
        SearchResult result = null;
        Iterator<String> iterator = target.getIPs().iterator();
        if (iterator.hasNext()) {
            String ip = iterator.next();
            String targetBaseURL = target.clash(event.peers.mySeed().getIPs()) ? "http://localhost:" + event.peers.mySeed().getPort() : target.getPublicURL(ip, Switchboard.getSwitchboard().getConfigBool("remotesearch.https.preferred", false));
            try {
                result = new SearchResult(event, Protocol.basicRequestParts(Switchboard.getSwitchboard(), target.hash, crypt.randomSalt()), wordhashes, excludehashes, "", language, contentdom, strictContentDom, count, time, maxDistance, partitions, target.getHexHash() + ".yacyh", targetBaseURL, secondarySearchSuperviser);
            }
            catch (IOException e) {
                Network.log.info("SEARCH failed, Peer: " + target.hash + ":" + target.getName() + " (" + e.getMessage() + ")");
                if (targetBaseURL.startsWith("https")) {
                    target.setFlagSSLAvailable(false);
                    event.peers.updateConnected(target);
                } else {
                    event.peers.peerActions.interfaceDeparture(target, ip);
                }
                return -1;
            }
        }
        if (result == null) {
            return -1;
        }
        long totalrequesttime = System.currentTimeMillis() - timestamp;
        try {
            Protocol.remoteSearchProcess(event, count, totalrequesttime, wordhashes, target, blacklist, result);
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
            return -1;
        }
        if (secondarySearchSuperviser != null) {
            String whacc = "";
            int ac = 0;
            for (Map.Entry<byte[], String> abstractEntry : result.indexabstract.entrySet()) {
                String wordhash;
                ByteBuffer ci;
                try {
                    ci = new ByteBuffer(abstractEntry.getValue());
                    wordhash = ASCII.String(abstractEntry.getKey());
                }
                catch (OutOfMemoryError e) {
                    ConcurrentLog.logException(e);
                    continue;
                }
                whacc = whacc + wordhash;
                secondarySearchSuperviser.addAbstract(wordhash, WordReferenceFactory.decompressIndex(ci, target.hash));
                ++ac;
            }
            if (ac > 0) {
                secondarySearchSuperviser.commitAbstract();
                Network.log.info("remote search: peer " + target.getName() + " sent " + ac + " index abstracts for words " + whacc);
            }
        }
        return result.availableCount;
    }

    protected static int secondarySearch(SearchEvent event, String wordhashes, String urlhashes, Classification.ContentDomain contentdom, boolean strictContentDom, int count, long time, int maxDistance, int partitions, Seed target, Blacklist blacklist) throws InterruptedException {
        long timestamp = System.currentTimeMillis();
        event.addExpectedRemoteReferences(count);
        SearchResult result = null;
        Iterator<String> iterator = target.getIPs().iterator();
        if (iterator.hasNext()) {
            String ip = iterator.next();
            String targetBaseURL = target.getPublicURL(ip, Switchboard.getSwitchboard().getConfigBool("remotesearch.https.preferred", false));
            try {
                result = new SearchResult(event, Protocol.basicRequestParts(Switchboard.getSwitchboard(), target.hash, crypt.randomSalt()), wordhashes, "", urlhashes, "", contentdom, strictContentDom, count, time, maxDistance, partitions, target.getHexHash() + ".yacyh", targetBaseURL, null);
            }
            catch (IOException e) {
                Network.log.info("SEARCH failed, Peer: " + target.hash + ":" + target.getName() + " (" + e.getMessage() + ")");
                if (targetBaseURL.startsWith("https")) {
                    target.setFlagSSLAvailable(false);
                    event.peers.updateConnected(target);
                } else {
                    event.peers.peerActions.interfaceDeparture(target, ip);
                }
                return -1;
            }
        }
        if (result == null) {
            return -1;
        }
        long totalrequesttime = System.currentTimeMillis() - timestamp;
        try {
            Protocol.remoteSearchProcess(event, count, totalrequesttime, wordhashes, target, blacklist, result);
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
            return -1;
        }
        return result.availableCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void remoteSearchProcess(SearchEvent event, int count, long time, String wordhashes, Seed target, Blacklist blacklist, SearchResult result) throws SpaceExceededException, InterruptedException {
        int words = wordhashes.length() / 12;
        assert (words > 0) : "wordhashes = " + wordhashes;
        ArrayList<ReferenceContainer<WordReference>> container = new ArrayList<ReferenceContainer<WordReference>>(words);
        for (int i = 0; i < words; ++i) {
            container.add(ReferenceContainer.emptyContainer(Segment.wordReferenceFactory, ASCII.getBytes(wordhashes.substring(i * 12, (i + 1) * 12)), count));
        }
        int term = count;
        HashMap<String, LinkedHashSet<String>> snip = event.addResultsToLocalIndex ? null : new HashMap<String, LinkedHashSet<String>>();
        ArrayList<URIMetadataNode> storeDocs = new ArrayList<URIMetadataNode>(result.links.size());
        block10: for (URIMetadataNode uRIMetadataNode : result.links) {
            if (term-- <= 0) break;
            if (uRIMetadataNode == null) continue;
            assert (uRIMetadataNode.hash().length == 12) : "urlEntry.hash() = " + ASCII.String(uRIMetadataNode.hash());
            if (uRIMetadataNode.hash().length != 12) continue;
            if (blacklist.isListed(Blacklist.BlacklistType.SEARCH, uRIMetadataNode.url())) {
                if (!Network.log.isInfo()) continue;
                Network.log.info("remote search: filtered blacklisted url " + uRIMetadataNode.url().toNormalform(true) + " from peer " + target.getName());
                continue;
            }
            String urlRejectReason = Switchboard.getSwitchboard().crawlStacker.urlInAcceptedDomain(uRIMetadataNode.url());
            if (urlRejectReason != null) {
                if (!Network.log.isInfo()) continue;
                Network.log.info("remote search: rejected url '" + uRIMetadataNode.url().toNormalform(true) + "' (" + urlRejectReason + ") from peer " + target.getName());
                continue;
            }
            WordReferenceVars entry2 = uRIMetadataNode.word();
            if (entry2 == null) {
                if (!Network.log.isWarn()) continue;
                Network.log.warn("remote search: no word attached from peer " + target.getName() + ", version " + target.getVersion());
                continue;
            }
            if (!Base64Order.enhancedCoder.equal(entry2.urlhash(), uRIMetadataNode.hash())) {
                Network.log.info("remote search: url-hash " + ASCII.String(uRIMetadataNode.hash()) + " does not belong to word-attached-hash " + ASCII.String(entry2.urlhash()) + "; url = " + uRIMetadataNode.url().toNormalform(true) + " from peer " + target.getName());
                continue;
            }
            storeDocs.add(uRIMetadataNode);
            ResultURLs.stack(ASCII.String(uRIMetadataNode.url().hash()), uRIMetadataNode.url().getHost(), event.peers.mySeed().hash.getBytes(), UTF8.getBytes(target.hash), ResultURLs.EventOrigin.QUERIES);
            if (uRIMetadataNode.snippet() != null && uRIMetadataNode.snippet().length() > 0 && !uRIMetadataNode.snippet().equals("null")) {
                TextSnippet.snippetsCache.put(wordhashes, ASCII.String(uRIMetadataNode.hash()), uRIMetadataNode.snippet());
                if (!event.addResultsToLocalIndex) {
                    LinkedHashSet<String> sniptxt = new LinkedHashSet<String>();
                    sniptxt.add(uRIMetadataNode.snippet());
                    snip.put(ASCII.String(uRIMetadataNode.hash()), sniptxt);
                }
            }
            for (ReferenceContainer referenceContainer : container) {
                try {
                    referenceContainer.add(entry2);
                }
                catch (SpaceExceededException e) {
                    ConcurrentLog.logException(e);
                    continue block10;
                }
            }
        }
        if (event.addResultsToLocalIndex) {
            if (Thread.interrupted()) {
                throw new InterruptedException("solrQuery interrupted");
            }
            WriteMetadataNodeToLocalIndexThread writerToLocalIndex = new WriteMetadataNodeToLocalIndexThread(event.query.getSegment(), storeDocs);
            writerToLocalIndex.start();
            try {
                writerToLocalIndex.join();
            }
            catch (InterruptedException interruptedException) {
                writerToLocalIndex.stopWriting();
                throw new InterruptedException("remoteProcess stopped!");
            }
            event.addRWIs((ReferenceContainer)container.get(0), false, target.getName() + "/" + target.hash, result.totalCount, time);
        } else {
            event.addNodes(storeDocs, null, snip, false, target.getName() + "/" + target.hash, count, true);
        }
        event.addFinalize();
        event.addExpectedRemoteReferences(-count);
        for (ReferenceContainer referenceContainer : container) {
            try {
                event.query.getSegment().storeRWI(referenceContainer);
            }
            catch (Exception e) {
                ConcurrentLog.logException(e);
            }
        }
        if (result.references != null && result.references.length > 0) {
            Network.log.info("remote search: peer " + target.getName() + " sent " + result.references.length + " topics");
            SearchEvent searchEvent = event;
            synchronized (searchEvent) {
                event.addTopic(result.references);
                event.addTopic(result.references);
            }
        }
        Network.log.info("remote search: peer " + target.getName() + " sent " + ((ReferenceContainer)container.get(0)).size() + "/" + result.totalCount + " references");
    }

    /*
     * Unable to fully structure code
     */
    protected static int solrQuery(SearchEvent event, SolrQuery solrQuery, int offset, int count, Seed target, int partitions, Blacklist blacklist, boolean useSolrFacets, boolean incrementNavigators) throws InterruptedException {
        if (event.query.getQueryGoal().getQueryString(false) == null || event.query.getQueryGoal().getQueryString(false).length() == 0) {
            return -1;
        }
        event.addExpectedRemoteReferences(count);
        if (partitions > 0) {
            solrQuery.set("partitions", partitions);
        }
        solrQuery.setStart(Integer.valueOf(offset));
        solrQuery.setRows(Integer.valueOf(count));
        localsearch = target == null || target.equals(event.peers.mySeed()) != false;
        facets = new HashMap<String, ReversibleScoreMap<String>>(event.query.facetfields.size());
        snippets = new HashMap<String, LinkedHashSet<String>>();
        rsp = new QueryResponse[]{null};
        docList = new SolrDocumentList[]{null};
        if (localsearch && !Switchboard.getSwitchboard().getConfigBool("debug.search.remote.solr.testlocal", false)) {
            try {
                sc = event.getQuery().getSegment().fulltext().getDefaultConnector();
                if (sc.isClosed()) ** GOTO lbl70
                rsp[0] = sc.getResponseByParams((ModifiableSolrParams)solrQuery);
                docList[0] = rsp[0].getResults();
            }
            catch (Throwable e) {
                Network.log.info("SEARCH failed (solr), localpeer (" + e.getMessage() + ")", e);
                return -1;
            }
        } else {
            targetBaseURL = null;
            try {
                v0 = myseed = target == event.peers.mySeed();
                if (myseed) {
                    targetBaseURL = "http://localhost:" + target.getPort();
                } else {
                    ips = target.getIPs();
                    if (ips.isEmpty()) {
                        Network.log.info("SEARCH failed (solr), remote Peer: " + target.getName() + " has no known IP address");
                        target.setFlagSolrAvailable(false);
                        return -1;
                    }
                    ip = ips.iterator().next();
                    targetBaseURL = target.getPublicURL(ip, Switchboard.getSwitchboard().getConfigBool("remotesearch.https.preferred", false));
                }
                if (!myseed && !target.getFlagSolrAvailable()) {
                    Network.log.info("SEARCH skip (solr), remote Solr interface not accessible, peer=" + target.getName());
                    return -1;
                }
                solrtimeout = Switchboard.getSwitchboard().getConfigInt("federated.service.solr.indexing.timeout", 6000);
                remoteRequest = new SolrRequestTask(solrQuery, (String)targetBaseURL, target, myseed, solrtimeout, rsp, docList);
                remoteRequest.start();
                remoteRequest.join(solrtimeout);
                if (remoteRequest.isAlive()) {
                    remoteRequest.close();
                    if (remoteRequest.isAlive()) {
                        remoteRequest.interrupt();
                    }
                    Network.log.info("SEARCH failed (solr), remote Peer: " + target.getName() + "/" + (String)targetBaseURL + " does not answer (time-out)");
                    target.setFlagSolrAvailable(myseed);
                    return -1;
                }
                if (rsp[0] == null || docList[0] == null) {
                    Network.log.info("SEARCH failed (solr), remote Peer: " + target.getName() + "/" + (String)targetBaseURL + " returned null");
                    if (!myseed) {
                        if (targetBaseURL.startsWith("https")) {
                            target.setFlagSSLAvailable(false);
                            event.peers.updateConnected(target);
                        } else {
                            target.setFlagSolrAvailable(false);
                        }
                    }
                    return -1;
                }
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Throwable e) {
                if (Network.log.isInfo()) {
                    Network.log.info("SEARCH failed (solr), remote Peer: " + target.getName() + (targetBaseURL != null ? "/" + (String)targetBaseURL : "") + " (" + e.getMessage() + ")");
                }
                target.setFlagSolrAvailable(localsearch);
                return -1;
            }
        }
lbl70:
        // 3 sources

        if (useSolrFacets) {
            for (String field : event.query.facetfields.keySet()) {
                facet = rsp[0].getFacetField(field);
                result = new ClusteredScoreMap<String>(UTF8.insensitiveUTF8Comparator);
                v1 = values = facet == null ? null : facet.getValues();
                if (values == null) continue;
                var19_30 = values.iterator();
                while (var19_30.hasNext()) {
                    ff = (FacetField.Count)var19_30.next();
                    c = (int)ff.getCount();
                    if (c == 0 || ff.getName().length() == 0) continue;
                    result.set(ff.getName(), c);
                }
                if (result.size() <= 0) continue;
                facets.put(field, result);
            }
        }
        if ((rawsnippets = rsp[0].getHighlighting()) != null) {
            block9: for (Map.Entry<K, V> re : rawsnippets.entrySet()) {
                rs = (Map)re.getValue();
                for (String field : solrQuery.getHighlightFields()) {
                    if (!rs.containsKey(field) || (s = (List)rs.get(field)).size() <= 0) continue;
                    ls = new LinkedHashSet<E>();
                    ls.addAll(s);
                    snippets.put((String)re.getKey(), ls);
                    continue block9;
                }
            }
        }
        rsp[0] = null;
        numFound = (int)docList[0].getNumFound();
        if (docList == null || docList[0].isEmpty()) {
            Network.log.info("SEARCH (solr), returned 0 out of 0 documents from " + (target == null ? "shard" : "peer " + target.hash + ":" + target.getName()) + " query = " + solrQuery.toString());
            if (localsearch && offset > 0) {
                event.local_solr_stored.set(numFound);
            }
            return 0;
        }
        resultContainer = new ArrayList<URIMetadataNode>();
        Network.log.info("SEARCH (solr), returned " + docList[0].size() + " out of " + docList[0].getNumFound() + " documents and " + facets.size() + " facets " + facets.keySet().toString() + " from " + (target == null ? "shard" : "peer " + target.hash + ":" + target.getName()));
        term = count;
        docs = event.addResultsToLocalIndex != false ? new ArrayList<SolrInputDocument>(docList[0].size()) : null;
        for (SolrDocument tmpdoc : docList[0]) {
            if (term-- <= 0) break;
            if (tmpdoc == null) continue;
            try {
                urlEntry = new URIMetadataNode(tmpdoc);
            }
            catch (MalformedURLException ex) {
                continue;
            }
            if (blacklist.isListed(Blacklist.BlacklistType.SEARCH, urlEntry.url())) {
                if (!Network.log.isInfo()) continue;
                if (localsearch) {
                    Network.log.info("local search (solr): filtered blacklisted url " + urlEntry.url().toNormalform(true));
                    continue;
                }
                Network.log.info("remote search (solr): filtered blacklisted url " + urlEntry.url().toNormalform(true) + " from " + (target == null ? "shard" : "peer " + target.hash + ":" + target.getName()));
                continue;
            }
            urlRejectReason = Switchboard.getSwitchboard().crawlStacker.urlInAcceptedDomain(urlEntry.url());
            if (urlRejectReason != null) {
                if (!Network.log.isInfo()) continue;
                if (localsearch) {
                    Network.log.info("local search (solr): rejected url '" + urlEntry.url().toNormalform(true) + "' (" + urlRejectReason + ")");
                    continue;
                }
                Network.log.info("remote search (solr): rejected url '" + urlEntry.url().toNormalform(true) + "' (" + urlRejectReason + ") from peer " + target.getName());
                continue;
            }
            if (!localsearch) {
                if (event.addResultsToLocalIndex) {
                    if (Protocol.checkDocumentSize(tmpdoc, event.getRemoteDocStoredMaxSize() * 1024L)) {
                        sid = event.query.getSegment().fulltext().getDefaultConfiguration().toSolrInputDocument(tmpdoc);
                        docs.add(sid);
                        event.query.getSegment().setFirstSeenTime(urlEntry.hash(), Math.min(urlEntry.moddate().getTime(), System.currentTimeMillis()));
                    } else {
                        Network.log.info("Document size greater than " + event.getRemoteDocStoredMaxSize() + " kbytes, excludes it from being stored to local index. Url : " + urlEntry.urlstring());
                    }
                }
                tmpdoc.removeFields(CollectionSchema.synonyms_sxt.getSolrFieldName());
                ResultURLs.stack(ASCII.String(urlEntry.url().hash()), urlEntry.url().getHost(), event.peers.mySeed().hash.getBytes(), UTF8.getBytes(target.hash), ResultURLs.EventOrigin.QUERIES);
            }
            resultContainer.add(urlEntry);
        }
        docList[0].clear();
        docList[0] = null;
        if (localsearch) {
            event.addNodes(resultContainer, facets, snippets, true, "localpeer", numFound, incrementNavigators);
            event.addFinalize();
            event.addExpectedRemoteReferences(-count);
            Network.log.info("local search (solr): localpeer sent " + resultContainer.size() + "/" + numFound + " references");
        } else {
            if (event.addResultsToLocalIndex) {
                if (Thread.interrupted()) {
                    throw new InterruptedException("solrQuery interrupted");
                }
                writeToLocalIndexThread = new WriteToLocalIndexThread(event.query.getSegment(), docs);
                writeToLocalIndexThread.start();
            }
            event.addNodes(resultContainer, facets, snippets, false, target.getName() + "/" + target.hash, numFound, incrementNavigators);
            event.addFinalize();
            event.addExpectedRemoteReferences(-count);
            Network.log.info("remote search (solr): peer " + target.getName() + " sent " + resultContainer.size() + "/" + numFound + " references");
        }
        return resultContainer.size();
    }

    protected static boolean checkDocumentSize(SolrDocument doc, long maxSize) {
        Object value;
        return maxSize <= 0L || !((value = doc.getFieldValue(CollectionSchema.text_t.getSolrFieldName())) instanceof String) || (long)((String)value).length() <= maxSize / 2L;
    }

    public static Map<String, String> permissionMessage(MultiProtocolURL targetBaseURL, Seed target, Switchboard sb) throws IOException {
        String salt = crypt.randomSalt();
        LinkedHashMap<String, ContentBody> parts = Protocol.basicRequestParts(sb, target.hash, salt);
        parts.put("process", (ContentBody)UTF8.StringBody("permission"));
        Post post = new Post(targetBaseURL, target.hash, "/yacy/message.html", parts, 6000);
        Map<String, String> result = FileUtils.table(post.result);
        return result;
    }

    public static Map<String, String> crawlReceipt(Switchboard sb, Seed mySeed, Seed target, String process, String result, String reason, URIMetadataNode entry2, String wordhashes) {
        assert (target != null);
        assert (mySeed != null);
        assert (mySeed != target);
        String salt = crypt.randomSalt();
        boolean preferHttps = sb.getConfigBool("network.unit.protocol.https.preferred", false);
        for (String ip : target.getIPs()) {
            try {
                byte[] content;
                block15: {
                    ArrayList<String> ldesc;
                    LinkedHashMap<String, ContentBody> parts = Protocol.basicRequestParts(sb, target.hash, salt);
                    parts.put("process", (ContentBody)UTF8.StringBody(process));
                    parts.put("urlhash", (ContentBody)UTF8.StringBody(entry2 == null ? "" : ASCII.String(entry2.hash())));
                    parts.put("result", (ContentBody)UTF8.StringBody(result));
                    parts.put("reason", (ContentBody)UTF8.StringBody(reason));
                    parts.put("wordh", (ContentBody)UTF8.StringBody(wordhashes));
                    String lurlstr = entry2 == null ? "" : ((ldesc = entry2.getDescription()).isEmpty() ? entry2.toString() : entry2.toString(ldesc.get(0)));
                    parts.put("lurlEntry", (ContentBody)UTF8.StringBody(crypt.simpleEncode(lurlstr, salt)));
                    try (HTTPClient httpClient = new HTTPClient(ClientIdentification.yacyInternetCrawlerAgent, 10000);){
                        MultiProtocolURL targetBaseURL = target.getPublicMultiprotocolURL(ip, preferHttps);
                        try {
                            content = httpClient.POSTbytes(new MultiProtocolURL(targetBaseURL, "/yacy/crawlReceipt.html"), target.getHexHash() + ".yacyh", parts, false, true);
                        }
                        catch (IOException e) {
                            if (targetBaseURL.isHTTPS()) {
                                targetBaseURL = target.getPublicMultiprotocolURL(ip, false);
                                content = httpClient.POSTbytes(new MultiProtocolURL(targetBaseURL, "/yacy/crawlReceipt.html"), target.getHexHash() + ".yacyh", parts, false, true);
                                if (content != null) {
                                    Protocol.markSSLUnavailableOnPeer(sb.peers, target, ip, "yacyClient.crawlReceipt");
                                }
                                break block15;
                            }
                            throw e;
                        }
                    }
                }
                return FileUtils.table(content);
            }
            catch (Exception e) {
                Network.log.warn("yacyClient.crawlReceipt error:" + e.getMessage());
            }
        }
        return null;
    }

    public static String transferIndex(Switchboard sb, Seed targetSeed, ReferenceContainerCache<WordReference> indexes, HandleSet urlRefs, Segment segment, boolean gzipBody, int timeout) {
        boolean preferHttps;
        Map<String, String> in;
        if (Network.log.isFine()) {
            for (ReferenceContainer<WordReference> referenceContainer : indexes) {
                Iterator<WordReference> eenum = referenceContainer.entries();
                while (eenum.hasNext()) {
                    Reference entry2 = eenum.next();
                    if (urlRefs.has(entry2.urlhash())) continue;
                    Network.log.fine("DEBUG transferIndex: to-send url hash '" + ASCII.String(entry2.urlhash()) + "' is not contained in urlCache");
                }
            }
        }
        if ((in = Protocol.transferRWI(targetSeed, indexes, gzipBody, timeout, preferHttps = sb.getConfigBool("network.unit.protocol.https.preferred", false))) == null) {
            String errorCause = "no connection from transferRWI";
            return errorCause;
        }
        String result = in.get("result");
        if (result == null) {
            String string = "no result from transferRWI";
            String usedIP = in.get("IP");
            sb.peers.peerActions.interfaceDeparture(targetSeed, usedIP);
            return string;
        }
        if (!result.equals("ok")) {
            targetSeed.setFlagAcceptRemoteIndex(false);
            sb.peers.addConnected(targetSeed);
            return result;
        }
        String string = in.get("unknownURL");
        if (string == null) {
            return "no unknownURL tag in response";
        }
        String string2 = string.trim();
        if (string2.isEmpty() || string2.equals(",")) {
            return null;
        }
        String[] uhs = CommonPattern.COMMA.split(string2);
        if (uhs.length == 0) {
            return null;
        }
        EventChannel.channels(EventChannel.DHTSEND).addMessage(new RSSMessage("Sent " + indexes.size() + " RWIs " + indexes.toString() + " to " + targetSeed.getName() + "/[" + targetSeed.hash + "], " + uhs.length + " URLs there unknown", "", targetSeed.hash));
        in = Protocol.transferURL(targetSeed, uhs, urlRefs, segment, gzipBody, timeout, preferHttps);
        if (in == null) {
            return "no connection from transferURL";
        }
        result = in.get("result");
        if (result == null) {
            String errorCause = "no result from transferURL";
            String usedIP = in.get("IP");
            sb.peers.peerActions.interfaceDeparture(targetSeed, usedIP);
            return errorCause;
        }
        if (!result.equals("ok")) {
            targetSeed.setFlagAcceptRemoteIndex(false);
            sb.peers.addConnected(targetSeed);
            return result;
        }
        EventChannel.channels(EventChannel.DHTSEND).addMessage(new RSSMessage("Sent " + uhs.length + " URLs to peer " + targetSeed.getName() + "/[" + targetSeed.hash + "]", "", targetSeed.hash));
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, String> transferRWI(Seed targetSeed, ReferenceContainerCache<WordReference> indexes, boolean gzipBody, int timeout, boolean preferHttps) {
        for (String ip : targetSeed.getIPs()) {
            if (ip == null) {
                Network.log.warn("no address for transferRWI");
                return null;
            }
            MultiProtocolURL targetBaseURL = null;
            try {
                targetBaseURL = targetSeed.getPublicMultiprotocolURL(ip, preferHttps);
            }
            catch (MalformedURLException e) {
                Network.log.info("yacyClient.transferRWI malformed target URL : " + targetBaseURL);
                Switchboard.getSwitchboard().peers.peerActions.interfaceDeparture(targetSeed, ip);
                continue;
            }
            String salt = crypt.randomSalt();
            if (gzipBody && targetSeed.getVersion() < 0.5820475816726685) {
                gzipBody = false;
            }
            int indexcount = 0;
            StringBuilder entrypost = new StringBuilder(indexes.size() * 73);
            for (ReferenceContainer<WordReference> referenceContainer : indexes) {
                Iterator<WordReference> eenum = referenceContainer.entries();
                while (eenum.hasNext()) {
                    Reference entry2 = eenum.next();
                    entrypost.append(ASCII.String(referenceContainer.getTermHash())).append(entry2.toPropertyForm()).append(serverCore.CRLF_STRING);
                    ++indexcount;
                }
            }
            if (indexcount == 0) {
                HashMap<String, String> result = new HashMap<String, String>(2);
                result.put("result", "ok");
                result.put("unknownURL", "");
                return result;
            }
            try {
                void var14_20;
                block19: {
                    LinkedHashMap<String, ContentBody> parts = Protocol.basicRequestParts(Switchboard.getSwitchboard(), targetSeed.hash, salt);
                    parts.put("wordc", (ContentBody)UTF8.StringBody(Integer.toString(indexes.size())));
                    parts.put("entryc", (ContentBody)UTF8.StringBody(Integer.toString(indexcount)));
                    parts.put("indexes", (ContentBody)UTF8.StringBody(entrypost.toString()));
                    Object var14_17 = null;
                    try (HTTPClient httpClient = new HTTPClient(ClientIdentification.yacyInternetCrawlerAgent, timeout);){
                        try {
                            byte[] byArray = httpClient.POSTbytes(new MultiProtocolURL(targetBaseURL, "/yacy/transferRWI.html"), targetSeed.getHexHash() + ".yacyh", parts, gzipBody, true);
                        }
                        catch (IOException e) {
                            if (targetBaseURL.isHTTPS()) {
                                targetBaseURL = targetSeed.getPublicMultiprotocolURL(ip, false);
                                byte[] byArray = httpClient.POSTbytes(new MultiProtocolURL(targetBaseURL, "/yacy/transferRWI.html"), targetSeed.getHexHash() + ".yacyh", parts, gzipBody, true);
                                if (byArray != null) {
                                    Protocol.markSSLUnavailableOnPeer(Switchboard.getSwitchboard().peers, targetSeed, ip, "yacyClient.transferRWI");
                                }
                                break block19;
                            }
                            throw e;
                        }
                    }
                }
                Iterator<String> v = FileUtils.strings((byte[])var14_20);
                ConcurrentHashMap<String, String> result = FileUtils.table(v);
                result.put("indexPayloadSize", Integer.toString(entrypost.length()));
                result.put("IP", ip);
                return result;
            }
            catch (Exception e) {
                Network.log.info("yacyClient.transferRWI to " + targetBaseURL + " error: " + e.getMessage());
                Switchboard.getSwitchboard().peers.peerActions.interfaceDeparture(targetSeed, ip);
            }
        }
        return null;
    }

    private static Map<String, String> transferURL(Seed targetSeed, String[] uhs, HandleSet urlRefs, Segment segment, boolean gzipBody, int timeout, boolean preferHttps) {
        for (String ip : targetSeed.getIPs()) {
            String salt = crypt.randomSalt();
            LinkedHashMap<String, ContentBody> parts = Protocol.basicRequestParts(Switchboard.getSwitchboard(), targetSeed.hash, salt);
            if (gzipBody && targetSeed.getVersion() < 0.5820475816726685) {
                gzipBody = false;
            }
            int urlc = 0;
            int urlPayloadSize = 0;
            metadataRetrievalRunning.incrementAndGet();
            for (int i = 0; i < uhs.length; ++i) {
                byte[] key = ASCII.getBytes(uhs[i]);
                if (!urlRefs.has(key)) continue;
                URIMetadataNode url = segment.fulltext().getMetadata(key);
                if (url == null) {
                    if (!Network.log.isFine()) continue;
                    Network.log.fine("DEBUG transferIndex: requested url hash '" + uhs[i] + "'");
                    continue;
                }
                String resource = url.toString();
                if (resource == null || resource.indexOf(0) != -1) continue;
                parts.put("url" + urlc, (ContentBody)UTF8.StringBody(resource));
                urlPayloadSize += resource.length();
                ++urlc;
            }
            metadataRetrievalRunning.decrementAndGet();
            try {
                byte[] content;
                block14: {
                    MultiProtocolURL targetBaseURL = targetSeed.getPublicMultiprotocolURL(ip, preferHttps);
                    parts.put("urlc", (ContentBody)UTF8.StringBody(Integer.toString(urlc)));
                    content = null;
                    try (HTTPClient httpClient = new HTTPClient(ClientIdentification.yacyInternetCrawlerAgent, timeout);){
                        try {
                            content = httpClient.POSTbytes(new MultiProtocolURL(targetBaseURL, "/yacy/transferURL.html"), targetSeed.getHexHash() + ".yacyh", parts, gzipBody, true);
                        }
                        catch (IOException e) {
                            if (targetBaseURL.isHTTPS()) {
                                targetBaseURL = targetSeed.getPublicMultiprotocolURL(ip, false);
                                content = httpClient.POSTbytes(new MultiProtocolURL(targetBaseURL, "/yacy/transferURL.html"), targetSeed.getHexHash() + ".yacyh", parts, gzipBody, true);
                                break block14;
                            }
                            throw e;
                        }
                    }
                }
                Iterator<String> v = FileUtils.strings(content);
                ConcurrentHashMap<String, String> result = FileUtils.table(v);
                result.put("urlPayloadSize", Integer.toString(urlPayloadSize));
                result.put("IP", ip);
                return result;
            }
            catch (Exception e) {
                Network.log.warn("yacyClient.transferURL to " + ip + " error: " + e.getMessage());
            }
        }
        return null;
    }

    public static Map<String, String> getProfile(Switchboard sb, Seed targetSeed) {
        String salt = crypt.randomSalt();
        boolean preferHttps = sb.getConfigBool("network.unit.protocol.https.preferred", false);
        for (String ip : targetSeed.getIPs()) {
            Map<String, String> map;
            HTTPClient httpclient = new HTTPClient(ClientIdentification.yacyInternetCrawlerAgent, 15000);
            try {
                byte[] content;
                LinkedHashMap<String, ContentBody> parts = Protocol.basicRequestParts(sb, targetSeed.hash, salt);
                MultiProtocolURL targetBaseURL = targetSeed.getPublicMultiprotocolURL(ip, preferHttps);
                try {
                    content = httpclient.POSTbytes(new MultiProtocolURL(targetBaseURL, "/yacy/profile.html"), targetSeed.getHexHash() + ".yacyh", parts, false, true);
                }
                catch (IOException e) {
                    if (targetBaseURL.isHTTPS()) {
                        targetBaseURL = targetSeed.getPublicMultiprotocolURL(ip, false);
                        content = httpclient.POSTbytes(new MultiProtocolURL(targetBaseURL, "/yacy/profile.html"), targetSeed.getHexHash() + ".yacyh", parts, false, true);
                        if (content != null) {
                            Protocol.markSSLUnavailableOnPeer(sb.peers, targetSeed, ip, "yacyClient.getProfile");
                        }
                    }
                    throw e;
                }
                map = FileUtils.table(content);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        httpclient.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Network.log.warn("yacyClient.getProfile error:" + e.getMessage());
                }
            }
            httpclient.close();
            return map;
        }
        return null;
    }

    public static ReferenceContainerCache<WebStructureGraph.HostReference> loadIDXHosts(Seed target) {
        ReferenceContainerCache<WebStructureGraph.HostReference> index2 = new ReferenceContainerCache<WebStructureGraph.HostReference>(WebStructureGraph.hostReferenceFactory, Base64Order.enhancedCoder, 6);
        if (target.getVersion() < 0.99007724) {
            return index2;
        }
        String salt = crypt.randomSalt();
        try {
            LinkedHashMap<String, ContentBody> parts = Protocol.basicRequestParts(Switchboard.getSwitchboard(), target.hash, salt);
            parts.put("object", (ContentBody)UTF8.StringBody("host"));
            Set<String> targetIps = target.getIPs();
            if (targetIps.isEmpty()) {
                Network.log.warn("yacyClient.loadIDXHosts error: no known address on target peer.");
                return null;
            }
            String remoteBaseURL = target.getPublicURL(targetIps.iterator().next(), Switchboard.getSwitchboard().getConfigBool("network.unit.protocol.https.preferred", false));
            Post post = new Post(new MultiProtocolURL(remoteBaseURL), target.hash, "/yacy/idx.json", parts, 30000);
            if (post.result == null || post.result.length == 0) {
                Network.log.warn("yacyClient.loadIDXHosts error: empty result");
                return null;
            }
            JSONObject json = new JSONObject(new JSONTokener(new InputStreamReader(new ByteArrayInputStream(post.result))));
            JSONObject idx2 = json.getJSONObject("idx");
            Iterator<String> termIterator = idx2.keys();
            while (termIterator.hasNext()) {
                String term = termIterator.next();
                JSONArray references = idx2.getJSONArray(term);
                int c = 0;
                ReferenceContainer<WebStructureGraph.HostReference> referenceContainer = new ReferenceContainer<WebStructureGraph.HostReference>(WebStructureGraph.hostReferenceFactory, UTF8.getBytes(term));
                try {
                    String reference;
                    while ((reference = references.getString(c++)) != null) {
                        referenceContainer.add(new WebStructureGraph.HostReference(reference));
                    }
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                index2.add(referenceContainer);
            }
            return index2;
        }
        catch (Exception e) {
            Network.log.warn("yacyClient.loadIDXHosts error:" + e.getMessage());
            return index2;
        }
    }

    public static final boolean authentifyRequest(serverObjects post, serverSwitch env) {
        if (post == null || env == null) {
            return false;
        }
        String unitName = post.get("network.unit.name", "freeworld");
        if (!unitName.equals(env.getConfig("network.unit.name", "freeworld"))) {
            return false;
        }
        String authenticationControl = env.getConfig("network.unit.protocol.control", "uncontrolled");
        if (authenticationControl.equals("uncontrolled")) {
            return true;
        }
        String authenticationMethod = env.getConfig("network.unit.protocol.request.authentication.method", "");
        if (authenticationMethod.isEmpty()) {
            return false;
        }
        if (authenticationMethod.equals("salted-magic-sim")) {
            String salt = post.get("key", "");
            String iam = post.get("iam", "");
            String magic = env.getConfig("network.unit.protocol.request.authentication.essentials", "");
            String md5 = Digest.encodeMD5Hex(salt + iam + magic);
            return post.get("magicmd5", "").equals(md5);
        }
        return false;
    }

    public static final LinkedHashMap<String, ContentBody> basicRequestParts(Switchboard sb, String targetHash, String salt) {
        LinkedHashMap<String, ContentBody> parts = new LinkedHashMap<String, ContentBody>();
        if (sb.peers.mySeed().hash != null) {
            String formattedTime;
            parts.put("iam", (ContentBody)UTF8.StringBody(sb.peers.mySeed().hash));
            if (targetHash != null) {
                parts.put("youare", (ContentBody)UTF8.StringBody(targetHash));
            }
            long myTime = System.currentTimeMillis();
            try {
                formattedTime = GenericFormatter.FORMAT_SHORT_SECOND.format(Instant.ofEpochMilli(myTime));
            }
            catch (DateTimeException e) {
                formattedTime = GenericFormatter.SHORT_SECOND_FORMATTER.format(new Date(myTime));
            }
            parts.put("mytime", (ContentBody)UTF8.StringBody(formattedTime));
            parts.put("myUTC", (ContentBody)UTF8.StringBody(Long.toString(myTime)));
            parts.put("network.unit.name", (ContentBody)UTF8.StringBody(Switchboard.getSwitchboard().getConfig("network.unit.name", "freeworld")));
        }
        parts.put("key", (ContentBody)UTF8.StringBody(salt));
        String authenticationControl = sb.getConfig("network.unit.protocol.control", "uncontrolled");
        String authenticationMethod = sb.getConfig("network.unit.protocol.request.authentication.method", "");
        if (authenticationControl.equals("controlled") && authenticationMethod.length() > 0 && authenticationMethod.equals("salted-magic-sim")) {
            String magic = sb.getConfig("network.unit.protocol.request.authentication.essentials", "");
            String md5 = Digest.encodeMD5Hex(salt + sb.peers.mySeed().hash + magic);
            parts.put("magicmd5", (ContentBody)UTF8.StringBody(md5));
        }
        return parts;
    }

    public static String requestPartsToString(Map<String, ContentBody> parts) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ContentBody> part : parts.entrySet()) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                part.getValue().writeTo((OutputStream)baos);
                baos.close();
                sb.append("&").append(part.getKey()).append("=").append(ASCII.String(baos.toByteArray()));
            }
            catch (IOException iOException) {}
        }
        return "?" + sb.toString().substring(1);
    }

    private static void markSSLUnavailableOnPeer(SeedDB seedDB, Seed peer, String address, String logPrefix) {
        Network.log.info(logPrefix + " SSL/TLS unavailable on peer '" + peer.getName() + "' : can be reached using http but not https on address " + address);
        peer.setFlagSSLAvailable(false);
        seedDB.updateConnected(peer);
    }

    private static class WriteToLocalIndexThread
    extends Thread {
        private AtomicBoolean stop = new AtomicBoolean(false);
        private Segment segment;
        private Collection<SolrInputDocument> docs;

        public WriteToLocalIndexThread(Segment segment, Collection<SolrInputDocument> docs) {
            super("WriteToLocalIndexThread");
            this.segment = segment;
            this.docs = docs;
        }

        @Override
        public void run() {
            for (SolrInputDocument doc : this.docs) {
                if (this.stop.get()) {
                    this.docs.clear();
                    Network.log.info("Writing documents collection to Solr segment was stopped.");
                    return;
                }
                this.segment.putDocument(doc);
            }
            this.docs.clear();
        }
    }

    protected static class SolrRequestTask
    extends Thread {
        private static final int MAX_ERROR_MESSAGE_LENGTH = 500;
        private static final ConcurrentLog log = new ConcurrentLog(SolrRequestTask.class.getSimpleName());
        private RemoteInstance instance;
        private SolrConnector solrConnector;
        private final SolrQuery solrQuery;
        private final String targetBaseURL;
        private final Seed target;
        private final boolean mySeed;
        private final int timeout;
        private final QueryResponse[] rsp;
        private final SolrDocumentList[] docList;
        private volatile boolean closed;

        protected SolrRequestTask(SolrQuery solrQuery, String targetBaseURL, Seed target, boolean mySeed, int timeout, QueryResponse[] rsp, SolrDocumentList[] docList) {
            super("Protocol.solrQuery(" + solrQuery.getQuery() + " to " + target.hash + ")");
            this.solrQuery = solrQuery;
            this.targetBaseURL = targetBaseURL;
            this.target = target;
            this.mySeed = mySeed;
            this.timeout = timeout;
            this.rsp = rsp;
            this.docList = docList;
            this.closed = false;
        }

        private void logError(String messageBegin, Exception ex) {
            if (log.isFine()) {
                String message2 = ex.getMessage();
                if (message2 == null) {
                    message2 = "no details";
                } else if (message2.length() > 500) {
                    message2 = message2.substring(0, 500) + "...";
                }
                log.fine(messageBegin + " at " + this.targetBaseURL + " : " + message2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: {
                try {
                    boolean trustSelfSignedOnAuthenticatedServer = false;
                    if (Switchboard.getSwitchboard() != null) {
                        trustSelfSignedOnAuthenticatedServer = Switchboard.getSwitchboard().getConfigBool("federated.service.solr.indexing.authenticated.allowSelfSigned", false);
                    }
                    long maxBytesPerResponse = MemoryControl.available() / 4L;
                    this.instance = new RemoteInstance(this.targetBaseURL, null, "solr", this.timeout, trustSelfSignedOnAuthenticatedServer, maxBytesPerResponse, false);
                    try {
                        boolean useBinaryResponseWriter = true;
                        if (Switchboard.getSwitchboard() != null) {
                            useBinaryResponseWriter = Switchboard.getSwitchboard().getConfigBool("remote.solr.binaryResponse.enabled", true);
                        }
                        this.solrConnector = new RemoteSolrConnector(this.instance, useBinaryResponseWriter && (this.mySeed || this.target.getVersion() >= 1.63), "solr");
                        if (this.solrConnector.isClosed() || this.closed) break block12;
                        try {
                            this.rsp[0] = this.solrConnector.getResponseByParams((ModifiableSolrParams)this.solrQuery);
                            this.docList[0] = this.rsp[0].getResults();
                            if (log.isFine() && this.rsp[0] != null && this.rsp[0].getElapsedTime() >= 0L) {
                                log.fine("Got a response from solr instance at " + this.targetBaseURL + " in " + this.rsp[0].getElapsedTime() + "ms");
                            }
                        }
                        catch (Exception e) {
                            this.logError("Could not get result from solr", e);
                        }
                    }
                    catch (Exception ee) {
                        this.logError("Could not connect to solr instance", ee);
                    }
                }
                catch (Exception eee) {
                    this.logError("Could not set up remote solr instance", eee);
                }
                finally {
                    this.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected synchronized void close() {
            if (this.closed) return;
            try {
                if (this.solrConnector == null) return;
                this.solrConnector.close();
                return;
            }
            catch (Exception e) {
                this.logError("Could not close solr connector", e);
                return;
            }
            finally {
                try {
                    if (this.instance != null) {
                        this.instance.close();
                    }
                }
                catch (Exception e) {
                    this.logError("Could not close solr instance", e);
                }
                finally {
                    this.closed = true;
                }
            }
        }
    }

    private static class SearchResult {
        public int availableCount;
        public int totalCount;
        public Map<byte[], Integer> indexcount;
        public String[] references;
        public List<URIMetadataNode> links;
        public Map<byte[], String> indexabstract;

        public SearchResult(SearchEvent event, Map<String, ContentBody> parts, String wordhashes, String excludehashes, String urlhashes, String language, Classification.ContentDomain contentdom, boolean strictContentDom, int count, long time, int maxDistance, int partitions, String hostname, String targetBaseURL, SecondarySearchSuperviser secondarySearchSuperviser) throws IOException {
            Map<String, String> resultMap = null;
            String key = "";
            ContentBody keyBody = parts.get("key");
            if (keyBody != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(20);
                keyBody.writeTo((OutputStream)baos);
                key = UTF8.String(baos.toByteArray());
                baos.close();
                baos = null;
            }
            parts.put("myseed", (ContentBody)UTF8.StringBody(event.peers.mySeed() == null ? "" : event.peers.mySeed().genSeedStr(key)));
            parts.put("count", (ContentBody)UTF8.StringBody(Integer.toString(Math.max(10, count))));
            parts.put("time", (ContentBody)UTF8.StringBody(Long.toString(Math.max(3000L, time))));
            parts.put("partitions", (ContentBody)UTF8.StringBody(Integer.toString(partitions)));
            parts.put("query", (ContentBody)UTF8.StringBody(wordhashes));
            parts.put("exclude", (ContentBody)UTF8.StringBody(excludehashes));
            parts.put("urls", (ContentBody)UTF8.StringBody(urlhashes));
            parts.put("prefer", (ContentBody)UTF8.StringBody(event.query.prefer.pattern()));
            parts.put("filter", (ContentBody)UTF8.StringBody(event.query.urlMaskString));
            parts.put("modifier", (ContentBody)UTF8.StringBody(event.query.modifier.toString()));
            parts.put("language", (ContentBody)UTF8.StringBody(language));
            parts.put("sitehash", (ContentBody)UTF8.StringBody(event.query.modifier.sitehash));
            parts.put("author", (ContentBody)UTF8.StringBody(event.query.modifier.author));
            parts.put("contentdom", (ContentBody)UTF8.StringBody(contentdom == null ? Classification.ContentDomain.ALL.toString() : contentdom.toString()));
            if (strictContentDom) {
                parts.put("strictContentDom", (ContentBody)UTF8.StringBody("true"));
            }
            parts.put("maxdist", (ContentBody)UTF8.StringBody(Integer.toString(maxDistance)));
            parts.put("profile", (ContentBody)UTF8.StringBody(crypt.simpleEncode(event.query.ranking.toExternalString())));
            parts.put("constraint", (ContentBody)UTF8.StringBody(event.query.constraint == null ? "" : event.query.constraint.exportB64()));
            if (secondarySearchSuperviser != null) {
                parts.put("abstracts", (ContentBody)UTF8.StringBody("auto"));
            }
            try (HTTPClient httpClient = new HTTPClient(ClientIdentification.yacyInternetCrawlerAgent, 8000);){
                byte[] a = httpClient.POSTbytes(new MultiProtocolURL(targetBaseURL + "/yacy/search.html"), hostname, parts, false, true);
                if (a != null && a.length > 200000) {
                    a = null;
                }
                resultMap = FileUtils.table(a);
            }
            if (resultMap == null || resultMap.isEmpty()) {
                throw new IOException("resultMap is NULL");
            }
            try {
                this.totalCount = Integer.parseInt(resultMap.get("joincount"));
            }
            catch (NumberFormatException e) {
                throw new IOException("wrong output format for joincount: " + e.getMessage());
            }
            try {
                this.availableCount = Integer.parseInt(resultMap.get("count"));
            }
            catch (NumberFormatException e) {
                throw new IOException("wrong output format for count: " + e.getMessage());
            }
            this.indexcount = new TreeMap<byte[], Integer>(Base64Order.enhancedCoder);
            this.indexabstract = new TreeMap<byte[], String>(Base64Order.enhancedCoder);
            for (Map.Entry<String, String> entry2 : resultMap.entrySet()) {
                if (entry2.getKey().startsWith("indexcount.")) {
                    this.indexcount.put(UTF8.getBytes(entry2.getKey().substring(11)), Integer.parseInt(entry2.getValue()));
                }
                if (!entry2.getKey().startsWith("indexabstract.")) continue;
                this.indexabstract.put(UTF8.getBytes(entry2.getKey().substring(14)), entry2.getValue());
            }
            this.references = CommonPattern.COMMA.split(resultMap.get("references"));
            this.links = new ArrayList<URIMetadataNode>(this.availableCount);
            for (int n = 0; n < this.availableCount; ++n) {
                URIMetadataNode urlEntry;
                String resultLine = resultMap.get("resource" + n);
                if (resultLine == null || (urlEntry = URIMetadataNode.importEntry(resultLine, "dht")) == null) continue;
                this.links.add(urlEntry);
            }
        }
    }

    private static class WriteMetadataNodeToLocalIndexThread
    extends Thread {
        private AtomicBoolean stop = new AtomicBoolean(false);
        private Segment segment;
        private Collection<URIMetadataNode> storeDocs;

        public WriteMetadataNodeToLocalIndexThread(Segment segment, Collection<URIMetadataNode> storeDocs) {
            super("WriteMetadataNodeToLocalIndexThread");
            this.segment = segment;
            this.storeDocs = storeDocs;
        }

        public void stopWriting() {
            this.stop.set(true);
        }

        @Override
        public void run() {
            for (URIMetadataNode entry2 : this.storeDocs) {
                if (this.stop.get()) {
                    Network.log.info("Writing documents collection to Solr segment was stopped.");
                    return;
                }
                try {
                    this.segment.setFirstSeenTime(entry2.hash(), Math.min(entry2.moddate().getTime(), System.currentTimeMillis()));
                    this.segment.fulltext().putMetadata(entry2);
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
        }
    }

    public static class Post {
        private byte[] result;

        public Post(MultiProtocolURL targetBaseURL, String targetHash, String path, Map<String, ContentBody> parts, int timeout) throws IOException {
            try (HTTPClient httpClient = new HTTPClient(ClientIdentification.yacyInternetCrawlerAgent);){
                httpClient.setTimout(timeout);
                MultiProtocolURL targetURL = new MultiProtocolURL(targetBaseURL, path);
                this.result = httpClient.POSTbytes(targetURL, Seed.b64Hash2hexHash(targetHash) + ".yacyh", parts, false, true);
            }
        }

        public byte[] getResult() {
            return this.result;
        }
    }
}

