/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers;

import java.util.Map;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.feed.RSSMessage;
import net.yacy.cora.storage.ConcurrentARC;
import net.yacy.kelondro.util.MapTools;
import net.yacy.peers.EventChannel;
import net.yacy.peers.Network;
import net.yacy.peers.NewsDB;
import net.yacy.peers.NewsPool;
import net.yacy.peers.Seed;
import net.yacy.peers.SeedDB;
import net.yacy.utils.crypt;

public class PeerActions {
    private final SeedDB seedDB;
    private Map<String, String> userAgents;
    private final NewsPool newsPool;

    public PeerActions(SeedDB seedDB, NewsPool newsPool) {
        this.seedDB = seedDB;
        this.newsPool = newsPool;
        this.userAgents = new ConcurrentARC<String, String>(10000, Runtime.getRuntime().availableProcessors() + 1);
    }

    public void close() {
        if (this.userAgents != null) {
            this.userAgents.clear();
        }
        this.userAgents = null;
    }

    public boolean connectPeer(Seed seed, boolean direct) {
        if (seed == null) {
            Network.log.severe("connect: WRONG seed (NULL)");
            return false;
        }
        String error = seed.isProper(false);
        if (error != null) {
            Network.log.severe("connect: WRONG seed (" + seed.getName() + "/" + seed.hash + "): " + error);
            return false;
        }
        if (this.seedDB.mySeedIsDefined() && seed.hash.equals(this.seedDB.mySeed().hash)) {
            Network.log.info("connect: SELF reference " + seed.getIPs());
            return false;
        }
        String peerType = seed.get("PeerType", "virgin");
        if (peerType.equals("virgin") || peerType.equals("junior")) {
            if (Network.log.isFine()) {
                Network.log.fine("connect: rejecting NOT QUALIFIED " + peerType + " seed " + seed.getName());
            }
            return false;
        }
        if (!peerType.equals("senior") && !peerType.equals("principal")) {
            if (Network.log.isFine()) {
                Network.log.fine("connect: rejecting NOT QUALIFIED " + peerType + " seed " + seed.getName());
            }
            return false;
        }
        Seed doubleSeed = this.seedDB.lookupByIPs(seed.getIPs(), seed.getPort(), true, false, false);
        if (doubleSeed != null && doubleSeed.getPort() == seed.getPort() && !doubleSeed.hash.equals(seed.hash)) {
            if (Network.log.isFine()) {
                Network.log.fine("connect: rejecting FRAUD (double hashes " + doubleSeed.hash + "/" + seed.hash + " on same port " + seed.getPort() + ") peer " + seed.getName());
            }
            return false;
        }
        if (seed.get("LastSeen", "").length() != 14) {
            seed.setLastSeenUTC();
            if (Network.log.isFine()) {
                Network.log.fine("connect: reset wrong date (" + seed.getName() + "/" + seed.hash + ")");
            }
        }
        long nowUTC0Time = System.currentTimeMillis();
        long ctimeUTC0 = seed.getLastSeenUTC();
        if (ctimeUTC0 > nowUTC0Time) {
            seed.setLastSeenUTC();
            ctimeUTC0 = nowUTC0Time;
            assert (seed.getLastSeenUTC() - ctimeUTC0 < 100L);
        }
        if (Math.abs(nowUTC0Time - ctimeUTC0) / 1000L / 60L > 1440L) {
            if (Network.log.isFine()) {
                Network.log.info("connect: rejecting out-dated peer '" + seed.getName() + "' from " + seed.getIPs() + "; nowUTC0=" + nowUTC0Time + ", seedUTC0=" + ctimeUTC0 + ", TimeDiff=" + PeerActions.formatInterval(Math.abs(nowUTC0Time - ctimeUTC0)));
            }
            return false;
        }
        Seed disconnectedSeed = this.seedDB.getDisconnected(seed.hash);
        if (direct) {
            seed.setLastSeenUTC();
            seed.setFlagDirectConnect(true);
        } else if (Math.abs(nowUTC0Time - ctimeUTC0) > 120000L) {
            seed.setFlagDirectConnect(false);
        }
        if (disconnectedSeed != null) {
            if (Network.log.isFine()) {
                Network.log.fine("connect: returned KNOWN " + peerType + " peer '" + seed.getName() + "' from " + seed.getIPs());
            }
            this.seedDB.addConnected(seed);
            return true;
        }
        Seed connectedSeed = this.seedDB.getConnected(seed.hash);
        if (connectedSeed != null) {
            try {
                if (ctimeUTC0 < connectedSeed.getLastSeenUTC() && !direct) {
                    if (Network.log.isFine()) {
                        Network.log.fine("connect: rejecting old info about peer '" + seed.getName() + "'");
                    }
                    return false;
                }
            }
            catch (NumberFormatException e) {
                if (Network.log.isFine()) {
                    Network.log.fine("connect: rejecting wrong peer '" + seed.getName() + "' from " + seed.getIPs() + ". Cause: " + e.getMessage());
                }
                return false;
            }
            if (Network.log.isFine()) {
                Network.log.fine("connect: updated KNOWN " + (direct ? "direct " : "") + peerType + " peer '" + seed.getName() + "' from " + seed.getIPs());
            }
            this.seedDB.addConnected(seed);
            return true;
        }
        if (this.seedDB.mySeedIsDefined() && seed.clash(this.seedDB.mySeed().getIPs())) {
            if (Network.log.isFine()) {
                Network.log.fine("connect: saved NEW seed (myself IP) " + seed.getIPs());
            }
        } else if (Network.log.isFine()) {
            Network.log.fine("connect: saved NEW " + peerType + " peer '" + seed.getName() + "' from " + seed.getIPs());
        }
        this.seedDB.addConnected(seed);
        return true;
    }

    public boolean peerArrival(Seed peer, boolean direct) {
        if (peer == null) {
            return false;
        }
        boolean res = this.connectPeer(peer, direct);
        if (res) {
            this.processPeerArrival(peer);
            EventChannel.channels(EventChannel.PEERNEWS).addMessage(new RSSMessage(peer.getName() + " joined the network", "", ""));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interfaceDeparture(Seed peer, String ip) {
        if (peer == null) {
            return;
        }
        if (Network.log.isFine()) {
            Network.log.fine("connect: no contact to a interface from " + peer.get("PeerType", "virgin") + " peer '" + peer.getName() + "' at " + ip);
        }
        SeedDB seedDB = this.seedDB;
        synchronized (seedDB) {
            if (this.seedDB.hasConnected(ASCII.getBytes(peer.hash))) {
                if (peer.countIPs() > 1) {
                    if (peer.removeIP(ip)) {
                        this.seedDB.updateConnected(peer);
                    } else {
                        this.seedDB.addDisconnected(peer);
                    }
                } else {
                    peer.put("dct", Long.toString(System.currentTimeMillis()));
                    this.seedDB.addDisconnected(peer);
                }
            }
        }
        EventChannel.channels(EventChannel.PEERNEWS).addMessage(new RSSMessage(peer.getName() + " interface not available: " + ip, "", ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void peerDeparture(Seed peer, String cause) {
        if (peer == null) {
            return;
        }
        if (Network.log.isFine()) {
            Network.log.fine("connect: no contact to a " + peer.get("PeerType", "virgin") + " peer '" + peer.getName() + "' at " + peer.getIPs() + ". Cause: " + cause);
        }
        SeedDB seedDB = this.seedDB;
        synchronized (seedDB) {
            peer.put("dct", Long.toString(System.currentTimeMillis()));
            this.seedDB.addDisconnected(peer);
        }
        EventChannel.channels(EventChannel.PEERNEWS).addMessage(new RSSMessage(peer.getName() + " left the network", "", ""));
    }

    public void peerPing(Seed peer) {
        if (peer == null) {
            return;
        }
        this.seedDB.addPotential(peer);
        this.processPeerArrival(peer);
        EventChannel.channels(EventChannel.PEERNEWS).addMessage(new RSSMessage(peer.getName() + " sent me a ping", "", ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPeerArrival(Seed peer) {
        String recordString = peer.get("news", null);
        if (recordString == null || recordString.isEmpty()) {
            return;
        }
        String decodedString = crypt.simpleDecode(recordString);
        NewsDB.Record record = this.newsPool.parseExternal(decodedString);
        if (record != null) {
            String cre1 = MapTools.string2map(decodedString, ",").get("cre");
            String cre2 = MapTools.string2map(record.toString(), ",").get("cre");
            if (cre1 == null || cre2 == null || !cre1.equals(cre2)) {
                Network.log.warn("processPeerArrival: ### ERROR - message creation date verification not equal: cre1=" + cre1 + ", cre2=" + cre2);
                return;
            }
            try {
                NewsPool newsPool = this.newsPool;
                synchronized (newsPool) {
                    this.newsPool.enqueueIncomingNews(record);
                }
            }
            catch (Exception e) {
                Network.log.severe("processPeerArrival", e);
            }
        }
    }

    public int sizeConnected() {
        return this.seedDB.sizeConnected();
    }

    public void setUserAgent(String IP, String userAgent) {
        if (this.userAgents == null) {
            return;
        }
        this.userAgents.put(IP, userAgent);
    }

    public String getUserAgent(String IP) {
        String userAgent = this.userAgents.get(IP);
        return userAgent == null ? "" : userAgent;
    }

    public static String formatInterval(long millis) {
        try {
            long mins = millis / 60000L;
            StringBuilder uptime = new StringBuilder(40);
            int uptimeDays = (int)Math.floor((double)mins / 1440.0);
            int uptimeHours = (int)(Math.floor((double)mins / 60.0) % 24.0);
            int uptimeMins = (int)mins % 60;
            uptime.append(uptimeDays).append(uptimeDays == 1 ? " day " : " days ").append(uptimeHours < 10 ? "0" : "").append(uptimeHours).append(':').append(uptimeMins < 10 ? "0" : "").append(uptimeMins);
            return uptime.toString();
        }
        catch (Exception e) {
            return "unknown";
        }
    }
}

