/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.index.Column;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.table.Table;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.peers.NewsDB;

public class NewsQueue
implements Iterable<NewsDB.Record> {
    private final File path;
    private Table queueStack;
    private final NewsDB newsDB;
    private static final Row rowdef = new Row(new Column[]{new Column("newsid", 3, 3, NewsDB.idLength, "id = created + originator"), new Column("last touched", 3, 3, "yyyyMMddHHmmss".length(), "")}, NaturalOrder.naturalOrder);

    public NewsQueue(File path, NewsDB newsDB) {
        this.path = path;
        this.newsDB = newsDB;
        try {
            this.queueStack = new Table(path, rowdef, 10, 0, false, false, true);
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
            this.queueStack = null;
        }
    }

    public void clear() {
        try {
            this.queueStack.clear();
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.path.exists()) {
                FileUtils.deletedelete(this.path);
            }
            try {
                this.queueStack = new Table(this.path, rowdef, 10, 0, false, false, true);
            }
            catch (SpaceExceededException ee) {
                ConcurrentLog.logException(e);
                this.queueStack = null;
            }
        }
    }

    public synchronized void close() {
        if (this.queueStack != null) {
            this.queueStack.close();
        }
        this.queueStack = null;
    }

    public int size() {
        return this.queueStack.size();
    }

    public boolean isEmpty() {
        return this.queueStack.isEmpty();
    }

    public synchronized void push(NewsDB.Record entry2) throws IOException, SpaceExceededException {
        if (!this.queueStack.consistencyCheck()) {
            ConcurrentLog.severe("yacyNewsQueue", "reset of table " + this.path);
            this.queueStack.clear();
        }
        this.queueStack.addUnique(this.r2b(entry2));
    }

    public synchronized NewsDB.Record pop() throws IOException {
        if (this.queueStack.isEmpty()) {
            return null;
        }
        return this.b2r(this.queueStack.removeOne());
    }

    public synchronized NewsDB.Record get(String id) {
        for (NewsDB.Record record : this) {
            if (record == null || !record.id().equals(id)) continue;
            return record;
        }
        return null;
    }

    public synchronized NewsDB.Record remove(String id) {
        for (NewsDB.Record record : this) {
            if (record == null || !record.id().equals(id)) continue;
            try {
                this.queueStack.remove(UTF8.getBytes(id));
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            return record;
        }
        return null;
    }

    NewsDB.Record b2r(Row.Entry b) throws IOException {
        if (b == null) {
            return null;
        }
        String id = b.getPrimaryKeyASCII();
        return this.newsDB.get(id);
    }

    private Row.Entry r2b(NewsDB.Record r) throws IOException, SpaceExceededException {
        if (r == null) {
            return null;
        }
        this.newsDB.put(r);
        Row.Entry b = this.queueStack.row().newEntry(new byte[][]{UTF8.getBytes(r.id()), UTF8.getBytes(GenericFormatter.SHORT_SECOND_FORMATTER.format())});
        return b;
    }

    @Override
    public Iterator<NewsDB.Record> iterator() {
        if (this.queueStack == null) {
            return new HashSet().iterator();
        }
        return new newsIterator();
    }

    private class newsIterator
    implements Iterator<NewsDB.Record> {
        Iterator<Row.Entry> stackNodeIterator;

        private newsIterator() {
            try {
                this.stackNodeIterator = NewsQueue.this.queueStack.rows();
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                this.stackNodeIterator = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.stackNodeIterator != null && this.stackNodeIterator.hasNext();
        }

        @Override
        public NewsDB.Record next() {
            Row.Entry row;
            if (this.stackNodeIterator == null) {
                return null;
            }
            try {
                row = this.stackNodeIterator.next();
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
                return null;
            }
            try {
                return NewsQueue.this.b2r(row);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public void remove() {
            if (this.stackNodeIterator != null) {
                this.stackNodeIterator.remove();
            }
        }
    }
}

