/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.Memory;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.data.word.Word;
import net.yacy.kelondro.data.word.WordReference;
import net.yacy.kelondro.index.RowHandleSet;
import net.yacy.kelondro.rwi.ReferenceContainer;
import net.yacy.kelondro.workflow.WorkflowProcessor;
import net.yacy.kelondro.workflow.WorkflowTask;
import net.yacy.peers.DHTSelection;
import net.yacy.peers.Protocol;
import net.yacy.peers.Seed;
import net.yacy.peers.SeedDB;
import net.yacy.peers.Transmission;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Segment;

public class Dispatcher
implements WorkflowTask<Transmission.Chunk> {
    private Map<String, Transmission.Chunk> transmissionBuffer;
    private final Segment segment;
    private final SeedDB seeds;
    private final ConcurrentLog log;
    private WorkflowProcessor<Transmission.Chunk> indexingTransmissionProcessor;
    private final Transmission transmission;
    private final Switchboard env;

    public Dispatcher(Switchboard env, boolean gzipBody, int timeout) {
        this.env = env;
        this.transmissionBuffer = new ConcurrentHashMap<String, Transmission.Chunk>();
        this.segment = env.index;
        this.seeds = env.peers;
        this.log = new ConcurrentLog("INDEX-TRANSFER-DISPATCHER");
        this.transmission = new Transmission(env, this.log, gzipBody, timeout);
        int concurrentSender = Math.min(8, WorkflowProcessor.availableCPU);
        this.indexingTransmissionProcessor = new WorkflowProcessor<Transmission.Chunk>("transferDocumentIndex", "This is the RWI transmission process", new String[]{"RWI/Cache/Collections"}, this, concurrentSender * 3, null, concurrentSender);
    }

    public int bufferSize() {
        return this.transmissionBuffer == null ? 0 : this.transmissionBuffer.size();
    }

    public int transmissionSize() {
        return this.indexingTransmissionProcessor == null ? 0 : this.indexingTransmissionProcessor.getQueueSize();
    }

    private ArrayList<ReferenceContainer<WordReference>> selectContainers(byte[] hash, byte[] limitHash, int maxContainerCount, int maxReferenceCount, int maxtime) throws IOException {
        ArrayList<ReferenceContainer<WordReference>> containers = this.selectContainers(hash, limitHash, maxContainerCount, maxReferenceCount, maxtime, false);
        return containers;
    }

    private ArrayList<ReferenceContainer<WordReference>> selectContainers(byte[] hash, byte[] limitHash, int maxContainerCount, int maxReferenceCount, int maxtime, boolean ram) throws IOException {
        ArrayList<ReferenceContainer<WordReference>> rc;
        ReferenceContainer<WordReference> container;
        long timeout;
        ArrayList<ReferenceContainer> containers = new ArrayList<ReferenceContainer>(maxContainerCount);
        Iterator indexContainerIterator = this.segment.termIndex() == null ? new ArrayList().iterator() : this.segment.termIndex().referenceContainerIterator(hash, true, true, ram);
        int refcount = 0;
        long l = maxtime == Integer.MAX_VALUE ? Long.MAX_VALUE : (timeout = maxtime < 0 ? Long.MAX_VALUE : System.currentTimeMillis() + (long)maxtime);
        while (containers.size() < maxContainerCount && refcount < maxReferenceCount && indexContainerIterator.hasNext() && System.currentTimeMillis() < timeout && (container = (ReferenceContainer<WordReference>)indexContainerIterator.next()) != null && (containers.isEmpty() || Base64Order.enhancedCoder.compare(container.getTermHash(), limitHash) < 0)) {
            if (container.isEmpty() || Word.isPrivate(container.getTermHash())) continue;
            refcount += container.size();
            containers.add(container);
        }
        if (ram) {
            RowHandleSet urlHashes = new RowHandleSet(12, (ByteOrder)Word.commonHashOrder, 0);
            for (ReferenceContainer c : containers) {
                urlHashes.clear();
                Iterator it = c.entries();
                while (it.hasNext()) {
                    try {
                        urlHashes.put(((WordReference)it.next()).urlhash());
                    }
                    catch (SpaceExceededException e) {
                        ConcurrentLog.logException(e);
                    }
                }
                if (this.log.isFine()) {
                    this.log.fine("selected " + urlHashes.size() + " urls for word '" + ASCII.String(c.getTermHash()) + "'");
                }
                if (this.segment.termIndex() == null || urlHashes.isEmpty()) continue;
                this.segment.termIndex().remove(c.getTermHash(), urlHashes);
            }
            rc = containers;
        } else {
            rc = new ArrayList<ReferenceContainer<WordReference>>(containers.size());
            for (ReferenceContainer c : containers) {
                container = this.segment.termIndex() == null ? null : this.segment.termIndex().remove(c.getTermHash());
                if (container == null || container.isEmpty()) continue;
                if (this.log.isFine()) {
                    this.log.fine("selected " + container.size() + " urls for word '" + ASCII.String(c.getTermHash()) + "'");
                }
                rc.add(container);
            }
        }
        return rc;
    }

    private ReferenceContainer<WordReference>[] splitContainer(ReferenceContainer<WordReference> container) throws SpaceExceededException {
        int partitionCount = this.seeds.scheme.verticalPartitions();
        ReferenceContainer[] partitionBuffer = (ReferenceContainer[])Array.newInstance(ReferenceContainer.class, partitionCount);
        for (int j = 0; j < partitionBuffer.length; ++j) {
            partitionBuffer[j] = new ReferenceContainer<WordReference>(Segment.wordReferenceFactory, container.getTermHash(), container.size() / partitionCount);
        }
        Iterator<WordReference> i = container.entries();
        while (i.hasNext()) {
            WordReference wordReference = i.next();
            if (wordReference == null) continue;
            partitionBuffer[this.seeds.scheme.verticalDHTPosition(wordReference.urlhash())].add(wordReference);
        }
        return partitionBuffer;
    }

    private void enqueueContainersToBuffer(byte[] wordhash, ReferenceContainer<WordReference>[] containers) {
        assert (containers.length == this.seeds.scheme.verticalPartitions());
        if (this.transmissionBuffer == null) {
            return;
        }
        List<Seed>[] targets = DHTSelection.selectDHTDistributionTargets(this.seeds, wordhash, 3, this.seeds.redundancy());
        assert (targets.length == this.seeds.scheme.verticalPartitions());
        assert (targets.length == containers.length);
        for (int vertical = 0; vertical < containers.length; ++vertical) {
            ReferenceContainer<WordReference> verticalContainer = containers[vertical];
            if (verticalContainer.isEmpty()) continue;
            for (Seed target : targets[vertical]) {
                Transmission.Chunk entry2 = this.transmissionBuffer.get(target.hash);
                if (entry2 == null) {
                    entry2 = this.transmission.newChunk(target);
                } else {
                    this.log.info("extending chunk for peer " + entry2.dhtTarget().hash + " containing " + entry2.containersSize() + " references with " + verticalContainer.size() + " more entries");
                }
                try {
                    entry2.add(verticalContainer);
                }
                catch (SpaceExceededException e) {
                    ConcurrentLog.logException(e);
                }
                this.transmissionBuffer.put(target.hash, entry2);
            }
        }
    }

    public boolean selectContainersEnqueueToBuffer(byte[] hash, byte[] limitHash, int maxContainerCount, int maxReferenceCount, int maxtime) {
        ArrayList<ReferenceContainer<WordReference>> selectedContainerCache;
        if (this.transmissionBuffer == null) {
            return false;
        }
        try {
            selectedContainerCache = this.selectContainers(hash, limitHash, maxContainerCount, maxReferenceCount, maxtime);
        }
        catch (IOException e) {
            this.log.severe("selectContainersEnqueueToBuffer: selectedContainer failed", e);
            return false;
        }
        this.log.info("selectContainersEnqueueToBuffer: selectedContainerCache was filled with " + selectedContainerCache.size() + " entries");
        if (selectedContainerCache == null || selectedContainerCache.isEmpty()) {
            this.log.info("selectContainersEnqueueToBuffer: selectedContainerCache is empty, cannot do anything here.");
            return false;
        }
        try {
            for (ReferenceContainer referenceContainer : selectedContainerCache) {
                ReferenceContainer<WordReference>[] partitionBuffer = this.splitContainer(referenceContainer);
                this.enqueueContainersToBuffer(referenceContainer.getTermHash(), partitionBuffer);
            }
        }
        catch (SpaceExceededException e) {
            this.log.severe("splitContainer: splitContainers failed because of too low RAM", e);
            return false;
        }
        this.log.info("selectContainersEnqueueToBuffer: splitContainerCache enqueued to the write buffer array which has now " + this.transmissionBuffer.size() + " entries.");
        return true;
    }

    public boolean dequeueContainer() {
        if (this.transmissionBuffer == null) {
            return false;
        }
        if (this.indexingTransmissionProcessor.getQueueSize() > this.indexingTransmissionProcessor.getMaxConcurrency()) {
            return false;
        }
        String maxtarget = null;
        int maxsize = -1;
        for (Map.Entry<String, Transmission.Chunk> chunk : this.transmissionBuffer.entrySet()) {
            if (chunk.getValue().containersSize() <= maxsize) continue;
            maxsize = chunk.getValue().containersSize();
            maxtarget = chunk.getKey();
        }
        if (maxsize < 0) {
            return false;
        }
        Transmission.Chunk chunk = this.transmissionBuffer.remove(maxtarget);
        this.indexingTransmissionProcessor.enQueue(chunk);
        return true;
    }

    @Override
    public Transmission.Chunk process(Transmission.Chunk chunk) throws Exception {
        return this.transferDocumentIndex(chunk);
    }

    private Transmission.Chunk transferDocumentIndex(Transmission.Chunk chunk) {
        boolean success;
        while (Protocol.metadataRetrievalRunning.get() > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        while (Memory.getSystemLoadAverage() > (double)this.env.getConfigFloat("20_dhtdistribution_loadprereq", 2.0f)) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (success = chunk.transmit()) {
            return chunk;
        }
        this.log.info("STORE: Chunk " + chunk.dhtTarget().getName() + " does not respond or accept the dht index, putting back index to backend");
        chunk.restore();
        return null;
    }

    public void close() {
        if (this.indexingTransmissionProcessor != null) {
            this.indexingTransmissionProcessor.shutdown();
        }
        if (this.transmissionBuffer != null) {
            block2: for (Map.Entry<String, Transmission.Chunk> e : this.transmissionBuffer.entrySet()) {
                for (ReferenceContainer<WordReference> i : e.getValue()) {
                    try {
                        this.segment.storeRWI(i);
                    }
                    catch (Exception e1) {
                        ConcurrentLog.logException(e1);
                        break block2;
                    }
                }
            }
            this.transmissionBuffer.clear();
        }
        this.transmissionBuffer = null;
        if (this.indexingTransmissionProcessor != null) {
            this.indexingTransmissionProcessor.clear();
        }
        this.indexingTransmissionProcessor = null;
    }
}

