/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.federate.yacy.Distribution;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.Digest;
import net.yacy.cora.sorting.OrderedScoreMap;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.LookAheadIterator;
import net.yacy.kelondro.util.kelondroException;
import net.yacy.peers.Network;
import net.yacy.peers.RemoteSearch;
import net.yacy.peers.Seed;
import net.yacy.peers.SeedDB;

public class DHTSelection {
    public static Set<Seed> selectClusterPeers(SeedDB seedDB, SortedSet<byte[]> peerhashes) {
        HashSet<Seed> l = new HashSet<Seed>();
        for (byte[] hashb : peerhashes) {
            Seed s = seedDB.get(ASCII.String(hashb));
            if (s == null) continue;
            l.add(s);
        }
        return l;
    }

    public static Collection<Seed> selectExtraTargets(SeedDB seedDB, HandleSet wordhashes, int minage, Collection<Seed> omit, int maxcount, Random r) {
        HashSet<Seed> extraSeeds = new HashSet<Seed>();
        if (seedDB != null) {
            Seed seed;
            OrderedScoreMap<Seed> seedSelection = new OrderedScoreMap<Seed>(null);
            Iterator<Seed> dhtEnum = seedDB.seedsConnected(true, false, null, 0.5);
            while (dhtEnum.hasNext()) {
                seed = dhtEnum.next();
                if (seed == null || omit != null && omit.contains(seed) || seed.isLastSeenTimeout(3600000L) || !seed.getFlagSolrAvailable()) continue;
                if (!seed.getFlagAcceptRemoteIndex() && seed.matchPeerTags(wordhashes)) {
                    seedSelection.dec(seed, r.nextInt(10) + 2);
                }
                if (seed.getFlagRootNode()) {
                    seedSelection.dec(seed, r.nextInt(30) + 6);
                }
                if (seed.getAge() < minage) {
                    seedSelection.dec(seed, r.nextInt(15) + 3);
                }
                if (seed.getAge() < 1) {
                    seedSelection.dec(seed, r.nextInt(40) + 8);
                }
                if (seed.getLinkCount() >= 100000L && seed.getLinkCount() < 1000000L) {
                    seedSelection.dec(seed, r.nextInt(25) + 5);
                }
                if (seed.getLinkCount() < 1000000L) continue;
                int pf = 1 + (int)(20000000L / seed.getLinkCount());
                seedSelection.dec(seed, r.nextInt(pf) + pf / 5);
            }
            Iterator i = seedSelection.iterator();
            int count = 0;
            while (i.hasNext() && count++ < maxcount) {
                seed = (Seed)i.next();
                if (RemoteSearch.log.isInfo()) {
                    RemoteSearch.log.info("selectPeers/extra: " + seed.hash + ":" + seed.getName() + ", " + seed.getLinkCount() + " URLs" + (seed.getLinkCount() >= 1000000L ? " LARGE-SIZE" : "") + (seed.getLinkCount() >= 100000L && seed.getLinkCount() < 1000000L ? " MEDIUM-SIZE" : "") + (!seed.getFlagAcceptRemoteIndex() && seed.matchPeerTags(wordhashes) ? " ROBINSON" : "") + (seed.getFlagRootNode() ? " NODE" : "") + (seed.getAge() < 1 ? " FRESH" : ""));
                }
                extraSeeds.add(seed);
            }
        }
        return extraSeeds;
    }

    public static Set<Seed> selectDHTSearchTargets(SeedDB seedDB, HandleSet wordhashes, int minage, int minWordCount, int redundancy, int maxredundancy, Random random) {
        LinkedHashSet<Seed> seeds2 = new LinkedHashSet<Seed>();
        if (seedDB != null) {
            Iterator<byte[]> iter = wordhashes.iterator();
            while (iter.hasNext()) {
                seeds2.addAll(DHTSelection.collectHorizontalDHTPositions(seedDB, iter.next(), minage, minWordCount, redundancy, maxredundancy, random));
            }
        }
        return seeds2;
    }

    private static ArrayList<Seed> collectHorizontalDHTPositions(SeedDB seedDB, byte[] wordhash, int minage, int minWordCount, int redundancy, int maxredundancy, Random random) {
        ArrayList<Seed> collectedSeeds = new ArrayList<Seed>(redundancy * seedDB.scheme.verticalPartitions());
        for (int verticalPosition = 0; verticalPosition < seedDB.scheme.verticalPartitions(); ++verticalPosition) {
            ArrayList<Seed> seeds2 = DHTSelection.selectVerticalDHTPositions(seedDB, wordhash, minage, minWordCount, maxredundancy, verticalPosition);
            if (seeds2.size() <= redundancy) {
                collectedSeeds.addAll(seeds2);
                continue;
            }
            for (int i = 0; i < redundancy; ++i) {
                collectedSeeds.add(seeds2.remove(random.nextInt(seeds2.size())));
            }
        }
        return collectedSeeds;
    }

    public static List<Seed>[] selectDHTDistributionTargets(SeedDB seedDB, byte[] wordhash, int minage, int redundancy) {
        List[] seedlists = (List[])Array.newInstance(ArrayList.class, seedDB.scheme.verticalPartitions());
        for (int verticalPosition = 0; verticalPosition < seedDB.scheme.verticalPartitions(); ++verticalPosition) {
            seedlists[verticalPosition] = DHTSelection.selectVerticalDHTPositions(seedDB, wordhash, minage, Integer.MIN_VALUE, redundancy, verticalPosition);
        }
        return seedlists;
    }

    private static ArrayList<Seed> selectVerticalDHTPositions(SeedDB seedDB, byte[] wordhash, int minage, int minWordCount, int redundancy, int verticalPosition) {
        ArrayList<Seed> seeds2 = new ArrayList<Seed>(redundancy);
        long dhtVerticalTarget = seedDB.scheme.verticalDHTPosition(wordhash, verticalPosition);
        byte[] verticalhash = Distribution.positionToHash(dhtVerticalTarget);
        Iterator<Seed> dhtEnum = DHTSelection.getAcceptRemoteIndexSeeds(seedDB, verticalhash, redundancy, false);
        int c = Math.min(seedDB.sizeConnected(), redundancy);
        int cc = 20;
        while (dhtEnum.hasNext() && c > 0 && cc-- > 0) {
            Seed seed = dhtEnum.next();
            if (seed == null || seed.hash == null || !seed.getFlagAcceptRemoteIndex() || seed.getAge() < minage || seed.getWordCount() < (long)minWordCount) continue;
            if (RemoteSearch.log.isInfo()) {
                RemoteSearch.log.info("selectPeers/DHTorder: " + seed.hash + ":" + seed.getName() + "/ score " + c);
            }
            seeds2.add(seed);
            --c;
        }
        return seeds2;
    }

    public static byte[] selectRandomTransferStart() {
        return ASCII.getBytes(Base64Order.enhancedCoder.encode(Digest.encodeMD5Raw(Long.toString(System.currentTimeMillis()))).substring(2, 14));
    }

    public static byte[] limitOver(SeedDB seedDB, byte[] startHash) {
        Iterator<Seed> seeds2 = DHTSelection.getAcceptRemoteIndexSeeds(seedDB, startHash, 1, false);
        if (seeds2.hasNext()) {
            return ASCII.getBytes(seeds2.next().hash);
        }
        return null;
    }

    public static List<Seed> getAcceptRemoteIndexSeedsList(SeedDB seedDB, byte[] starthash, int max, boolean alsoMyOwn) {
        Iterator<Seed> seedIter = DHTSelection.getAcceptRemoteIndexSeeds(seedDB, starthash, max, alsoMyOwn);
        ArrayList<Seed> targets = new ArrayList<Seed>();
        while (seedIter.hasNext() && max-- > 0) {
            targets.add(seedIter.next());
        }
        return targets;
    }

    public static Iterator<Seed> getAcceptRemoteIndexSeeds(SeedDB seedDB, byte[] starthash, int max, boolean alsoMyOwn) {
        return new acceptRemoteIndexSeedEnum(seedDB, starthash, Math.min(max, seedDB.sizeConnected()), alsoMyOwn);
    }

    public static Iterator<Seed> getProvidesRemoteCrawlURLs(SeedDB seedDB) {
        return new providesRemoteCrawlURLsEnum(seedDB);
    }

    public static ConcurrentMap<String, Seed> seedsByAge(SeedDB seedDB, boolean up, int count, int minWordCount) {
        if (count > seedDB.sizeConnected()) {
            count = seedDB.sizeConnected();
        }
        Iterator<Seed> seeds2 = seedDB.seedsSortedConnected(!up, "LastSeen");
        try {
            ConcurrentHashMap<String, Seed> result = new ConcurrentHashMap<String, Seed>();
            while (seeds2.hasNext() && count-- > 0) {
                Seed ys = seeds2.next();
                if (ys == null || ys.hash == null || ys.getWordCount() < (long)minWordCount) continue;
                result.put(ys.hash, ys);
            }
            return result;
        }
        catch (kelondroException e) {
            Network.log.severe("Internal Error at yacySeedDB.seedsByAge: " + e.getMessage(), e);
            return null;
        }
    }

    public static ConcurrentMap<String, Seed> seedsByAge(SeedDB seedDB, boolean up, int count) {
        return DHTSelection.seedsByAge(seedDB, up, count, Integer.MIN_VALUE);
    }

    private static class providesRemoteCrawlURLsEnum
    extends LookAheadIterator<Seed>
    implements Iterator<Seed>,
    Iterable<Seed> {
        private final Iterator<Seed> se;
        private final SeedDB seedDB;

        private providesRemoteCrawlURLsEnum(SeedDB seedDB) {
            this.seedDB = seedDB;
            this.se = seedDB.seedsConnected(true, false, null, 0.55f);
        }

        @Override
        protected Seed next0() {
            try {
                while (this.se.hasNext()) {
                    Seed s = this.se.next();
                    if (s == null) {
                        return null;
                    }
                    if (s.getLong("RCount", 0L) <= 0L) continue;
                    return s;
                }
            }
            catch (kelondroException e) {
                System.out.println("DEBUG providesRemoteCrawlURLsEnum:" + e.getMessage());
                Network.log.severe("database inconsistency (" + e.getMessage() + "), re-set of db.");
                this.seedDB.resetActiveTable();
                return null;
            }
            return null;
        }
    }

    private static class seedDHTEnum
    implements Iterator<Seed> {
        private Iterator<Seed> e;
        private int steps;
        private final SeedDB seedDB;
        private boolean alsoMyOwn;
        private int pass;
        private int insertOwnInPass;
        private Seed nextSeed;

        private seedDHTEnum(SeedDB seedDB, byte[] firstHash, boolean alsoMyOwn) {
            this.seedDB = seedDB;
            this.steps = seedDB.sizeConnected() + (alsoMyOwn ? 1 : 0);
            this.e = seedDB.seedsConnected(true, false, firstHash, 0.486f);
            this.pass = 1;
            this.alsoMyOwn = alsoMyOwn;
            this.insertOwnInPass = alsoMyOwn ? (Base64Order.enhancedCoder.compare(ASCII.getBytes(seedDB.mySeed().hash), firstHash) > 0 ? 1 : 2) : 0;
            this.nextSeed = this.nextInternal();
        }

        @Override
        public boolean hasNext() {
            return this.nextSeed != null || this.alsoMyOwn;
        }

        public Seed nextInternal() {
            if (this.steps == 0) {
                return null;
            }
            --this.steps;
            if (!this.e.hasNext() && this.pass == 1) {
                this.e = this.seedDB.seedsConnected(true, false, null, 0.486f);
                this.pass = 2;
            }
            if (this.e.hasNext()) {
                return this.e.next();
            }
            this.steps = 0;
            return null;
        }

        @Override
        public Seed next() {
            if (this.alsoMyOwn && (this.pass > this.insertOwnInPass || this.pass == this.insertOwnInPass && this.nextSeed == null || this.pass == this.insertOwnInPass && this.nextSeed != null && Base64Order.enhancedCoder.compare(ASCII.getBytes(this.seedDB.mySeed().hash), ASCII.getBytes(this.nextSeed.hash)) < 0)) {
                this.alsoMyOwn = false;
                return this.seedDB.mySeed();
            }
            Seed next = this.nextSeed;
            this.nextSeed = this.nextInternal();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class acceptRemoteIndexSeedEnum
    extends LookAheadIterator<Seed>
    implements Iterator<Seed>,
    Iterable<Seed> {
        private final Iterator<Seed> se;
        private final SeedDB seedDB;
        private int remaining;
        private final boolean alsoMyOwn;

        private acceptRemoteIndexSeedEnum(SeedDB seedDB, byte[] starthash, int max, boolean alsoMyOwn) {
            this.seedDB = seedDB;
            this.se = new seedDHTEnum(seedDB, starthash, alsoMyOwn);
            this.remaining = max;
            this.alsoMyOwn = alsoMyOwn;
        }

        @Override
        protected Seed next0() {
            if (this.remaining <= 0) {
                return null;
            }
            Seed s = null;
            try {
                while (this.se.hasNext()) {
                    s = this.se.next();
                    if (s == null) {
                        return null;
                    }
                    if (!s.getFlagAcceptRemoteIndex() && (!this.alsoMyOwn || !s.hash.equals(this.seedDB.mySeed().hash))) continue;
                    --this.remaining;
                    break;
                }
                return s;
            }
            catch (kelondroException e) {
                System.out.println("DEBUG acceptRemoteIndexSeedEnum:" + e.getMessage());
                Network.log.severe("database inconsistency (" + e.getMessage() + "), re-set of db.");
                this.seedDB.resetActiveTable();
                return null;
            }
        }
    }
}

