/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.ConcurrentLog;

public final class SetTools {
    public static int log2a(int x) {
        int l = 0;
        while (x > 0) {
            x >>>= 1;
            ++l;
        }
        return l;
    }

    public static <A, B> SortedMap<A, B> joinConstructive(Collection<SortedMap<A, B>> maps, boolean concatStrings) {
        TreeMap<Long, SortedMap<A, B>> orderMap = new TreeMap<Long, SortedMap<A, B>>();
        Iterator<SortedMap<A, B>> i = maps.iterator();
        int count = 0;
        while (i.hasNext()) {
            SortedMap<A, B> singleMap = i.next();
            if (singleMap == null || singleMap.isEmpty()) {
                return new TreeMap();
            }
            orderMap.put(Long.valueOf(singleMap.size() * 1000 + count), singleMap);
            ++count;
        }
        if (orderMap.isEmpty()) {
            return new TreeMap();
        }
        Long k = (Long)orderMap.firstKey();
        SortedMap<A, B> joinResult = (SortedMap<A, B>)orderMap.remove(k);
        while (!orderMap.isEmpty() && !joinResult.isEmpty()) {
            k = (Long)orderMap.firstKey();
            SortedMap<A, B> mapA = joinResult;
            SortedMap mapB = (SortedMap)orderMap.remove(k);
            joinResult = SetTools.joinConstructiveByTest(mapA, mapB, concatStrings);
            mapA = null;
            mapB = null;
        }
        if (joinResult.isEmpty()) {
            return new TreeMap();
        }
        return joinResult;
    }

    public static <A, B> SortedMap<A, B> joinConstructive(SortedMap<A, B> map1, SortedMap<A, B> map2, boolean concatStrings) {
        int stepsTest;
        int low;
        if (map1 == null || map2 == null) {
            return null;
        }
        if (map1.comparator() != map2.comparator()) {
            return null;
        }
        if (map1.isEmpty() || map2.isEmpty()) {
            return new TreeMap(map1.comparator());
        }
        int high = map1.size() > map2.size() ? map1.size() : map2.size();
        int stepsEnum = 10 * (high + (low = map1.size() > map2.size() ? map2.size() : map1.size()) - 1);
        if (stepsEnum > (stepsTest = 12 * SetTools.log2a(high) * low)) {
            if (map1.size() > map2.size()) {
                return SetTools.joinConstructiveByTest(map2, map1, concatStrings);
            }
            return SetTools.joinConstructiveByTest(map1, map2, concatStrings);
        }
        return SetTools.joinConstructiveByEnumeration(map1, map2, concatStrings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <A, B> SortedMap<A, B> joinConstructiveByTest(SortedMap<A, B> small, SortedMap<A, B> large, boolean concatStrings) {
        TreeMap<A, String> result = new TreeMap<A, String>(large.comparator());
        SortedMap<A, B> sortedMap = small;
        synchronized (sortedMap) {
            Iterator<Map.Entry<A, B>> mi = small.entrySet().iterator();
            while (mi.hasNext()) {
                try {
                    Object mobj2;
                    Map.Entry<A, B> mentry1 = mi.next();
                    SortedMap<A, B> sortedMap2 = large;
                    synchronized (sortedMap2) {
                        mobj2 = large.get(mentry1.getKey());
                    }
                    if (mobj2 == null) continue;
                    if (mentry1.getValue() instanceof String) {
                        result.put(mentry1.getKey(), concatStrings ? (String)mentry1.getValue() + (String)mobj2 : (String)mentry1.getValue());
                        continue;
                    }
                    if (mentry1.getValue() instanceof StringBuilder) {
                        result.put(mentry1.getKey(), (String)((Object)(concatStrings ? ((StringBuilder)mentry1.getValue()).append((CharSequence)((StringBuilder)mobj2)) : mentry1.getValue())));
                        continue;
                    }
                    result.put(mentry1.getKey(), (String)mentry1.getValue());
                }
                catch (ConcurrentModificationException e) {
                    ConcurrentLog.warn("SetTools", e.getMessage(), e);
                    break;
                }
            }
        }
        return result;
    }

    private static <A, B> SortedMap<A, B> joinConstructiveByEnumeration(SortedMap<A, B> map1, SortedMap<A, B> map2, boolean concatStrings) {
        Comparator<A> comp = map1.comparator();
        Iterator<Map.Entry<A, B>> mi1 = map1.entrySet().iterator();
        Iterator<Map.Entry<A, B>> mi2 = map2.entrySet().iterator();
        TreeMap<A, CharSequence> result = new TreeMap<A, CharSequence>(map1.comparator());
        if (mi1.hasNext() && mi2.hasNext()) {
            Map.Entry<A, B> mentry1 = mi1.next();
            Map.Entry<A, B> mentry2 = mi2.next();
            while (true) {
                int c;
                if ((c = comp.compare(mentry1.getKey(), mentry2.getKey())) < 0) {
                    if (!mi1.hasNext()) break;
                    mentry1 = mi1.next();
                    continue;
                }
                if (c > 0) {
                    if (!mi2.hasNext()) break;
                    mentry2 = mi2.next();
                    continue;
                }
                if (mentry1.getValue() instanceof String) {
                    result.put(mentry1.getKey(), concatStrings ? (String)mentry1.getValue() + (String)mentry2.getValue() : (String)mentry1.getValue());
                } else if (mentry1.getValue() instanceof StringBuilder) {
                    result.put(mentry1.getKey(), concatStrings ? ((StringBuilder)mentry1.getValue()).append((CharSequence)((StringBuilder)mentry2.getValue())) : (StringBuilder)mentry1.getValue());
                } else {
                    result.put(mentry1.getKey(), (CharSequence)mentry1.getValue());
                }
                if (!mi1.hasNext()) break;
                mentry1 = mi1.next();
                if (!mi2.hasNext()) break;
                mentry2 = mi2.next();
            }
        }
        return result;
    }

    public static <A> SortedSet<A> joinConstructive(SortedSet<A> set1, SortedSet<A> set2) {
        int stepsTest;
        int low;
        if (set1 == null || set2 == null) {
            return null;
        }
        if (set1.comparator() != set2.comparator()) {
            return null;
        }
        if (set1.isEmpty() || set2.isEmpty()) {
            return new TreeSet<A>(set1.comparator());
        }
        int high = set1.size() > set2.size() ? set1.size() : set2.size();
        int stepsEnum = 10 * (high + (low = set1.size() > set2.size() ? set2.size() : set1.size()) - 1);
        if (stepsEnum > (stepsTest = 12 * SetTools.log2a(high) * low)) {
            if (set1.size() < set2.size()) {
                return SetTools.joinConstructiveByTest(set1.iterator(), set2);
            }
            return SetTools.joinConstructiveByTest(set2.iterator(), set1);
        }
        return SetTools.joinConstructiveByEnumeration(set1, set2);
    }

    public static <A> SortedSet<A> joinConstructiveByTest(Iterator<A> small, SortedSet<A> large) {
        TreeSet<A> result = new TreeSet<A>(large.comparator());
        while (small.hasNext()) {
            A o = small.next();
            if (!large.contains(o)) continue;
            result.add(o);
        }
        return result;
    }

    private static <A> SortedSet<A> joinConstructiveByEnumeration(SortedSet<A> set1, SortedSet<A> set2) {
        Comparator<A> comp = set1.comparator();
        Iterator mi = set1.iterator();
        Iterator si = set2.iterator();
        TreeSet<A> result = new TreeSet<A>(set1.comparator());
        if (mi.hasNext() && si.hasNext()) {
            Object mobj = mi.next();
            Object sobj = si.next();
            while (true) {
                int c;
                if ((c = comp.compare(mobj, sobj)) < 0) {
                    if (!mi.hasNext()) break;
                    mobj = mi.next();
                    continue;
                }
                if (c > 0) {
                    if (!si.hasNext()) break;
                    sobj = si.next();
                    continue;
                }
                result.add(mobj);
                if (!mi.hasNext()) break;
                mobj = mi.next();
                if (!si.hasNext()) break;
                sobj = si.next();
            }
        }
        return result;
    }

    public static <A> boolean totalInclusion(Iterator<A> small, Set<A> large) {
        while (small.hasNext()) {
            if (large.contains(small.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean totalInclusion(HandleSet small, HandleSet large) {
        for (byte[] handle : small) {
            if (large.has(handle)) continue;
            return false;
        }
        return true;
    }

    public static <A> boolean anymatch(SortedSet<A> set1, SortedSet<A> set2) {
        int stepsTest;
        int low;
        if (set1 == null || set2 == null) {
            return false;
        }
        if (set1.comparator() != set2.comparator()) {
            return false;
        }
        if (set1.isEmpty() || set2.isEmpty()) {
            return false;
        }
        int high = set1.size() > set2.size() ? set1.size() : set2.size();
        int stepsEnum = 10 * (high + (low = set1.size() > set2.size() ? set2.size() : set1.size()) - 1);
        if (stepsEnum > (stepsTest = 12 * SetTools.log2a(high) * low)) {
            return set1.size() < set2.size() ? SetTools.anymatchByTest(set1.iterator(), set2) : SetTools.anymatchByTest(set2.iterator(), set1);
        }
        return SetTools.anymatchByEnumeration(set1, set2);
    }

    public static boolean anymatch(HandleSet set1, HandleSet set2) {
        int stepsTest;
        int low;
        if (set1 == null || set2 == null) {
            return false;
        }
        if (set1.comparator() != set2.comparator()) {
            return false;
        }
        if (set1.isEmpty() || set2.isEmpty()) {
            return false;
        }
        int high = set1.size() > set2.size() ? set1.size() : set2.size();
        int stepsEnum = 10 * (high + (low = set1.size() > set2.size() ? set2.size() : set1.size()) - 1);
        if (stepsEnum > (stepsTest = 12 * SetTools.log2a(high) * low)) {
            if (set1.size() < set2.size()) {
                return SetTools.anymatchByTest(set1, set2);
            }
            return SetTools.anymatchByTest(set2, set1);
        }
        return SetTools.anymatchByEnumeration(set1, set2);
    }

    public static <A> boolean anymatchByTest(Iterator<A> small, SortedSet<A> large) {
        while (small.hasNext()) {
            if (!large.contains(small.next())) continue;
            return true;
        }
        return false;
    }

    private static boolean anymatchByTest(HandleSet small, HandleSet large) {
        for (byte[] o : small) {
            if (!large.has(o)) continue;
            return true;
        }
        return false;
    }

    private static <A> boolean anymatchByEnumeration(SortedSet<A> set1, SortedSet<A> set2) {
        block6: {
            Comparator<A> comp = set1.comparator();
            Iterator mi = set1.iterator();
            Iterator si = set2.iterator();
            if (mi.hasNext() && si.hasNext()) {
                Object mobj = mi.next();
                Object sobj = si.next();
                while (true) {
                    int c;
                    if ((c = comp.compare(mobj, sobj)) < 0) {
                        if (mi.hasNext()) {
                            mobj = mi.next();
                            continue;
                        }
                    } else {
                        if (c <= 0) break;
                        if (si.hasNext()) {
                            sobj = si.next();
                            continue;
                        }
                    }
                    break block6;
                    break;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean anymatchByEnumeration(HandleSet set1, HandleSet set2) {
        block6: {
            ByteOrder comp = set1.comparator();
            Iterator<byte[]> mi = set1.iterator();
            Iterator<byte[]> si = set2.iterator();
            if (mi.hasNext() && si.hasNext()) {
                byte[] mobj = mi.next();
                byte[] sobj = si.next();
                while (true) {
                    int c;
                    if ((c = comp.compare(mobj, sobj)) < 0) {
                        if (mi.hasNext()) {
                            mobj = mi.next();
                            continue;
                        }
                    } else {
                        if (c <= 0) break;
                        if (si.hasNext()) {
                            sobj = si.next();
                            continue;
                        }
                    }
                    break block6;
                    break;
                }
                return true;
            }
        }
        return false;
    }

    public static <A, B> void excludeDestructive(Map<A, B> map, Set<A> set) {
        if (map == null) {
            return;
        }
        if (set == null) {
            return;
        }
        assert (!(map instanceof SortedMap) || !(set instanceof SortedSet) || ((SortedMap)map).comparator() == ((SortedSet)set).comparator());
        if (map.isEmpty() || set.isEmpty()) {
            return;
        }
        if (map.size() < set.size()) {
            SetTools.excludeDestructiveByTestMapInSet(map, set);
        } else {
            SetTools.excludeDestructiveByTestSetInMap(map, set);
        }
    }

    private static <A, B> void excludeDestructiveByTestMapInSet(Map<A, B> map, Set<A> set) {
        Iterator<A> mi = map.keySet().iterator();
        while (mi.hasNext()) {
            if (!set.contains(mi.next())) continue;
            mi.remove();
        }
    }

    private static <A, B> void excludeDestructiveByTestSetInMap(Map<A, B> map, Set<A> set) {
        Iterator<A> si = set.iterator();
        while (si.hasNext()) {
            map.remove(si.next());
        }
    }

    public static <A> void excludeDestructive(Set<A> set1, Set<A> set2) {
        if (set1 == null) {
            return;
        }
        if (set2 == null) {
            return;
        }
        assert (!(set1 instanceof SortedSet) || !(set2 instanceof SortedSet) || ((SortedSet)set1).comparator() == ((SortedSet)set2).comparator());
        if (set1.isEmpty() || set2.isEmpty()) {
            return;
        }
        if (set1.size() < set2.size()) {
            SetTools.excludeDestructiveByTestSmallInLarge(set1, set2);
        } else {
            SetTools.excludeDestructiveByTestLargeInSmall(set1, set2);
        }
    }

    public static <A> void excludeDestructiveByTestSmallInLarge(Collection<A> small, Set<A> large) {
        Iterator<A> mi = small.iterator();
        while (mi.hasNext()) {
            if (!large.contains(mi.next())) continue;
            mi.remove();
        }
    }

    public static <A> void excludeDestructiveByTestLargeInSmall(Set<A> large, Collection<A> small) {
        Iterator<A> si = small.iterator();
        while (si.hasNext()) {
            large.remove(si.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SortedMap<String, String> loadMap(String filename, String sep) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
            while ((line = br.readLine()) != null) {
                int pos;
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#' || (pos = line.indexOf(sep)) <= 0) continue;
                map.put(line.substring(0, pos).trim().toLowerCase(), line.substring(pos + sep.length()).trim());
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SortedMap<String, List<String>> loadMapMultiValsPerKey(String filename, String sep) {
        TreeMap<String, List<String>> map = new TreeMap<String, List<String>>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                int pos = line.indexOf(sep);
                if (pos <= 0) {
                    line = line + sep + ".*";
                    pos = line.length() - sep.length() - 2;
                }
                String key = line.substring(0, pos).trim().toLowerCase();
                String value = line.substring(pos + sep.length()).trim();
                if (!map.containsKey(key)) {
                    map.put(key, new ArrayList());
                }
                ((List)map.get(key)).add(value);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SortedSet<String> loadList(File file, Comparator<String> c) {
        TreeSet<String> list2 = new TreeSet<String>(c);
        if (!file.exists()) {
            return list2;
        }
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((line = br.readLine()) != null) {
                int i = line.indexOf("|");
                if (i > 0) {
                    line = line.substring(0, i - 1);
                }
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                list2.add(line.trim().toLowerCase());
            }
        }
        catch (IOException e) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    ConcurrentLog.warn("SetTools", "Could not close input stream on file " + file);
                }
            }
        }
        return list2;
    }

    public static String setToString(HandleSet set, char separator) {
        Iterator<byte[]> i = set.iterator();
        StringBuilder sb = new StringBuilder(set.size() * 7);
        if (i.hasNext()) {
            sb.append(UTF8.String(i.next()));
        }
        while (i.hasNext()) {
            sb.append(separator).append(UTF8.String(i.next()));
        }
        return sb.toString();
    }

    public static String setToString(Set<String> set, char separator) {
        Iterator<String> i = set.iterator();
        StringBuilder sb = new StringBuilder(set.size() * 7);
        if (i.hasNext()) {
            sb.append(i.next());
        }
        while (i.hasNext()) {
            sb.append(separator).append(i.next());
        }
        return sb.toString();
    }

    public static Object nth(Collection<?> c, int n) {
        if (c == null || c.size() <= n) {
            return null;
        }
        int i = 0;
        for (Object o : c) {
            if (i++ != n) continue;
            return o;
        }
        return null;
    }

    public static void main(String[] args) {
        TreeMap<String, String> m = new TreeMap<String, String>();
        TreeMap<String, String> s = new TreeMap<String, String>();
        m.put("a", "a");
        m.put("x", "x");
        m.put("f", "f");
        m.put("h", "h");
        m.put("w", "w");
        m.put("7", "7");
        m.put("t", "t");
        m.put("k", "k");
        m.put("y", "y");
        m.put("z", "z");
        s.put("a", "a");
        s.put("b", "b");
        s.put("c", "c");
        s.put("k", "k");
        s.put("l", "l");
        s.put("m", "m");
        s.put("n", "n");
        s.put("o", "o");
        s.put("p", "p");
        s.put("q", "q");
        s.put("r", "r");
        s.put("s", "s");
        s.put("t", "t");
        s.put("x", "x");
        System.out.println("Compare " + ((Object)m).toString() + " with " + ((Object)s).toString());
        System.out.println("Join=" + SetTools.joinConstructiveByEnumeration(m, s, true));
        System.out.println("Join=" + SetTools.joinConstructiveByTest(m, s, true));
        System.out.println("Join=" + SetTools.joinConstructiveByTest(m, s, true));
        System.out.println("Join=" + SetTools.joinConstructive(m, s, true));
    }
}

