/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.util;

import java.util.concurrent.atomic.AtomicBoolean;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.util.GenerationMemoryStrategy;
import net.yacy.kelondro.util.StandardMemoryStrategy;

public abstract class MemoryStrategy {
    protected static final ConcurrentLog log = new ConcurrentLog("MEMORY");
    protected static long lastGC = 0L;
    protected static boolean error = true;
    protected static String name;

    protected static final boolean hasError() {
        return error;
    }

    protected static final String getName() {
        return name;
    }

    protected synchronized boolean gc(int last, String info) {
        assert (last >= 10000);
        long elapsed = System.currentTimeMillis() - lastGC;
        if (elapsed > (long)last) {
            System.gc();
            lastGC = System.currentTimeMillis();
            return true;
        }
        if (log.isFinest()) {
            log.finest("[gc] no execute, last run: " + elapsed / 1000L + " seconds ago, call: " + info);
        }
        return false;
    }

    protected abstract long free();

    protected abstract long available();

    protected abstract long used();

    protected abstract long total();

    protected abstract long maxMemory();

    protected abstract boolean request(long var1, boolean var3, AtomicBoolean var4);

    protected abstract boolean properState();

    protected void resetProperState() {
    }

    protected void setProperMbyte(long mbyte) {
    }

    public static void main(String[] args) {
        StandardMemoryStrategy sms = new StandardMemoryStrategy();
        System.out.println("StandardMemoryStrategy   / memoryFree  : " + ((MemoryStrategy)sms).free());
        System.out.println("StandardMemoryStrategy   / memoryTotal : " + ((MemoryStrategy)sms).total());
        GenerationMemoryStrategy gms = new GenerationMemoryStrategy();
        System.out.println("GenerationMemoryStrategy / memoryFree  : " + ((MemoryStrategy)gms).free());
        System.out.println("GenerationMemoryStrategy / memoryTotal : " + ((MemoryStrategy)gms).total());
    }
}

