/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.kelondro.util.BDecoder;

public class BEncoder {
    public static Map<String, BDecoder.BObject> transcode(Map<String, byte[]> map) {
        HashMap<String, BDecoder.BObject> m = new HashMap<String, BDecoder.BObject>();
        for (Map.Entry<String, byte[]> entry2 : map.entrySet()) {
            m.put(entry2.getKey(), new BDecoder.BStringObject(entry2.getValue()));
        }
        return m;
    }

    public static byte[] encode(Map<String, BDecoder.BObject> map) {
        BDecoder.BDictionaryObject dict = new BDecoder.BDictionaryObject(map);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            dict.toStream(baos);
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static byte[] encodeMap(String key, byte[] value) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            BDecoder.BDictionaryObject.toStream(baos, key, value);
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void main(String[] args) {
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        m.put("k", "000".getBytes());
        m.put("r", "111".getBytes());
        m.put("s", "222".getBytes());
        Map<String, BDecoder.BObject> t = BEncoder.transcode(m);
        byte[] b = BEncoder.encode(t);
        System.out.println(UTF8.String(b));
        BDecoder d = new BDecoder(b);
        BDecoder.BObject o = d.parse();
        System.out.println(o.toString());
    }
}

