/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.table;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.storage.HandleMap;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.index.Column;
import net.yacy.kelondro.index.Index;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.index.RowCollection;
import net.yacy.kelondro.index.RowHandleMap;
import net.yacy.kelondro.index.RowSet;
import net.yacy.kelondro.io.BufferedRecords;
import net.yacy.kelondro.io.Records;
import net.yacy.kelondro.table.ChunkIterator;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.kelondro.util.kelondroException;

public class Table
implements Index,
Iterable<Row.Entry> {
    private static final ConcurrentLog log = new ConcurrentLog("TABLE");
    private static final Map<String, Table> tableTracker = new ConcurrentSkipListMap<String, Table>();
    private static final long maxarraylength = 0x7FFFFFFL;
    private final long minmemremaining;
    private final int buffersize;
    private final Row rowdef;
    private final Row taildef;
    private HandleMap index;
    private BufferedRecords file;
    private RowSet table;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table(File tablefile, Row rowdef, int buffersize, int initialSpace, boolean useTailCache, boolean exceed134217727, boolean warmUp) throws SpaceExceededException, kelondroException {
        this.rowdef = rowdef;
        this.buffersize = buffersize;
        this.minmemremaining = Math.max(0xC800000L, MemoryControl.available() / 10L);
        Column[] cols = new Column[rowdef.columns() - 1];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = rowdef.column(i + 1);
        }
        this.taildef = new Row(cols, NaturalOrder.naturalOrder);
        boolean freshFile = false;
        if (!tablefile.exists()) {
            freshFile = true;
            FileOutputStream fos = null;
            if (tablefile.getParentFile() != null) {
                tablefile.getParentFile().mkdirs();
            }
            try {
                fos = new FileOutputStream(tablefile);
            }
            catch (FileNotFoundException e) {
                log.severe("", e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        try {
            byte[] key;
            int fileSize = (int)Table.tableSize(tablefile, rowdef.objectsize, true);
            int records = Math.max(fileSize, initialSpace);
            long neededRAM4table = 0xC800000L + (long)records * ((long)(this.taildef.objectsize + rowdef.primaryKeyLength) + 4L) * 3L / 2L;
            this.table = null;
            try {
                this.table = (exceed134217727 || neededRAM4table < 0x7FFFFFFL) && useTailCache && MemoryControl.available() > 629145600L && MemoryControl.request(neededRAM4table, true) ? new RowSet(this.taildef, records) : null;
            }
            catch (SpaceExceededException e) {
                this.table = null;
            }
            catch (Throwable e) {
                this.table = null;
            }
            if (log.isFine()) {
                log.fine("initialization of " + tablefile.getName() + ". table copy: " + (this.table == null ? "no" : "yes") + ", available RAM: " + MemoryControl.available() / 1024L / 1024L + "MB, needed: " + neededRAM4table / 1024L / 1024L + "MB, allocating space for " + records + " entries");
            }
            long neededRAM4index = 0x6400000L + (long)records * ((long)rowdef.primaryKeyLength + 4L) * 3L / 2L;
            if (records > 0 && !MemoryControl.request(neededRAM4index, true)) {
                log.severe(tablefile.getName() + ": not enough RAM (" + MemoryControl.available() / 1024L / 1024L + "MB) left for index, deleting allocated table space to enable index space allocation (needed: " + neededRAM4index / 1024L / 1024L + "MB)");
                this.table = null;
                System.gc();
                log.severe(tablefile.getName() + ": RAM after releasing the table: " + MemoryControl.available() / 1024L / 1024L + "MB");
            }
            this.index = new RowHandleMap(rowdef.primaryKeyLength, rowdef.objectOrder, 4, records, tablefile.getAbsolutePath());
            RowHandleMap errors = new RowHandleMap(rowdef.primaryKeyLength, NaturalOrder.naturalOrder, 4, records, tablefile.getAbsolutePath() + ".errors");
            if (log.isFine()) {
                log.fine(tablefile + ": TABLE " + tablefile.toString() + " has table copy " + (this.table == null ? "DISABLED" : "ENABLED"));
            }
            if (log.isFine()) {
                log.fine("initializing RAM index for TABLE " + tablefile.getName() + ", please wait.");
            }
            int i = 0;
            if (this.table == null) {
                ChunkIterator ki = new ChunkIterator(tablefile, rowdef.objectsize, rowdef.primaryKeyLength);
                try {
                    while (ki.hasNext()) {
                        key = (byte[])ki.next();
                        assert (key != null);
                        if (key == null) {
                            ++i;
                            continue;
                        }
                        if (rowdef.objectOrder.wellformed(key)) {
                            this.index.putUnique(key, i++);
                            continue;
                        }
                        errors.putUnique(key, i++);
                    }
                }
                finally {
                    if (ki.hasNext()) {
                        try {
                            ki.close();
                        }
                        catch (IOException ioe) {
                            log.warn("Could not close input stream on the file " + tablefile);
                        }
                    }
                }
            }
            key = new byte[rowdef.primaryKeyLength];
            ChunkIterator ri = new ChunkIterator(tablefile, rowdef.objectsize, rowdef.objectsize);
            try {
                while (ri.hasNext()) {
                    byte[] record = (byte[])ri.next();
                    assert (record != null);
                    if (record == null) {
                        ++i;
                        continue;
                    }
                    System.arraycopy(record, 0, key, 0, rowdef.primaryKeyLength);
                    if (rowdef.objectOrder.wellformed(key)) {
                        this.index.putUnique(key, i++);
                        try {
                            this.table.addUnique(this.taildef.newEntry(record, rowdef.primaryKeyLength, true));
                            continue;
                        }
                        catch (SpaceExceededException e) {
                            this.table = null;
                            try {
                                ri.close();
                                break;
                            }
                            finally {
                                log.warn("Could not close input stream on the file " + tablefile);
                            }
                        }
                    }
                    errors.putUnique(key, i++);
                }
            }
            finally {
                if (ri.hasNext()) {
                    try {
                        ri.close();
                    }
                    catch (IOException ioe) {
                        log.warn("Could not close input stream on the file " + tablefile);
                    }
                }
            }
            Runtime.getRuntime().gc();
            if (this.abandonTable()) {
                this.table = null;
            }
            this.file = new BufferedRecords(new Records(tablefile, rowdef.objectsize), this.buffersize);
            assert (this.file.size() == (long)this.index.size()) : "file.size() = " + this.file.size() + ", index.size() = " + this.index.size() + ", file = " + this.filename();
            int errorc = errors.size();
            int errorcc = 0;
            for (Map.Entry<byte[], Long> entry2 : errors) {
                int idx2 = (int)entry2.getValue().longValue();
                this.removeInFile(idx2);
                key = entry2.getKey();
                if (key == null) continue;
                log.warn("removing not well-formed entry " + idx2 + " with key: " + NaturalOrder.arrayList(key, 0, key.length) + ", " + errorcc++ + "/" + errorc);
            }
            errors.close();
            assert (this.file.size() == (long)this.index.size()) : "file.size() = " + this.file.size() + ", index.size() = " + this.index.size() + ", file = " + this.filename();
            if (!freshFile && warmUp) {
                this.warmUp0();
            }
        }
        catch (FileNotFoundException e) {
            log.severe("", e);
            throw new kelondroException(e.getMessage());
        }
        catch (IOException e) {
            log.severe("", e);
            throw new kelondroException(e.getMessage());
        }
        tableTracker.put(tablefile.toString(), this);
    }

    public synchronized void warmUp() {
        this.warmUp0();
    }

    private final void warmUp0() {
        try {
            ArrayList<long[]> doubles = this.index.removeDoubles();
            if (doubles.isEmpty()) {
                return;
            }
            log.info(this.filename() + ": WARNING - TABLE " + this.filename() + " has " + doubles.size() + " doubles");
            byte[] record = new byte[this.rowdef.objectsize];
            byte[] key = new byte[this.rowdef.primaryKeyLength];
            for (long[] lArray : doubles) {
                this.file.get((int)lArray[0], record, 0);
                System.arraycopy(record, 0, key, 0, this.rowdef.primaryKeyLength);
                this.index.putUnique(key, (int)lArray[0]);
            }
            TreeSet<Long> delpos = new TreeSet<Long>();
            for (long[] ds3 : doubles) {
                for (int j = 1; j < ds3.length; ++j) {
                    delpos.add(ds3[j]);
                }
            }
            while (!delpos.isEmpty()) {
                Long l = (Long)delpos.last();
                delpos.remove(l);
                this.removeInFile(l.intValue());
            }
        }
        catch (SpaceExceededException e) {
            log.severe("", e);
        }
        catch (IOException e) {
            log.severe("", e);
        }
        this.optimize();
    }

    @Override
    public void optimize() {
        this.index.optimize();
        if (this.table != null) {
            this.table.optimize();
        }
    }

    @Override
    public long mem() {
        return this.index.mem() + (this.table == null ? 0L : this.table.mem());
    }

    private boolean abandonTable() {
        return MemoryControl.shortStatus() || MemoryControl.available() < this.minmemremaining;
    }

    @Override
    public byte[] smallestKey() {
        return this.index.smallestKey();
    }

    @Override
    public byte[] largestKey() {
        return this.index.largestKey();
    }

    public static long tableSize(File tablefile, int recordsize, boolean fixIfCorrupted) throws kelondroException {
        try {
            return Records.tableSize(tablefile, recordsize);
        }
        catch (IOException e) {
            if (!fixIfCorrupted) {
                log.severe("table size broken for file " + tablefile.toString(), e);
                throw new kelondroException(e.getMessage());
            }
            log.severe("table size broken, try to fix " + tablefile.toString());
            try {
                Records.fixTableSize(tablefile, recordsize);
                log.info("successfully fixed table file " + tablefile.toString());
                return Records.tableSize(tablefile, recordsize);
            }
            catch (IOException ee) {
                log.severe("table size fix did not work", ee);
                throw new kelondroException(e.getMessage());
            }
        }
    }

    public static final Iterator<String> filenames() {
        return tableTracker.keySet().iterator();
    }

    public static final TableStatistics memoryStats(String filename) {
        Table theTABLE = tableTracker.get(filename);
        return theTABLE.memoryStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TableStatistics memoryStats() {
        Table table = this;
        synchronized (table) {
            assert (this.table == null || this.table.size() == this.index.size()) : "table.size() = " + this.table.size() + ", index.size() = " + this.index.size();
        }
        TableStatistics stats = new TableStatistics();
        if (this.index == null) {
            return stats;
        }
        stats.tableSize = this.index.size();
        if (this.index instanceof RowHandleMap) {
            stats.keyChunkSize = ((RowHandleMap)this.index).row().objectsize;
            stats.keyMem = (long)((RowHandleMap)this.index).row().objectsize * (long)this.index.size();
        }
        if (this.table != null) {
            stats.valueChunkSize = this.table.row().objectsize;
            stats.valueMem = (long)this.table.row().objectsize * (long)this.table.size();
        }
        return stats;
    }

    public boolean usesFullCopy() {
        return this.table != null;
    }

    public static long staticRAMIndexNeed(File f, Row rowdef) {
        return (long)(rowdef.primaryKeyLength + 4) * Table.tableSize(f, rowdef.objectsize, true) * 140L / 100L;
    }

    public boolean consistencyCheck() {
        try {
            return this.file.size() == (long)this.index.size();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            return false;
        }
    }

    @Override
    public synchronized void addUnique(Row.Entry row) throws IOException, SpaceExceededException {
        assert (this.file.size() == (long)this.index.size()) : "file.size() = " + this.file.size() + ", index.size() = " + this.index.size();
        assert (this.table == null || this.table.size() == this.index.size()) : "table.size() = " + this.table.size() + ", index.size() = " + this.index.size();
        int i = (int)this.file.size();
        try {
            this.index.putUnique(row.getPrimaryKeyBytes(), i);
        }
        catch (SpaceExceededException e) {
            if (this.table == null) {
                throw e;
            }
            this.table = null;
            this.index.putUnique(row.getPrimaryKeyBytes(), i);
        }
        byte[] rowbytes = row.bytes();
        if (this.table != null) {
            assert (this.table.size() == i);
            try {
                this.table.addUnique(this.taildef.newEntry(rowbytes, this.rowdef.primaryKeyLength, true));
            }
            catch (SpaceExceededException e) {
                this.table = null;
            }
            if (this.abandonTable()) {
                this.table = null;
            }
        }
        this.file.add(rowbytes, 0);
        assert (this.file.size() == (long)this.index.size()) : "file.size() = " + this.file.size() + ", index.size() = " + this.index.size();
    }

    public synchronized void addUnique(List<Row.Entry> rows) throws IOException, SpaceExceededException {
        assert (this.file.size() == (long)this.index.size()) : "file.size() = " + this.file.size() + ", index.size() = " + this.index.size();
        for (Row.Entry entry2 : rows) {
            try {
                this.addUnique(entry2);
            }
            catch (SpaceExceededException e) {
                if (this.table == null) {
                    throw e;
                }
                this.table = null;
                this.addUnique(entry2);
            }
        }
        assert (this.file.size() == (long)this.index.size()) : "file.size() = " + this.file.size() + ", index.size() = " + this.index.size();
    }

    @Override
    public synchronized List<RowCollection> removeDoubles() throws IOException, SpaceExceededException {
        ArrayList<long[]> doubles;
        assert (this.file.size() == (long)this.index.size()) : "file.size() = " + this.file.size() + ", index.size() = " + this.index.size();
        ArrayList<RowCollection> report = new ArrayList<RowCollection>();
        TreeSet<Long> d = new TreeSet<Long>();
        byte[] b = new byte[this.rowdef.objectsize];
        long lastlog = System.currentTimeMillis();
        try {
            doubles = this.index.removeDoubles();
        }
        catch (SpaceExceededException e) {
            if (this.table == null) {
                throw e;
            }
            this.table = null;
            doubles = this.index.removeDoubles();
        }
        for (long[] is : doubles) {
            RowSet rows = new RowSet(this.rowdef, is.length);
            for (long L : is) {
                assert ((long)((int)L) < this.file.size()) : "L.intValue() = " + (int)L + ", file.size = " + this.file.size();
                d.add(L);
                if ((long)((int)L) >= this.file.size()) continue;
                this.file.get((int)L, b, 0);
                Row.Entry inconsistentEntry = this.rowdef.newEntry(b);
                try {
                    rows.addUnique(inconsistentEntry);
                }
                catch (SpaceExceededException e) {
                    if (this.table == null) {
                        throw e;
                    }
                    this.table = null;
                    rows.addUnique(inconsistentEntry);
                }
            }
            report.add(rows);
        }
        while (!d.isEmpty()) {
            Long s = (Long)d.last();
            d.remove(s);
            this.removeInFile(s.intValue());
            if (System.currentTimeMillis() - lastlog <= 30000L) continue;
            log.info("removing " + d.size() + " entries in " + this.filename());
            lastlog = System.currentTimeMillis();
        }
        assert (this.file.size() == (long)this.index.size()) : "file.size() = " + this.file.size() + ", index.size() = " + this.index.size();
        return report;
    }

    @Override
    public void close() {
        String tablefile = null;
        if (this.file != null) {
            tablefile = this.file.filename().toString();
            this.file.close();
        }
        this.file = null;
        if (this.table != null) {
            this.table.close();
        }
        this.table = null;
        if (this.index != null) {
            this.index.close();
        }
        this.index = null;
        if (tablefile != null) {
            tableTracker.remove(tablefile);
        }
    }

    @Override
    public String filename() {
        return this.file.filename().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Row.Entry get(byte[] key, boolean _forcecopy) throws IOException {
        if (this.file == null || this.index == null) {
            return null;
        }
        Row.Entry e = this.get0(key);
        if (e != null && this.rowdef.objectOrder.equal(key, e.getPrimaryKeyBytes())) {
            return e;
        }
        Table table = this;
        synchronized (table) {
            assert (this.table == null || this.table.size() == this.index.size()) : "table.size() = " + this.table.size() + ", index.size() = " + this.index.size() + ", file = " + this.filename();
            e = this.get0(key);
            assert (e == null || this.rowdef.objectOrder.equal(key, e.getPrimaryKeyBytes())) : "key = " + ASCII.String(key) + ", e.k = " + ASCII.String(e.getPrimaryKeyBytes());
            return e;
        }
    }

    private final Row.Entry get0(byte[] key) throws IOException {
        Row.Entry cacherow;
        if (this.file == null || this.index == null) {
            return null;
        }
        int i = (int)this.index.get(key);
        if (i == -1) {
            return null;
        }
        byte[] b = new byte[this.rowdef.objectsize];
        if (this.table == null || (cacherow = this.table.get(i, false)) == null) {
            try {
                this.file.get(i, b, 0);
            }
            catch (IndexOutOfBoundsException e) {
                log.severe("IndexOutOfBoundsException: " + e.getMessage(), e);
                this.index.remove(key);
                if (this.table != null) {
                    this.table.remove(key);
                }
                return null;
            }
        } else {
            assert (key.length == this.rowdef.primaryKeyLength);
            System.arraycopy(key, 0, b, 0, key.length);
            System.arraycopy(cacherow.bytes(), 0, b, this.rowdef.primaryKeyLength, this.rowdef.objectsize - this.rowdef.primaryKeyLength);
        }
        return this.rowdef.newEntry(b);
    }

    @Override
    public final Map<byte[], Row.Entry> get(Collection<byte[]> keys, boolean forcecopy) throws IOException, InterruptedException {
        TreeMap<byte[], Row.Entry> map = new TreeMap<byte[], Row.Entry>(this.row().objectOrder);
        for (byte[] key : keys) {
            Row.Entry entry2 = this.get(key, forcecopy);
            if (entry2 == null) continue;
            map.put(key, entry2);
        }
        return map;
    }

    @Override
    public final boolean has(byte[] key) {
        if (this.index == null) {
            return false;
        }
        return this.index.has(key);
    }

    @Override
    public final synchronized CloneableIterator<byte[]> keys(boolean up, byte[] firstKey) throws IOException {
        return this.index.keys(up, firstKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Row.Entry replace(Row.Entry row) throws IOException, SpaceExceededException {
        assert (row != null);
        if (this.file == null || row == null) {
            return null;
        }
        byte[] rowb = row.bytes();
        assert (rowb != null);
        if (rowb == null) {
            return null;
        }
        byte[] key = row.getPrimaryKeyBytes();
        Table table = this;
        synchronized (table) {
            Row.Entry cacherow;
            int i = (int)this.index.get(key);
            if (i == -1) {
                try {
                    this.addUnique(row);
                }
                catch (SpaceExceededException e) {
                    if (this.table == null) {
                        throw e;
                    }
                    this.table = null;
                    this.addUnique(row);
                }
                return null;
            }
            byte[] b = new byte[this.rowdef.objectsize];
            if (this.table == null || (cacherow = this.table.get(i, false)) == null) {
                this.file.get(i, b, 0);
                this.file.put(i, rowb, 0);
            } else {
                assert (cacherow != null);
                System.arraycopy(key, 0, b, 0, this.rowdef.primaryKeyLength);
                System.arraycopy(cacherow.bytes(), 0, b, this.rowdef.primaryKeyLength, this.rowdef.objectsize - this.rowdef.primaryKeyLength);
                try {
                    this.table.set(i, this.taildef.newEntry(rowb, this.rowdef.primaryKeyLength, true));
                }
                catch (SpaceExceededException e) {
                    this.table = null;
                }
                if (this.abandonTable()) {
                    this.table = null;
                }
                this.file.put(i, rowb, 0);
            }
            assert (this.file.size() == (long)this.index.size()) : "file.size() = " + this.file.size() + ", index.size() = " + this.index.size();
            assert (this.table == null || this.table.size() == this.index.size()) : "table.size() = " + this.table.size() + ", index.size() = " + this.index.size();
            return this.rowdef.newEntry(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean put(Row.Entry row) throws IOException, SpaceExceededException {
        assert (row != null);
        if (this.file == null || row == null) {
            return true;
        }
        byte[] rowb = row.bytes();
        assert (rowb != null);
        if (rowb == null) {
            return true;
        }
        byte[] key = row.getPrimaryKeyBytes();
        Table table = this;
        synchronized (table) {
            int i = (int)this.index.get(key);
            if (i == -1) {
                try {
                    this.addUnique(row);
                }
                catch (SpaceExceededException e) {
                    if (this.table == null) {
                        throw e;
                    }
                    this.table = null;
                    this.addUnique(row);
                }
                return true;
            }
            if (this.table == null) {
                this.file.put(i, rowb, 0);
            } else {
                this.file.put(i, rowb, 0);
                if (this.abandonTable()) {
                    this.table = null;
                } else {
                    try {
                        this.table.set(i, this.taildef.newEntry(rowb, this.rowdef.primaryKeyLength, true));
                    }
                    catch (SpaceExceededException e) {
                        this.table = null;
                    }
                }
            }
            assert (this.file.size() == (long)this.index.size()) : "file.size() = " + this.file.size() + ", index.size() = " + this.index.size();
            assert (this.table == null || this.table.size() == this.index.size()) : "table.size() = " + this.table.size() + ", index.size() = " + this.index.size();
            return false;
        }
    }

    private final void removeInFile(int i) throws IOException, SpaceExceededException {
        assert (i >= 0);
        byte[] p = new byte[this.rowdef.objectsize];
        if (this.table == null) {
            if (i == this.index.size() - 1) {
                this.file.cleanLast();
            } else {
                while (this.file.size() > 0L) {
                    this.file.cleanLast(p, 0);
                    if (!this.rowdef.objectOrder.wellformed(p, 0, this.rowdef.primaryKeyLength)) continue;
                    this.file.put(i, p, 0);
                    byte[] k = new byte[this.rowdef.primaryKeyLength];
                    System.arraycopy(p, 0, k, 0, this.rowdef.primaryKeyLength);
                    this.index.put(k, i);
                    break;
                }
            }
        } else if (i == this.index.size() - 1) {
            this.table.removeRow(i, false);
            this.file.cleanLast();
        } else {
            Row.Entry te = this.table.removeOne();
            try {
                this.table.set(i, te);
            }
            catch (SpaceExceededException e) {
                this.table = null;
            }
            while (this.file.size() > 0L) {
                this.file.cleanLast(p, 0);
                Row.Entry lr = this.rowdef.newEntry(p);
                if (lr == null) {
                    this.table.clear();
                    this.table = null;
                    continue;
                }
                this.file.put(i, p, 0);
                byte[] pk = lr.getPrimaryKeyBytes();
                if (pk == null) {
                    log.warn("Possible corruption found in table " + this.filename() + " detected. i=" + i + ",p=" + p);
                    continue;
                }
                this.index.put(pk, i);
                break;
            }
        }
    }

    @Override
    public final boolean delete(byte[] key) throws IOException {
        return this.remove(key) != null;
    }

    @Override
    public final synchronized Row.Entry remove(byte[] key) throws IOException {
        Row.Entry cacherow;
        assert (this.file.size() == (long)this.index.size()) : "file.size() = " + this.file.size() + ", index.size() = " + this.index.size();
        assert (this.table == null || this.table.size() == this.index.size()) : "table.size() = " + this.table.size() + ", index.size() = " + this.index.size();
        assert (key.length == this.rowdef.primaryKeyLength);
        int i = (int)this.index.get(key);
        if (i == -1) {
            return null;
        }
        byte[] b = new byte[this.rowdef.objectsize];
        byte[] p = new byte[this.rowdef.objectsize];
        int sb = this.index.size();
        assert (i < this.index.size());
        if (this.table == null || (cacherow = this.table.get(i, false)) == null) {
            if (i == this.index.size() - 1) {
                int ix = (int)this.index.remove(key);
                assert (this.index.size() < i + 1) : "index.size() = " + this.index.size() + ", i = " + i;
                assert (ix == i);
                this.file.cleanLast(b, 0);
            } else {
                assert (i < this.index.size() - 1) : "index.size() = " + this.index.size() + ", i = " + i;
                int ix = (int)this.index.remove(key);
                assert (i < this.index.size()) : "index.size() = " + this.index.size() + ", i = " + i;
                assert (ix == i);
                this.file.get(i, b, 0);
                this.file.cleanLast(p, 0);
                this.file.put(i, p, 0);
                byte[] k = new byte[this.rowdef.primaryKeyLength];
                System.arraycopy(p, 0, k, 0, this.rowdef.primaryKeyLength);
                try {
                    this.index.put(k, i);
                }
                catch (SpaceExceededException e) {
                    ConcurrentLog.logException(e);
                    throw new IOException("RowSpaceExceededException: " + e.getMessage());
                }
            }
            assert (this.file.size() == (long)this.index.size()) : "file.size() = " + this.file.size() + ", index.size() = " + this.index.size();
        } else {
            System.arraycopy(key, 0, b, 0, key.length);
            System.arraycopy(cacherow.bytes(), 0, b, this.rowdef.primaryKeyLength, this.taildef.objectsize);
            if (i == this.index.size() - 1) {
                int ix = (int)this.index.remove(key);
                assert (this.index.size() < i + 1) : "index.size() = " + this.index.size() + ", i = " + i;
                assert (ix == i);
                this.table.removeRow(i, false);
                this.file.cleanLast();
            } else {
                int ix = (int)this.index.remove(key);
                assert (i < this.index.size()) : "index.size() = " + this.index.size() + ", i = " + i;
                assert (ix == i);
                Row.Entry te = this.table.removeOne();
                try {
                    this.table.set(i, te);
                }
                catch (SpaceExceededException e) {
                    ConcurrentLog.logException(e);
                    this.table = null;
                }
                this.file.cleanLast(p, 0);
                this.file.put(i, p, 0);
                Row.Entry lr = this.rowdef.newEntry(p);
                try {
                    this.index.put(lr.getPrimaryKeyBytes(), i);
                }
                catch (SpaceExceededException e) {
                    this.table = null;
                    throw new IOException("RowSpaceExceededException: " + e.getMessage());
                }
            }
            assert (this.file.size() == (long)this.index.size()) : "file.size() = " + this.file.size() + ", index.size() = " + this.index.size();
            assert (this.table.size() == this.index.size()) : "table.size() = " + this.table.size() + ", index.size() = " + this.index.size();
        }
        assert (this.file.size() == (long)this.index.size()) : "file.size() = " + this.file.size() + ", index.size() = " + this.index.size();
        assert (this.table == null || this.table.size() == this.index.size()) : "table.size() = " + this.table.size() + ", index.size() = " + this.index.size();
        assert (this.index.size() + 1 == sb) : "index.size() = " + this.index.size() + ", sb = " + sb;
        return this.rowdef.newEntry(b);
    }

    @Override
    public final synchronized Row.Entry removeOne() throws IOException {
        assert (this.table == null || this.table.size() == this.index.size()) : "table.size() = " + this.table.size() + ", index.size() = " + this.index.size();
        byte[] le = new byte[this.rowdef.objectsize];
        long fsb = this.file.size();
        assert (fsb != 0L) : "file.size() = " + fsb;
        this.file.cleanLast(le, 0);
        assert (this.file.size() < fsb) : "file.size() = " + this.file.size();
        Row.Entry lr = this.rowdef.newEntry(le);
        assert (lr != null);
        assert (lr.getPrimaryKeyBytes() != null);
        int is = this.index.size();
        assert (this.index.has(lr.getPrimaryKeyBytes()));
        int i = (int)this.index.remove(lr.getPrimaryKeyBytes());
        assert (i < 0 || this.index.size() < is) : "index.size() = " + this.index.size() + ", is = " + is;
        assert (i >= 0);
        if (this.table != null) {
            int tsb = this.table.size();
            this.table.removeOne();
            assert (this.table.size() < tsb) : "table.size() = " + this.table.size() + ", tsb = " + tsb;
        }
        assert (this.table == null || this.table.size() == this.index.size()) : "table.size() = " + this.table.size() + ", index.size() = " + this.index.size();
        return lr;
    }

    @Override
    public final List<Row.Entry> top(int count) throws IOException {
        if (count > this.size()) {
            count = this.size();
        }
        ArrayList<Row.Entry> list2 = new ArrayList<Row.Entry>();
        if (this.file == null || this.index == null || this.size() == 0 || count == 0) {
            return list2;
        }
        for (long i = this.file.size() - 1L; count > 0 && i >= 0L; --i, --count) {
            byte[] b = new byte[this.rowdef.objectsize];
            this.file.get(i, b, 0);
            list2.add(this.rowdef.newEntry(b));
        }
        return list2;
    }

    @Override
    public final List<Row.Entry> random(int count) throws IOException {
        if (count > this.size()) {
            count = this.size();
        }
        ArrayList<Row.Entry> list2 = new ArrayList<Row.Entry>();
        if (this.file == null || this.index == null || this.size() == 0 || count == 0) {
            return list2;
        }
        int stepsize = this.size() / count;
        for (long cursor = 0L; count > 0 && cursor < (long)this.size(); --count, cursor += (long)stepsize) {
            byte[] b = new byte[this.rowdef.objectsize];
            this.file.get(cursor, b, 0);
            list2.add(this.rowdef.newEntry(b));
        }
        return list2;
    }

    @Override
    public synchronized void clear() throws IOException {
        this.file.clear();
        this.table = this.table == null ? null : new RowSet(this.taildef);
        this.index.clear();
    }

    @Override
    public final Row row() {
        return this.rowdef;
    }

    @Override
    public final int size() {
        if (this.index == null) {
            return 0;
        }
        return this.index.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.index == null || this.index.isEmpty();
    }

    @Override
    public final Iterator<Row.Entry> iterator() {
        try {
            return this.rows();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public synchronized CloneableIterator<Row.Entry> rows() throws IOException {
        this.file.flushBuffer();
        return new rowIteratorNoOrder();
    }

    @Override
    public synchronized CloneableIterator<Row.Entry> rows(boolean up, byte[] firstKey) throws IOException {
        return new rowIterator(up, firstKey);
    }

    private static byte[] testWord(char c) {
        return new byte[]{(byte)c, 32, 32, 32};
    }

    private static String[] permutations(int letters) {
        String p = "";
        for (int i = 0; i < letters; ++i) {
            p = p + (char)(65 + i);
        }
        return Table.permutations(p);
    }

    private static String[] permutations(String source) {
        if (source.isEmpty()) {
            return new String[0];
        }
        if (source.length() == 1) {
            return new String[]{source};
        }
        char c = source.charAt(0);
        String[] recres = Table.permutations(source.substring(1));
        String[] result = new String[source.length() * recres.length];
        for (int perm = 0; perm < recres.length; ++perm) {
            result[perm * source.length()] = c + recres[perm];
            for (int pos = 1; pos < source.length() - 1; ++pos) {
                result[perm * source.length() + pos] = recres[perm].substring(0, pos) + c + recres[perm].substring(pos);
            }
            result[perm * source.length() + source.length() - 1] = recres[perm] + c;
        }
        return result;
    }

    private static Table testTable(File f, String testentities, boolean useTailCache, boolean exceed134217727) throws IOException, SpaceExceededException {
        if (f.exists()) {
            FileUtils.deletedelete(f);
        }
        Row rowdef = new Row("byte[] a-4, byte[] b-4", NaturalOrder.naturalOrder);
        Table tt = new Table(f, rowdef, 100, 0, useTailCache, exceed134217727, true);
        Row.Entry row = rowdef.newEntry();
        for (int i = 0; i < testentities.length(); ++i) {
            byte[] b = Table.testWord(testentities.charAt(i));
            row.setCol(0, b);
            row.setCol(1, b);
            tt.put(row);
        }
        return tt;
    }

    private static int countElements(Table t) {
        int count = 0;
        for (Row.Entry row : t) {
            ++count;
            if (row != null) continue;
            System.out.println("ERROR! null element found");
        }
        return count;
    }

    public static void bigtest(int elements, File testFile, boolean useTailCache, boolean exceed134217727) {
        System.out.println("starting big test with " + elements + " elements:");
        long start = System.currentTimeMillis();
        String[] s = Table.permutations(elements);
        try {
            for (int i = 0; i < s.length; ++i) {
                System.out.println("*** probing tree " + i + " for permutation " + s[i]);
                Table tt = Table.testTable(testFile, s[i], useTailCache, exceed134217727);
                int count = Table.countElements(tt);
                if (count != tt.size()) {
                    System.out.println("wrong size for " + s[i] + ": count = " + count + ", size() = " + tt.size());
                }
                tt.close();
                for (String element : s) {
                    tt = Table.testTable(testFile, s[i], useTailCache, exceed134217727);
                    for (int elt = 0; elt < element.length(); ++elt) {
                        tt.remove(Table.testWord(element.charAt(elt)));
                        count = Table.countElements(tt);
                        if (count == tt.size()) continue;
                        System.out.println("ERROR! wrong size for probe tree " + s[i] + "; probe delete " + element + "; position " + elt + "; count = " + count + ", size() = " + tt.size());
                    }
                    tt.close();
                }
            }
            System.out.println("FINISHED test after " + (System.currentTimeMillis() - start) / 1000L + " seconds.");
        }
        catch (Exception e) {
            ConcurrentLog.logException(e);
            System.out.println("TERMINATED");
        }
    }

    public void print() throws IOException {
        System.out.println("PRINTOUT of table, length=" + this.size());
        CloneableIterator<byte[]> i = this.keys(true, null);
        while (i.hasNext()) {
            System.out.print("row " + i + ": ");
            byte[] key = (byte[])i.next();
            Row.Entry row = this.get(key, false);
            System.out.println(row.toString());
        }
        System.out.println("EndOfTable");
    }

    public static void main(String[] args) {
        File f = new File(args[0]);
        System.out.println("========= Testcase: no tail cache:");
        Table.bigtest(5, f, false, false);
        System.out.println("========= Testcase: with tail cache:");
        Table.bigtest(5, f, true, true);
    }

    @Override
    public void deleteOnExit() {
        this.file.deleteOnExit();
    }

    private final class rowIterator
    implements CloneableIterator<Row.Entry> {
        private final CloneableIterator<byte[]> i;
        private final boolean up;
        private final byte[] fk;
        private int c;

        private rowIterator(boolean up, byte[] firstKey) {
            this.up = up;
            this.fk = firstKey;
            this.i = Table.this.index.keys(up, firstKey);
            this.c = -1;
        }

        @Override
        public CloneableIterator<Row.Entry> clone(Object modifier) {
            return new rowIterator(this.up, this.fk);
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public Row.Entry next() {
            Row.Entry cacherow;
            byte[] k = (byte[])this.i.next();
            assert (k != null);
            if (k == null) {
                return null;
            }
            this.c = (int)Table.this.index.get(k);
            if (this.c < 0) {
                throw new ConcurrentModificationException();
            }
            byte[] b = new byte[((Table)Table.this).rowdef.objectsize];
            if (Table.this.table == null || (cacherow = Table.this.table.get(this.c, false)) == null) {
                try {
                    Table.this.file.get(this.c, b, 0);
                }
                catch (IOException e) {
                    log.severe("", e);
                    return null;
                }
            } else {
                System.arraycopy(k, 0, b, 0, ((Table)Table.this).rowdef.primaryKeyLength);
                System.arraycopy(cacherow.bytes(), 0, b, ((Table)Table.this).rowdef.primaryKeyLength, ((Table)Table.this).taildef.objectsize);
            }
            return Table.this.rowdef.newEntry(b);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("no remove in Table.rowIterator");
        }

        @Override
        public void close() {
            this.i.close();
        }
    }

    private final class rowIteratorNoOrder
    implements CloneableIterator<Row.Entry> {
        Iterator<Map.Entry<byte[], Long>> i;
        long idx;
        byte[] key;

        public rowIteratorNoOrder() {
            this.i = Table.this.index.iterator();
        }

        @Override
        public final CloneableIterator<Row.Entry> clone(Object modifier) {
            return new rowIteratorNoOrder();
        }

        @Override
        public final boolean hasNext() {
            return this.i != null && this.i.hasNext();
        }

        @Override
        public final Row.Entry next() {
            Map.Entry<byte[], Long> entry2 = this.i.next();
            if (entry2 == null) {
                return null;
            }
            this.key = entry2.getKey();
            if (this.key == null) {
                return null;
            }
            this.idx = entry2.getValue();
            try {
                return Table.this.get(this.key, false);
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public final void remove() {
            if (this.key != null) {
                try {
                    Table.this.removeInFile((int)this.idx);
                }
                catch (IOException iOException) {
                }
                catch (SpaceExceededException spaceExceededException) {
                    // empty catch block
                }
                this.i.remove();
            }
        }

        @Override
        public final void close() {
            if (this.i instanceof CloneableIterator) {
                ((CloneableIterator)this.i).close();
            }
        }
    }

    public class TableStatistics {
        private int tableSize = 0;
        private int keyChunkSize = 0;
        private long keyMem = 0L;
        private int valueChunkSize = 0;
        private long valueMem = 0L;

        public int getKeyChunkSize() {
            return this.keyChunkSize;
        }

        public long getKeyMem() {
            return this.keyMem;
        }

        public int getTableSize() {
            return this.tableSize;
        }

        public int getValueChunkSize() {
            return this.valueChunkSize;
        }

        public long getValueMem() {
            return this.valueMem;
        }

        public long getTotalMem() {
            return this.keyMem + this.valueMem;
        }
    }
}

