/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.table;

import java.io.File;
import java.io.IOException;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.table.Table;
import net.yacy.kelondro.util.kelondroException;

public class IndexTable {
    private final Table table;

    public IndexTable(File location, int keysize, int payloadsize, boolean useTailCache, boolean exceed134217727) throws IOException {
        Table t;
        Row row = new Row("byte[] key-" + keysize + ", long num-" + payloadsize + " {b256}", NaturalOrder.naturalOrder);
        try {
            t = new Table(location, row, 0x100000, 0, useTailCache, exceed134217727, true);
        }
        catch (SpaceExceededException e) {
            try {
                t = new Table(location, row, 0, 0, false, exceed134217727, true);
            }
            catch (SpaceExceededException | kelondroException e1) {
                throw new IOException(e);
            }
        }
        this.table = t;
    }

    public Long put(byte[] key, long value) throws IOException {
        Row.Entry entry2 = this.table.row().newEntry();
        entry2.setCol(0, key);
        entry2.setCol(1, value);
        try {
            Row.Entry oldentry = this.table.replace(entry2);
            if (oldentry == null) {
                return null;
            }
            return oldentry.getColLong(1);
        }
        catch (SpaceExceededException e) {
            throw new IOException(e);
        }
    }

    public long get(byte[] key) throws IOException {
        Row.Entry entry2 = this.table.get(key, false);
        if (entry2 == null) {
            return -1L;
        }
        Long l = entry2.getColLong(1);
        return l == null ? -1L : l;
    }

    public boolean has(byte[] key) {
        return this.table.has(key);
    }

    public Long remove(byte[] key) throws IOException {
        Row.Entry entry2 = this.table.remove(key);
        if (entry2 == null) {
            return null;
        }
        return entry2.getColLong(1);
    }

    public void clear() throws IOException {
        this.table.clear();
    }

    public void close() {
        this.table.close();
    }
}

