/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.logging;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.yacy.document.parser.html.CharacterCoding;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.OS;
import net.yacy.peers.operation.yacyBuildProperties;
import net.yacy.search.Switchboard;
import net.yacy.utils.nxTools;

public class ThreadDump
extends HashMap<StackTrace, List<String>>
implements Map<StackTrace, List<String>> {
    private static final long serialVersionUID = -5587850671040354397L;
    private static final String multiDumpFilter = ".*((java.net.DatagramSocket.receive)|(java.lang.Thread.getAllStackTraces)|(java.net.SocketInputStream.read)|(java.net.ServerSocket.accept)|(java.net.Socket.connect)).*";
    private static final Pattern multiDumpFilterPattern = Pattern.compile(".*((java.net.DatagramSocket.receive)|(java.lang.Thread.getAllStackTraces)|(java.net.SocketInputStream.read)|(java.net.ServerSocket.accept)|(java.net.Socket.connect)).*");
    private static final String statestatement = "java.lang.Thread.State:";

    public static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        return Thread.getAllStackTraces();
    }

    public static boolean canProduceLockedBy(File logFile) {
        if (!OS.canExecUnix) {
            return false;
        }
        if (!logFile.exists()) {
            return false;
        }
        return System.currentTimeMillis() - logFile.lastModified() <= 60000L;
    }

    public ThreadDump(File logFile) throws IOException {
        long sizeAfter;
        long sizeBefore = 0L;
        if (ThreadDump.canProduceLockedBy(logFile)) {
            sizeBefore = logFile.length();
            int pid = OS.getPID();
            if (pid >= 0) {
                try {
                    OS.execSynchronous(new String[]{"kill", "-3", Integer.toString(pid)});
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if ((sizeAfter = logFile.length()) <= sizeBefore) {
            return;
        }
        try (RandomAccessFile raf = new RandomAccessFile(logFile, "r");){
            raf.seek(sizeBefore);
            byte[] b = new byte[(int)(sizeAfter - sizeBefore)];
            raf.readFully(b);
            this.importText(new ByteArrayInputStream(b));
        }
    }

    public ThreadDump(InputStream is) throws IOException {
        this.importText(is);
    }

    public static Thread.State threadState(String line) {
        int p = line.indexOf(statestatement);
        if (p < 0) {
            return null;
        }
        if ((p = (line = line.substring(p + statestatement.length()).trim()).indexOf(32)) >= 0) {
            line = line.substring(0, p).trim();
        }
        try {
            return Thread.State.valueOf(line);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private void importText(InputStream is) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String thread = null;
        ArrayList<String> list2 = new ArrayList<String>();
        Thread.State state = null;
        while ((line = br.readLine()) != null) {
            int p;
            Thread.State state0 = ThreadDump.threadState(line);
            if (state0 != null) {
                state = state0;
            }
            if (line.isEmpty()) {
                if (thread != null) {
                    this.put(new StackTrace(thread, state), list2);
                }
                list2 = new ArrayList();
                thread = null;
                state = null;
                continue;
            }
            if (line.charAt(0) == '\"' && (p = line.indexOf("\" prio=", 0)) > 0) {
                thread = line.substring(1, p);
                continue;
            }
            if (thread == null) continue;
            list2.add(line);
        }
        if (thread != null) {
            this.put(new StackTrace(thread, state), list2);
        }
    }

    public ThreadDump(File appPath, Map<Thread, StackTraceElement[]> stackTraces, boolean plain, Thread.State stateIn) {
        File classPath = new File(appPath, "source");
        for (Map.Entry<Thread, StackTraceElement[]> entry2 : stackTraces.entrySet()) {
            Thread thread = entry2.getKey();
            StackTraceElement[] stackTraceElements = entry2.getValue();
            String tracename = "";
            if (stateIn != null && !stateIn.equals((Object)thread.getState()) || stackTraceElements.length <= 0) continue;
            StringBuilder sb = new StringBuilder(3000);
            if (plain) {
                File classFile = ThreadDump.getClassFile(classPath, stackTraceElements[stackTraceElements.length - 1].getClassName());
                tracename = classFile.getName();
                if (tracename.endsWith(".java")) {
                    tracename = tracename.substring(0, tracename.length() - 5);
                }
                if (tracename.length() > 20) {
                    tracename = tracename.substring(0, 20);
                }
                while (tracename.length() < 20) {
                    tracename = tracename + "_";
                }
                tracename = "[" + tracename + "] ";
            }
            String threadtitle = tracename + "Thread= " + thread.getName() + " " + (thread.isDaemon() ? "daemon" : "") + " id=" + thread.getId() + " " + thread.getState().toString();
            boolean cutcore = true;
            for (int i = 0; i < stackTraceElements.length; ++i) {
                StackTraceElement ste = stackTraceElements[i];
                String className = ste.getClassName();
                if (cutcore && (className.startsWith("java.") || className.startsWith("sun."))) {
                    sb.setLength(0);
                    ThreadDump.bufferappend(sb, plain, tracename + "at " + CharacterCoding.unicode2html(ste.toString(), true));
                    continue;
                }
                cutcore = false;
                String line = i == 0 ? ThreadDump.getLine(ThreadDump.getClassFile(classPath, className), ste.getLineNumber()) : null;
                if (line != null && !line.isEmpty()) {
                    ThreadDump.bufferappend(sb, plain, tracename + "at " + CharacterCoding.unicode2html(ste.toString(), true) + " [" + line.trim() + "]");
                    continue;
                }
                ThreadDump.bufferappend(sb, plain, tracename + "at " + CharacterCoding.unicode2html(ste.toString(), true));
            }
            String threaddump = sb.toString();
            ArrayList<String> threads = (ArrayList<String>)this.get(threaddump);
            if (threads == null) {
                threads = new ArrayList<String>();
            }
            Thread.State state = null;
            for (String t : threads) {
                int p = t.indexOf(statestatement);
                if (p < 0) continue;
                state = Thread.State.valueOf(t.substring(p + statestatement.length()).trim());
            }
            threads.add(threadtitle);
            this.put(new StackTrace(threaddump, state), threads);
        }
    }

    public void appendStackTraces(StringBuilder buffer, boolean plain, Thread.State stateIn) {
        ThreadDump.bufferappend(buffer, plain, "THREADS WITH STATES: " + stateIn.toString());
        ThreadDump.bufferappend(buffer, plain, "&nbsp;");
        for (Map.Entry entry2 : this.entrySet()) {
            List threads = (List)entry2.getValue();
            for (String t : threads) {
                ThreadDump.bufferappend(buffer, plain, t);
            }
            ThreadDump.bufferappend(buffer, plain, ((StackTrace)entry2.getKey()).text);
            ThreadDump.bufferappend(buffer, plain, "&nbsp;");
        }
        ThreadDump.bufferappend(buffer, plain, "&nbsp;");
    }

    public void appendBlockTraces(StringBuilder buffer, boolean plain) {
        ThreadDump.bufferappend(buffer, plain, "THREADS WITH STATES: LOCK FOR OTHERS");
        ThreadDump.bufferappend(buffer, plain, "&nbsp;");
        Map<StackTrace, Integer> locks = this.countLocks();
        for (int i = this.size() + 10; i > 0; --i) {
            for (Map.Entry<StackTrace, Integer> entry2 : locks.entrySet()) {
                if (entry2.getValue() != i) continue;
                ThreadDump.bufferappend(buffer, plain, "holds lock for " + i + " threads:");
                List list2 = (List)this.get(entry2.getKey());
                if (list2 == null) continue;
                ThreadDump.bufferappend(buffer, plain, "Thread= " + entry2.getKey());
                for (String s : list2) {
                    ThreadDump.bufferappend(buffer, plain, "  " + (plain ? s : s.replaceAll("<", "&lt;").replaceAll(">", "&gt;")));
                }
                ThreadDump.bufferappend(buffer, plain, "&nbsp;");
            }
        }
        ThreadDump.bufferappend(buffer, plain, "&nbsp;");
    }

    public static void appendStackTraceStats(File rootPath, StringBuilder buffer, List<Map<Thread, StackTraceElement[]>> stackTraces, boolean plain) {
        HashMap<String, Integer> dumps = new HashMap<String, Integer>();
        for (Map<Thread, StackTraceElement[]> trace : stackTraces) {
            ThreadDump x = new ThreadDump(rootPath, trace, plain, Thread.State.RUNNABLE);
            for (Map.Entry e : x.entrySet()) {
                if (multiDumpFilterPattern.matcher(((StackTrace)e.getKey()).text).matches()) continue;
                Integer c = (Integer)dumps.get(((StackTrace)e.getKey()).text);
                if (c == null) {
                    dumps.put(((StackTrace)e.getKey()).text, 1);
                    continue;
                }
                c = c + 1;
                dumps.put(((StackTrace)e.getKey()).text, c);
            }
        }
        while (!dumps.isEmpty()) {
            Map.Entry<String, Integer> e = ThreadDump.removeMax(dumps);
            ThreadDump.bufferappend(buffer, plain, "Occurrences: " + e.getValue());
            ThreadDump.bufferappend(buffer, plain, e.getKey());
            ThreadDump.bufferappend(buffer, plain, "&nbsp;");
        }
        ThreadDump.bufferappend(buffer, plain, "&nbsp;");
    }

    private static Map.Entry<String, Integer> removeMax(Map<String, Integer> result) {
        Map.Entry<String, Integer> max = null;
        for (Map.Entry<String, Integer> e : result.entrySet()) {
            if (max != null && e.getValue() <= max.getValue()) continue;
            max = e;
        }
        result.remove(max.getKey());
        return max;
    }

    private static File getClassFile(File sourcePath, String classname) {
        String classPath = classname.replace('.', '/') + ".java";
        File file = new File(sourcePath, classPath);
        return file;
    }

    private static String getLine(File file, int line) {
        if (!file.exists()) {
            return "";
        }
        try {
            String lineString = nxTools.line(FileUtils.read(file), line);
            if (lineString == null) {
                return "@ERROR";
            }
            return lineString;
        }
        catch (IOException e) {
            return "@EXCEPTION: " + e.getMessage();
        }
    }

    public static void bufferappend(StringBuilder buffer, boolean plain, String a) {
        buffer.append(plain ? a.replaceAll("&nbsp;", "") : a);
        buffer.append(plain ? "\n" : "<br />");
    }

    public List<Map.Entry<StackTrace, List<String>>> freerun() {
        ArrayList<Map.Entry<StackTrace, List<String>>> runner = new ArrayList<Map.Entry<StackTrace, List<String>>>();
        block0: for (Map.Entry entry2 : this.entrySet()) {
            if (((StackTrace)entry2.getKey()).state != Thread.State.RUNNABLE) continue;
            for (String s : (List)entry2.getValue()) {
                if (s.indexOf("locked <") <= 0 && s.indexOf("waiting to lock", 0) <= 0) continue;
                continue block0;
            }
            runner.add(entry2);
        }
        return runner;
    }

    public Map<Lock, StackTrace> locks() {
        HashMap<Lock, StackTrace> locks = new HashMap<Lock, StackTrace>();
        for (Map.Entry entry2 : this.entrySet()) {
            for (String s : (List)entry2.getValue()) {
                int p = s.indexOf("locked <", 0);
                if (p <= 0) continue;
                locks.put(new Lock(s.substring(p + 8, s.indexOf(62))), (StackTrace)entry2.getKey());
            }
        }
        return locks;
    }

    public Lock lockedBy(StackTrace threadName) {
        List list2 = (List)this.get(threadName);
        if (list2 == null) {
            return null;
        }
        for (String s : list2) {
            int p = s.indexOf(60, 0);
            if (p <= 0 || s.indexOf("locked <", 0) >= 0) continue;
            return new Lock(s.substring(p + 1, s.indexOf(62)));
        }
        return null;
    }

    public Map<StackTrace, Integer> countLocks() {
        Map<Lock, StackTrace> locks = this.locks();
        HashMap<StackTrace, Integer> count = new HashMap<StackTrace, Integer>();
        for (Map.Entry<Lock, StackTrace> entry2 : locks.entrySet()) {
            int c = 0;
            for (StackTrace thread : this.keySet()) {
                if (!entry2.getKey().equals(this.lockedBy(thread))) continue;
                ++c;
            }
            if (c <= 0) continue;
            count.put(entry2.getValue(), c);
        }
        return count;
    }

    public void print() {
        for (StackTrace thread : this.keySet()) {
            this.print(thread);
        }
    }

    public void print(StackTrace thread) {
        List list2 = (List)this.get(thread);
        if (list2 == null) {
            return;
        }
        System.out.println("Thread: " + thread);
        for (String s : list2) {
            System.out.println("  " + s);
        }
        System.out.println("");
    }

    public static String threaddump(Switchboard sb, boolean plain, int sleep, boolean multiple, int multipleCount) {
        ThreadInfo[] threadinfo;
        StringBuilder buffer = new StringBuilder(1000);
        if (sleep > 0) {
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Date dt = new Date();
        String versionstring = yacyBuildProperties.getReleaseStub();
        Runtime runtime = Runtime.getRuntime();
        ThreadDump.bufferappend(buffer, plain, "************* Start Thread Dump " + dt + " *******************");
        ThreadDump.bufferappend(buffer, plain, "&nbsp;");
        ThreadDump.bufferappend(buffer, plain, "YaCy Version: " + versionstring);
        ThreadDump.bufferappend(buffer, plain, "Assigned&nbsp;&nbsp;&nbsp;Memory = " + runtime.maxMemory());
        ThreadDump.bufferappend(buffer, plain, "Used&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Memory = " + (runtime.totalMemory() - runtime.freeMemory()));
        ThreadDump.bufferappend(buffer, plain, "Available&nbsp;&nbsp;Memory = " + (runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory()));
        ThreadDump.bufferappend(buffer, plain, "&nbsp;");
        ThreadDump.bufferappend(buffer, plain, "&nbsp;");
        File appPath = sb.getAppPath();
        if (multiple) {
            ArrayList<Map<Thread, StackTraceElement[]>> traces = new ArrayList<Map<Thread, StackTraceElement[]>>();
            for (int i = 0; i < multipleCount; ++i) {
                try {
                    traces.add(ThreadDump.getAllStackTraces());
                    continue;
                }
                catch (OutOfMemoryError e) {
                    break;
                }
            }
            ThreadDump.appendStackTraceStats(appPath, buffer, traces, plain);
        } else {
            File logFile = new File("yacy.log");
            if (ThreadDump.canProduceLockedBy(logFile)) {
                try {
                    new ThreadDump(logFile).appendBlockTraces(buffer, plain);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (OS.canExecUnix) {
                ThreadDump.bufferappend(buffer, plain, "this thread dump function can find threads that lock others, to enable this function start YaCy with 'startYACY.sh -l'");
                ThreadDump.bufferappend(buffer, plain, "&nbsp;");
            }
            Map<Thread, StackTraceElement[]> stackTraces = ThreadDump.getAllStackTraces();
            new ThreadDump(appPath, stackTraces, plain, Thread.State.BLOCKED).appendStackTraces(buffer, plain, Thread.State.BLOCKED);
            new ThreadDump(appPath, stackTraces, plain, Thread.State.RUNNABLE).appendStackTraces(buffer, plain, Thread.State.RUNNABLE);
            new ThreadDump(appPath, stackTraces, plain, Thread.State.TIMED_WAITING).appendStackTraces(buffer, plain, Thread.State.TIMED_WAITING);
            new ThreadDump(appPath, stackTraces, plain, Thread.State.WAITING).appendStackTraces(buffer, plain, Thread.State.WAITING);
            new ThreadDump(appPath, stackTraces, plain, Thread.State.NEW).appendStackTraces(buffer, plain, Thread.State.NEW);
            new ThreadDump(appPath, stackTraces, plain, Thread.State.TERMINATED).appendStackTraces(buffer, plain, Thread.State.TERMINATED);
        }
        ThreadDump.bufferappend(buffer, plain, "************* End Thread Dump " + dt + " *******************");
        ThreadDump.bufferappend(buffer, plain, "");
        ThreadMXBean threadbean = ManagementFactory.getThreadMXBean();
        ThreadDump.bufferappend(buffer, plain, "Thread list from ThreadMXBean, " + threadbean.getThreadCount() + " threads:");
        for (ThreadInfo ti : threadinfo = threadbean.dumpAllThreads(true, true)) {
            ThreadDump.bufferappend(buffer, plain, ti.getThreadName());
        }
        return buffer.toString();
    }

    public static void main(String[] args) {
        ThreadDump dump = null;
        if (args.length == 2 && args[0].equals("-f")) {
            File dumpfile = new File(args[1]);
            try {
                dump = new ThreadDump(dumpfile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Usage : java " + ThreadDump.class.getName() + " -f /path/to/yacy.log");
            return;
        }
        assert (dump != null);
        Map<StackTrace, Integer> locks = dump.countLocks();
        List<Map.Entry<StackTrace, List<String>>> freerun = dump.freerun();
        assert (locks != null);
        System.out.println("*** Thread Dump Lock report; dump size = " + dump.size() + ", locks = " + locks.size() + ", freerunner = " + freerun.size());
        for (int i = 0; i < dump.size() + 10; ++i) {
            for (Map.Entry<StackTrace, Integer> entry2 : locks.entrySet()) {
                if (entry2.getValue() != i) continue;
                System.out.println("holds lock for " + i + " threads:");
                dump.print(entry2.getKey());
            }
        }
        System.out.println("*** Thread freerunner report; dump size = " + dump.size() + ", locks = " + locks.size() + ", freerunner = " + freerun.size());
        for (Map.Entry<StackTrace, List<String>> entry3 : freerun) {
            System.out.println("freerunner:");
            dump.print(entry3.getKey());
        }
    }

    public static class Lock {
        private final String id;

        public Lock(String name) {
            this.id = name;
        }

        public boolean equals(Object a) {
            return a != null && a instanceof Lock && this.id.equals(((Lock)a).id);
        }

        public boolean equals(Lock a) {
            return a != null && this.id.equals(a.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            return this.id;
        }
    }

    public static class StackTrace {
        private final String text;
        private final Thread.State state;

        public StackTrace(String text, Thread.State state) {
            this.state = state;
            this.text = text;
        }

        public boolean equals(Object a) {
            return a != null && a instanceof StackTrace && this.text.equals(((StackTrace)a).text);
        }

        public boolean equals(StackTrace a) {
            return a != null && this.text.equals(a.text);
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public String toString() {
            return this.text;
        }
    }
}

