/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.index;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.index.Index;
import net.yacy.kelondro.index.RAMIndex;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.index.RowCollection;
import net.yacy.kelondro.index.RowHandleSet;
import net.yacy.kelondro.util.MergeIterator;
import net.yacy.kelondro.util.StackIterator;

public final class RAMIndexCluster
implements Index,
Iterable<Row.Entry>,
Cloneable {
    private final String name;
    private final Row rowdef;
    private final RAMIndex[] cluster;

    public RAMIndexCluster(String name, Row rowdef, int clusterSize) {
        this.name = name;
        this.cluster = new RAMIndex[clusterSize];
        this.rowdef = rowdef;
        for (int i = 0; i < this.cluster.length; ++i) {
            this.cluster[i] = null;
        }
    }

    private RAMIndexCluster(String name, Row rowdef, RAMIndex[] array) {
        this.name = name;
        this.cluster = array;
        this.rowdef = rowdef;
    }

    @Override
    public void optimize() {
        for (RAMIndex i : this.cluster) {
            if (i == null) continue;
            i.optimize();
        }
    }

    public RAMIndexCluster clone() {
        RAMIndex[] a = new RAMIndex[this.cluster.length];
        for (int i = 0; i < this.cluster.length; ++i) {
            a[i] = this.cluster[i] == null ? null : this.cluster[i].clone();
        }
        return new RAMIndexCluster(this.name + ".clone", this.rowdef, a);
    }

    private final int indexFor(byte[] key) {
        return (int)(this.rowdef.objectOrder.cardinal(key) / 17L % (long)this.cluster.length);
    }

    private final int indexFor(Row.Entry row) {
        return (int)(this.rowdef.objectOrder.cardinal(row.bytes(), 0, row.getPrimaryKeyLength()) / 17L % (long)this.cluster.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final byte[] smallestKey() {
        RowHandleSet keysort = new RowHandleSet(this.rowdef.primaryKeyLength, this.rowdef.objectOrder, this.cluster.length);
        RAMIndex[] rAMIndexArray = this.cluster;
        synchronized (this.cluster) {
            for (RAMIndex rs : this.cluster) {
                try {
                    keysort.put(rs.smallestKey());
                }
                catch (SpaceExceededException e) {
                    ConcurrentLog.logException(e);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return keysort.smallestKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final byte[] largestKey() {
        RowHandleSet keysort = new RowHandleSet(this.rowdef.primaryKeyLength, this.rowdef.objectOrder, this.cluster.length);
        RAMIndex[] rAMIndexArray = this.cluster;
        synchronized (this.cluster) {
            for (RAMIndex rs : this.cluster) {
                try {
                    keysort.put(rs.largestKey());
                }
                catch (SpaceExceededException e) {
                    ConcurrentLog.logException(e);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return keysort.largestKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final RAMIndex accessArray(int i) {
        RAMIndex r = this.cluster[i];
        if (r != null) return r;
        RAMIndex[] rAMIndexArray = this.cluster;
        synchronized (this.cluster) {
            r = this.cluster[i];
            if (r != null) return r;
            this.cluster[i] = r = new RAMIndex(this.name + "." + i, this.rowdef);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return r;
        }
    }

    @Override
    public final void addUnique(Row.Entry row) throws SpaceExceededException {
        int i = this.indexFor(row);
        assert (i >= 0) : "i = " + i;
        if (i < 0) {
            return;
        }
        this.accessArray(i).addUnique(row);
    }

    public final void addUnique(List<Row.Entry> rows) throws SpaceExceededException {
        for (Row.Entry row : rows) {
            this.addUnique(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() {
        RAMIndex[] rAMIndexArray = this.cluster;
        synchronized (this.cluster) {
            for (RAMIndex c : this.cluster) {
                if (c == null) continue;
                c.clear();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        RAMIndex[] rAMIndexArray = this.cluster;
        synchronized (this.cluster) {
            for (RAMIndex c : this.cluster) {
                if (c == null) continue;
                c.close();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public final void deleteOnExit() {
    }

    @Override
    public final String filename() {
        return null;
    }

    @Override
    public final Row.Entry get(byte[] key, boolean forcecopy) {
        int i = this.indexFor(key);
        if (i < 0) {
            return null;
        }
        RAMIndex r = this.cluster[i];
        if (r == null) {
            return null;
        }
        return r.get(key, forcecopy);
    }

    @Override
    public Map<byte[], Row.Entry> get(Collection<byte[]> keys, boolean forcecopy) throws IOException, InterruptedException {
        TreeMap<byte[], Row.Entry> map = new TreeMap<byte[], Row.Entry>(this.row().objectOrder);
        for (byte[] key : keys) {
            Row.Entry entry2 = this.get(key, forcecopy);
            if (entry2 == null) continue;
            map.put(key, entry2);
        }
        return map;
    }

    @Override
    public final boolean has(byte[] key) {
        int i = this.indexFor(key);
        if (i < 0) {
            return false;
        }
        RAMIndex r = this.cluster[i];
        if (r == null) {
            return false;
        }
        return r.has(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CloneableIterator<byte[]> keys(boolean up, byte[] firstKey) {
        RAMIndex[] rAMIndexArray = this.cluster;
        synchronized (this.cluster) {
            ArrayList col = new ArrayList();
            for (RAMIndex element : this.cluster) {
                if (element == null) continue;
                col.add(element.keys(up, firstKey));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return MergeIterator.cascade(col, this.rowdef.objectOrder, MergeIterator.simpleMerge, up);
        }
    }

    @Override
    public final boolean put(Row.Entry row) throws SpaceExceededException {
        int i = this.indexFor(row);
        assert (i >= 0) : "i = " + i;
        if (i < 0) {
            return true;
        }
        return this.accessArray(i).put(row);
    }

    @Override
    public final boolean delete(byte[] key) {
        int i = this.indexFor(key);
        if (i < 0) {
            return false;
        }
        return this.accessArray(i).delete(key);
    }

    @Override
    public final Row.Entry remove(byte[] key) {
        int i = this.indexFor(key);
        if (i < 0) {
            return null;
        }
        return this.accessArray(i).remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ArrayList<RowCollection> removeDoubles() throws SpaceExceededException {
        ArrayList<RowCollection> col = new ArrayList<RowCollection>();
        RAMIndex[] rAMIndexArray = this.cluster;
        synchronized (this.cluster) {
            for (int i = 0; i < this.cluster.length; ++i) {
                if (this.cluster[i] == null) continue;
                col.addAll(this.cluster[i].removeDoubles());
                if (!this.cluster[i].isEmpty()) continue;
                this.cluster[i] = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return col;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Row.Entry removeOne() {
        RAMIndex[] rAMIndexArray = this.cluster;
        synchronized (this.cluster) {
            for (int i = 0; i < this.cluster.length; ++i) {
                if (this.cluster[i] == null) continue;
                Row.Entry entry2 = this.cluster[i].removeOne();
                if (this.cluster[i].isEmpty()) {
                    this.cluster[i] = null;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return entry2;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Row.Entry> top(int count) {
        ArrayList<Row.Entry> list2 = new ArrayList<Row.Entry>();
        RAMIndex[] rAMIndexArray = this.cluster;
        synchronized (this.cluster) {
            for (RAMIndex element : this.cluster) {
                if (element != null) {
                    try {
                        List<Row.Entry> list0 = element.top(count - list2.size());
                        list2.addAll(list0);
                    }
                    catch (IOException e) {
                        continue;
                    }
                }
                if (list2.size() < count) continue;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return list2;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Row.Entry> random(int count) {
        ArrayList<Row.Entry> list2 = new ArrayList<Row.Entry>();
        RAMIndex[] rAMIndexArray = this.cluster;
        synchronized (this.cluster) {
            for (RAMIndex element : this.cluster) {
                if (element != null) {
                    try {
                        List<Row.Entry> list0 = element.random(count - list2.size());
                        list2.addAll(list0);
                    }
                    catch (IOException e) {
                        continue;
                    }
                }
                if (list2.size() < count) continue;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return list2;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return list2;
        }
    }

    @Override
    public final Row.Entry replace(Row.Entry row) throws SpaceExceededException {
        int i = this.indexFor(row);
        assert (i >= 0) : "i = " + i;
        if (i < 0) {
            return null;
        }
        return this.accessArray(i).replace(row);
    }

    @Override
    public final Row row() {
        return this.rowdef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CloneableIterator<Row.Entry> rows(boolean up, byte[] firstKey) {
        RAMIndex[] rAMIndexArray = this.cluster;
        synchronized (this.cluster) {
            ArrayList<CloneableIterator<Row.Entry>> col = new ArrayList<CloneableIterator<Row.Entry>>(this.cluster.length);
            for (RAMIndex element : this.cluster) {
                if (element == null) continue;
                col.add(element.rows(up, firstKey));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return StackIterator.stack(col.toArray((CloneableIterator[])Array.newInstance(CloneableIterator.class, col.size())), this.getEntryComparator(), up);
        }
    }

    private Comparator<Row.Entry> getEntryComparator() {
        return new Comparator<Row.Entry>(){

            @Override
            public int compare(Row.Entry o1, Row.Entry o2) {
                return ((RAMIndexCluster)RAMIndexCluster.this).rowdef.objectOrder.compare(o1.getPrimaryKeyBytes(), o2.getPrimaryKeyBytes());
            }
        };
    }

    @Override
    public final CloneableIterator<Row.Entry> rows() {
        return this.rows(true, null);
    }

    @Override
    public final int size() {
        int c = 0;
        for (RAMIndex i : this.cluster) {
            if (i == null) continue;
            c += i.size();
        }
        return c;
    }

    @Override
    public long mem() {
        long m = 0L;
        for (RAMIndex i : this.cluster) {
            if (i == null) continue;
            m += i.mem();
        }
        return m;
    }

    @Override
    public final boolean isEmpty() {
        for (RAMIndex i : this.cluster) {
            if (i == null || i.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Iterator<Row.Entry> iterator() {
        return this.rows(true, null);
    }

    public final long inc(byte[] key, int col, long add, Row.Entry initrow) throws SpaceExceededException {
        int i = this.indexFor(key);
        if (i < 0) {
            return -1L;
        }
        return this.accessArray(i).inc(key, col, add, initrow);
    }
}

