/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.data.word;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.util.ByteBuffer;
import net.yacy.kelondro.data.word.WordReference;
import net.yacy.kelondro.data.word.WordReferenceRow;
import net.yacy.kelondro.data.word.WordReferenceVars;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.rwi.ReferenceContainer;
import net.yacy.kelondro.rwi.ReferenceFactory;

public class WordReferenceFactory
implements ReferenceFactory<WordReference>,
Serializable {
    private static final long serialVersionUID = -7168706947127349876L;

    @Override
    public WordReference produceSlow(Row.Entry e) {
        return new WordReferenceRow(e);
    }

    @Override
    public WordReference produceFast(WordReference r, boolean local) {
        if (r instanceof WordReferenceVars) {
            return r;
        }
        return new WordReferenceVars(r, local);
    }

    @Override
    public Row getRow() {
        return WordReferenceRow.urlEntryRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <ReferenceType extends WordReference> ByteBuffer compressIndex(ReferenceContainer<WordReference> inputContainer, ReferenceContainer<WordReference> excludeContainer, long maxtime) {
        Iterator<Object> i;
        long timeout = maxtime == Long.MAX_VALUE ? Long.MAX_VALUE : (maxtime < 0L ? Long.MAX_VALUE : System.currentTimeMillis() + maxtime);
        TreeMap<String, StringBuilder> doms = new TreeMap<String, StringBuilder>();
        ReferenceContainer<WordReference> referenceContainer = inputContainer;
        synchronized (referenceContainer) {
            i = inputContainer.entries();
            while (i.hasNext()) {
                WordReference iEntry = i.next();
                if (excludeContainer != null && excludeContainer.getReference(iEntry.urlhash()) != null) continue;
                String dom = iEntry instanceof WordReferenceVars ? ((WordReferenceVars)iEntry).hosthash() : ASCII.String(iEntry.urlhash(), 6, 6);
                String mod = ASCII.String(iEntry.urlhash(), 0, 6);
                StringBuilder paths = (StringBuilder)doms.get(dom);
                if (paths == null) {
                    doms.put(dom, new StringBuilder(30).append(mod));
                } else {
                    doms.put(dom, paths.append(mod));
                }
                if (System.currentTimeMillis() <= timeout) continue;
            }
        }
        ByteBuffer bb = new ByteBuffer(inputContainer.size() * 6);
        bb.append('{');
        i = doms.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry2 = (Map.Entry)i.next();
            bb.append((String)entry2.getKey());
            bb.append(':');
            bb.append(((StringBuilder)entry2.getValue()).toString());
            if (System.currentTimeMillis() > timeout) break;
            if (!i.hasNext()) continue;
            bb.append(',');
        }
        bb.append('}');
        return bb;
    }

    public static final SortedMap<String, Set<String>> decompressIndex(ByteBuffer ci, String peerhash) {
        SortedMap<String, Set<String>> target = Collections.synchronizedSortedMap(new TreeMap());
        if (ci.byteAt(0) != 123 || ci.byteAt(ci.length() - 1) != 125) {
            return target;
        }
        ci = ci.trim(1, ci.length() - 2);
        while (ci.length() >= 13 && ci.byteAt(6) == 58) {
            assert (ci.length() >= 6) : "ci.length() = " + ci.length();
            String dom = ci.toStringBuilder(0, 6, 6).toString();
            ci.trim(7);
            while (!ci.isEmpty() && ci.byteAt(0) != 44) {
                assert (ci.length() >= 6) : "ci.length() = " + ci.length();
                StringBuilder urlsb = ci.toStringBuilder(0, 6, 12);
                urlsb.append(dom);
                String url = urlsb.toString();
                ci.trim(6);
                HashSet<String> peers = (HashSet<String>)target.get(url);
                if (peers == null) {
                    peers = new HashSet<String>();
                    target.put(url, peers);
                }
                peers.add(peerhash);
            }
            if (ci.byteAt(0) != 44) continue;
            ci.trim(1);
        }
        return target;
    }
}

