/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.blob;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.util.ByteArray;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.LookAheadIterator;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.BEncodedHeap;
import net.yacy.kelondro.blob.TableColumnIndexException;
import net.yacy.kelondro.blob.TablesColumnBLOBIndex;
import net.yacy.kelondro.blob.TablesColumnIndex;
import net.yacy.kelondro.blob.TablesColumnRAMIndex;
import net.yacy.kelondro.data.word.Word;
import net.yacy.kelondro.util.FileUtils;

public class Tables
implements Iterable<String> {
    private static final String p1 = "(?:^|.*,)";
    private static final String p2 = "((?:";
    private static final String p3 = ")(?:,.*|$)){";
    private static final String CIDX = "_cidx";
    private static final int NOINDEX = 50000;
    private static final int RAMINDEX = 100000;
    private static final String suffix = ".bheap";
    private static final String system_table_pkcounter = "pkcounter";
    private static final String system_table_pkcounter_counterName = "pk";
    private final File location;
    private final ConcurrentHashMap<String, BEncodedHeap> tables;
    private final ConcurrentHashMap<String, TablesColumnIndex> cidx;
    private int keymaxlen;
    private static final GenericFormatter my_SHORT_MILSEC_FORMATTER = new GenericFormatter(GenericFormatter.newShortMilsecFormat(), 1L);

    public Tables(File location, int keymaxlen) {
        String[] files;
        this.location = new File(location.getAbsolutePath());
        if (!this.location.exists()) {
            this.location.mkdirs();
        }
        this.keymaxlen = keymaxlen;
        this.tables = new ConcurrentHashMap();
        for (String f : files = this.location.list()) {
            File file;
            if (!f.endsWith(suffix) || (file = new File(this.location, f)).length() != 0L) continue;
            file.delete();
        }
        this.cidx = new ConcurrentHashMap();
    }

    public TablesColumnIndex getIndex(String tableName, TablesColumnIndex.INDEXTYPE indexType) throws TableColumnIndexException, IOException {
        TablesColumnIndex index2;
        switch (indexType) {
            case RAM: {
                index2 = new TablesColumnRAMIndex();
                break;
            }
            case BLOB: {
                String idx_table = tableName + CIDX;
                BEncodedHeap bheap = this.getHeap(idx_table);
                index2 = new TablesColumnBLOBIndex(bheap);
                break;
            }
            default: {
                throw new TableColumnIndexException("Unsupported TableColumnIndex: " + indexType.name());
            }
        }
        return index2;
    }

    public TablesColumnIndex getIndex(String tableName) throws TableColumnIndexException {
        TablesColumnIndex index2;
        int size;
        TablesColumnIndex tci = this.cidx.get(tableName);
        if (tci != null) {
            return tci;
        }
        try {
            size = this.size(tableName);
        }
        catch (IOException e) {
            size = 0;
        }
        if (size < 50000) {
            throw new TableColumnIndexException("TableColumnIndex not available for tables with less than 50000 rows: " + tableName);
        }
        if (size < 100000) {
            index2 = new TablesColumnRAMIndex();
        } else {
            BEncodedHeap bheap;
            String idx_table = tableName + CIDX;
            try {
                bheap = this.getHeap(idx_table);
            }
            catch (IOException e) {
                bheap = null;
                ConcurrentLog.logException(e);
            }
            index2 = bheap != null ? new TablesColumnBLOBIndex(bheap) : new TablesColumnRAMIndex();
        }
        this.cidx.put(tableName, index2);
        return index2;
    }

    public boolean hasIndex(String tableName) {
        return this.cidx.containsKey(tableName);
    }

    public boolean hasIndex(String tableName, String columnName) {
        TablesColumnIndex tci = this.cidx.get(tableName);
        if (tci != null) {
            return tci.hasIndex(columnName);
        }
        try {
            if (this.has(tableName + CIDX, Word.word2hash(columnName))) {
                return true;
            }
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        return false;
    }

    public Iterator<Row> getByIndex(String table, String whereColumn, String separator, String whereValue) {
        HashSet<Row> rows = new HashSet<Row>();
        TreeSet<byte[]> set1 = new TreeSet<byte[]>(TablesColumnIndex.NATURALORDER);
        TreeSet<byte[]> set2 = new TreeSet<byte[]>(TablesColumnIndex.NATURALORDER);
        String[] values = whereValue.split(separator);
        if (this.hasIndex(table, whereColumn)) {
            try {
                TablesColumnIndex index2 = this.getIndex(table);
                for (int i = 0; i < values.length; ++i) {
                    Collection<byte[]> b = index2.get(whereColumn, values[i]);
                    if (b == null) continue;
                    Iterator<byte[]> biter = b.iterator();
                    while (biter.hasNext()) {
                        set1.add(biter.next());
                    }
                    if (i == 0) {
                        set2.addAll(set1);
                    } else {
                        set2.retainAll(set1);
                    }
                    set1.clear();
                }
                for (byte[] pk : set2) {
                    rows.add(this.select(table, pk));
                }
            }
            catch (Exception e) {
                ConcurrentLog.logException(e);
                return new HashSet().iterator();
            }
        } else {
            if (!separator.isEmpty()) {
                StringBuilder patternBuilder = new StringBuilder(256);
                patternBuilder.append(p1);
                patternBuilder.append(p2);
                for (String value : values) {
                    patternBuilder.append(Pattern.quote(value));
                    patternBuilder.append('|');
                }
                patternBuilder.deleteCharAt(patternBuilder.length() - 1);
                patternBuilder.append(p3);
                patternBuilder.append(values.length);
                patternBuilder.append('}');
                Pattern p = Pattern.compile(patternBuilder.toString(), 2);
                try {
                    return this.iterator(table, whereColumn, p);
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                    return new HashSet().iterator();
                }
            }
            try {
                return this.iterator(table, whereColumn, UTF8.getBytes(whereValue));
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                return new HashSet().iterator();
            }
        }
        return rows.iterator();
    }

    @Override
    public Iterator<String> iterator() {
        return this.getTablenames().iterator();
    }

    public Set<String> getTablenames() {
        String[] files;
        for (String f : files = this.location.list()) {
            File file;
            if (!f.endsWith(suffix) || (file = new File(this.location, f)).length() == 0L) continue;
            String tablename = f.substring(0, f.length() - suffix.length());
            try {
                this.getHeap(tablename);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        return this.tables.keySet();
    }

    public void close(String tablename) {
        BEncodedHeap heap = this.tables.remove(tablename);
        if (heap == null) {
            return;
        }
        heap.close();
    }

    public synchronized void close() {
        for (BEncodedHeap heap : this.tables.values()) {
            heap.close();
        }
        this.tables.clear();
    }

    public void clear() {
        Set<String> tablenames = this.getTablenames();
        for (String tablename : tablenames) {
            this.clear(tablename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(String tablename) {
        try {
            BEncodedHeap heap = this.getHeap(tablename);
            if (heap != null) {
                File f = heap.getFile();
                heap.clear();
                heap.close();
                FileUtils.deletedelete(f);
                heap = null;
            }
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        finally {
            this.tables.remove(tablename);
        }
    }

    public boolean hasHeap(String tablename) {
        return this.tables.containsKey(tablename);
    }

    public BEncodedHeap getHeap(String tablename) throws IOException {
        String table = tablename + suffix;
        BEncodedHeap heap = this.tables.get(tablename);
        if (heap != null) {
            return heap;
        }
        File heapf = new File(this.location, table);
        heap = new BEncodedHeap(heapf, this.keymaxlen);
        this.tables.put(tablename, heap);
        return heap;
    }

    public int size() {
        return this.tables.size();
    }

    public int size(String table) throws IOException {
        BEncodedHeap heap = this.getHeap(table);
        return heap.size();
    }

    private byte[] ukey(String tablename) throws IOException, SpaceExceededException {
        byte[] pk;
        Row row = this.select(system_table_pkcounter, UTF8.getBytes(tablename));
        if (row == null) {
            row = new Row(UTF8.getBytes(tablename), system_table_pkcounter_counterName, UTF8.getBytes(this.int2key(0)));
            this.update(system_table_pkcounter, row);
        }
        int pki = (pk = (byte[])row.get(system_table_pkcounter_counterName)) == null ? this.size(tablename) : (int)(ByteArray.parseDecimal(pk) + 1L);
        while (this.has(tablename, pk = UTF8.getBytes(this.int2key(pki)))) {
            ++pki;
        }
        return pk;
    }

    private String int2key(int i) {
        StringBuilder sb = new StringBuilder(this.keymaxlen);
        String is = Integer.toString(i);
        for (int j = 0; j < this.keymaxlen - is.length(); ++j) {
            sb.append('0');
        }
        sb.append(is);
        return sb.toString();
    }

    public byte[] insert(String tablename, Map<String, byte[]> map) throws IOException, SpaceExceededException {
        byte[] uk = this.ukey(tablename);
        this.update(tablename, uk, map);
        BEncodedHeap heap = this.getHeap(system_table_pkcounter);
        heap.insert(UTF8.getBytes(tablename), system_table_pkcounter_counterName, uk);
        return uk;
    }

    public void insert(String table, byte[] pk, Map<String, byte[]> map) throws IOException {
        BEncodedHeap heap = this.getHeap(table);
        try {
            heap.insert(pk, map);
        }
        catch (SpaceExceededException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void insert(String table, Row row) throws IOException {
        BEncodedHeap heap = this.getHeap(table);
        try {
            heap.insert(row.pk, row);
        }
        catch (SpaceExceededException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void update(String table, byte[] pk, Map<String, byte[]> map) throws IOException {
        BEncodedHeap heap = this.getHeap(table);
        try {
            heap.update(pk, map);
        }
        catch (SpaceExceededException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void update(String table, Row row) throws IOException {
        BEncodedHeap heap = this.getHeap(table);
        try {
            heap.update(row.pk, row);
        }
        catch (SpaceExceededException e) {
            throw new IOException(e.getMessage());
        }
    }

    public byte[] createRow(String table) throws IOException, SpaceExceededException {
        return this.insert(table, new ConcurrentHashMap<String, byte[]>());
    }

    public Row select(String table, byte[] pk) throws IOException, SpaceExceededException {
        BEncodedHeap heap = this.getHeap(table);
        Map<String, byte[]> b = heap.get(pk);
        if (b != null) {
            return new Row(pk, b);
        }
        return null;
    }

    public void delete(String table, byte[] pk) throws IOException {
        BEncodedHeap heap = this.getHeap(table);
        heap.delete(pk);
    }

    public boolean has(String table, byte[] key) throws IOException {
        BEncodedHeap heap = this.getHeap(table);
        return heap.containsKey((Object)key);
    }

    public Iterator<byte[]> keys(String table) throws IOException {
        BEncodedHeap heap = this.getHeap(table);
        return heap.keys();
    }

    public Iterator<byte[]> keys(String table, boolean up, boolean rotating) throws IOException {
        BEncodedHeap heap = this.getHeap(table);
        return heap.keys(up, rotating);
    }

    public Iterator<Row> iterator(String table) throws IOException {
        return new HeapRowIterator(table);
    }

    public Iterator<Row> iterator(String table, String whereColumn, byte[] whereValue) throws IOException {
        return new HeapRowIterator(table, whereColumn, whereValue);
    }

    public Iterator<Row> iterator(String table, String whereColumn, Pattern wherePattern) throws IOException {
        return new HeapRowIterator(table, whereColumn, wherePattern);
    }

    public Iterator<Row> iterator(String table, Pattern wherePattern) throws IOException {
        return new HeapRowIterator(table, wherePattern);
    }

    public Iterator<Row> iterator(String table, boolean up) throws IOException {
        return new OrderedRowIterator(table, up);
    }

    public Iterator<Row> iterator(String table, String whereColumn, byte[] whereValue, boolean up) throws IOException {
        return new OrderedRowIterator(table, whereColumn, whereValue, up);
    }

    public Iterator<Row> iterator(String table, String whereColumn, Pattern wherePattern, boolean up) throws IOException {
        return new OrderedRowIterator(table, whereColumn, wherePattern, up);
    }

    public Iterator<Row> iterator(String table, Pattern wherePattern, boolean up) throws IOException {
        return new OrderedRowIterator(table, wherePattern, up);
    }

    public static Collection<Row> orderBy(Iterator<Row> rowIterator2, String sortColumn) {
        return Tables.orderByString(rowIterator2, sortColumn, "", SortDirection.ASC);
    }

    public static Collection<Row> orderByInt(Iterator<Row> rowIterator2, String sortColumn, int defaultValue, SortDirection sortDir) {
        Comparator<Row> comparator = Comparator.comparingInt(row -> row.get(sortColumn, defaultValue));
        comparator = Comparator.nullsFirst(comparator.thenComparing(row -> UTF8.String(((Row)row).pk)));
        if (sortDir == SortDirection.DESC) {
            comparator = comparator.reversed();
        }
        return Tables.orderBy(rowIterator2, comparator);
    }

    public static Collection<Row> orderByLong(Iterator<Row> rowIterator2, String sortColumn, long defaultValue, SortDirection sortDir) {
        Comparator<Row> comparator = Comparator.comparingLong(row -> row.get(sortColumn, defaultValue));
        comparator = Comparator.nullsFirst(comparator.thenComparing(row -> UTF8.String(((Row)row).pk)));
        if (sortDir == SortDirection.DESC) {
            comparator = comparator.reversed();
        }
        return Tables.orderBy(rowIterator2, comparator);
    }

    public static Collection<Row> orderByString(Iterator<Row> rowIterator2, String sortColumn, String defaultValue, SortDirection sortDir) {
        Comparator<Row> comparator = Comparator.nullsFirst(Comparator.comparing(row -> row.get(sortColumn, defaultValue)));
        comparator = Comparator.nullsFirst(comparator.thenComparing(row -> UTF8.String(((Row)row).pk)));
        if (sortDir == SortDirection.DESC) {
            comparator = comparator.reversed();
        }
        return Tables.orderBy(rowIterator2, comparator);
    }

    public static Collection<Row> orderByDate(Iterator<Row> rowIterator2, String sortColumn, Date defaultValue, SortDirection sortDir) {
        Comparator<Row> comparator = Comparator.nullsFirst(Comparator.comparing(row -> row.get(sortColumn, defaultValue)));
        comparator = Comparator.nullsFirst(comparator.thenComparing(row -> UTF8.String(((Row)row).pk)));
        if (sortDir == SortDirection.DESC) {
            comparator = comparator.reversed();
        }
        return Tables.orderBy(rowIterator2, comparator);
    }

    public static Collection<Row> orderBy(Iterator<Row> rowIterator2, Comparator<Row> comparator) {
        TreeSet<Row> sortTree = new TreeSet<Row>(comparator);
        while (rowIterator2.hasNext()) {
            sortTree.add(rowIterator2.next());
        }
        return sortTree;
    }

    public ArrayList<String> columns(String table) throws IOException {
        BEncodedHeap heap = this.getHeap(table);
        return heap.columns();
    }

    public static void main(String[] args) {
        File f = new File(new File("maptest").getAbsolutePath());
        try {
            Tables map = new Tables(f.getParentFile(), 4);
            HashMap<String, byte[]> m = new HashMap<String, byte[]>();
            m.put("k", "000".getBytes());
            map.update("testdao", "123".getBytes(), m);
            m.put("k", "111".getBytes());
            map.update("testdao", "456".getBytes(), m);
            m.put("k", "222".getBytes());
            map.update("testdao", "789".getBytes(), m);
            Iterator<Row> i = map.iterator("testdao");
            while (i.hasNext()) {
                System.out.println(i.next().toString());
            }
            map.close();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
    }

    public class Row
    extends Data {
        private static final long serialVersionUID = 978426054043749338L;
        private final byte[] pk;

        private Row(Map.Entry<byte[], Map<String, byte[]>> entry2) {
            super(entry2.getValue());
            assert (entry2 != null);
            assert (entry2.getKey() != null);
            assert (entry2.getValue() != null);
            this.pk = entry2.getKey();
        }

        private Row(byte[] pk, Map<String, byte[]> map) {
            super(map);
            assert (pk != null);
            assert (map != null);
            this.pk = pk;
        }

        private Row(byte[] pk, String k0, byte[] v0) {
            assert (k0 != null);
            assert (v0 != null);
            this.put(k0, v0);
            this.pk = pk;
        }

        public byte[] getPK() {
            return this.pk;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(Tables.this.keymaxlen + 20 * this.size());
            sb.append(UTF8.String(this.pk)).append(":").append(super.toString());
            return sb.toString();
        }
    }

    public static class Data
    extends LinkedHashMap<String, byte[]> {
        private static final long serialVersionUID = 978426054043749337L;

        public Data() {
        }

        private Data(Map<String, byte[]> map) {
            assert (map != null);
            this.putAll(map);
        }

        @Override
        public void put(String colname, String value) {
            super.put(colname, UTF8.getBytes(value));
        }

        @Override
        public void put(String colname, int value) {
            super.put(colname, ASCII.getBytes(Integer.toString(value)));
        }

        @Override
        public void put(String colname, long value) {
            super.put(colname, ASCII.getBytes(Long.toString(value)));
        }

        @Override
        public void put(String colname, Date value) {
            super.put(colname, UTF8.getBytes(my_SHORT_MILSEC_FORMATTER.format(value)));
        }

        public byte[] get(String colname, byte[] dflt) {
            byte[] r = (byte[])this.get(colname);
            if (r == null) {
                return dflt;
            }
            return r;
        }

        public String get(String colname, String dflt) {
            byte[] r = (byte[])this.get(colname);
            if (r == null) {
                return dflt;
            }
            return UTF8.String(r);
        }

        public int get(String colname, int dflt) {
            byte[] r = (byte[])this.get(colname);
            if (r == null) {
                return dflt;
            }
            try {
                return (int)ByteArray.parseDecimal(r);
            }
            catch (NumberFormatException e) {
                return dflt;
            }
        }

        public long get(String colname, long dflt) {
            byte[] r = (byte[])this.get(colname);
            if (r == null) {
                return dflt;
            }
            try {
                return ByteArray.parseDecimal(r);
            }
            catch (NumberFormatException e) {
                return dflt;
            }
        }

        public Date get(String colname, Date dflt) {
            byte[] r = (byte[])this.get(colname);
            if (r == null) {
                return dflt;
            }
            try {
                return my_SHORT_MILSEC_FORMATTER.parse(UTF8.String(r), 0).getTime();
            }
            catch (ParseException e) {
                return dflt;
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.size() * 40);
            sb.append('{');
            for (Map.Entry entry2 : this.entrySet()) {
                sb.append((String)entry2.getKey()).append('=').append(UTF8.String((byte[])entry2.getValue())).append(", ");
            }
            if (sb.length() > 1) {
                sb.setLength(sb.length() - 2);
            }
            sb.append('}');
            return sb.toString();
        }
    }

    public class OrderedRowIterator
    extends LookAheadIterator<Row>
    implements Iterator<Row> {
        private final String whereColumn;
        private final byte[] whereValue;
        private final Pattern wherePattern;
        private final Iterator<byte[]> i;
        private final BEncodedHeap heap;

        public OrderedRowIterator(String table, boolean up) throws IOException {
            this.whereColumn = null;
            this.whereValue = null;
            this.wherePattern = null;
            this.heap = Tables.this.getHeap(table);
            this.i = this.heap.keys(up, false);
        }

        public OrderedRowIterator(String table, String whereColumn, byte[] whereValue, boolean up) throws IOException {
            assert (whereColumn != null || whereValue == null);
            this.whereColumn = whereColumn;
            this.whereValue = whereValue;
            this.wherePattern = null;
            this.heap = Tables.this.getHeap(table);
            this.i = this.heap.keys(up, false);
        }

        public OrderedRowIterator(String table, String whereColumn, Pattern wherePattern, boolean up) throws IOException {
            this.whereColumn = whereColumn;
            this.whereValue = null;
            this.wherePattern = wherePattern == null || wherePattern.toString().isEmpty() ? null : wherePattern;
            this.heap = Tables.this.getHeap(table);
            this.i = this.heap.keys(up, false);
        }

        public OrderedRowIterator(String table, Pattern wherePattern, boolean up) throws IOException {
            this.whereColumn = null;
            this.whereValue = null;
            this.wherePattern = wherePattern == null || wherePattern.toString().isEmpty() ? null : wherePattern;
            this.heap = Tables.this.getHeap(table);
            this.i = this.heap.keys(up, false);
        }

        @Override
        protected Row next0() {
            if (this.i == null) {
                return null;
            }
            while (this.i.hasNext()) {
                byte[] pk = this.i.next();
                try {
                    Map<String, byte[]> map = this.heap.get(pk);
                    if (map == null) continue;
                    Row r = new Row(pk, map);
                    if (this.whereValue != null) {
                        if (!Arrays.equals((byte[])r.get(this.whereColumn), this.whereValue)) continue;
                        return r;
                    }
                    if (this.wherePattern != null) {
                        if (this.whereColumn == null) {
                            for (byte[] b : r.values()) {
                                if (!this.wherePattern.matcher(UTF8.String(b)).matches()) continue;
                                return r;
                            }
                            continue;
                        }
                        if (!this.wherePattern.matcher(UTF8.String((byte[])r.get(this.whereColumn))).matches()) continue;
                        return r;
                    }
                    return r;
                }
                catch (IOException | SpaceExceededException e) {
                }
            }
            return null;
        }
    }

    public class HeapRowIterator
    extends LookAheadIterator<Row>
    implements Iterator<Row> {
        private final String whereColumn;
        private final byte[] whereValue;
        private final Pattern wherePattern;
        private final Iterator<Map.Entry<byte[], Map<String, byte[]>>> i;

        public HeapRowIterator(String table) throws IOException {
            this.whereColumn = null;
            this.whereValue = null;
            this.wherePattern = null;
            BEncodedHeap heap = Tables.this.getHeap(table);
            this.i = heap.iterator();
        }

        public HeapRowIterator(String table, String whereColumn, byte[] whereValue) throws IOException {
            assert (whereColumn != null || whereValue == null);
            this.whereColumn = whereColumn;
            this.whereValue = whereValue;
            this.wherePattern = null;
            BEncodedHeap heap = Tables.this.getHeap(table);
            this.i = heap.iterator();
        }

        public HeapRowIterator(String table, String whereColumn, Pattern wherePattern) throws IOException {
            this.whereColumn = whereColumn;
            this.whereValue = null;
            this.wherePattern = wherePattern == null || wherePattern.toString().isEmpty() ? null : wherePattern;
            BEncodedHeap heap = Tables.this.getHeap(table);
            this.i = heap.iterator();
        }

        public HeapRowIterator(String table, Pattern pattern) throws IOException {
            this.whereColumn = null;
            this.whereValue = null;
            this.wherePattern = pattern == null || pattern.toString().isEmpty() ? null : pattern;
            BEncodedHeap heap = Tables.this.getHeap(table);
            this.i = heap.iterator();
        }

        @Override
        protected Row next0() {
            if (this.i == null) {
                return null;
            }
            while (this.i.hasNext()) {
                Row r = new Row(this.i.next());
                if (this.whereValue != null) {
                    if (!Arrays.equals((byte[])r.get(this.whereColumn), this.whereValue)) continue;
                    return r;
                }
                if (this.wherePattern != null) {
                    if (this.whereColumn == null) {
                        for (byte[] b : r.values()) {
                            if (!this.wherePattern.matcher(UTF8.String(b)).matches()) continue;
                            return r;
                        }
                        continue;
                    }
                    if (!this.wherePattern.matcher(UTF8.String((byte[])r.get(this.whereColumn))).matches()) continue;
                    return r;
                }
                return r;
            }
            return null;
        }
    }

    public static enum SortDirection {
        ASC,
        DESC;

    }
}

