/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.blob;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.order.Digest;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.storage.HandleMap;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.LookAheadIterator;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.Gap;
import net.yacy.kelondro.blob.HeapWriter;
import net.yacy.kelondro.index.RowHandleMap;
import net.yacy.kelondro.io.CachedFileWriter;
import net.yacy.kelondro.io.Writer;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.kelondro.util.RotateIterator;

public class HeapReader {
    private static final ConcurrentLog log = new ConcurrentLog("HeapReader");
    protected int keylength;
    protected File heapFile;
    protected final ByteOrder ordering;
    protected Writer file;
    protected HandleMap index;
    protected Gap free;
    private File fingerprintFileIdx;
    private File fingerprintFileGap;
    private Date closeDate;
    private static final byte zero = 0;

    public HeapReader(File heapFile, int keylength, ByteOrder ordering) throws IOException {
        this.ordering = ordering;
        this.heapFile = heapFile;
        this.keylength = keylength;
        this.index = null;
        this.free = null;
        this.heapFile.getParentFile().mkdirs();
        this.file = new CachedFileWriter(this.heapFile);
        this.closeDate = null;
        this.fingerprintFileIdx = null;
        this.fingerprintFileGap = null;
        if (this.initIndexReadDump()) {
            CloneableIterator<byte[]> i = this.index.keys(true, null);
            int c = 3;
            byte[] b1 = new byte[this.keylength];
            boolean ok = true;
            while (i.hasNext() && c-- > 0) {
                byte[] b = (byte[])i.next();
                long pos = this.index.get(b);
                this.file.seek(pos + 4L);
                this.file.readFully(b1, 0, b1.length);
                if (this.ordering.equal(b, b1)) continue;
                ok = false;
                break;
            }
            if (!ok) {
                log.warn("verification of idx file for " + heapFile.toString() + " failed, re-building index");
                this.initIndexReadFromHeap();
            } else {
                log.info("using a dump of the index of " + heapFile.toString() + ".");
            }
        } else {
            this.initIndexReadFromHeap();
        }
        this.mergeFreeEntries();
        this.file.close();
    }

    public long mem() {
        return this.index.mem();
    }

    public void optimize() {
        this.index.optimize();
    }

    protected byte[] normalizeKey(byte[] key) {
        assert (key.length >= this.keylength || this.ordering instanceof NaturalOrder);
        return HeapReader.normalizeKey(key, this.keylength);
    }

    protected static byte[] normalizeKey(byte[] key, int keylength) {
        if (key.length == keylength) {
            return key;
        }
        byte[] k = new byte[keylength];
        if (key.length < keylength) {
            System.arraycopy(key, 0, k, 0, key.length);
            for (int i = key.length; i < keylength; ++i) {
                k[i] = 0;
            }
        } else {
            System.arraycopy(key, 0, k, 0, keylength);
        }
        return k;
    }

    private boolean initIndexReadDump() {
        String fingerprint = HeapReader.fingerprintFileHash(this.heapFile);
        if (fingerprint == null) {
            log.severe("cannot generate a fingerprint for " + this.heapFile + ": null");
            return false;
        }
        this.fingerprintFileIdx = HeapWriter.fingerprintIndexFile(this.heapFile, fingerprint);
        if (!this.fingerprintFileIdx.exists()) {
            this.fingerprintFileIdx = new File(this.fingerprintFileIdx.getAbsolutePath() + ".gz");
        }
        this.fingerprintFileGap = HeapWriter.fingerprintGapFile(this.heapFile, fingerprint);
        if (!this.fingerprintFileGap.exists()) {
            this.fingerprintFileGap = new File(this.fingerprintFileGap.getAbsolutePath() + ".gz");
        }
        if (!this.fingerprintFileIdx.exists() || !this.fingerprintFileGap.exists()) {
            HeapReader.deleteAllFingerprints(this.heapFile, this.fingerprintFileIdx.getName(), this.fingerprintFileGap.getName());
            return false;
        }
        try {
            this.index = new RowHandleMap(this.keylength, this.ordering, 8, this.fingerprintFileIdx);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            return false;
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
            return false;
        }
        if (this.index instanceof RowHandleMap) {
            int[] saturation = ((RowHandleMap)this.index).saturation();
            log.info("saturation of " + this.fingerprintFileIdx.getName() + ": keylength = " + saturation[0] + ", vallength = " + saturation[1] + ", size = " + this.index.size() + ", maximum saving for index-compression = " + saturation[0] * this.index.size() / 1024 / 1024 + " MB, exact saving for value-compression = " + saturation[1] * this.index.size() / 1024 / 1024 + " MB");
        }
        try {
            this.free = new Gap(this.fingerprintFileGap);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            return false;
        }
        return !this.index.isEmpty();
    }

    public void deleteFingerprint() {
        if (this.fingerprintFileIdx != null) {
            FileUtils.deletedelete(this.fingerprintFileIdx);
            this.fingerprintFileIdx = null;
        }
        if (this.fingerprintFileGap != null) {
            FileUtils.deletedelete(this.fingerprintFileGap);
            this.fingerprintFileGap = null;
        }
    }

    protected static String fingerprintFileHash(File f) {
        assert (f != null);
        assert (f.exists()) : "file = " + f.toString();
        String fp = Digest.fastFingerprintB64(f, false);
        assert (fp != null) : "file = " + f.toString();
        if (fp == null) {
            return null;
        }
        return fp.substring(0, 12);
    }

    private static void deleteAllFingerprints(File f, String exception1, String exception2) {
        File d = f.getParentFile();
        String n = f.getName();
        String[] l = d.list();
        for (int i = 0; i < l.length; ++i) {
            if (!l[i].startsWith(n) || exception1 != null && l[i].equals(exception1) || exception2 != null && l[i].equals(exception2) || !l[i].endsWith(".idx") && !l[i].endsWith(".gap") && !l[i].endsWith(".idx.gz") && !l[i].endsWith(".gap.gz")) continue;
            FileUtils.deletedelete(new File(d, l[i]));
        }
    }

    private void initIndexReadFromHeap() throws IOException {
        log.info("generating index for " + this.heapFile.toString() + ", " + this.file.length() / 1024L / 1024L + " MB. Please wait.");
        this.free = new Gap();
        RowHandleMap.initDataConsumer indexready = RowHandleMap.asynchronusInitializer(this.name() + ".initializer", this.keylength, this.ordering, 8, Math.max(10, (int)(Runtime.getRuntime().freeMemory() / 0xA00000L)));
        byte[] key = new byte[this.keylength];
        long seek = 0L;
        if (this.file.length() > 0L) {
            while (true) {
                int reclen;
                try {
                    this.file.seek(seek);
                    reclen = this.file.readInt();
                    if (reclen == 0) {
                        log.severe("reclen == 0 at seek pos " + seek + " in file " + this.heapFile);
                        this.file.setLength(seek);
                        break;
                    }
                    this.file.readFully(key, 0, key.length);
                }
                catch (IOException e) {
                    break;
                }
                if (key == null || key[0] == 0) {
                    if (reclen > 0) {
                        this.free.put(seek, reclen);
                    }
                } else if (this.ordering.wellformed(key)) {
                    indexready.consume(key, seek);
                    key = new byte[this.keylength];
                } else {
                    this.free.put(seek, reclen);
                    this.file.seek(seek + 4L);
                    Arrays.fill(key, (byte)0);
                    this.file.write(key);
                    log.warn("BLOB " + this.heapFile.getName() + ": skiped not wellformed key " + UTF8.String(key) + " at seek pos " + seek);
                }
                seek += 4L + (long)reclen;
            }
        }
        indexready.finish();
        try {
            this.index = indexready.result();
        }
        catch (InterruptedException e) {
            ConcurrentLog.logException(e);
        }
        catch (ExecutionException e) {
            ConcurrentLog.logException(e);
        }
        log.info("finished index generation for " + this.heapFile.toString() + ", " + this.index.size() + " entries, " + this.free.size() + " gaps.");
    }

    private void mergeFreeEntries() throws IOException {
        if (this.free.size() > 1) {
            int merged = 0;
            Iterator i = this.free.entrySet().iterator();
            Map.Entry lastFree = i.next();
            while (i.hasNext()) {
                Map.Entry nextFree = i.next();
                if ((Long)lastFree.getKey() + (long)((Integer)lastFree.getValue()).intValue() + 4L == (Long)nextFree.getKey()) {
                    this.file.seek((Long)lastFree.getKey());
                    lastFree.setValue((Integer)lastFree.getValue() + (Integer)nextFree.getValue() + 4);
                    this.file.writeInt((Integer)lastFree.getValue());
                    this.file.seek((Long)nextFree.getKey());
                    this.file.writeInt(0);
                    i.remove();
                    ++merged;
                    continue;
                }
                lastFree = nextFree;
            }
            log.info("BLOB " + this.heapFile.toString() + ": merged " + merged + " free records");
            if (merged > 0) {
                this.deleteFingerprint();
            }
        }
    }

    public String name() {
        return this.heapFile.toString();
    }

    public File location() {
        return this.heapFile;
    }

    public int size() {
        assert (this.index != null) : "index == null; closeDate=" + this.closeDate + ", now=" + new Date();
        if (this.index == null) {
            log.severe("this.index == null in size(); closeDate=" + this.closeDate + ", now=" + new Date() + this.heapFile == null ? "" : " file = " + this.heapFile.toString());
            return 0;
        }
        return this.index == null ? 0 : this.index.size();
    }

    public boolean isEmpty() {
        assert (this.index != null) : "index == null; closeDate=" + this.closeDate + ", now=" + new Date();
        if (this.index == null) {
            log.severe("this.index == null in isEmpty(); closeDate=" + this.closeDate + ", now=" + new Date() + this.heapFile == null ? "" : " file = " + this.heapFile.toString());
            return true;
        }
        return this.index.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(byte[] key) {
        assert (this.index != null) : "index == null; closeDate=" + this.closeDate + ", now=" + new Date();
        if (this.index == null) {
            log.severe("this.index == null in containsKey(); closeDate=" + this.closeDate + ", now=" + new Date() + this.heapFile == null ? "" : " file = " + this.heapFile.toString());
            return false;
        }
        key = this.normalizeKey(key);
        HandleMap handleMap = this.index;
        synchronized (handleMap) {
            return this.index.get(key) >= 0L;
        }
    }

    public ByteOrder ordering() {
        return this.ordering;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized byte[] firstKey() throws IOException {
        assert (this.index != null) : "index == null; closeDate=" + this.closeDate + ", now=" + new Date();
        if (this.index == null) {
            log.severe("this.index == null in firstKey(); closeDate=" + this.closeDate + ", now=" + new Date() + this.heapFile == null ? "" : " file = " + this.heapFile.toString());
            return null;
        }
        HandleMap handleMap = this.index;
        synchronized (handleMap) {
            return this.index.smallestKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] first() throws IOException, SpaceExceededException {
        assert (this.index != null) : "index == null; closeDate=" + this.closeDate + ", now=" + new Date();
        if (this.index == null) {
            log.severe("this.index == null in first(); closeDate=" + this.closeDate + ", now=" + new Date() + this.heapFile == null ? "" : " file = " + this.heapFile.toString());
            return null;
        }
        HandleMap handleMap = this.index;
        synchronized (handleMap) {
            byte[] key = this.index.smallestKey();
            if (key == null) {
                return null;
            }
            return this.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] lastKey() throws IOException {
        assert (this.index != null) : "index == null; closeDate=" + this.closeDate + ", now=" + new Date();
        if (this.index == null) {
            log.severe("this.index == null in lastKey(); closeDate=" + this.closeDate + ", now=" + new Date() + this.heapFile == null ? "" : " file = " + this.heapFile.toString());
            return null;
        }
        if (this.index == null) {
            return null;
        }
        HandleMap handleMap = this.index;
        synchronized (handleMap) {
            return this.index.largestKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] last() throws IOException, SpaceExceededException {
        assert (this.index != null) : "index == null; closeDate=" + this.closeDate + ", now=" + new Date();
        if (this.index == null) {
            log.severe("this.index == null in last(); closeDate=" + this.closeDate + ", now=" + new Date() + this.heapFile == null ? "" : " file = " + this.heapFile.toString());
            return null;
        }
        HandleMap handleMap = this.index;
        synchronized (handleMap) {
            byte[] key = this.index.largestKey();
            if (key == null) {
                return null;
            }
            return this.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(byte[] key) throws IOException, SpaceExceededException {
        assert (this.index != null) : "index == null; closeDate=" + this.closeDate + ", now=" + new Date();
        if (this.index == null) {
            log.severe("this.index == null in get(); closeDate=" + this.closeDate + ", now=" + new Date() + this.heapFile == null ? "" : " file = " + this.heapFile.toString());
            return null;
        }
        key = this.normalizeKey(key);
        HandleMap handleMap = this.index;
        synchronized (handleMap) {
            byte[] blob;
            byte[] keyf;
            long pos = this.index.get(key);
            if (pos < 0L) {
                return null;
            }
            this.file.seek(pos);
            int len = this.file.readInt() - this.keylength;
            if (len < 0) {
                log.severe("file " + this.file.file() + " corrupted at " + pos + ": negative len. len = " + len + ", pk.len = " + this.keylength);
                this.index.remove(key);
                return null;
            }
            long memr = len + this.keylength + 64;
            if (MemoryControl.available() < memr && !MemoryControl.request(memr, true)) {
                throw new SpaceExceededException(memr, "HeapReader.get()/check");
            }
            try {
                keyf = new byte[this.keylength];
            }
            catch (OutOfMemoryError e) {
                throw new SpaceExceededException(this.keylength, "HeapReader.get()/keyf");
            }
            this.file.readFully(keyf, 0, keyf.length);
            if (!this.ordering.equal(key, keyf)) {
                log.severe("indexed verification access failed for " + this.heapFile.toString());
                this.index.remove(key);
                return null;
            }
            try {
                blob = new byte[len];
            }
            catch (OutOfMemoryError e) {
                MemoryControl.gc(1000, "HeapReader.get()/blob");
                try {
                    blob = new byte[len];
                }
                catch (OutOfMemoryError ee) {
                    throw new SpaceExceededException(len, "HeapReader.get()/blob");
                }
            }
            this.file.readFully(blob, 0, blob.length);
            return blob;
        }
    }

    public byte[] get(Object key) {
        if (!(key instanceof byte[])) {
            return null;
        }
        try {
            return this.get((byte[])key);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
        }
        return null;
    }

    protected boolean checkKey(byte[] key, long pos) throws IOException {
        key = this.normalizeKey(key);
        this.file.seek(pos);
        this.file.readInt();
        byte[] keyf = new byte[this.keylength];
        this.file.readFully(keyf, 0, keyf.length);
        return this.ordering.equal(key, keyf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length(byte[] key) throws IOException {
        assert (this.index != null) : "index == null; closeDate=" + this.closeDate + ", now=" + new Date();
        if (this.index == null) {
            log.severe("this.index == null in length(); closeDate=" + this.closeDate + ", now=" + new Date() + this.heapFile == null ? "" : " file = " + this.heapFile.toString());
            return 0L;
        }
        key = this.normalizeKey(key);
        HandleMap handleMap = this.index;
        synchronized (handleMap) {
            long pos = this.index.get(key);
            if (pos < 0L) {
                return -1L;
            }
            this.file.seek(pos);
            return this.file.readInt() - this.keylength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean writeIDX) {
        if (this.index == null) {
            return;
        }
        HandleMap handleMap = this.index;
        synchronized (handleMap) {
            try {
                if (this.file != null) {
                    try {
                        this.file.close();
                    }
                    catch (IOException e) {
                        ConcurrentLog.logException(e);
                    }
                }
                this.file = null;
                if (writeIDX && this.index != null && this.free != null && (this.index.size() > 3 || this.free.size() > 3)) {
                    try {
                        long start;
                        String fingerprint = HeapReader.fingerprintFileHash(this.heapFile);
                        if (fingerprint == null) {
                            log.severe("cannot write a dump for " + this.heapFile.getName() + ": fingerprint is null");
                        } else {
                            File newFingerprintFileGap = HeapWriter.fingerprintGapFile(this.heapFile, fingerprint);
                            if (this.fingerprintFileGap != null && this.fingerprintFileGap.getName().equals(newFingerprintFileGap.getName()) && this.fingerprintFileGap.exists()) {
                                log.info("using existing gap dump instead of writing a new one: " + this.fingerprintFileGap.getName());
                            } else {
                                start = System.currentTimeMillis();
                                this.free.dump(newFingerprintFileGap);
                                log.info("wrote a dump for the " + this.free.size() + " gap entries of " + this.heapFile.getName() + " in " + (System.currentTimeMillis() - start) + " milliseconds.");
                            }
                        }
                        this.free.clear();
                        this.free = null;
                        if (fingerprint != null) {
                            File newFingerprintFileIdx = HeapWriter.fingerprintIndexFile(this.heapFile, fingerprint);
                            if (this.fingerprintFileIdx != null && this.fingerprintFileIdx.getName().equals(newFingerprintFileIdx.getName()) && this.fingerprintFileIdx.exists()) {
                                log.info("using existing idx dump instead of writing a new one: " + this.fingerprintFileIdx.getName());
                            } else {
                                start = System.currentTimeMillis();
                                this.index.dump(newFingerprintFileIdx);
                                log.info("wrote a dump for the " + this.index.size() + " index entries of " + this.heapFile.getName() + " in " + (System.currentTimeMillis() - start) + " milliseconds.");
                            }
                        }
                        this.index.close();
                        this.index = null;
                    }
                    catch (IOException e) {
                        ConcurrentLog.logException(e);
                    }
                }
                if (this.free != null) {
                    this.free.clear();
                }
                this.free = null;
                if (this.index != null) {
                    this.index.close();
                }
                this.index = null;
                this.closeDate = new Date();
            }
            catch (Throwable e) {
                ConcurrentLog.logException(e);
            }
            log.info("close HeapFile " + this.heapFile.getName() + "; trace: " + ConcurrentLog.stackTrace());
        }
    }

    public synchronized void close() {
        this.close(true);
    }

    public int keylength() {
        return this.keylength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloneableIterator<byte[]> keys(boolean up, boolean rotating) throws IOException {
        if (this.index == null) {
            log.severe("this.index == null in keys(); closeDate=" + this.closeDate + ", now=" + new Date() + this.heapFile == null ? "" : " file = " + this.heapFile.toString());
            return null;
        }
        HandleMap handleMap = this.index;
        synchronized (handleMap) {
            return new RotateIterator<byte[]>(this.index.keys(up, null), null, this.index.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloneableIterator<byte[]> keys(boolean up, byte[] firstKey) throws IOException {
        assert (this.index != null) : "index == null; closeDate=" + this.closeDate + ", now=" + new Date();
        if (this.index == null) {
            log.severe("this.index == null in keys(); closeDate=" + this.closeDate + ", now=" + new Date() + this.heapFile == null ? "" : " file = " + this.heapFile.toString());
            return null;
        }
        HandleMap handleMap = this.index;
        synchronized (handleMap) {
            return this.index.keys(up, firstKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() {
        assert (this.index != null) : "index == null; closeDate=" + this.closeDate + ", now=" + new Date();
        if (this.index == null) {
            log.severe("this.index == null in length(); closeDate=" + this.closeDate + ", now=" + new Date() + this.heapFile == null ? "" : " file = " + this.heapFile.toString());
            return 0L;
        }
        HandleMap handleMap = this.index;
        synchronized (handleMap) {
            return this.heapFile.length();
        }
    }

    public static void main(String[] args) {
        File f = new File(args[0]);
        try {
            entries hr = new entries(f, 12);
            while (hr.hasNext()) {
                Map.Entry entry2 = (Map.Entry)hr.next();
                System.out.println(ASCII.String((byte[])entry2.getKey()) + ":" + UTF8.String((byte[])entry2.getValue()));
            }
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
    }

    public static class entry
    implements Map.Entry<byte[], byte[]> {
        private final byte[] s;
        private byte[] b;

        public entry(byte[] s, byte[] b) {
            this.s = s;
            this.b = b;
        }

        @Override
        public byte[] getKey() {
            return this.s;
        }

        @Override
        public byte[] getValue() {
            return this.b;
        }

        @Override
        public byte[] setValue(byte[] value) {
            byte[] b1 = this.b;
            this.b = value;
            return b1;
        }
    }

    public static class entries
    extends LookAheadIterator<Map.Entry<byte[], byte[]>>
    implements CloneableIterator<Map.Entry<byte[], byte[]>>,
    Iterator<Map.Entry<byte[], byte[]>>,
    Iterable<Map.Entry<byte[], byte[]>> {
        private DataInputStream is;
        int keylen;
        private final File blobFile;

        public entries(File blobFile, int keylen) throws IOException {
            if (!blobFile.exists()) {
                throw new IOException("file " + blobFile + " does not exist");
            }
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(blobFile);
                this.is = new DataInputStream(new BufferedInputStream(fis, 262144));
            }
            catch (OutOfMemoryError e) {
                this.is = fis != null ? new DataInputStream(fis) : new DataInputStream(new FileInputStream(blobFile));
            }
            this.keylen = keylen;
            this.blobFile = blobFile;
        }

        @Override
        public CloneableIterator<Map.Entry<byte[], byte[]>> clone(Object modifier) {
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.is = null;
            try {
                return new entries(this.blobFile, this.keylen);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                return null;
            }
        }

        @Override
        public Map.Entry<byte[], byte[]> next0() {
            if (this.is == null) {
                return null;
            }
            try {
                byte b;
                int len;
                int keylen1;
                block20: {
                    keylen1 = this.keylen - 1;
                    while (true) {
                        if ((len = this.is.readInt()) == 0) {
                            continue;
                        }
                        b = this.is.readByte();
                        if (b != 0) break block20;
                        if (len > 1 && len - 1 != this.is.skipBytes(len - 1)) break;
                    }
                    log.warn("problem skiping " + len + " bytes in " + this.blobFile.getName());
                    try {
                        this.is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return null;
                }
                byte[] key = new byte[this.keylen];
                key[0] = b;
                if (this.is.read(key, 1, keylen1) < keylen1) {
                    try {
                        this.is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return null;
                }
                if (len < this.keylen) {
                    try {
                        this.is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return null;
                }
                try {
                    byte[] payload = new byte[len - this.keylen];
                    if (this.is.read(payload) < payload.length) {
                        try {
                            this.is.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return null;
                    }
                    return new entry(key, payload);
                }
                catch (OutOfMemoryError ee) {
                    log.severe("out of memory in LookAheadIterator.next0", ee);
                    try {
                        this.is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return null;
                }
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public synchronized void close() {
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
            this.is = null;
        }
    }
}

