/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.blob;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.BLOB;
import net.yacy.kelondro.blob.HeapModifier;
import net.yacy.kelondro.blob.HeapWriter;
import net.yacy.kelondro.blob.MapHeap;
import net.yacy.kelondro.io.AbstractWriter;
import net.yacy.kelondro.util.MemoryControl;

public final class Heap
extends HeapModifier
implements BLOB {
    private SortedMap<byte[], byte[]> buffer;
    private int buffersize;
    private final int buffermax;

    public Heap(File heapFile, int keylength, ByteOrder ordering, int buffermax) throws IOException {
        super(heapFile, keylength, ordering);
        this.buffermax = buffermax;
        this.buffer = new TreeMap<byte[], byte[]>(ordering);
        this.buffersize = 0;
        ConcurrentLog.info("Heap", "initializing heap " + this.name());
    }

    @Override
    public int size() {
        return super.size() + (this.buffer == null ? 0 : this.buffer.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(byte[] key) {
        if (this.index == null) {
            return false;
        }
        key = this.normalizeKey(key);
        Heap heap = this;
        synchronized (heap) {
            assert (this.buffer != null);
            if (this.buffer != null && this.buffer.containsKey(key)) {
                return true;
            }
            return super.containsKey(key);
        }
    }

    private void add(byte[] key, byte[] blob) throws IOException {
        assert (blob.length > 0);
        if (blob == null || blob.length == 0) {
            return;
        }
        int pos = (int)this.file.length();
        try {
            this.index.put(key, pos);
            this.file.seek(pos);
            this.file.writeInt(this.keylength + blob.length);
            this.file.write(key);
            this.file.write(blob, 0, blob.length);
        }
        catch (SpaceExceededException e) {
            throw new IOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBuffer() throws IOException {
        long pos;
        if (this.buffer == null) {
            return;
        }
        Iterator<Map.Entry<byte[], byte[]>> i = this.buffer.entrySet().iterator();
        int l = 0;
        while (i.hasNext()) {
            l += i.next().getValue().length;
        }
        assert (l == this.buffersize);
        int posBuffer = 0;
        Heap heap = this;
        synchronized (heap) {
            super.deleteFingerprint();
        }
        i = this.buffer.entrySet().iterator();
        long posFile = pos = this.file.length();
        posBuffer = 0;
        byte[] ba = new byte[l + (4 + this.keylength) * this.buffer.size()];
        TreeMap<byte[], byte[]> nextBuffer = new TreeMap<byte[], byte[]>(this.ordering);
        while (i.hasNext()) {
            Map.Entry<byte[], byte[]> entry2 = i.next();
            byte[] key = this.normalizeKey(entry2.getKey());
            byte[] blob = entry2.getValue();
            try {
                this.index.put(key, posFile);
            }
            catch (SpaceExceededException e) {
                nextBuffer.put(entry2.getKey(), blob);
                continue;
            }
            byte[] b = AbstractWriter.int2array(this.keylength + blob.length);
            assert (b.length == 4);
            assert (posBuffer + 4 < ba.length) : "posBuffer = " + posBuffer + ", ba.length = " + ba.length;
            System.arraycopy(b, 0, ba, posBuffer, 4);
            assert (posBuffer + 4 + key.length <= ba.length) : "posBuffer = " + posBuffer + ", key.length = " + key.length + ", ba.length = " + ba.length;
            System.arraycopy(key, 0, ba, posBuffer + 4, key.length);
            assert (posBuffer + 4 + key.length + blob.length <= ba.length) : "posBuffer = " + posBuffer + ", key.length = " + key.length + ", blob.length = " + blob.length + ", ba.length = " + ba.length;
            System.arraycopy(blob, 0, ba, posBuffer + 4 + this.keylength, blob.length);
            posFile += (long)(4 + this.keylength + blob.length);
            posBuffer += 4 + this.keylength + blob.length;
        }
        assert (ba.length == posBuffer);
        this.file.seek(pos);
        this.file.write(ba);
        this.buffer.clear();
        this.buffer.putAll(nextBuffer);
        this.buffersize = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(byte[] key) throws IOException, SpaceExceededException {
        key = this.normalizeKey(key);
        Heap heap = this;
        synchronized (heap) {
            byte[] blob;
            if (this.buffer != null && (blob = (byte[])this.buffer.get(key)) != null) {
                return blob;
            }
            return super.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length(byte[] key) throws IOException {
        key = this.normalizeKey(key);
        Heap heap = this;
        synchronized (heap) {
            byte[] blob;
            if (this.buffer != null && (blob = (byte[])this.buffer.get(key)) != null) {
                return blob.length;
            }
            return super.length(key);
        }
    }

    @Override
    public synchronized void clear() throws IOException {
        ConcurrentLog.info("Heap", "clearing heap " + this.name());
        assert (this.buffer != null);
        if (this.buffer == null) {
            this.buffer = new TreeMap<byte[], byte[]>(this.ordering);
        }
        this.buffer.clear();
        this.buffersize = 0;
        super.clear();
    }

    @Override
    public synchronized void close(boolean writeIDX) {
        ConcurrentLog.info("Heap", "closing heap " + this.name());
        if (this.file != null && this.buffer != null) {
            try {
                this.flushBuffer();
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        this.buffer = null;
        super.close(writeIDX);
        assert (this.file == null);
    }

    @Override
    public synchronized void close() {
        this.close(true);
    }

    public int getBuffermax() {
        return this.buffermax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(byte[] key, byte[] b) throws IOException {
        key = this.normalizeKey(key);
        if (b.length == 0) {
            return;
        }
        Heap heap = this;
        synchronized (heap) {
            this.delete(key);
            try {
                if (this.putToGap(key, b)) {
                    return;
                }
            }
            catch (SpaceExceededException spaceExceededException) {
                // empty catch block
            }
            assert (this.buffer != null);
            if (this.buffersize + b.length > this.buffermax || MemoryControl.shortStatus()) {
                super.shrinkWithGapsAtEnd();
                this.flushBuffer();
                if (b.length > this.buffermax) {
                    this.add(key, b);
                } else if (this.buffer != null) {
                    this.buffer.put(key, b);
                    this.buffersize += b.length;
                }
                return;
            }
            if (this.buffer != null) {
                this.buffer.put(key, b);
                this.buffersize += b.length;
            }
        }
    }

    private boolean putToGap(byte[] key, byte[] b) throws IOException, SpaceExceededException {
        if (b.length == 0) {
            return true;
        }
        if (this.free == null || this.free.isEmpty()) {
            return false;
        }
        long lseek = -1L;
        int lsize = 0;
        int reclen = b.length + this.keylength;
        Iterator i = this.free.entrySet().iterator();
        int acount = 0;
        int bcount = 0;
        while (i.hasNext()) {
            Map.Entry entry2 = i.next();
            if ((Integer)entry2.getValue() == reclen) {
                this.index.put(key, (Long)entry2.getKey());
                this.file.seek((Long)entry2.getKey());
                int reclenf = this.file.readInt();
                assert (reclenf == reclen);
                this.file.write(key);
                if (this.keylength > key.length) {
                    for (int j = 0; j < this.keylength - key.length; ++j) {
                        this.file.write(HeapWriter.ZERO);
                    }
                }
                this.file.write(b);
                i.remove();
                return true;
            }
            ++acount;
            if ((Integer)entry2.getValue() <= lsize) continue;
            lseek = (Long)entry2.getKey();
            lsize = (Integer)entry2.getValue();
            if (acount <= 100 && ++bcount <= 10) continue;
        }
        if (lsize > reclen + 4) {
            this.file.seek(lseek);
            this.file.writeInt(reclen);
            this.file.write(key);
            if (this.keylength > key.length) {
                for (int j = 0; j < this.keylength - key.length; ++j) {
                    this.file.write(HeapWriter.ZERO);
                }
            }
            this.file.write(b);
            this.index.put(key, lseek);
            int newfreereclen = lsize - reclen - 4;
            assert (newfreereclen > 0);
            this.file.writeInt(newfreereclen);
            this.free.remove(lseek);
            this.free.put(lseek + 4L + (long)reclen, newfreereclen);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(byte[] key) throws IOException {
        key = this.normalizeKey(key);
        Heap heap = this;
        synchronized (heap) {
            byte[] blob;
            super.deleteFingerprint();
            assert (this.buffer != null);
            if (this.buffer != null && (blob = (byte[])this.buffer.remove(key)) != null) {
                this.buffersize -= blob.length;
                return;
            }
            super.delete(key);
        }
    }

    @Override
    public synchronized CloneableIterator<byte[]> keys(boolean up, boolean rotating) throws IOException {
        this.flushBuffer();
        return super.keys(up, rotating);
    }

    @Override
    public synchronized CloneableIterator<byte[]> keys(boolean up, byte[] firstKey) throws IOException {
        this.flushBuffer();
        return super.keys(up, firstKey);
    }

    @Override
    public synchronized long length() {
        return super.length() + (long)this.buffersize;
    }

    public static void heaptest() {
        File f = new File("/Users/admin/blobtest.heap");
        try {
            Heap heap = new Heap(f, 12, NaturalOrder.naturalOrder, 524288);
            heap.insert("aaaaaaaaaaaa".getBytes(), "eins zwei drei".getBytes());
            heap.insert("aaaaaaaaaaab".getBytes(), "vier fuenf sechs".getBytes());
            heap.insert("aaaaaaaaaaac".getBytes(), "sieben acht neun".getBytes());
            heap.insert("aaaaaaaaaaad".getBytes(), "zehn elf zwoelf".getBytes());
            CloneableIterator<byte[]> i = heap.index.keys(true, null);
            while (i.hasNext()) {
                System.out.println("key_a: " + UTF8.String((byte[])i.next()));
            }
            i = heap.keys(true, false);
            while (i.hasNext()) {
                System.out.println("key_b: " + UTF8.String((byte[])i.next()));
            }
            heap.delete("aaaaaaaaaaab".getBytes());
            heap.delete("aaaaaaaaaaac".getBytes());
            heap.insert("aaaaaaaaaaaX".getBytes(), "WXYZ".getBytes());
            heap.close(true);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
    }

    private static Map<String, String> map(String a, String b) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(a, b);
        return m;
    }

    public static void maptest() {
        File f = new File("/Users/admin/blobtest.heap");
        try {
            MapHeap heap = new MapHeap(f, 12, NaturalOrder.naturalOrder, 524288, 500, '_');
            heap.insert("aaaaaaaaaaaa".getBytes(), Heap.map("aaaaaaaaaaaa", "eins zwei drei"));
            heap.insert("aaaaaaaaaaab".getBytes(), Heap.map("aaaaaaaaaaab", "vier fuenf sechs"));
            heap.insert("aaaaaaaaaaac".getBytes(), Heap.map("aaaaaaaaaaac", "sieben acht neun"));
            heap.insert("aaaaaaaaaaad".getBytes(), Heap.map("aaaaaaaaaaad", "zehn elf zwoelf"));
            heap.delete("aaaaaaaaaaab".getBytes());
            heap.delete("aaaaaaaaaaac".getBytes());
            heap.insert("aaaaaaaaaaaX".getBytes(), Heap.map("aaaaaaaaaaad", "WXYZ"));
            heap.close();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
        }
    }

    public static void main(String[] args) {
        Heap.maptest();
    }
}

