/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.blob;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.storage.AbstractMapStore;
import net.yacy.cora.storage.MapStore;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.blob.BEncodedHeapBag;
import net.yacy.kelondro.data.word.Word;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.MergeIterator;

public class BEncodedHeapShard
extends AbstractMapStore
implements MapStore {
    private ConcurrentHashMap<String, MapStore> shard = new ConcurrentHashMap();
    private final File baseDir;
    private final Method shardMethod;

    public BEncodedHeapShard(File baseDir, Method shardMethod) {
        this.baseDir = baseDir;
        this.shardMethod = shardMethod;
        this.init();
    }

    private void init() {
        String[] tablefile;
        this.shard = new ConcurrentHashMap();
        if (!this.baseDir.exists()) {
            this.baseDir.mkdirs();
        }
        for (String element : tablefile = this.baseDir.list()) {
            if (!this.shardMethod.isShardPart(element)) continue;
            ConcurrentLog.info("BEncodedHeapShard", "opening partial shard " + element);
            MapStore bag = this.openBag(element);
            this.shard.put(this.shardMethod.getShardName(element), bag);
        }
    }

    @Override
    public synchronized void close() {
        if (this.shard == null) {
            return;
        }
        Iterator<MapStore> i = this.shard.values().iterator();
        while (i.hasNext()) {
            i.next().close();
        }
        this.shard = null;
    }

    @Override
    public void clear() {
        String[] l;
        this.close();
        for (String element : l = this.baseDir.list()) {
            File f;
            if (!this.shardMethod.isShardPart(element) || (f = new File(this.baseDir, element)).isDirectory()) continue;
            FileUtils.deletedelete(f);
        }
        this.init();
    }

    private MapStore keeperOf(byte[] key) {
        String shardfile = this.shardMethod.filename(key);
        MapStore bag = this.shard.get(shardfile);
        if (bag != null) {
            return bag;
        }
        bag = this.openBag(shardfile);
        this.shard.put(shardfile, bag);
        return bag;
    }

    public MapStore openBag(String shardfile) {
        BEncodedHeapBag bag = new BEncodedHeapBag(this.baseDir, shardfile, this.shardMethod.getKeylength(), this.shardMethod.getOrdering(), 10, 31536000000L, Integer.MAX_VALUE);
        return bag;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null || !(key instanceof byte[])) {
            return false;
        }
        String shardfile = this.shardMethod.filename((byte[])key);
        MapStore bag = this.shard.get(shardfile);
        if (bag == null) {
            return false;
        }
        return bag.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, byte[]> put(byte[] key, Map<String, byte[]> map) {
        if (this.shard == null) {
            return null;
        }
        MapStore keeper = null;
        ConcurrentHashMap<String, MapStore> concurrentHashMap = this.shard;
        synchronized (concurrentHashMap) {
            keeper = this.keeperOf(key);
        }
        return keeper.put(key, map);
    }

    @Override
    public Map<String, byte[]> get(Object key) {
        if (key == null || !(key instanceof byte[])) {
            return null;
        }
        String shardfile = this.shardMethod.filename((byte[])key);
        MapStore bag = this.shard.get(shardfile);
        if (bag == null) {
            return null;
        }
        return (Map)bag.get(key);
    }

    @Override
    public boolean isEmpty() {
        Iterator<MapStore> i = this.shard.values().iterator();
        while (i.hasNext()) {
            if (i.next().isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        Iterator<MapStore> i = this.shard.values().iterator();
        int s = 0;
        while (i.hasNext()) {
            s += i.next().size();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, byte[]> remove(Object key) {
        MapStore bag;
        if (key == null || !(key instanceof byte[])) {
            return null;
        }
        ConcurrentHashMap<String, MapStore> concurrentHashMap = this.shard;
        synchronized (concurrentHashMap) {
            bag = this.keeperOf((byte[])key);
        }
        if (bag == null) {
            return null;
        }
        return (Map)bag.remove(key);
    }

    @Override
    public ByteOrder getOrdering() {
        return this.shardMethod.getOrdering();
    }

    @Override
    public CloneableIterator<byte[]> keyIterator() {
        ArrayList c = new ArrayList(this.shard.size());
        Iterator<MapStore> i = this.shard.values().iterator();
        while (i.hasNext()) {
            CloneableIterator<byte[]> k = i.next().keyIterator();
            if (k == null || !k.hasNext()) continue;
            c.add(k);
        }
        return MergeIterator.cascade(c, this.shardMethod.getOrdering(), MergeIterator.simpleMerge, true);
    }

    private static BEncodedHeapShard testHeapShard(File f) {
        return new BEncodedHeapShard(f, new B64ShardMethod(12, Base64Order.enhancedCoder, "testshard"));
    }

    public static void main(String[] args) {
        File f = new File("/tmp");
        BEncodedHeapShard hb = BEncodedHeapShard.testHeapShard(f);
        for (int i = 0; i < 10000; ++i) {
            hb.put(Word.word2hash(Integer.toString(i)), BEncodedHeapBag.testMap(i));
        }
        System.out.println("test size after put = " + hb.size());
        hb.close();
        hb = BEncodedHeapShard.testHeapShard(f);
        Iterator<Map.Entry<byte[], Map<String, byte[]>>> mi = hb.iterator();
        int c = 100;
        while (mi.hasNext() && c-- > 0) {
            Map.Entry<byte[], Map<String, byte[]>> entry2 = mi.next();
            System.out.println(UTF8.String(entry2.getKey()) + ": " + AbstractMapStore.map2String(entry2.getValue()));
        }
        for (int i = 10000; i > 0; --i) {
            hb.remove(Word.word2hash(Integer.toString(i - 1)));
        }
        System.out.println("test size after remove = " + hb.size());
        hb.close();
        ConcurrentLog.shutdown();
    }

    public static class B64ShardMethod
    implements Method {
        private final int keylength;
        private final ByteOrder ordering;
        private final byte[] template;
        private final int charpos;
        private final String prefix;

        public B64ShardMethod(int keylength, ByteOrder ordering, String prefix) {
            this.keylength = keylength;
            this.ordering = ordering;
            this.template = ASCII.getBytes(prefix + ".?");
            this.charpos = ASCII.getBytes(prefix).length + 1;
            this.prefix = prefix;
        }

        @Override
        public String filename(byte[] key) {
            byte[] s = new byte[this.template.length];
            System.arraycopy(this.template, 0, s, 0, s.length);
            s[this.charpos] = key[0];
            return ASCII.String(s);
        }

        @Override
        public int getKeylength() {
            return this.keylength;
        }

        @Override
        public ByteOrder getOrdering() {
            return this.ordering;
        }

        @Override
        public boolean isShardPart(String filename) {
            return filename.startsWith(this.prefix) && filename.charAt(this.prefix.length()) == '.' && filename.endsWith(".heap");
        }

        @Override
        public String getShardName(String filename) {
            return filename.substring(0, this.template.length);
        }
    }

    public static interface Method {
        public String filename(byte[] var1);

        public int getKeylength();

        public ByteOrder getOrdering();

        public boolean isShardPart(String var1);

        public String getShardName(String var1);
    }
}

