/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.http;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import net.yacy.cora.protocol.Domains;
import net.yacy.server.http.AlternativeDomainNames;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class YacyDomainHandler
extends AbstractHandler
implements Handler {
    private AlternativeDomainNames alternativeResolvers;

    public void setAlternativeResolver(AlternativeDomainNames resolver) {
        this.alternativeResolvers = resolver;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String host = request.getServerName();
        String resolved = this.alternativeResolvers.resolve(host);
        if (resolved != null) {
            int newPort = Domains.stripToPort(resolved);
            String newHost = Domains.stripToHostName(resolved);
            if (this.alternativeResolvers.myIPs().contains(newHost)) {
                return;
            }
            if (Domains.isLocal(newHost, null)) {
                return;
            }
            RequestDispatcher dispatcher = request.getRequestDispatcher(target);
            dispatcher.forward((ServletRequest)new DomainRequestWrapper(request, newHost, newPort), (ServletResponse)response);
            baseRequest.setHandled(true);
        }
    }

    private class DomainRequestWrapper
    extends HttpServletRequestWrapper {
        private final String newServerName;
        private final int newServerPort;

        public DomainRequestWrapper(HttpServletRequest request, String serverName, int serverPort) {
            super(request);
            this.newServerName = serverName;
            this.newServerPort = serverPort;
        }

        public String getServerName() {
            return this.newServerName;
        }

        public int getServerPort() {
            return this.newServerPort;
        }

        public StringBuffer getRequestURL() {
            StringBuffer buf = new StringBuffer(this.getScheme() + "://" + this.newServerName + ":" + this.newServerPort + this.getPathInfo());
            return buf;
        }

        public String getHeader(String name) {
            if (name.equals("Host")) {
                return this.newServerName + (this.newServerPort != 80 ? ":" + this.newServerPort : "");
            }
            return super.getHeader(name);
        }

        public Enumeration<String> getHeaders(String name) {
            if (name.equals("Host")) {
                Vector<String> header = new Vector<String>();
                header.add(this.newServerName + (this.newServerPort != 80 ? ":" + this.newServerPort : ""));
                return header.elements();
            }
            return super.getHeaders(name);
        }
    }
}

