/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.util.Date;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.yacy.cora.document.feed.RSSMessage;
import net.yacy.cora.federate.opensearch.SRURSSConnector;
import net.yacy.cora.geo.GeoLocation;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.HeaderFramework;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.CommonPattern;
import net.yacy.document.LibraryProvider;
import net.yacy.http.servlets.YaCyDefaultServlet;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class yacysearch_location {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        prop.put("kml", 0L);
        String peerContext = YaCyDefaultServlet.getContext(header, sb);
        if (header.get("EXT", "").equals("kml") || header.get("EXT", "").equals("xml") || header.get("EXT", "").equals("rss")) {
            double la;
            prop.put("kml", 1L);
            if (post == null) {
                return prop;
            }
            String query2 = post.get("query", "");
            boolean search_query = post.get("dom", "").indexOf("location", 0) >= 0;
            boolean metatag = post.get("dom", "").indexOf("metatag", 0) >= 0;
            boolean alltext = post.get("dom", "").indexOf("alltext", 0) >= 0;
            boolean search_title = alltext || post.get("dom", "").indexOf("title", 0) >= 0;
            boolean search_publisher = alltext || post.get("dom", "").indexOf("publisher", 0) >= 0;
            boolean search_creator = alltext || post.get("dom", "").indexOf("creator", 0) >= 0;
            boolean search_subject = alltext || post.get("dom", "").indexOf("subject", 0) >= 0;
            long maximumTime = post.getLong("maximumTime", 5000L);
            int maximumRecords = post.getInt("maximumRecords", 6000);
            double lon = post.getDouble("lon", 0.0);
            double lat = post.getDouble("lat", 0.0);
            double radius = post.getDouble("r", 0.0);
            int placemarkCounter = 0;
            if (query2.length() > 0 && search_query) {
                TreeSet<GeoLocation> locations = LibraryProvider.geoLoc.find(query2, true);
                for (String qp : CommonPattern.SPACES.split(query2)) {
                    locations.addAll(LibraryProvider.geoLoc.find(qp, true));
                }
                for (GeoLocation location : locations) {
                    double lo = location.lon();
                    la = location.lat();
                    if (lo == 0.0 && la == 0.0) continue;
                    prop.put("kml_placemark_" + placemarkCounter + "_location", location.getName());
                    prop.put("kml_placemark_" + placemarkCounter + "_name", location.getName());
                    prop.put("kml_placemark_" + placemarkCounter + "_author", "");
                    prop.put("kml_placemark_" + placemarkCounter + "_copyright", "");
                    prop.put("kml_placemark_" + placemarkCounter + "_subject", "");
                    prop.put("kml_placemark_" + placemarkCounter + "_description", "");
                    prop.put("kml_placemark_" + placemarkCounter + "_date", "");
                    prop.putXML("kml_placemark_" + placemarkCounter + "_url", peerContext + "/yacysearch.html?query=" + location.getName());
                    prop.put("kml_placemark_" + placemarkCounter + "_pointname", location.getName());
                    prop.put("kml_placemark_" + placemarkCounter + "_lon", lo);
                    prop.put("kml_placemark_" + placemarkCounter + "_lat", la);
                    ++placemarkCounter;
                }
            }
            if (query2.length() > 0 && (metatag || search_title || search_publisher || search_creator || search_subject)) {
                try {
                    RSSMessage message2;
                    String rssSearchServiceURL = "http://127.0.0.1:" + sb.getLocalPort() + "/yacysearch.rss";
                    LinkedBlockingQueue<RSSMessage> results = new LinkedBlockingQueue<RSSMessage>();
                    SRURSSConnector.searchSRURSS(results, rssSearchServiceURL, lon == 0.0 && lat == 0.0 ? query2 : query2 + " /radius/" + lat + "/" + lon + "/" + radius, maximumTime, Integer.MAX_VALUE, null, false, ClientIdentification.yacyInternetCrawlerAgent);
                    while ((message2 = (RSSMessage)results.poll(maximumTime, TimeUnit.MILLISECONDS)) != RSSMessage.POISON && message2 != null) {
                        double lo = message2.getLon();
                        la = message2.getLat();
                        if (lo == 0.0 && la == 0.0) continue;
                        prop.put("kml_placemark_" + placemarkCounter + "_location", message2.getTitle());
                        prop.put("kml_placemark_" + placemarkCounter + "_name", message2.getTitle());
                        prop.put("kml_placemark_" + placemarkCounter + "_author", message2.getAuthor());
                        prop.put("kml_placemark_" + placemarkCounter + "_copyright", message2.getCopyright());
                        prop.put("kml_placemark_" + placemarkCounter + "_subject", message2.getSubject());
                        prop.put("kml_placemark_" + placemarkCounter + "_description", message2.getDescriptions().size() > 0 ? message2.getDescriptions().get(0) : "");
                        prop.put("kml_placemark_" + placemarkCounter + "_date", message2.getPubDate() != null ? message2.getPubDate() : new Date());
                        prop.putXML("kml_placemark_" + placemarkCounter + "_url", message2.getLink());
                        prop.put("kml_placemark_" + placemarkCounter + "_pointname", message2.getTitle());
                        prop.put("kml_placemark_" + placemarkCounter + "_lon", lo);
                        prop.put("kml_placemark_" + placemarkCounter + "_lat", la);
                        if (++placemarkCounter < maximumRecords) continue;
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            prop.put("kml_placemark", placemarkCounter);
        }
        if (header.get("EXT", "").equals("rss")) {
            if (post == null) {
                return prop;
            }
            String promoteSearchPageGreeting = env.getConfig("promoteSearchPageGreeting", "");
            if (env.getConfigBool("promoteSearchPageGreeting.useNetworkName", false)) {
                promoteSearchPageGreeting = env.getConfig("network.unit.description", "");
            }
            String originalquerystring = post == null ? "" : post.get("query", post.get("search", "")).trim();
            boolean global = post.get("kml_resource", "local").equals("global");
            prop.put("kml_date822", HeaderFramework.formatRFC1123(new Date()));
            prop.put("kml_promoteSearchPageGreeting", promoteSearchPageGreeting);
            prop.put("kml_rssYacyImageURL", peerContext + "/env/grafics/yacy.png");
            prop.put("kml_searchBaseURL", peerContext + "/yacysearch_location.rss");
            prop.putXML("kml_rss_query", originalquerystring);
            prop.put("kml_rss_queryenc", originalquerystring.replace(' ', '+'));
            prop.put("kml_resource", global ? "global" : "local");
            prop.put("kml_contentdom", post == null ? "text" : post.get("contentdom", "text"));
            prop.put("kml_verify", post == null ? "true" : post.get("verify", "true"));
        }
        if (header.get("EXT", "").equals("html")) {
            prop.put("topmenu", sb.getConfigBool("publicTopmenu", true) ? 1L : 0L);
            prop.put("promoteSearchPageGreeting", sb.getConfig("promoteSearchPageGreeting", ""));
            if (post == null || post.get("query") == null) {
                prop.put("initsearch", 0L);
            } else {
                prop.put("initsearch", 1L);
                prop.put("initsearch_query", post.get("query"));
            }
        }
        return prop;
    }
}

