/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.api;

import java.io.IOException;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.Memory;
import net.yacy.crawler.CrawlSwitchboard;
import net.yacy.crawler.data.CrawlProfile;
import net.yacy.kelondro.index.RowHandleSet;
import net.yacy.kelondro.io.ByteCount;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.kelondro.workflow.BusyThread;
import net.yacy.kelondro.workflow.WorkflowProcessor;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Fulltext;
import net.yacy.search.index.Segment;
import net.yacy.search.schema.CollectionConfiguration;
import net.yacy.search.schema.CollectionSchema;
import net.yacy.search.schema.WebgraphSchema;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class status_p {
    public static final String STATE_RUNNING = "running";
    public static final String STATE_PAUSED = "paused";

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        boolean html = post != null && post.containsKey("html");
        prop.setLocalized(html);
        Segment segment = sb.index;
        Fulltext fulltext = segment.fulltext();
        prop.put("rejected", "0");
        sb.updateMySeed();
        int cacheMaxSize = (int)sb.getConfigLong("wordCacheMaxCount", 10000L);
        prop.put("ppm", Switchboard.currentPPM());
        prop.putNum("qpm", sb.peers.mySeed().getQPM());
        prop.putNum("wordCacheSize", segment.RWIBufferCount());
        prop.putNum("wordCacheMaxSize", cacheMaxSize);
        prop.putNum("usedMemory", MemoryControl.used());
        prop.putNum("freeMemory", MemoryControl.free());
        prop.putNum("totalMemory", MemoryControl.total());
        prop.putNum("maxMemory", MemoryControl.maxMemory());
        prop.putNum("usedDisk", sb.observer.getSizeOfDataPath(true));
        prop.putNum("freeDisk", sb.observer.getUsableSpace());
        prop.putNum("processors", WorkflowProcessor.availableCPU);
        prop.putNum("load", Memory.getSystemLoadAverage());
        prop.put("trafficIn", ByteCount.getGlobalCount());
        prop.put("trafficProxy", ByteCount.getAccountCount("PROXY"));
        prop.put("trafficCrawler", ByteCount.getAccountCount("CRAWLER"));
        prop.putNum("urlpublictextSize", fulltext.collectionSize());
        prop.putNum("urlpublictextSegmentCount", fulltext.getDefaultConnector().getSegmentCount());
        prop.putNum("webgraphSize", fulltext.useWebgraph() ? fulltext.webgraphSize() : 0L);
        prop.putNum("webgraphSegmentCount", fulltext.useWebgraph() ? (long)fulltext.getWebgraphConnector().getSegmentCount() : 0L);
        prop.putNum("citationSize", segment.citationCount());
        prop.putNum("citationSegmentCount", segment.citationSegmentCount());
        prop.putNum("rwipublictextSize", segment.RWICount());
        prop.putNum("rwipublictextSegmentCount", segment.RWISegmentCount());
        prop.putNum("loaderSize", sb.crawlQueues.activeWorkerEntries().size());
        prop.putNum("loaderMax", sb.getConfigLong("crawler.MaxActiveThreads", 10L));
        BusyThread localCrawl = sb.getThread("50_localcrawl");
        prop.putNum("localCrawlSize", localCrawl == null ? 0L : (long)localCrawl.getJobCount());
        prop.put("localCrawlState", sb.crawlJobIsPaused("50_localcrawl") ? STATE_PAUSED : STATE_RUNNING);
        prop.putNum("limitCrawlSize", sb.crawlQueues.limitCrawlJobSize());
        prop.put("limitCrawlState", STATE_RUNNING);
        BusyThread remoteCrawl = sb.getThread("62_remotetriggeredcrawl");
        prop.putNum("remoteCrawlSize", remoteCrawl == null ? 0L : (long)remoteCrawl.getJobCount());
        prop.put("remoteCrawlState", sb.crawlJobIsPaused("62_remotetriggeredcrawl") ? STATE_PAUSED : STATE_RUNNING);
        prop.putNum("noloadCrawlSize", sb.crawlQueues.noloadCrawlJobSize());
        prop.put("noloadCrawlState", STATE_RUNNING);
        int count = 0;
        int domlistlength = post == null ? 160 : post.getInt("domlistlength", 160);
        String hosts = "";
        for (byte[] h : sb.crawler.getActive()) {
            CrawlProfile profile2 = sb.crawler.getActive(h);
            if (CrawlSwitchboard.DEFAULT_PROFILES.contains(profile2.name())) continue;
            profile2.putProfileEntry("crawlProfiles_list_", prop, true, false, count, domlistlength);
            RowHandleSet urlhashes = sb.crawler.getURLHashes(h);
            prop.put("crawlProfiles_list_" + count + "_count", urlhashes == null ? "unknown" : Integer.toString(urlhashes.size()));
            if (profile2.urlMustMatchPattern() == CrawlProfile.MATCH_ALL_PATTERN) {
                hosts = hosts + "," + profile2.name();
            }
            ++count;
        }
        prop.put("crawlProfiles_list", count);
        prop.put("crawlProfiles_count", count);
        prop.put("crawlProfiles", count == 0 ? 0L : 1L);
        prop.put("postprocessingRunning", CollectionConfiguration.postprocessingRunning ? 1L : 0L);
        boolean processCollection = sb.index.fulltext().getDefaultConfiguration().contains(CollectionSchema.process_sxt) && (sb.index.connectedCitation() || sb.index.fulltext().useWebgraph());
        boolean processWebgraph = sb.index.fulltext().getWebgraphConfiguration().contains(WebgraphSchema.process_sxt) && sb.index.fulltext().useWebgraph();
        long timeSinceStart = (processCollection || processWebgraph) && CollectionConfiguration.postprocessingRunning ? System.currentTimeMillis() - CollectionConfiguration.postprocessingStartTime : 0L;
        long collectionRemainingCount = 0L;
        long webgraphRemainingCount = 0L;
        if (processCollection) {
            try {
                collectionRemainingCount = sb.index.fulltext().getDefaultConnector().getCountByQuery("{!cache=false}" + CollectionConfiguration.collection1query(sb.index, null));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (processWebgraph) {
            try {
                webgraphRemainingCount = sb.index.fulltext().getWebgraphConnector().getCountByQuery(CollectionConfiguration.webgraphquery(sb.index, null));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        long countSinceStart = CollectionConfiguration.postprocessingRunning ? (long)(CollectionConfiguration.postprocessingCollection1Count + CollectionConfiguration.postprocessingWebgraphCount) - collectionRemainingCount - webgraphRemainingCount : 0L;
        int speed = timeSinceStart == 0L ? 0 : (int)(60000L * countSinceStart / timeSinceStart);
        long remainingTime = speed == 0 ? 0L : 60000L * collectionRemainingCount / (long)speed;
        int remainingTimeMinutes = (int)(remainingTime / 60000L);
        int remainingTimeSeconds = (int)((remainingTime - (long)(remainingTimeMinutes * 60000)) / 1000L);
        prop.put("postprocessingCollectionRemainingCount", collectionRemainingCount);
        prop.put("postprocessingWebgraphRemainingCount", webgraphRemainingCount);
        prop.put("postprocessingRunning_activity", CollectionConfiguration.postprocessingActivity);
        prop.put("postprocessingSpeed", speed);
        prop.put("postprocessingElapsedTime", timeSinceStart);
        prop.put("postprocessingRemainingTime", remainingTime);
        prop.put("postprocessingRemainingTimeMinutes", (remainingTimeMinutes < 10 ? "0" : "") + Integer.toString(remainingTimeMinutes));
        prop.put("postprocessingRemainingTimeSeconds", (remainingTimeSeconds < 10 ? "0" : "") + Integer.toString(remainingTimeSeconds));
        return prop;
    }
}

