/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.api;

import java.awt.Container;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.feed.RSSFeed;
import net.yacy.cora.document.feed.RSSMessage;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.Html2Image;
import net.yacy.crawler.data.Snapshots;
import net.yacy.crawler.data.Transactions;
import net.yacy.document.ImageParser;
import net.yacy.http.servlets.TemplateMissingParameterException;
import net.yacy.http.servlets.TemplateProcessingException;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.peers.graphics.EncodedImage;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import org.apache.solr.common.SolrInputDocument;
import org.json.JSONException;
import org.json.JSONObject;

public class snapshot {
    private static final int DEFAULT_WIDTH = 1024;
    private static final int DEFAULT_HEIGHT = 1024;
    private static final int DEFAULT_DENSITY = 300;
    private static final int DEFAULT_QUALITY = 75;
    private static final String DEFAULT_EXT = "jpg";

    public static Object respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        serverObjects defaultResponse = new serverObjects();
        boolean authenticated = sb.adminAuthenticated(header) >= 2;
        String ext = header.get("EXT", "");
        if (ext.isEmpty()) {
            throw new TemplateProcessingException("Missing extension. Try with rss, xml, json, pdf, png or jpg." + ext, 400);
        }
        if (ext.equals("rss")) {
            if (!authenticated) {
                defaultResponse.authenticationRequired();
                return defaultResponse;
            }
            int maxcount = post == null ? 10 : post.getInt("maxcount", 10);
            int depthx = post == null ? -1 : post.getInt("depth", -1);
            Integer depth = depthx == -1 ? null : Integer.valueOf(depthx);
            String orderx = post == null ? "ANY" : post.get("order", "ANY");
            Snapshots.Order order = Snapshots.Order.valueOf(orderx);
            String statex = post == null ? Transactions.State.INVENTORY.name() : post.get("state", Transactions.State.INVENTORY.name());
            Transactions.State state = Transactions.State.valueOf(statex);
            String host = post == null ? null : post.get("host");
            LinkedHashMap<String, Snapshots.Revisions> iddate = Transactions.select(host, depth, order, maxcount, state);
            RSSFeed rssfeed = new RSSFeed(Integer.MAX_VALUE);
            rssfeed.setChannel(new RSSMessage("Snapshot list for host = " + host + ", depth = " + depth + ", order = " + (Object)((Object)order) + ", maxcount = " + maxcount, "", ""));
            for (Map.Entry e : iddate.entrySet()) {
                try {
                    String u;
                    String string = u = ((Snapshots.Revisions)e.getValue()).url == null ? sb.index.fulltext().getURL((String)e.getKey()) : ((Snapshots.Revisions)e.getValue()).url;
                    if (u == null) continue;
                    RSSMessage message2 = new RSSMessage(u, "", new DigestURL(u), (String)e.getKey());
                    message2.setPubDate(((Snapshots.Revisions)e.getValue()).dates[0]);
                    rssfeed.addMessage(message2);
                }
                catch (IOException ee) {
                    ConcurrentLog.logException(ee);
                }
            }
            byte[] rssBinary = UTF8.getBytes(rssfeed.toString());
            return new ByteArrayInputStream(rssBinary);
        }
        if (post == null) {
            post = new serverObjects();
        }
        boolean xml = ext.equals("xml");
        boolean pdf = ext.equals("pdf");
        if (pdf && !authenticated) {
            defaultResponse.authenticationRequired();
            return defaultResponse;
        }
        boolean pngjpg = ext.equals("png") || ext.equals(DEFAULT_EXT);
        String urlhash = post.get("urlhash", "");
        String url = post.get("url", "");
        DigestURL durl = null;
        if (urlhash.length() == 0 && url.length() > 0) {
            try {
                durl = new DigestURL(url);
                urlhash = ASCII.String(durl.hash());
            }
            catch (MalformedURLException state) {
                // empty catch block
            }
        }
        if (durl == null && urlhash.length() > 0) {
            try {
                String u = sb.index.fulltext().getURL(urlhash);
                durl = u == null ? null : new DigestURL(u);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        if (ext.equals("json")) {
            JSONObject result;
            block75: {
                String command = post.get("command", "metadata");
                String statename = post.get("state");
                result = new JSONObject();
                try {
                    Snapshots.Revisions r;
                    if (command.equals("status")) {
                        JSONObject sizes = new JSONObject();
                        for (Map.Entry<String, Integer> state : Transactions.sizes().entrySet()) {
                            sizes.put(state.getKey(), state.getValue());
                        }
                        result.put("size", sizes);
                        break block75;
                    }
                    if (command.equals("list")) {
                        Transactions.State[] stateArray;
                        int depthi;
                        if (!authenticated) {
                            defaultResponse.authenticationRequired();
                            return defaultResponse;
                        }
                        String host = post.get("host");
                        String depth = post.get("depth");
                        int n = depthi = depth == null ? -1 : Integer.parseInt(depth);
                        if (statename == null) {
                            Transactions.State[] stateArray2 = new Transactions.State[2];
                            stateArray2[0] = Transactions.State.INVENTORY;
                            stateArray = stateArray2;
                            stateArray2[1] = Transactions.State.ARCHIVE;
                        } else {
                            Transactions.State[] stateArray3 = new Transactions.State[1];
                            stateArray = stateArray3;
                            stateArray3[0] = Transactions.State.valueOf(statename);
                        }
                        for (Transactions.State state : stateArray) {
                            if (host == null) {
                                JSONObject hostCountInventory = new JSONObject();
                                for (String string : Transactions.listHosts(state)) {
                                    int size = Transactions.listIDsSize(string, depthi, state);
                                    if (size <= 0) continue;
                                    hostCountInventory.put(string, size);
                                }
                                result.put("count." + state.name(), hostCountInventory);
                                continue;
                            }
                            TreeMap<Integer, Collection<Snapshots.Revisions>> ids = Transactions.listIDs(host, depthi, state);
                            if (ids == null) {
                                result.put("result", "fail");
                                result.put("comment", "no entries for host " + host + " found");
                                continue;
                            }
                            for (Map.Entry entry2 : ids.entrySet()) {
                                for (Snapshots.Revisions r2 : (Collection)entry2.getValue()) {
                                    try {
                                        JSONObject metadata = new JSONObject();
                                        String u = r2.url != null ? r2.url : sb.index.fulltext().getURL(r2.urlhash);
                                        metadata.put("url", u == null ? "unknown" : u);
                                        metadata.put("dates", r2.dates);
                                        assert (r2.depth == (Integer)entry2.getKey());
                                        metadata.put("depth", (Integer)entry2.getKey());
                                        result.put(r2.urlhash, metadata);
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        }
                        break block75;
                    }
                    if (command.equals("commit")) {
                        if (!authenticated) {
                            defaultResponse.authenticationRequired();
                            return defaultResponse;
                        }
                        r = Transactions.commit(urlhash);
                        if (r != null) {
                            result.put("result", "success");
                            result.put("depth", r.depth);
                            result.put("url", r.url);
                            result.put("dates", r.dates);
                        } else {
                            result.put("result", "fail");
                        }
                        result.put("urlhash", urlhash);
                        break block75;
                    }
                    if (command.equals("rollback")) {
                        if (!authenticated) {
                            defaultResponse.authenticationRequired();
                            return defaultResponse;
                        }
                        r = Transactions.rollback(urlhash);
                        if (r != null) {
                            result.put("result", "success");
                            result.put("depth", r.depth);
                            result.put("url", r.url);
                            result.put("dates", r.dates);
                        } else {
                            result.put("result", "fail");
                        }
                        result.put("urlhash", urlhash);
                        break block75;
                    }
                    if (!command.equals("metadata")) break block75;
                    try {
                        Snapshots.Revisions r3;
                        Transactions.State state;
                        Transactions.State state2 = state = statename == null || statename.length() == 0 ? null : Transactions.State.valueOf(statename);
                        if (state == null) {
                            r = Transactions.getRevisions(Transactions.State.INVENTORY, urlhash);
                            if (r != null) {
                                state = Transactions.State.INVENTORY;
                            }
                            if ((r = Transactions.getRevisions(Transactions.State.ARCHIVE, urlhash)) != null) {
                                state = Transactions.State.ARCHIVE;
                            }
                        } else {
                            r3 = Transactions.getRevisions(state, urlhash);
                        }
                        if (r3 != null) {
                            JSONObject metadata = new JSONObject();
                            String u = r3.url != null ? r3.url : sb.index.fulltext().getURL(r3.urlhash);
                            metadata.put("url", u == null ? "unknown" : u);
                            metadata.put("dates", r3.dates);
                            metadata.put("depth", r3.depth);
                            metadata.put("state", state.name());
                            result.put(r3.urlhash, metadata);
                        }
                    }
                    catch (IOException | IllegalArgumentException r3) {
                    }
                }
                catch (JSONException e) {
                    ConcurrentLog.logException(e);
                }
            }
            String json = result.toString();
            if (post.containsKey("callback")) {
                json = post.get("callback") + "([" + json + "]);";
            }
            return new ByteArrayInputStream(UTF8.getBytes(json));
        }
        if (durl == null) {
            throw new TemplateMissingParameterException("Missing valid url or urlhash parameter");
        }
        if (xml) {
            Collection<File> xmlSnapshots = Transactions.findPaths(durl, "xml", Transactions.State.ANY);
            File xmlFile = null;
            if (xmlSnapshots.isEmpty()) {
                throw new TemplateProcessingException("Could not find the xml snapshot file.", 404);
            }
            xmlFile = xmlSnapshots.iterator().next();
            try {
                byte[] xmlBinary = FileUtils.read(xmlFile);
                return new ByteArrayInputStream(xmlBinary);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                throw new TemplateProcessingException("Could not read the xml snapshot file.");
            }
        }
        if (pdf || pngjpg) {
            Collection<File> pdfSnapshots = Transactions.findPaths(durl, "pdf", Transactions.State.INVENTORY);
            File pdfFile = null;
            if (pdfSnapshots.isEmpty()) {
                if (!authenticated) {
                    throw new TemplateProcessingException("Could not find the pdf snapshot file. You must be authenticated to generate one on the fly.", 404);
                }
                URIMetadataNode sd = sb.index.fulltext().getMetadata(durl.hash());
                boolean success = false;
                if (sd == null) {
                    success = Transactions.store(durl, new Date(), 99, false, true, sb.getConfigBool("isTransparentProxy", false) ? "http://127.0.0.1:" + sb.getConfigInt("port", 8090) : null, sb.getConfig("crawler.http.acceptLanguage", null));
                } else {
                    SolrInputDocument sid = sb.index.fulltext().getDefaultConfiguration().toSolrInputDocument(sd);
                    success = Transactions.store(sid, false, true, true, sb.getConfigBool("isTransparentProxy", false) ? "http://127.0.0.1:" + sb.getConfigInt("port", 8090) : null, sb.getConfig("crawler.http.acceptLanguage", null));
                }
                if (success && !(pdfSnapshots = Transactions.findPaths(durl, "pdf", Transactions.State.ANY)).isEmpty()) {
                    pdfFile = pdfSnapshots.iterator().next();
                }
            } else {
                pdfFile = pdfSnapshots.iterator().next();
            }
            if (pdfFile == null) {
                throw new TemplateProcessingException("Could not find the pdf snapshot file and could not generate one on the fly.", 404);
            }
            if (pdf) {
                try {
                    byte[] pdfBinary = FileUtils.read(pdfFile);
                    return new ByteArrayInputStream(pdfBinary);
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                    throw new TemplateProcessingException("Could not read the pdf snapshot file.");
                }
            }
            if (pngjpg) {
                int width = Math.min(post.getInt("width", 1024), 1024);
                int height = Math.min(post.getInt("height", 1024), 1024);
                String imageFileStub = pdfFile.getAbsolutePath();
                File imageFile = new File((imageFileStub = imageFileStub.substring(0, imageFileStub.length() - 3)) + 1024 + "." + 1024 + "." + ext);
                if (!imageFile.exists() && authenticated && !Html2Image.pdf2image(pdfFile, imageFile, 1024, 1024, 300, 75)) {
                    throw new TemplateProcessingException("Could not generate the " + ext + " image snapshot file.");
                }
                if (!imageFile.exists()) {
                    throw new TemplateProcessingException("Could not find the " + ext + " image snapshot file. You must be authenticated to generate one on the fly.", 404);
                }
                if (width == 1024 && height == 1024) {
                    try {
                        byte[] imageBinary = FileUtils.read(imageFile);
                        return new ByteArrayInputStream(imageBinary);
                    }
                    catch (IOException e) {
                        ConcurrentLog.logException(e);
                        throw new TemplateProcessingException("Could not read the " + ext + " image snapshot file.");
                    }
                }
                try {
                    Image image = ImageParser.parse(imageFile.getAbsolutePath(), FileUtils.read(imageFile));
                    if (image == null) {
                        throw new TemplateProcessingException("Could not parse the " + ext + " image snapshot file.");
                    }
                    Image scaled = image.getScaledInstance(width, height, 16);
                    MediaTracker mediaTracker = new MediaTracker(new Container());
                    mediaTracker.addImage(scaled, 0);
                    try {
                        mediaTracker.waitForID(0);
                    }
                    catch (InterruptedException state) {
                        // empty catch block
                    }
                    BufferedImage scaledBufferedImg = new BufferedImage(width, height, 1);
                    scaledBufferedImg.createGraphics().drawImage(scaled, 0, 0, width, height, null);
                    return new EncodedImage(scaledBufferedImg, ext, true);
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                    throw new TemplateProcessingException("Could not scale the " + ext + " image snapshot file.");
                }
            }
        }
        throw new TemplateProcessingException("Unsupported extension : " + ext + ". Try with rss, xml, json, pdf, png or jpg.", 400);
    }
}

