/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.api;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.yacy;

public class share {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        byte[] data;
        int c;
        serverObjects prop = new serverObjects();
        int n = c = post == null ? 1 : post.getInt("c", 0);
        if (c > 0) {
            prop.put("mode", 0L);
            return prop;
        }
        prop.put("mode", 1L);
        prop.put("mode_success", 0L);
        prop.put("mode_countsuccess", 0L);
        prop.put("mode_countfail", 0L);
        prop.put("mode_item", "");
        if (post == null) {
            return prop;
        }
        String filename = post.get("data", "");
        if (filename.isEmpty()) {
            prop.put("mode_success_message", "file name is empty");
            return prop;
        }
        if (!filename.startsWith("yacy_dump_") || !filename.endsWith(".xml.gz")) {
            prop.put("mode_success_message", "no index dump file (yacy_dump_*.xml.gz)");
            return prop;
        }
        String dataString = post.get("data$file", "");
        if (dataString.length() == 0) {
            return prop;
        }
        if (filename.endsWith(".base64")) {
            data = Base64Order.standardCoder.decode(dataString);
            filename = filename.substring(0, filename.length() - 7);
        } else {
            data = UTF8.getBytes(dataString);
        }
        if (data == null || data.length == 0) {
            return prop;
        }
        int ttp = filename.indexOf("_t");
        if (ttp < 0) {
            return prop;
        }
        if (filename.charAt(ttp + 3) != '.') {
            return prop;
        }
        filename = filename.substring(0, ttp) + "_ts" + filename.substring(ttp + 3);
        File tmpFile = new File(yacy.shareDumpDefaultPath, filename + ".tmp");
        File finalFile = new File(yacy.shareDumpDefaultPath, filename);
        try {
            Files.copy(new ByteArrayInputStream(data), tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            tmpFile.renameTo(finalFile);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            return prop;
        }
        prop.put("mode_success", 1L);
        return prop;
    }
}

