/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.api;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.federate.solr.connector.SolrConnector;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.sorting.OrderedScoreMap;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.document.SentenceReader;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Segment;
import net.yacy.search.schema.CollectionSchema;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;

public class citation {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        StringBuilder dd;
        SolrDocument doc;
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        Segment segment = sb.index;
        SolrConnector connector = segment.fulltext().getDefaultConnector();
        prop.put("url", "");
        prop.put("citations", 0L);
        prop.put("sentences", 0L);
        DigestURL uri = null;
        String url = "";
        String hash = "";
        int ch = 10;
        boolean filter = false;
        if (post != null) {
            if (!(!post.containsKey("url") || (url = post.get("url")).startsWith("http://") || url.startsWith("https://") || url.startsWith("ftp://") || url.startsWith("smb://") || url.startsWith("file://"))) {
                url = "http://" + url;
            }
            if (post.containsKey("hash")) {
                hash = post.get("hash");
            }
            if (post.containsKey("ch")) {
                ch = post.getInt("ch", ch);
            }
            filter = post.getBoolean("filter");
        }
        prop.put("filter", filter);
        if (url.length() > 0) {
            try {
                uri = new DigestURL(url, null);
                hash = ASCII.String(uri.hash());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uri == null && hash.length() > 0) {
            try {
                String u = sb.getURL(ASCII.getBytes(hash));
                if (u == null) {
                    connector.commit(true);
                    u = sb.getURL(ASCII.getBytes(hash));
                }
                if (u != null) {
                    uri = new DigestURL(u);
                }
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        if (uri == null) {
            return prop;
        }
        url = uri.toNormalform(true);
        prop.put("url", url);
        try {
            doc = segment.fulltext().getDefaultConnector().getDocumentById(hash, CollectionSchema.title.getSolrFieldName(), CollectionSchema.text_t.getSolrFieldName());
        }
        catch (IOException e1) {
            return prop;
        }
        ArrayList title = (ArrayList)doc.getFieldValue(CollectionSchema.title.getSolrFieldName());
        String text = (String)doc.getFieldValue(CollectionSchema.text_t.getSolrFieldName());
        ArrayList<String> sentences = new ArrayList<String>();
        if (title != null) {
            for (String s : title) {
                if (s.length() <= 0) continue;
                sentences.add(s);
            }
        }
        if (text != null && !text.isEmpty()) {
            SentenceReader sr = new SentenceReader(text);
            while (sr.hasNext()) {
                StringBuilder line = sr.next();
                if (line.length() <= 0) continue;
                sentences.add(line.toString());
            }
        }
        OrderedScoreMap<String> scores = new OrderedScoreMap<String>(null);
        LinkedHashMap sentenceOcc = new LinkedHashMap();
        for (String sentence : sentences) {
            if (sentence == null || sentence.length() < 40) {
                sentenceOcc.put(sentence, null);
                continue;
            }
            try {
                sentence = sentence.replace('\"', '\'');
                SolrDocumentList doclist = connector.getDocumentListByQuery("text_t:\"" + sentence + "\"", CollectionSchema.url_chars_i.getSolrFieldName() + " asc", 0, 100, CollectionSchema.sku.getSolrFieldName());
                int count = (int)doclist.getNumFound();
                if (count <= 0) continue;
                TreeSet<DigestURL> list2 = new TreeSet<DigestURL>();
                for (SolrDocument d : doclist) {
                    String string = (String)d.getFieldValue(CollectionSchema.sku.getSolrFieldName());
                    if (string == null || string.equals(url)) continue;
                    scores.inc(string);
                    try {
                        list2.add(new DigestURL(string, null));
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                sentenceOcc.put(sentence, list2);
            }
            catch (Throwable throwable) {}
        }
        sentences.clear();
        int i = 0;
        int sentenceNr = 0;
        for (Map.Entry se : sentenceOcc.entrySet()) {
            Set app = (Set)se.getValue();
            if (filter) {
                if (app != null && app.size() > 0) {
                    dd = new StringBuilder((String)se.getKey());
                    prop.put("sentences_" + i + "_dt", sentenceNr);
                    dd.append("<br/>appears in:");
                    for (DigestURL digestURL : app) {
                        if (digestURL == null) continue;
                        dd.append(" <a href=\"").append(digestURL.toNormalform(false)).append("\">").append(digestURL.getHost()).append("</a>");
                    }
                    prop.put("sentences_" + i + "_dd", dd.toString());
                    ++i;
                }
            } else {
                dd = new StringBuilder((String)se.getKey());
                prop.put("sentences_" + i + "_dt", sentenceNr);
                if (app != null && app.size() > 0) {
                    dd.append("<br/>appears in:");
                    for (DigestURL digestURL : app) {
                        if (digestURL == null) continue;
                        dd.append(" <a href=\"").append(digestURL.toNormalform(false)).append("\">").append(digestURL.getHost()).append("</a>");
                    }
                }
                prop.put("sentences_" + i + "_dd", dd.toString());
                ++i;
            }
            ++sentenceNr;
        }
        prop.put("sentences", i);
        i = 0;
        for (String u : scores.keyList(false)) {
            try {
                DigestURL uu2 = new DigestURL(u, null);
                prop.put("citations_" + i + "_dt", "<a href=\"" + u + "\">" + u + "</a>");
                dd = new StringBuilder();
                dd.append("makes ").append(Integer.toString(scores.get(u))).append(" citations: of ").append(url);
                for (Map.Entry entry2 : sentenceOcc.entrySet()) {
                    Set occurls = (Set)entry2.getValue();
                    if (occurls == null || !occurls.contains(uu2)) continue;
                    dd.append("<br/><a href=\"../solr/select?q=text_t:%22").append(((String)entry2.getKey()).replace('\"', '\'')).append("%22&rows=100&grep=&wt=grephtml\">").append((String)entry2.getKey()).append("</a>");
                }
                prop.put("citations_" + i + "_dd", dd.toString());
                ++i;
            }
            catch (MalformedURLException uu2) {}
        }
        prop.put("citations", i);
        i = 0;
        for (String u : scores.keyList(false)) {
            if (scores.get(u) < ch) continue;
            try {
                DigestURL uu = new DigestURL(u, null);
                if (uu.getOrganization().equals(uri.getOrganization())) continue;
                prop.put("similar_links_" + i + "_url", u);
                ++i;
            }
            catch (MalformedURLException malformedURLException) {}
        }
        prop.put("similar_links", i);
        prop.put("similar", i > 0 ? 1L : 0L);
        return prop;
    }
}

