/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.api.bookmarks.posts;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import net.yacy.cora.date.ISO8601Formatter;
import net.yacy.cora.order.Digest;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.data.BookmarksDB;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class get {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard switchboard = (Switchboard)env;
        boolean isAdmin = switchboard.verifyAuthentication(header);
        serverObjects prop = new serverObjects();
        String tag = null;
        if (post != null && post.containsKey("tag")) {
            tag = post.get("tag");
        }
        String date = post != null && post.containsKey("date") ? post.get("date") : ISO8601Formatter.FORMATTER.format();
        boolean extendedXML = post != null && post.containsKey("extendedXML");
        int count = 0;
        Date parsedDate = null;
        try {
            parsedDate = ISO8601Formatter.FORMATTER.parse(date, 0).getTime();
        }
        catch (ParseException e) {
            parsedDate = new Date();
        }
        List<String> bookmark_hashes = switchboard.bookmarksDB.getDate(Long.toString(parsedDate.getTime())).getBookmarkList();
        for (String bookmark_hash : bookmark_hashes) {
            BookmarksDB.Bookmark bookmark = switchboard.bookmarksDB.getBookmark(bookmark_hash);
            if (bookmark == null || !(ISO8601Formatter.FORMATTER.format(new Date(bookmark.getTimeStamp())).equals(date) && tag == null || bookmark.getTags().contains(tag) && isAdmin) && !bookmark.getPublic()) continue;
            prop.putHTML("posts_" + count + "_url", bookmark.getUrl());
            prop.putHTML("posts_" + count + "_title", bookmark.getTitle());
            prop.putHTML("posts_" + count + "_description", bookmark.getDescription());
            prop.put("posts_" + count + "_md5", Digest.encodeMD5Hex(bookmark.getUrl()));
            prop.put("posts_" + count + "_time", date);
            prop.putHTML("posts_" + count + "_tags", bookmark.getTagsString().replaceAll(",", " "));
            prop.put("posts_" + count + "_isExtended", extendedXML ? "1" : "0");
            if (extendedXML) {
                prop.put("posts_" + count + "_isExtended_private", Boolean.toString(!bookmark.getPublic()));
            }
            ++count;
        }
        prop.put("posts", count);
        return prop;
    }
}

