/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.api.bookmarks;

import java.util.Iterator;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.CommonPattern;
import net.yacy.data.BookmarkHelper;
import net.yacy.data.BookmarksDB;
import net.yacy.data.UserDB;
import net.yacy.http.servlets.YaCyDefaultServlet;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class get_folders {
    private static final serverObjects prop = new serverObjects();
    private static Switchboard sb = null;
    private static UserDB.Entry user = null;
    private static boolean isAdmin = false;

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        prop.clear();
        sb = (Switchboard)env;
        user = get_folders.sb.userDB.getUser(header);
        boolean bl = isAdmin = sb.verifyAuthentication(header) || user != null && user.hasRight(UserDB.AccessRight.BOOKMARK_RIGHT);
        String username = user != null ? user.getUserName() : (isAdmin ? "admin" : "unknown");
        prop.putHTML("display_user", username);
        prop.put("display_address", YaCyDefaultServlet.getContext(header, sb));
        prop.put("display_peer", get_folders.sb.peers.mySeed().getName());
        String root = "/";
        String[] foldername = null;
        if (post != null && post.containsKey("root")) {
            root = post.get("root").equals("source") || post.get("root").equals("") ? "/" : (post.get("root").startsWith("/") ? post.get("root") : "/" + post.get("root"));
        }
        Iterator<String> it = null;
        it = BookmarkHelper.getFolderList(root, get_folders.sb.bookmarksDB.getTagIterator(isAdmin));
        int n = CommonPattern.SLASH.split(root, 0).length;
        if (n == 0) {
            n = 1;
        }
        int count = 0;
        while (it.hasNext()) {
            String folder = it.next();
            foldername = CommonPattern.SLASH.split(folder, 0);
            if (foldername.length != n + 1) continue;
            prop.put("folders_" + count + "_foldername", foldername[n]);
            prop.put("folders_" + count + "_expanded", "false");
            prop.put("folders_" + count + "_type", "folder");
            prop.put("folders_" + count + "_hash", folder);
            prop.put("folders_" + count + "_url", "");
            prop.put("folders_" + count + "_hasChildren", "true");
            prop.put("folders_" + count + "_comma", ",");
            ++count;
        }
        it = get_folders.sb.bookmarksDB.getBookmarksIterator(root, isAdmin);
        while (it.hasNext()) {
            BookmarksDB.Bookmark bm = get_folders.sb.bookmarksDB.getBookmark(it.next());
            if (bm == null) continue;
            if (post.containsKey("bmtype")) {
                if (post.get("bmtype").equals("title")) {
                    prop.put("folders_" + count + "_foldername", bm.getTitle());
                } else if (post.get("bmtype").equals("href")) {
                    prop.put("folders_" + count + "_foldername", "<a href='" + bm.getUrl() + " 'target='_blank'>" + bm.getTitle() + "</a>");
                } else {
                    prop.put("folders_" + count + "_foldername", bm.getUrl());
                }
            }
            prop.put("folders_" + count + "_expanded", "false");
            prop.put("folders_" + count + "_url", bm.getUrl());
            prop.put("folders_" + count + "_type", "file");
            prop.put("folders_" + count + "_hash", bm.getUrlHash());
            prop.put("folders_" + count + "_hasChildren", "false");
            prop.put("folders_" + count + "_comma", ",");
            ++count;
        }
        prop.put("folders_" + --count + "_comma", "");
        prop.put("folders", ++count);
        return prop;
    }
}

