/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.api.bookmarks;

import java.util.Date;
import java.util.Iterator;
import net.yacy.cora.date.ISO8601Formatter;
import net.yacy.cora.protocol.HeaderFramework;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.data.BookmarkHelper;
import net.yacy.data.BookmarksDB;
import net.yacy.data.UserDB;
import net.yacy.document.parser.html.CharacterCoding;
import net.yacy.http.servlets.YaCyDefaultServlet;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class get_bookmarks {
    private static final serverObjects prop = new serverObjects();
    private static Switchboard sb = null;
    private static UserDB.Entry user = null;
    private static boolean isAdmin = false;
    private static int R = 1;
    private static final int MAXRESULTS = 10000;

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        int display;
        String qtype;
        String query2;
        int page;
        int itemsPerPage;
        prop.clear();
        sb = (Switchboard)env;
        user = get_bookmarks.sb.userDB.getUser(header);
        boolean bl = isAdmin = sb.verifyAuthentication(header) || user != null && user.hasRight(UserDB.AccessRight.BOOKMARK_RIGHT);
        String username = user != null ? user.getUserName() : (isAdmin ? "admin" : "unknown");
        prop.putHTML("display_user", username);
        prop.put("display_address", YaCyDefaultServlet.getContext(header, sb));
        prop.put("display_peer", get_bookmarks.sb.peers.mySeed().getName());
        if (post != null) {
            String d;
            itemsPerPage = post.containsKey("rp") ? post.getInt("rp", 10000) : 10000;
            page = post.containsKey("page") ? post.getInt("page", 1) : 1;
            query2 = post.containsKey("query") ? post.get("query", "") : "";
            String string = qtype = post.containsKey("qtype") ? post.get("qtype", "") : "";
            display = post.containsKey("display") ? ("flexigrid".equals(d = post.get("display")) || "1".equals(d) ? DisplayType.FLEXIGRID.getValue() : ("xbel".equals(d) || "2".equals(d) ? DisplayType.XBEL.getValue() : ("rss".equals(d) || "3".equals(d) ? DisplayType.RSS.getValue() : DisplayType.XML.getValue()))) : DisplayType.XML.getValue();
            prop.put("display", display);
        } else {
            query2 = "";
            qtype = "";
            page = 1;
            itemsPerPage = 10000;
            display = DisplayType.XML.getValue();
        }
        int count = 0;
        int total = 0;
        int start = 0;
        if (display == DisplayType.XBEL.getValue()) {
            String root = "/";
            if ("tags".equals(qtype) && !"".equals(query2)) {
                prop.putHTML("display_folder", "1");
                prop.putHTML("display_folder_foldername", query2);
                prop.putHTML("display_folder_folderhash", BookmarkHelper.tagHash(query2));
                Iterator<String> it = get_bookmarks.sb.bookmarksDB.getBookmarksIterator(query2, isAdmin);
                count = get_bookmarks.print_XBEL(it, count);
                prop.put("display_xbel", count);
            } else if (query2.length() > 0 && "folders".equals(qtype)) {
                root = query2.charAt(0) == '/' ? query2 : "/" + query2;
            }
            prop.putHTML("display_folder", "0");
            R = root.replaceAll("[^/]", "").length() - 1;
            count = get_bookmarks.recurseFolders(BookmarkHelper.getFolderList(root, get_bookmarks.sb.bookmarksDB.getTagIterator(isAdmin)), root, 0, true, "");
            prop.put("display_xbel", count);
        } else {
            Iterator<String> it = "tags".equals(qtype) && !"".equals(query2) && !"/".equals(query2) ? get_bookmarks.sb.bookmarksDB.getBookmarksIterator(query2, isAdmin) : get_bookmarks.sb.bookmarksDB.getBookmarksIterator(isAdmin);
            if (itemsPerPage < 10000) {
                if (page > 1) {
                    start = (page - 1) * itemsPerPage + 1;
                }
                for (count = 0; count < start && it.hasNext(); ++count) {
                    it.next();
                }
                total += count;
            }
            count = 0;
            while (count < itemsPerPage && it.hasNext()) {
                BookmarksDB.Bookmark bookmark = get_bookmarks.sb.bookmarksDB.getBookmark(it.next());
                if (bookmark == null) continue;
                prop.put("display_bookmarks_" + count + "_id", count);
                prop.put("display_bookmarks_" + count + "_link", bookmark.getUrl());
                prop.put("display_bookmarks_" + count + "_date", ISO8601Formatter.FORMATTER.format(new Date(bookmark.getTimeStamp())));
                prop.put("display_bookmarks_" + count + "_rfc822date", HeaderFramework.formatRFC1123(new Date(bookmark.getTimeStamp())));
                prop.put("display_bookmarks_" + count + "_public", bookmark.getPublic() ? "0" : "1");
                prop.put("display_bookmarks_" + count + "_hash", bookmark.getUrlHash());
                prop.put("display_bookmarks_" + count + "_comma", ",");
                prop.putHTML("display_bookmarks_" + count + "_title-html", bookmark.getTitle());
                prop.putHTML("display_bookmarks_" + count + "_desc-html", bookmark.getDescription());
                prop.putHTML("display_bookmarks_" + count + "_tags-html", bookmark.getTagsString().replaceAll(",", ", "));
                prop.putHTML("display_bookmarks_" + count + "_folders-html", bookmark.getFoldersString());
                prop.putXML("display_bookmarks_" + count + "_title-xml", bookmark.getTitle());
                prop.putXML("display_bookmarks_" + count + "_desc-xml", bookmark.getDescription());
                prop.putXML("display_bookmarks_" + count + "_tags-xml", bookmark.getTagsString());
                prop.putXML("display_bookmarks_" + count + "_folders-xml", bookmark.getFoldersString());
                prop.put("display_bookmarks_" + count + "_title", bookmark.getTitle());
                prop.put("display_bookmarks_" + count + "_desc", bookmark.getDescription());
                prop.put("display_bookmarks_" + count + "_tags", bookmark.getTagsString());
                prop.put("display_bookmarks_" + count + "_folders", bookmark.getFoldersString());
                ++count;
            }
            prop.put("display_bookmarks_" + (itemsPerPage - 1) + "_comma", "");
            prop.put("display_bookmarks", count);
            while (it.hasNext()) {
                it.next();
                ++count;
            }
            prop.put("display_page", page);
            prop.put("display_total", total += count);
        }
        return prop;
    }

    private static int recurseFolders(Iterator<String> it, String root, int count, boolean next, String prev) {
        String fn = "";
        fn = next ? it.next() : prev;
        if ("\uffff".equals(fn)) {
            for (int i = prev.replaceAll("[^/]", "").length() - R; i > 0; --i) {
                prop.put("display_xbel_" + count + "_elements", "</folder>");
                ++count;
            }
            return count;
        }
        if (fn.startsWith("/".equals(root) ? root : root + "/")) {
            prop.put("display_xbel_" + count + "_elements", "<folder id=\"" + BookmarkHelper.tagHash(fn) + "\">");
            String title = fn;
            prop.put("display_xbel_" + ++count + "_elements", "<title>" + CharacterCoding.unicode2xml(title.replaceAll("(/.[^/]*)*/", ""), true) + "</title>");
            ++count;
            Iterator<String> bit = get_bookmarks.sb.bookmarksDB.getBookmarksIterator(fn, isAdmin);
            count = get_bookmarks.print_XBEL(bit, count);
            if (it.hasNext()) {
                count = get_bookmarks.recurseFolders(it, fn, count, true, fn);
            }
        } else {
            if (count > 0) {
                prop.put("display_xbel_" + count + "_elements", "</folder>");
                ++count;
            }
            if ("".equals(root = root.replaceAll("(/.[^/]*$)", ""))) {
                root = "/";
            }
            count = get_bookmarks.recurseFolders(it, root, count, false, fn);
        }
        return count;
    }

    private static int print_XBEL(Iterator<String> bit, int count) {
        while (bit.hasNext()) {
            BookmarksDB.Bookmark bookmark = get_bookmarks.sb.bookmarksDB.getBookmark(bit.next());
            if (bookmark == null) continue;
            Date date = new Date(bookmark.getTimeStamp());
            prop.put("display_xbel_" + count + "_elements", "<bookmark id=\"" + bookmark.getUrlHash() + "\" href=\"" + CharacterCoding.unicode2xml(bookmark.getUrl(), true) + "\" added=\"" + CharacterCoding.unicode2xml(ISO8601Formatter.FORMATTER.format(date), true) + "\">");
            prop.put("display_xbel_" + ++count + "_elements", "<title>");
            prop.putXML("display_xbel_" + ++count + "_elements", bookmark.getTitle());
            prop.put("display_xbel_" + ++count + "_elements", "</title>");
            prop.put("display_xbel_" + ++count + "_elements", "<info>");
            prop.put("display_xbel_" + ++count + "_elements", "<metadata owner=\"Mozilla\" ShortcutURL=\"" + CharacterCoding.unicode2xml(bookmark.getTagsString().replaceAll("/.*,", "").toLowerCase(), true) + "\"/>");
            prop.put("display_xbel_" + ++count + "_elements", "<metadata owner=\"YaCy\" public=\"" + Boolean.toString(bookmark.getPublic()) + "\"/>");
            prop.put("display_xbel_" + ++count + "_elements", "</info>");
            prop.put("display_xbel_" + ++count + "_elements", "<desc>");
            prop.putXML("display_xbel_" + ++count + "_elements", bookmark.getDescription());
            prop.put("display_xbel_" + ++count + "_elements", "</desc>");
            prop.put("display_xbel_" + ++count + "_elements", "</bookmark>");
            ++count;
        }
        return count;
    }

    private static enum DisplayType {
        XML(0),
        XHTML(0),
        JSON(0),
        FLEXIGRID(1),
        XBEL(2),
        RSS(3),
        RDF(4);

        private final int value;

        private DisplayType(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }
}

