/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.TransactionManager;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.server.servletProperties;
import net.yacy.utils.translation.TranslationManager;

public class Translator_p {
    public static servletProperties respond(RequestHeader requestHeader, serverObjects post, serverSwitch env) {
        try {
            servletProperties prop = new servletProperties();
            Switchboard sb = (Switchboard)env;
            String langcfg = sb.getConfig("locale.language", "default");
            prop.put("targetlang", langcfg);
            if ("default".equals(langcfg) || "browser".equals(langcfg)) {
                prop.put("errmsg", 1L);
                return prop;
            }
            prop.put("errmsg", 0L);
            File localesFolder = sb.getAppPath("locale.source", "locales");
            File lngfile = new File(localesFolder, langcfg + ".lng");
            TranslationManager localTransMgr = new TranslationManager();
            File masterxlf = new File(localesFolder, "master.lng.xlf");
            if (!masterxlf.exists()) {
                localTransMgr.createMasterTranslationLists(localesFolder, masterxlf);
            }
            Map<String, Map<String, String>> origTrans = localTransMgr.joinMasterTranslationLists(masterxlf, lngfile);
            File locallngfile = localTransMgr.getScratchFile(lngfile);
            Map<String, Map<String, String>> localTrans = localTransMgr.loadTranslationsLists(locallngfile);
            int i = 0;
            if (origTrans.size() > 0) {
                boolean filteruntranslated;
                String filename = origTrans.keySet().iterator().next();
                if (post != null && post.containsKey("sourcefile")) {
                    filename = post.get("sourcefile", filename);
                }
                Iterator<String> filenameit = origTrans.keySet().iterator();
                boolean bl = filteruntranslated = post == null ? false : post.getBoolean("filteruntranslated");
                while (filenameit.hasNext()) {
                    String tmp = filenameit.next();
                    if (filteruntranslated) {
                        Map<String, String> tmptrans = origTrans.get(tmp);
                        boolean hasuntrans = false;
                        for (String string : tmptrans.values()) {
                            if (string != null && !string.isEmpty()) continue;
                            hasuntrans = true;
                            break;
                        }
                        if (!hasuntrans) continue;
                    }
                    prop.put("filelist_" + i + "_filename", tmp);
                    prop.put("filelist_" + i + "_selected", tmp.equals(filename));
                    ++i;
                }
                prop.put("filelist", i);
                prop.add("sourcefile", filename);
                Map<String, String> origTextList = origTrans.get(filename);
                i = 0;
                boolean editapproved = false;
                int textlistid = -1;
                if (post != null) {
                    prop.put("filter.checked", filteruntranslated);
                    textlistid = post.getInt("approve", -1);
                    if (post.containsKey("editapproved")) {
                        textlistid = post.getInt("editapproved", -1);
                        editapproved = true;
                    }
                }
                boolean changed = false;
                for (String sourcetext : origTextList.keySet()) {
                    boolean existinlocalTrans;
                    String targettxt = origTextList.get(sourcetext);
                    boolean bl2 = existinlocalTrans = localTrans.containsKey(filename) && localTrans.get(filename).containsKey(sourcetext);
                    if (editapproved) {
                        existinlocalTrans |= i == textlistid;
                    }
                    if (targettxt == null || targettxt.isEmpty() || existinlocalTrans) {
                        prop.put("textlist_" + i + "_filteruntranslated", true);
                    } else if (filteruntranslated) continue;
                    if (i == textlistid && post != null) {
                        TransactionManager.checkPostTransaction(requestHeader, post);
                        if (editapproved) {
                            localTransMgr.addTranslation(localTrans, filename, sourcetext, targettxt);
                        } else {
                            String t = post.get("targettxt" + Integer.toString(textlistid));
                            if (!t.isEmpty()) {
                                if (sourcetext.startsWith(">") && !t.startsWith(">")) {
                                    t = ">" + t;
                                }
                                if (sourcetext.endsWith("<") && !t.endsWith("<")) {
                                    t = t + "<";
                                }
                            }
                            targettxt = t;
                            origTextList.put(sourcetext, targettxt);
                            changed = localTransMgr.addTranslation(localTrans, filename, sourcetext, targettxt);
                        }
                    }
                    prop.putHTML("textlist_" + i + "_sourcetxt", sourcetext);
                    prop.putHTML("textlist_" + i + "_targettxt", targettxt);
                    prop.put("textlist_" + i + "_tokenid", Integer.toString(i));
                    prop.put("textlist_" + i + "_filteruntranslated_tokenid", Integer.toString(i));
                    ++i;
                }
                if (post != null && post.containsKey("savetranslationlist")) {
                    changed = true;
                }
                if (changed) {
                    TransactionManager.checkPostTransaction(requestHeader, post);
                    localTransMgr.saveAsLngFile(langcfg, locallngfile, localTrans);
                    String string = env.getConfig("htRootPath", "htroot");
                    File sourceDir = new File(env.getAppPath(), string);
                    File destDir = new File(env.getDataPath("locale.translated_html", "DATA/LOCALE/htroot"), locallngfile.getName().substring(0, locallngfile.getName().length() - 4));
                    File sourceFile = new File(sourceDir, filename);
                    File destFile = new File(destDir, filename);
                    localTransMgr.translateFile(sourceFile, destFile, origTextList);
                }
            }
            prop.put("transactionToken", TransactionManager.getTransactionToken(requestHeader));
            prop.put("textlist", i);
            return prop;
        }
        catch (IOException ex) {
            ConcurrentLog.logException(ex);
            return null;
        }
    }
}

