/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.net.MalformedURLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.sorting.ConcurrentScoreMap;
import net.yacy.cora.sorting.ScoreMap;
import net.yacy.kelondro.index.Row;
import net.yacy.peers.NewsDB;
import net.yacy.peers.Seed;
import net.yacy.repository.Blacklist;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.utils.crypt;
import net.yacy.utils.nxTools;

public class Surftips {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        boolean authenticated = sb.adminAuthenticated(header) >= 2;
        int display = post == null || !authenticated ? 0 : post.getInt("display", 0);
        prop.put("display", display);
        boolean showScore = post != null && post.containsKey("score");
        boolean publicPage = sb.getConfigBool("publicSurftips", true);
        boolean authorizedAccess = sb.verifyAuthentication(header);
        if (post != null && post.containsKey("publicPage")) {
            if (!authorizedAccess) {
                prop.authenticationRequired();
                return prop;
            }
            publicPage = post.get("publicPage", "0").equals("1");
            sb.setConfig("publicSurftips", publicPage);
        }
        prop.put("surftips_publicSurftips", publicPage);
        if (publicPage || authorizedAccess) {
            HashMap<String, String> map;
            String hash;
            if (post != null && (hash = post.get("voteNegative", null)) != null) {
                if (!sb.verifyAuthentication(header)) {
                    prop.authenticationRequired();
                    return prop;
                }
                if (sb.isRobinsonMode()) {
                    map = new HashMap();
                    map.put("urlhash", hash);
                    map.put("vote", "negative");
                    map.put("refid", post.get("refid", ""));
                    sb.peers.newsPool.publishMyNews(sb.peers.mySeed(), "stippavt", map);
                }
            }
            if (post != null && (hash = post.get("votePositive", null)) != null) {
                if (!sb.verifyAuthentication(header)) {
                    prop.authenticationRequired();
                    return prop;
                }
                map = new HashMap<String, String>();
                map.put("urlhash", hash);
                map.put("url", crypt.simpleDecode(post.get("url", "")));
                map.put("title", crypt.simpleDecode(post.get("title", "")));
                map.put("description", crypt.simpleDecode(post.get("description", "")));
                map.put("vote", "positive");
                map.put("refid", post.get("refid", ""));
                map.put("comment", post.get("comment", ""));
                sb.peers.newsPool.publishMyNews(sb.peers.mySeed(), "stippavt", map);
            }
            HashMap<String, Integer> negativeHashes = new HashMap<String, Integer>();
            HashMap<String, Integer> positiveHashes = new HashMap<String, Integer>();
            Surftips.accumulateVotes(sb, negativeHashes, positiveHashes, 0);
            ConcurrentScoreMap<String> ranking = new ConcurrentScoreMap<String>();
            Row rowdef = new Row("String url-255, String title-120, String description-120, String refid-" + ("yyyyMMddHHmmss".length() + 12), NaturalOrder.naturalOrder);
            HashMap<String, Row.Entry> surftips = new HashMap<String, Row.Entry>();
            Surftips.accumulateSurftips(sb, surftips, ranking, rowdef, negativeHashes, positiveHashes, 0);
            Iterator k = ranking.keys(false);
            int i = 0;
            while (k.hasNext()) {
                Row.Entry row;
                String urlhash = (String)k.next();
                if (urlhash == null || (row = surftips.get(urlhash)) == null) continue;
                String url = row.getPrimaryKeyUTF8().trim();
                try {
                    if (Switchboard.urlBlacklist.isListed(Blacklist.BlacklistType.SURFTIPS, new DigestURL(url))) {
                    }
                }
                catch (MalformedURLException e) {}
                continue;
                String title = row.getColUTF8(1);
                String description = row.getColUTF8(2);
                if (url == null || title == null || description == null) continue;
                String refid = row.getColUTF8(3);
                boolean voted = sb.peers.newsPool.getSpecific(2, "stippavt", "refid", refid) != null || sb.peers.newsPool.getSpecific(3, "stippavt", "refid", refid) != null;
                prop.put("surftips_results_" + i + "_authorized", authenticated ? "1" : "0");
                prop.put("surftips_results_" + i + "_authorized_recommend", voted ? "0" : "1");
                prop.put("surftips_results_" + i + "_authorized_recommend_urlhash", urlhash);
                prop.put("surftips_results_" + i + "_authorized_recommend_refid", refid);
                prop.put("surftips_results_" + i + "_authorized_recommend_url", crypt.simpleEncode(url, null, 'b'));
                prop.put("surftips_results_" + i + "_authorized_recommend_title", crypt.simpleEncode(title, null, 'b'));
                prop.put("surftips_results_" + i + "_authorized_recommend_description", crypt.simpleEncode(description, null, 'b'));
                prop.put("surftips_results_" + i + "_authorized_recommend_display", display);
                prop.put("surftips_results_" + i + "_authorized_recommend_showScore", showScore ? "1" : "0");
                prop.putXML("surftips_results_" + i + "_authorized_urlhash", urlhash);
                prop.putXML("surftips_results_" + i + "_url", url);
                prop.putXML("surftips_results_" + i + "_urlname", nxTools.shortenURLString(url, 60));
                prop.putXML("surftips_results_" + i + "_urlhash", urlhash);
                prop.putXML("surftips_results_" + i + "_title", showScore ? "(" + ranking.get(urlhash) + ") " + title : title);
                prop.putHTML("surftips_results_" + i + "_description", description);
                if (++i < 50) continue;
            }
            prop.put("surftips_results", i);
            prop.put("surftips", "1");
        } else {
            prop.put("surftips", "0");
        }
        return prop;
    }

    private static int timeFactor(Date created) {
        return (int)Math.max(0L, 10L - (System.currentTimeMillis() - created.getTime()) / 24L / 60L / 60L / 1000L);
    }

    private static void accumulateVotes(Switchboard sb, HashMap<String, Integer> negativeHashes, HashMap<String, Integer> positiveHashes, int dbtype) {
        int maxCount = Math.min(1000, sb.peers.newsPool.size(dbtype));
        Iterator<NewsDB.Record> recordIterator = sb.peers.newsPool.recordIterator(dbtype);
        int j = 0;
        while (recordIterator.hasNext() && j++ < maxCount) {
            Integer i;
            int factor;
            NewsDB.Record record = recordIterator.next();
            if (record == null || !record.category().equals("stippavt")) continue;
            String urlhash = record.attribute("urlhash", "");
            String vote = record.attribute("vote", "");
            int n = factor = dbtype == 2 || dbtype == 3 ? 2 : 1;
            if (vote.equals("negative")) {
                i = negativeHashes.get(urlhash);
                if (i == null) {
                    negativeHashes.put(urlhash, factor);
                } else {
                    negativeHashes.put(urlhash, i + factor);
                }
            }
            if (!vote.equals("positive")) continue;
            i = positiveHashes.get(urlhash);
            if (i == null) {
                positiveHashes.put(urlhash, factor);
                continue;
            }
            positiveHashes.put(urlhash, i + factor);
        }
    }

    private static void accumulateSurftips(Switchboard sb, HashMap<String, Row.Entry> surftips, ScoreMap<String> ranking, Row rowdef, HashMap<String, Integer> negativeHashes, HashMap<String, Integer> positiveHashes, int dbtype) {
        int maxCount = Math.min(1000, sb.peers.newsPool.size(dbtype));
        Iterator<NewsDB.Record> recordIterator = sb.peers.newsPool.recordIterator(dbtype);
        int j = 0;
        String url = "";
        int score = 0;
        while (recordIterator.hasNext() && j++ < maxCount) {
            String urlhash;
            Set<String> ips;
            Seed seed;
            NewsDB.Record record = recordIterator.next();
            if (record == null) continue;
            Row.Entry entry2 = null;
            if (record.category().equals("crwlstrt")) {
                String intention = record.attribute("intention", "");
                url = record.attribute("startURL", "");
                if (url.length() < 12) continue;
                entry2 = rowdef.newEntry(new byte[][]{url.getBytes(), (intention.isEmpty() || intention.equals("simple web crawl") || intention.equals("Automatic ReCrawl!") ? record.attribute("startURL", "") : intention).getBytes(), intention.equals("Automatic ReCrawl!") ? UTF8.getBytes("Automatic ReCrawl") : UTF8.getBytes("Crawl Start Point"), record.id().getBytes()});
                score = 2 + Math.min(10, intention.length() / 4) + Surftips.timeFactor(record.created());
            }
            if (record.category().equals("bkmrkadd")) {
                url = record.attribute("url", "");
                if (url.length() < 12) continue;
                entry2 = rowdef.newEntry(new byte[][]{url.getBytes(), UTF8.getBytes(record.attribute("title", "")), UTF8.getBytes("Bookmark: " + record.attribute("description", "")), record.id().getBytes()});
                score = 8 + Surftips.timeFactor(record.created());
            }
            if (record.category().equals("stippadd")) {
                url = record.attribute("url", "");
                if (url.length() < 12) continue;
                entry2 = rowdef.newEntry(new byte[][]{url.getBytes(), UTF8.getBytes(record.attribute("title", "")), UTF8.getBytes("Surf Tipp: " + record.attribute("description", "")), record.id().getBytes()});
                score = 5 + Surftips.timeFactor(record.created());
            }
            if (record.category().equals("stippavt")) {
                if (!record.attribute("vote", "negative").equals("positive") || (url = record.attribute("url", "")).length() < 12) continue;
                entry2 = rowdef.newEntry(new byte[][]{url.getBytes(), UTF8.getBytes(record.attribute("title", "")), UTF8.getBytes(record.attribute("description", "")), UTF8.getBytes(record.attribute("refid", ""))});
                score = 5 + Surftips.timeFactor(record.created());
            }
            if (record.category().equals("wiki_upd")) {
                seed = sb.peers.getConnected(record.originator());
                if (seed == null) {
                    seed = sb.peers.getDisconnected(record.originator());
                }
                if (seed != null && !(ips = seed.getIPs()).isEmpty()) {
                    url = seed.getPublicURL(ips.iterator().next(), false) + "/Wiki.html?page=" + record.attribute("page", "");
                    entry2 = rowdef.newEntry(new byte[][]{UTF8.getBytes(url), UTF8.getBytes(record.attribute("author", "Anonymous") + ": " + record.attribute("page", "")), UTF8.getBytes("Wiki Update: " + record.attribute("description", "")), UTF8.getBytes(record.id())});
                    score = 4 + Surftips.timeFactor(record.created());
                }
            }
            if (record.category().equals("blog_add")) {
                seed = sb.peers.getConnected(record.originator());
                if (seed == null) {
                    seed = sb.peers.getDisconnected(record.originator());
                }
                if (seed != null && !(ips = seed.getIPs()).isEmpty()) {
                    url = seed.getPublicURL(ips.iterator().next(), false) + "/Blog.html?page=" + record.attribute("page", "");
                    entry2 = rowdef.newEntry(new byte[][]{UTF8.getBytes(url), UTF8.getBytes(record.attribute("author", "Anonymous") + ": " + record.attribute("page", "")), UTF8.getBytes("Blog Entry: " + record.attribute("subject", "")), UTF8.getBytes(record.id())});
                    score = 4 + Surftips.timeFactor(record.created());
                }
            }
            if (entry2 == null) continue;
            try {
                urlhash = UTF8.String(new DigestURL(url).hash());
            }
            catch (MalformedURLException e) {
                urlhash = null;
            }
            if (urlhash == null) {
                try {
                    urlhash = UTF8.String(new DigestURL("http://" + url).hash());
                }
                catch (MalformedURLException e) {
                    urlhash = null;
                }
            }
            if (urlhash == null) {
                System.out.println("Surftips: bad url '" + url + "' from news record " + record.toString());
                continue;
            }
            Integer vote = negativeHashes.get(urlhash);
            if (vote != null) {
                score = Math.max(0, score - vote);
            }
            if ((vote = positiveHashes.get(urlhash)) != null) {
                score += 2 * vote;
            }
            if (surftips.containsKey(urlhash)) {
                ranking.inc(urlhash, score);
                continue;
            }
            ranking.set(urlhash, score);
            surftips.put(urlhash, entry2);
        }
    }
}

