/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.TransactionManager;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.peers.operation.yacyRelease;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class Steering {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch ss) {
        if (post == null || post.isEmpty() || ss == null) {
            serverObjects prop = new serverObjects();
            if (ss != null && ((Switchboard)ss).verifyAuthentication(header)) {
                prop.put("transactionToken", TransactionManager.getTransactionToken(header));
                prop.put("info_transactionToken", TransactionManager.getTransactionToken(header));
            } else {
                prop.authenticationRequired();
            }
            return prop;
        }
        Switchboard sb = (Switchboard)ss;
        serverObjects prop = new serverObjects();
        prop.put("info", "0");
        String requestIP = post.get("CLIENTIP", "localhost");
        if (!sb.verifyAuthentication(header)) {
            ConcurrentLog.info("STEERING", "log-in attempt for steering from " + requestIP);
            prop.authenticationRequired();
            return prop;
        }
        if (post.containsKey("shutdown")) {
            TransactionManager.checkPostTransaction(header, post);
            ConcurrentLog.info("STEERING", "shutdown request from " + requestIP);
            sb.terminate(10L, "shutdown request from Steering; ip = " + requestIP);
            prop.put("info", "3");
            return prop;
        }
        if (post.containsKey("restart")) {
            TransactionManager.checkPostTransaction(header, post);
            ConcurrentLog.info("STEERING", "restart request from " + requestIP);
            yacyRelease.restart();
            prop.put("info", "4");
            return prop;
        }
        if (post.containsKey("update")) {
            TransactionManager.checkPostTransaction(header, post);
            ConcurrentLog.info("STEERING", "update request from " + requestIP);
            boolean devenvironment = new File(sb.getAppPath(), ".git").exists();
            String releaseFileName = post.get("releaseinstall", "");
            File releaseFile = new File(sb.releasePath, releaseFileName);
            if (FileUtils.isInDirectory(releaseFile, sb.releasePath)) {
                if (!devenvironment && releaseFileName.length() > 0 && releaseFile.exists()) {
                    if (yacyRelease.deployRelease(releaseFile)) {
                        prop.put("info", "5");
                        prop.putHTML("info_release", releaseFileName);
                    } else {
                        prop.put("info", "7");
                        prop.putHTML("info_release", releaseFileName);
                    }
                } else {
                    prop.put("info", "8");
                }
            } else {
                prop.put("info", "6");
            }
            return prop;
        }
        return prop;
    }
}

