/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.data.TransactionManager;
import net.yacy.http.InetPathAccessHandler;
import net.yacy.kelondro.util.Formatter;
import net.yacy.peers.Network;
import net.yacy.peers.Seed;
import net.yacy.peers.operation.yacySeedUploader;
import net.yacy.search.Switchboard;
import net.yacy.search.query.SearchEventCache;
import net.yacy.search.snippet.TextSnippet;
import net.yacy.server.serverCore;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class SettingsAck_p {
    private static boolean nothingChanged = false;

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        serverObjects prop = new serverObjects();
        Switchboard sb = (Switchboard)env;
        prop.put("needsRestart_referer", "Settings_p.html");
        prop.put("needsRestart", false);
        if (post == null) {
            prop.put("info", "1");
            return prop;
        }
        TransactionManager.checkPostTransaction(header, post);
        if (post.containsKey("adminaccount")) {
            String user = post.get("adminuser");
            String pw1 = post.get("adminpw1");
            String pw2 = post.get("adminpw2");
            if (user == null || pw1 == null || pw2 == null) {
                prop.put("info", "1");
                return prop;
            }
            if (user.isEmpty()) {
                prop.put("info", "2");
                return prop;
            }
            if (!pw1.equals(pw2)) {
                prop.put("info", "3");
                return prop;
            }
            env.setConfig("adminAccountBase64MD5", sb.encodeDigestAuth(user, pw1));
            env.setConfig("adminAccountUserName", user);
            prop.put("info", "5");
            prop.putHTML("info_user", user);
            return prop;
        }
        if (post.containsKey("proxyaccount")) {
            boolean useProxyAccounts;
            prop.put("needsRestart_referer", "Settings_p.html?page=ProxyAccess");
            prop.put("info_port", env.getLocalPort());
            prop.put("info_restart", "0");
            String filter = post.get("proxyfilter").trim();
            boolean bl = useProxyAccounts = post.containsKey("use_proxyaccounts") && post.get("use_proxyaccounts").equals("on");
            if (filter == null) {
                prop.put("info", "1");
                return prop;
            }
            if (filter.isEmpty()) {
                filter = "*";
            } else if (!filter.equals("*")) {
                int patternCount = 0;
                String patternStr = null;
                try {
                    StringTokenizer st = new StringTokenizer(filter, ",");
                    while (st.hasMoreTokens()) {
                        ++patternCount;
                        patternStr = st.nextToken();
                        Pattern.compile(patternStr);
                    }
                }
                catch (PatternSyntaxException e) {
                    prop.put("info", "27");
                    prop.putHTML("info_filter", filter);
                    prop.put("info_nr", patternCount);
                    prop.putHTML("info_error", e.getMessage());
                    prop.putHTML("info_pattern", patternStr);
                    return prop;
                }
            }
            env.setConfig("proxyClient", filter);
            env.setConfig("use_proxyAccounts", useProxyAccounts);
            if (!useProxyAccounts) {
                prop.put("info", "6");
                prop.putHTML("info_filter", filter);
            } else {
                prop.put("info", "7");
                prop.putHTML("info_filter", filter);
            }
            return prop;
        }
        if (post.containsKey("httpNetworking")) {
            prop.put("needsRestart_referer", "Settings_p.html?page=ProxyAccess");
            boolean isTransparentProxy = post.containsKey("isTransparentProxy");
            env.setConfig("isTransparentProxy", isTransparentProxy);
            prop.put("info_isTransparentProxy", isTransparentProxy ? "on" : "off");
            if (isTransparentProxy) {
                prop.put("needsRestart", isTransparentProxy);
            }
            boolean proxyAlwaysFresh = post.containsKey("proxyAlwaysFresh");
            env.setConfig("proxyAlwaysFresh", proxyAlwaysFresh);
            prop.put("info_proxyAlwaysFresh", proxyAlwaysFresh ? "on" : "off");
            env.setConfig("proxy.sendViaHeader", post.containsKey("proxy.sendViaHeader"));
            prop.put("info_proxy.sendViaHeader", post.containsKey("proxy.sendViaHeader") ? "on" : "off");
            env.setConfig("proxy.sendXForwardedForHeader", post.containsKey("proxy.sendXForwardedForHeader"));
            prop.put("info_proxy.sendXForwardedForHeader", post.containsKey("proxy.sendXForwardedForHeader") ? "on" : "off");
            prop.put("info", "20");
            return prop;
        }
        if (post.containsKey("serveraccount")) {
            String error;
            String staticIP;
            prop.put("needsRestart_referer", "Settings_p.html?page=ServerAccess");
            String fileHost = post.get("fileHost").trim();
            if (fileHost != null && !fileHost.isEmpty() && !fileHost.equals(env.getConfig("fileHost", "localpeer"))) {
                env.setConfig("fileHost", fileHost);
            }
            if ((staticIP = post.get("staticIP").trim()).startsWith("http://")) {
                staticIP = staticIP.length() > 7 ? staticIP.substring(7) : "";
            } else if (staticIP.startsWith("https://")) {
                staticIP = staticIP.length() > 8 ? staticIP.substring(8) : "";
            }
            String string = error = Seed.isProperIP(staticIP) ? null : "ip not proper: " + staticIP;
            if (error == null) {
                serverCore.useStaticIP = true;
                sb.peers.mySeed().setIP(staticIP);
                env.setConfig("staticIP", staticIP);
            } else {
                serverCore.useStaticIP = false;
                sb.peers.mySeed().setIP("");
                env.setConfig("staticIP", "");
            }
            String publicPort = post.get("publicPort").trim();
            try {
                Integer pport = Integer.parseInt(publicPort);
                if (pport < 65535 && pport >= 0) {
                    serverCore.usePublicPort = true;
                    sb.peers.mySeed().setPort(pport);
                    env.setConfig("publicPort", publicPort);
                }
            }
            catch (NumberFormatException pport) {
                // empty catch block
            }
            String filter = post.get("serverfilter").trim();
            if (filter == null) {
                prop.put("info", "1");
                return prop;
            }
            if (filter.isEmpty()) {
                filter = "*";
            } else if (!filter.equals("*")) {
                int patternCount = 0;
                String patternStr = null;
                StringTokenizer st = new StringTokenizer(filter, ",");
                try {
                    while (st.hasMoreTokens()) {
                        ++patternCount;
                        patternStr = st.nextToken();
                        InetPathAccessHandler.checkPattern(patternStr);
                    }
                }
                catch (IllegalArgumentException e) {
                    prop.put("info", "27");
                    prop.putHTML("info_filter", filter);
                    prop.put("info_nr", patternCount);
                    prop.putHTML("info_error", e.getMessage());
                    prop.putHTML("info_pattern", patternStr);
                    return prop;
                }
            }
            env.setConfig("serverClient", filter);
            prop.put("info", "8");
            prop.putHTML("info_filter", filter);
            return prop;
        }
        if (post.containsKey("serverCompression")) {
            prop.put("needsRestart_referer", "Settings_p.html?page=ServerAccess");
            boolean oldValue = env.getConfigBool("server.response.compress.gzip", true);
            boolean newValue = post.containsKey("server.response.compress.gzip");
            env.setConfig("server.response.compress.gzip", newValue);
            prop.put("needsRestart", newValue != oldValue);
            prop.put("info", "37");
            return prop;
        }
        if (post.containsKey("proxysettings")) {
            prop.put("needsRestart_referer", "Settings_p.html?page=proxy");
            boolean useRemoteProxy = post.containsKey("remoteProxyUse");
            boolean useRemoteProxy4SSL = post.containsKey("remoteProxyUse4SSL");
            String remoteProxyHost = post.get("remoteProxyHost", "");
            int remoteProxyPort = post.getInt("remoteProxyPort", 3128);
            String remoteProxyUser = post.get("remoteProxyUser", "");
            String remoteProxyPwd = post.get("remoteProxyPwd", "");
            String remoteProxyNoProxyStr = post.get("remoteProxyNoProxy", "");
            env.setConfig("remoteProxyHost", remoteProxyHost);
            env.setConfig("remoteProxyPort", Integer.toString(remoteProxyPort));
            env.setConfig("remoteProxyUser", remoteProxyUser);
            env.setConfig("remoteProxyPwd", remoteProxyPwd);
            env.setConfig("remoteProxyNoProxy", remoteProxyNoProxyStr);
            env.setConfig("remoteProxyUse", useRemoteProxy);
            env.setConfig("remoteProxyUse4SSL", useRemoteProxy4SSL);
            sb.initRemoteProxy();
            prop.put("info", "15");
            return prop;
        }
        if (post.containsKey("urlproxySettings")) {
            prop.put("needsRestart_referer", "Settings_p.html?page=UrlProxyAccess");
            env.setConfig("proxyURL.access", post.get("urlproxyfilter"));
            env.setConfig("proxyURL.rewriteURLs", post.get("urlproxydomains"));
            env.setConfig("proxyURL", "on".equals(post.get("urlproxyenabled")));
            env.setConfig("proxyURL.useforresults", "on".equals(post.get("urlproxyuseforresults")));
            prop.put("info_success", "1");
            prop.put("info", "33");
            return prop;
        }
        if (post.containsKey("seedUploadRetry")) {
            prop.put("needsRestart_referer", "Settings_p.html?page=seed");
            String error = Network.saveSeedList(sb);
            if (error == null) {
                prop.put("info", "13");
                prop.put("info_success", "1");
            } else {
                prop.put("info", "14");
                prop.putHTML("info_errormsg", error.replaceAll("\n", "<br>"));
                env.setConfig("seedUploadMethod", "none");
            }
            return prop;
        }
        if (post.containsKey("seedSettings")) {
            boolean uploadMethodChanged;
            prop.put("needsRestart_referer", "Settings_p.html?page=seed");
            String oldSeedUploadMethod = env.getConfig("seedUploadMethod", "none");
            String newSeedUploadMethod = post.get("seedUploadMethod");
            String oldSeedURLStr = sb.peers.mySeed().get("seedURL", "");
            String newSeedURLStr = post.get("seedURL");
            boolean seedUrlChanged = !oldSeedURLStr.equals(newSeedURLStr);
            boolean bl = uploadMethodChanged = !oldSeedUploadMethod.equals(newSeedUploadMethod);
            if (uploadMethodChanged) {
                uploadMethodChanged = Network.changeSeedUploadMethod(newSeedUploadMethod);
            }
            if (seedUrlChanged || uploadMethodChanged) {
                String error;
                env.setConfig("seedUploadMethod", newSeedUploadMethod);
                sb.peers.mySeed().put("seedURL", newSeedURLStr);
                if (seedUrlChanged) {
                    sb.peers.saveMySeed();
                }
                if ((error = Network.saveSeedList(sb)) == null) {
                    prop.put("info_seedUploadMethod", newSeedUploadMethod);
                    prop.putHTML("info_seedURL", newSeedURLStr);
                    prop.put("info_success", newSeedUploadMethod.equalsIgnoreCase("none") ? "0" : "1");
                    prop.put("info", "19");
                } else {
                    prop.put("info", "14");
                    prop.putHTML("info_errormsg", error.replaceAll("\n", "<br>"));
                    env.setConfig("seedUploadMethod", "none");
                }
                return prop;
            }
        }
        if (post.containsKey("seedFileSettings") || post.containsKey("seedFtpSettings") || post.containsKey("seedScpSettings")) {
            prop.put("needsRestart_referer", "Settings_p.html?page=seed");
        }
        HashMap<String, String> uploaders = Network.getSeedUploadMethods();
        for (String uploaderName : uploaders.keySet()) {
            if (!post.containsKey("seed" + uploaderName + "Settings")) continue;
            nothingChanged = true;
            yacySeedUploader theUploader = Network.getSeedUploader(uploaderName);
            String[] configOptions = theUploader.getConfigurationOptions();
            if (configOptions != null) {
                for (String configOption : configOptions) {
                    String oldSettings;
                    String newSettings = post.get(configOption, "");
                    if (nothingChanged &= newSettings.equals(oldSettings = env.getConfig(configOption, ""))) continue;
                    env.setConfig(configOption, newSettings);
                }
            }
            if (!nothingChanged) {
                if (env.getConfig("seedUploadMethod", "none").equalsIgnoreCase(uploaderName)) {
                    String error = Network.saveSeedList(sb);
                    if (error == null) {
                        prop.put("info", "13");
                        prop.put("info_success", "1");
                    } else {
                        prop.put("info", "14");
                        prop.putHTML("info_errormsg", error.replaceAll("\n", "<br>"));
                        env.setConfig("seedUploadMethod", "none");
                    }
                } else {
                    prop.put("info", "13");
                    prop.put("info_success", "0");
                }
            } else {
                prop.put("info", "13");
                prop.put("info_success", "0");
            }
            return prop;
        }
        if (post.containsKey("msgForwarding")) {
            prop.put("needsRestart_referer", "Settings_p.html?page=messageForwarding");
            env.setConfig("msgForwardingEnabled", post.containsKey("msgForwardingEnabled"));
            env.setConfig("msgForwardingCmd", post.get("msgForwardingCmd"));
            env.setConfig("msgForwardingTo", post.get("msgForwardingTo"));
            prop.put("info", "21");
            prop.put("info_msgForwardingEnabled", post.containsKey("msgForwardingEnabled") ? "on" : "off");
            prop.putHTML("info_msgForwardingCmd", post.get("msgForwardingCmd"));
            prop.putHTML("info_msgForwardingTo", post.get("msgForwardingTo"));
            return prop;
        }
        if (post.containsKey("crawlerSettings")) {
            long maxFileSize;
            long maxSmbSize;
            long maxFtpSize;
            long maxHttpSize;
            int crawlerTimeout;
            prop.put("needsRestart_referer", "Settings_p.html?page=crawler");
            String timeoutStr = post.get("crawler.clientTimeout");
            if (timeoutStr == null || timeoutStr.length() == 0) {
                timeoutStr = "10000";
            }
            try {
                crawlerTimeout = Integer.parseInt(timeoutStr);
                if (crawlerTimeout < 0) {
                    crawlerTimeout = 0;
                }
                env.setConfig("crawler.clientTimeout", Integer.toString(crawlerTimeout));
            }
            catch (NumberFormatException e) {
                prop.put("info", "29");
                prop.putHTML("info_crawler.clientTimeout", post.get("crawler.clientTimeout"));
                return prop;
            }
            String maxSizeStr = post.get("crawler.http.maxFileSize");
            if (maxSizeStr == null || maxSizeStr.length() == 0) {
                maxSizeStr = "-1";
            }
            try {
                maxHttpSize = Integer.parseInt(maxSizeStr);
                if (maxHttpSize < 0L) {
                    maxHttpSize = -1L;
                }
                env.setConfig("crawler.http.maxFileSize", Long.toString(maxHttpSize));
            }
            catch (NumberFormatException e) {
                prop.put("info", "30");
                prop.putHTML("info_crawler.http.maxFileSize", post.get("crawler.http.maxFileSize"));
                return prop;
            }
            maxSizeStr = post.get("crawler.ftp.maxFileSize");
            if (maxSizeStr == null || maxSizeStr.length() == 0) {
                maxSizeStr = "-1";
            }
            try {
                maxFtpSize = Integer.parseInt(maxSizeStr);
                env.setConfig("crawler.ftp.maxFileSize", Long.toString(maxFtpSize));
            }
            catch (NumberFormatException e) {
                prop.put("info", "31");
                prop.putHTML("info_crawler.ftp.maxFileSize", post.get("crawler.ftp.maxFileSize"));
                return prop;
            }
            maxSizeStr = post.get("crawler.smb.maxFileSize");
            if (maxSizeStr == null || maxSizeStr.length() == 0) {
                maxSizeStr = "-1";
            }
            try {
                maxSmbSize = Integer.parseInt(maxSizeStr);
                env.setConfig("crawler.smb.maxFileSize", Long.toString(maxSmbSize));
            }
            catch (NumberFormatException e) {
                prop.put("info", "31");
                prop.putHTML("info_crawler.smb.maxFileSize", post.get("crawler.smb.maxFileSize"));
                return prop;
            }
            maxSizeStr = post.get("crawler.file.maxFileSize");
            if (maxSizeStr == null || maxSizeStr.length() == 0) {
                maxSizeStr = "-1";
            }
            try {
                maxFileSize = Integer.parseInt(maxSizeStr);
                env.setConfig("crawler.file.maxFileSize", Long.toString(maxFileSize));
            }
            catch (NumberFormatException e) {
                prop.put("info", "31");
                prop.putHTML("info_crawler.file.maxFileSize", post.get("crawler.file.maxFileSize"));
                return prop;
            }
            prop.put("info_crawler.clientTimeout", crawlerTimeout == 0 ? "0" : Formatter.number((double)crawlerTimeout / 1000.0, false) + " sec");
            prop.put("info_crawler.http.maxFileSize", maxHttpSize == -1L ? "-1" : Formatter.bytesToString(maxHttpSize));
            prop.put("info_crawler.ftp.maxFileSize", maxFtpSize == -1L ? "-1" : Formatter.bytesToString(maxFtpSize));
            prop.put("info_crawler.smb.maxFileSize", maxSmbSize == -1L ? "-1" : Formatter.bytesToString(maxSmbSize));
            prop.put("info_crawler.file.maxFileSize", maxFileSize == -1L ? "-1" : Formatter.bytesToString(maxFileSize));
            prop.put("info", "28");
            return prop;
        }
        if (post.containsKey("serverports")) {
            int portssl;
            int port = post.getInt("port", 8090);
            if (port > 0) {
                env.setConfig("port", port);
            }
            if ((portssl = post.getInt("port.ssl", 8443)) > 0) {
                env.setConfig("port.ssl", portssl);
            }
            int portshutdown = post.getInt("port.shutdown", -1);
            env.setConfig("port.shutdown", portshutdown);
            prop.put("info_port", port);
            prop.put("info_port.ssl", portssl);
            prop.put("info_port.shutdown", portshutdown);
            prop.put("needsRestart_referer", "Settings_p.html?page=ServerAccess");
            prop.put("info", "36");
            return prop;
        }
        if (post.containsKey("port.ssl")) {
            prop.put("needsRestart_referer", "Settings_p.html?page=ProxyAccess");
            int port = post.getInt("port.ssl", 8443);
            if (port > 0 && port != env.getConfigInt("port.ssl", 8443)) {
                env.setConfig("port.ssl", port);
            }
            prop.put("info_port.ssl", port);
            prop.put("info", "32");
            return prop;
        }
        if (post.containsKey("debugAnalysisSettings")) {
            prop.put("needsRestart_referer", "Settings_p.html?page=debug");
            boolean tickedCheckbox = post.containsKey("solrBinaryResponse");
            env.setConfig("remote.solr.binaryResponse.enabled", tickedCheckbox);
            tickedCheckbox = post.containsKey("searchTestLocalDHT");
            env.setConfig("debug.search.remote.dht.testlocal", tickedCheckbox);
            tickedCheckbox = post.containsKey("searchTestLocalSolr");
            env.setConfig("debug.search.remote.solr.testlocal", tickedCheckbox);
            tickedCheckbox = post.containsKey("searchShowRanking");
            env.setConfig("search.result.show.ranking", tickedCheckbox);
            tickedCheckbox = post.containsKey("debug.snippets.statistics.enabled");
            sb.setConfig("debug.snippets.statistics.enabled", tickedCheckbox);
            TextSnippet.statistics.setEnabled(tickedCheckbox);
            tickedCheckbox = post.containsKey("searchLocalDHT");
            env.setConfig("debug.search.local.dht.off", !tickedCheckbox);
            tickedCheckbox = post.containsKey("searchLocalSolr");
            env.setConfig("debug.search.local.solr.off", !tickedCheckbox);
            tickedCheckbox = post.containsKey("searchRemoteDHT");
            env.setConfig("debug.search.remote.dht.off", !tickedCheckbox);
            tickedCheckbox = post.containsKey("searchRemoteSolr");
            env.setConfig("debug.search.remote.solr.off", !tickedCheckbox);
            SearchEventCache.cleanupEvents(true);
            prop.put("info", "34");
            return prop;
        }
        if (post.containsKey("referrerPolicySettings")) {
            prop.put("needsRestart_referer", "Settings_p.html?page=referrer");
            String metaPolicy = post.get("metaPolicy", "origin-when-cross-origin");
            env.setConfig("referrer.meta.policy", metaPolicy);
            boolean tickedCheckbox = post.containsKey("searchResultNoReferrer");
            env.setConfig("search.result.noreferrer", tickedCheckbox);
            prop.put("info", "35");
            return prop;
        }
        if (post.containsKey("httpClientSettings")) {
            prop.put("needsRestart_referer", "Settings_p.html?page=httpClient");
            if (System.getProperty("jsse.enableSNIExtension") == null) {
                env.setConfig("http.outgoing.general.tls.sniExtension.enabled", post.containsKey("http.outgoing.general.tls.sniExtension.enabled"));
                env.setConfig("http.outgoing.remoteSolr.tls.sniExtension.enabled", post.containsKey("http.outgoing.remoteSolr.tls.sniExtension.enabled"));
            }
            sb.initOutgoingConnectionSettings();
            prop.put("info", "38");
            return prop;
        }
        prop.put("info", "1");
        return prop;
    }
}

