/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.peers.PeerActions;
import net.yacy.peers.Seed;
import net.yacy.peers.operation.yacyVersion;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class RemoteCrawl_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        if (post != null) {
            sb.tables.recordAPICall(post, "RemoteCrawl_p.html", "configuration", "remote crawler configuration");
            if (post.containsKey("crawlResponse")) {
                boolean crawlResponse = post.get("crawlResponse", "off").equals("on");
                sb.initRemoteCrawler(crawlResponse);
            }
            if (post.containsKey("acceptCrawlLimit")) {
                int newppm = 1;
                try {
                    newppm = Math.max(1, post.getInt("acceptCrawlLimit", 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                sb.setRemotecrawlPPM(newppm);
            }
        }
        sb.peers.mySeed().setFlagAcceptRemoteCrawl(sb.getConfigBool("crawlResponse", false));
        prop.put("disabled", !sb.peers.mySeed().isActive() && !sb.peers.mySeed().getFlagAcceptRemoteCrawl() ? 1L : 0L);
        prop.put("crawlResponse", sb.peers.mySeed().getFlagAcceptRemoteCrawl() ? 1L : 0L);
        long RTCbusySleep = Math.max(1L, env.getConfigLong("62_remotetriggeredcrawl_busysleep", 100L));
        int RTCppm = (int)(60000L / RTCbusySleep);
        prop.put("acceptCrawlLimit", RTCppm);
        String STR_TABLE_LIST = "list_";
        int conCount = 0;
        boolean dark = true;
        Iterator<Seed> e = null;
        e = sb.peers.seedsSortedConnected(false, "RCount");
        Pattern peerSearchPattern = null;
        while (e.hasNext() && conCount < 300) {
            long rcount;
            long lastseen;
            Seed seed = e.next();
            assert (seed != null);
            if (seed == null || (lastseen = Math.abs((System.currentTimeMillis() - seed.getLastSeenUTC()) / 1000L / 60L)) > 720L || (rcount = seed.getLong("RCount", 0L)) == 0L) continue;
            if (post != null && post.containsKey("search") && peerSearchPattern != null) {
                boolean abort = true;
                Matcher m = peerSearchPattern.matcher(seed.getName());
                if (m.find()) {
                    abort = false;
                }
                if ((m = peerSearchPattern.matcher(seed.hash)).find()) {
                    abort = false;
                }
                if (abort) continue;
            }
            prop.put("list_" + conCount + "_dark", dark ? 1 : 0);
            dark = !dark;
            String shortname = seed.get("Name", "deadlink");
            if (shortname.length() > 20) {
                shortname = shortname.substring(0, 20) + "...";
            }
            String peeradr = seed.getPublicAddress(seed.getIPs().iterator().next());
            prop.putHTML("list_" + conCount + "_shortname", shortname);
            prop.putHTML("list_" + conCount + "_peeraddress", peeradr);
            prop.put("list_" + conCount + "_age", seed.getAge());
            String[] yv = yacyVersion.combined2prettyVersion(seed.get("Version", "0.1"), shortname);
            prop.putHTML("list_" + conCount + "_version", yv[0] + "/" + yv[1]);
            prop.putNum("list_" + conCount + "_lastSeen", lastseen);
            prop.put("list_" + conCount + "_utc", seed.get("UTC", "-"));
            prop.putHTML("list_" + conCount + "_uptime", PeerActions.formatInterval(60000L * seed.getLong("Uptime", 0L)));
            prop.putNum("list_" + conCount + "_LCount", seed.getLinkCount());
            prop.putNum("list_" + conCount + "_ICount", seed.getWordCount());
            prop.putNum("list_" + conCount + "_RCount", rcount);
            prop.putNum("list_" + conCount + "_ppm", seed.getPPM());
            prop.putNum("list_" + conCount + "_qph", (double)Math.round(6000.0 * (double)seed.getQPM()) / 100.0);
            ++conCount;
        }
        prop.putNum("list", conCount);
        return prop;
    }
}

