/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import net.yacy.cora.federate.solr.Ranking;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.sorting.ReversibleScoreMap;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.search.Switchboard;
import net.yacy.search.query.SearchEventCache;
import net.yacy.search.schema.CollectionConfiguration;
import net.yacy.search.schema.CollectionSchema;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class RankingSolr_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        HashMap vocabularyFacet;
        String bf;
        String fq;
        String bq;
        Switchboard sb = (Switchboard)env;
        SearchEventCache.cleanupEvents(true);
        sb.index.clearCaches();
        int profileNr = 0;
        if (post != null) {
            profileNr = post.getInt("profileNr", profileNr);
        }
        if (post != null && post.containsKey("EnterBoosts")) {
            StringBuilder boostString = new StringBuilder();
            for (Map.Entry<String, String> entry2 : post.entrySet()) {
                String fieldValue;
                String fieldName;
                Object field;
                if (!entry2.getKey().startsWith("boost") || (field = CollectionSchema.valueOf(fieldName = entry2.getKey().substring(6))) == null || (fieldValue = entry2.getValue()) == null || fieldValue.length() == 0) continue;
                try {
                    float boost = Float.parseFloat(fieldValue);
                    if (!(boost > 0.0f)) continue;
                    if (boostString.length() > 0) {
                        boostString.append(',');
                    }
                    boostString.append(((CollectionSchema)field).getSolrFieldName()).append('^').append(Float.toString(boost));
                }
                catch (NumberFormatException e) {}
            }
            if (boostString.length() > 0) {
                String s = boostString.toString();
                sb.setConfig("search.ranking.solr.collection.boostfields.tmpa." + profileNr, s);
                sb.index.fulltext().getDefaultConfiguration().getRanking(profileNr).updateBoosts(s);
            }
        }
        if (post != null && post.containsKey("ResetBoosts")) {
            String s = "url_paths_sxt^3.0,synonyms_sxt^0.5,title^5.0,text_t^1.0,host_s^6.0,h1_txt^5.0,url_file_name_tokens_t^4.0,h2_txt^3.0,keywords^2.0,description_txt^1.5,author^1.0";
            sb.setConfig("search.ranking.solr.collection.boostfields.tmpa." + profileNr, "url_paths_sxt^3.0,synonyms_sxt^0.5,title^5.0,text_t^1.0,host_s^6.0,h1_txt^5.0,url_file_name_tokens_t^4.0,h2_txt^3.0,keywords^2.0,description_txt^1.5,author^1.0");
            sb.index.fulltext().getDefaultConfiguration().getRanking(profileNr).updateBoosts("url_paths_sxt^3.0,synonyms_sxt^0.5,title^5.0,text_t^1.0,host_s^6.0,h1_txt^5.0,url_file_name_tokens_t^4.0,h2_txt^3.0,keywords^2.0,description_txt^1.5,author^1.0");
        }
        if (post != null && post.containsKey("EnterBQ") && (bq = post.get("bq")) != null) {
            sb.setConfig("search.ranking.solr.collection.boostquery.tmpa." + profileNr, bq);
            sb.index.fulltext().getDefaultConfiguration().getRanking(profileNr).setBoostQuery(bq);
        }
        if (post != null && post.containsKey("ResetBQ")) {
            bq = "crawldepth_i:0^0.8\ncrawldepth_i:1^0.4";
            if ("crawldepth_i:0^0.8\ncrawldepth_i:1^0.4" != null) {
                sb.setConfig("search.ranking.solr.collection.boostquery.tmpa." + profileNr, "crawldepth_i:0^0.8\ncrawldepth_i:1^0.4");
                sb.index.fulltext().getDefaultConfiguration().getRanking(profileNr).setBoostQuery("crawldepth_i:0^0.8\ncrawldepth_i:1^0.4");
            }
        }
        if (post != null && post.containsKey("EnterFQ") && (fq = post.get("fq")) != null) {
            sb.setConfig("search.ranking.solr.collection.filterquery.tmpa." + profileNr, fq);
            sb.index.fulltext().getDefaultConfiguration().getRanking(profileNr).setFilterQuery(fq);
        }
        if (post != null && post.containsKey("ResetFQ")) {
            fq = "";
            if ("" != null) {
                sb.setConfig("search.ranking.solr.collection.filterquery.tmpa." + profileNr, "");
                sb.index.fulltext().getDefaultConfiguration().getRanking(profileNr).setFilterQuery("");
            }
        }
        if (post != null && post.containsKey("EnterBF") && (bf = post.get("bf")) != null) {
            sb.setConfig("search.ranking.solr.collection.boostfunction.tmpb." + profileNr, bf);
            sb.index.fulltext().getDefaultConfiguration().getRanking(profileNr).setBoostFunction(bf);
        }
        if (post != null && post.containsKey("ResetBF")) {
            bf = "";
            if ("" != null) {
                sb.setConfig("search.ranking.solr.collection.boostfunction.tmpb." + profileNr, "");
                sb.index.fulltext().getDefaultConfiguration().getRanking(profileNr).setBoostFunction("");
            }
        }
        serverObjects prop = new serverObjects();
        int i = 0;
        CollectionConfiguration colcfg = sb.index.fulltext().getDefaultConfiguration();
        Ranking ranking = colcfg.getRanking(profileNr);
        for (CollectionSchema field : CollectionSchema.values()) {
            Float boost;
            if (!field.isSearchable() || (boost = ranking.getFieldBoost(field)) == null && !colcfg.contains(field)) continue;
            prop.put("boosts_" + i + "_field", field.getSolrFieldName());
            if (boost == null || boost.floatValue() <= 0.0f) {
                prop.put("boosts_" + i + "_checked", 0L);
                prop.put("boosts_" + i + "_boost", "");
                prop.put("boosts_" + i + "_notinindexwarning", "0");
            } else {
                prop.put("boosts_" + i + "_checked", 1L);
                prop.put("boosts_" + i + "_boost", boost.toString());
                prop.put("boosts_" + i + "_notinindexwarning", colcfg.contains(field.name()) ? "0" : "1");
            }
            prop.putHTML("boosts_" + i + "_comment", field.getComment());
            ++i;
        }
        prop.put("boosts", i);
        prop.put("fq", ranking.getFilterQuery());
        prop.put("bq", ranking.getBoostQuery());
        prop.put("bf", ranking.getBoostFunction());
        for (int j = 0; j < 4; ++j) {
            prop.put("profiles_" + j + "_nr", j);
            prop.put("profiles_" + j + "_name", sb.getConfig("search.ranking.solr.collection.boostname.tmpa." + j, "N.N."));
            prop.put("profiles_" + j + "_selected", profileNr == j ? 1L : 0L);
        }
        prop.put("profiles", 4L);
        prop.put("profileNr", profileNr);
        try {
            vocabularyFacet = sb.index.fulltext().getDefaultConnector().getFacets(CollectionSchema.vocabularies_sxt.getSolrFieldName() + ":[* TO *]", 100, CollectionSchema.vocabularies_sxt.getSolrFieldName());
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            vocabularyFacet = new HashMap();
        }
        if (vocabularyFacet.size() == 0) {
            prop.put("boosthint", 0L);
        } else {
            prop.put("boosthint", 1L);
            prop.putHTML("boosthint_vocabulariesfield", CollectionSchema.vocabularies_sxt.getSolrFieldName());
            ReversibleScoreMap vokcounts = (ReversibleScoreMap)vocabularyFacet.values().iterator().next();
            Collection vocnames = vokcounts.keyList(true);
            prop.putHTML("boosthint_vocabulariesavailable", vocnames.toString());
            ArrayList<String> voccountFields = new ArrayList<String>();
            ArrayList<String> voclogcountFields = new ArrayList<String>();
            ArrayList<String> voclogcountsFields = new ArrayList<String>();
            ArrayList<String> ff = new ArrayList<String>();
            for (String vocname : vocnames) {
                voccountFields.add("vocabulary_" + vocname + "_i");
                voclogcountFields.add("vocabulary_" + vocname + "_log_i");
                voclogcountsFields.add("vocabulary_" + vocname + "_log_val");
            }
            ff.addAll(voclogcountFields);
            ff.addAll(voclogcountsFields);
            prop.putHTML("boosthint_vocabulariesvoccount", voccountFields.toString());
            prop.putHTML("boosthint_vocabulariesvoclogcount", voclogcountFields.toString());
            prop.putHTML("boosthint_vocabulariesvoclogcounts", voclogcountsFields.toString());
            String[] facetfields = ff.toArray(new String[ff.size()]);
            int fc = 0;
            if (facetfields.length > 0) {
                try {
                    LinkedHashMap<String, ReversibleScoreMap<String>> facets = sb.index.fulltext().getDefaultConnector().getFacets("*:*", 100, facetfields);
                    facets.put(CollectionSchema.vocabularies_sxt.getSolrFieldName(), vokcounts);
                    for (Map.Entry<String, ReversibleScoreMap<String>> facetentry : facets.entrySet()) {
                        ReversibleScoreMap<String> facetfieldmap = facetentry.getValue();
                        if (facetfieldmap.size() == 0) continue;
                        TreeMap<String, Integer> statMap = new TreeMap<String, Integer>();
                        for (String k : facetfieldmap) {
                            statMap.put(k, facetfieldmap.get(k));
                        }
                        prop.put("boosthint_facets_" + fc + "_facetname", facetentry.getKey());
                        int c = 0;
                        for (Map.Entry entry3 : statMap.entrySet()) {
                            prop.put("boosthint_facets_" + fc + "_facet_" + c + "_key", (String)entry3.getKey());
                            prop.put("boosthint_facets_" + fc + "_facet_" + c + "_count", ((Integer)entry3.getValue()).intValue());
                            ++c;
                        }
                        prop.put("boosthint_facets_" + fc + "_facet", c);
                        ++fc;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            prop.put("boosthint_facets", fc);
        }
        return prop;
    }
}

