/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.util.LinkedHashMap;
import java.util.Map;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.search.Switchboard;
import net.yacy.search.query.SearchEventCache;
import net.yacy.search.ranking.RankingProfile;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.utils.crypt;

public class RankingRWI_p {
    private static final int maxRankingRange = 16;
    private static final LinkedHashMap<String, String> rankingParameters = new LinkedHashMap();

    private static serverObjects defaultValues() {
        serverObjects prop = new serverObjects();
        prop.put("search", "");
        prop.put("num-results", "0");
        prop.put("excluded", "0");
        prop.put("combine", "0");
        prop.put("resultbottomline", "0");
        prop.put("localCount", "10");
        prop.put("localWDist", "999");
        prop.put("globalChecked", "0");
        prop.put("postsortChecked", "1");
        prop.put("localTime", "6");
        prop.put("results", "");
        prop.put("urlmaskoptions", "0");
        prop.putHTML("urlmaskoptions_urlmaskfilter", ".*");
        prop.put("jumpToCursor", "1");
        return prop;
    }

    private static void putRanking(serverObjects prop, RankingProfile rankingProfile, String prefix) {
        RankingRWI_p.putRanking(prop, rankingProfile.preToExternalMap(prefix), prefix, "Pre");
        RankingRWI_p.putRanking(prop, rankingProfile.postToExternalMap(prefix), prefix, "Post");
    }

    private static void putRanking(serverObjects prop, Map<String, String> map, String prefix, String attrExtension) {
        prop.put("attr" + attrExtension, map.size());
        int j = 0;
        for (Map.Entry<String, String> entry2 : map.entrySet()) {
            String info;
            String name;
            String key = entry2.getKey();
            String description = rankingParameters.get(key.substring(prefix.length()));
            int p = description.indexOf(59, 0);
            if (p >= 0) {
                name = description.substring(0, p);
                info = description.substring(p + 1);
            } else {
                name = description;
                info = "";
            }
            prop.put("attr" + attrExtension + "_" + j + "_name", name);
            prop.put("attr" + attrExtension + "_" + j + "_info", info);
            prop.put("attr" + attrExtension + "_" + j + "_nameorg", key);
            prop.put("attr" + attrExtension + "_" + j + "_select", 16L);
            for (int i = 0; i < 16; ++i) {
                prop.put("attr" + attrExtension + "_" + j + "_select_" + i + "_nameorg", key);
                prop.put("attr" + attrExtension + "_" + j + "_select_" + i + "_value", i);
                try {
                    prop.put("attr" + attrExtension + "_" + j + "_select_" + i + "_checked", i == Integer.parseInt(entry2.getValue()) ? "1" : "0");
                    continue;
                }
                catch (NumberFormatException e) {
                    prop.put("attr" + attrExtension + "_" + j + "_select_" + i + "_checked", "0");
                }
            }
            prop.put("attr" + attrExtension + "_" + j + "_value", Integer.parseInt(map.get(key)));
            ++j;
        }
    }

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        SearchEventCache.cleanupEvents(true);
        if (post == null || sb == null) {
            serverObjects prop = RankingRWI_p.defaultValues();
            RankingProfile ranking = sb == null ? new RankingProfile(Classification.ContentDomain.TEXT) : sb.getRanking();
            RankingRWI_p.putRanking(prop, ranking, "local");
            return prop;
        }
        if (post.containsKey("EnterRanking")) {
            RankingProfile ranking = new RankingProfile("local", post.toString());
            sb.setConfig("search.ranking.rwi.profile", crypt.simpleEncode(ranking.toExternalString()));
            serverObjects prop = RankingRWI_p.defaultValues();
            RankingRWI_p.putRanking(prop, ranking, "local");
            return prop;
        }
        if (post.containsKey("ResetRanking")) {
            sb.setConfig("search.ranking.rwi.profile", "");
            RankingProfile ranking = new RankingProfile(Classification.ContentDomain.TEXT);
            serverObjects prop = RankingRWI_p.defaultValues();
            RankingRWI_p.putRanking(prop, ranking, "local");
            return prop;
        }
        RankingProfile localRanking = new RankingProfile("local", post.toString());
        serverObjects prop = new serverObjects();
        RankingRWI_p.putRanking(prop, localRanking, "local");
        prop.putAll(localRanking.toExternalMap("local"));
        return prop;
    }

    static {
        rankingParameters.put("appemph", "Appearance In Emphasized Text;a higher ranking level prefers documents where the search word is emphasized");
        rankingParameters.put("appurl", "Appearance In URL;a higher ranking level prefers documents with urls that match the search word");
        rankingParameters.put("appauthor", "Appearance In Author;a higher ranking level prefers documents with authors that match the search word");
        rankingParameters.put("appref", "Appearance In Reference/Anchor Name;a higher ranking level prefers documents where the search word matches in the description text");
        rankingParameters.put("apptags", "Appearance In Tags;a higher ranking level prefers documents where the search word is part of subject tags");
        rankingParameters.put("appdescr", "Appearance In Title;a higher ranking level prefers documents with titles that match the search word");
        rankingParameters.put("authority", "Authority of Domain;a higher ranking level prefers documents from domains with a large number of matching documents");
        rankingParameters.put("cathasapp", "Category App, Appearance;a higher ranking level prefers documents with embedded links to applications");
        rankingParameters.put("cathasaudio", "Category Audio Appearance;a higher ranking level prefers documents with embedded links to audio content");
        rankingParameters.put("cathasimage", "Category Image Appearance;a higher ranking level prefers documents with embedded images");
        rankingParameters.put("cathasvideo", "Category Video Appearance;a higher ranking level prefers documents with embedded links to video files");
        rankingParameters.put("catindexof", "Category Index Page;a higher ranking level prefers 'index of' (directory listings) pages");
        rankingParameters.put("date", "Date;a higher ranking level prefers younger documents. The age of a document is measured using the date submitted by the remote server as document date");
        rankingParameters.put("domlength", "Domain Length;a higher ranking level prefers documents with a short domain name");
        rankingParameters.put("hitcount", "Hit Count;a higher ranking level prefers documents with a large number of matchings for the search word(s)");
        rankingParameters.put("language", "Preferred Language;a higher ranking level prefers documents with a language that matches the browser language.");
        rankingParameters.put("llocal", "Links To Local Domain;a higher ranking level prefers documents with a high number of hyperlinks to the same domain as the matching document.");
        rankingParameters.put("lother", "Links To Other Domain;a higher ranking level prefers documents with a high number of hyperlinks to domains other than the matching document domain");
        rankingParameters.put("phrasesintext", "Phrases In Text;a higher ranking level prefers documents with a large number of phrases (sentences) in the matching document.");
        rankingParameters.put("posinphrase", "Position In Phrase;a higher ranking level prefers documents with a word match position high in the matching phrase. The phrase match is the phrase (sentence) where the matching word appears first.");
        rankingParameters.put("posintext", "Position In Text;a higher ranking level prefers documents with a word match position high in the document. This prefers documents where the search wort is at the beginning of a text.");
        rankingParameters.put("posofphrase", "Position Of Phrase;a higher ranking level prefers documents with a phrase match position high in the document. The phrase match is the phrase (sentence) where the matching word appears first. This prefers documents where the search wort is at the beginning of a text.");
        rankingParameters.put("tf", "Term Frequency;a higher ranking level prefers documents with a high (number of matching words)/(number of words in document) ratio. This is same ranking as used in lucene and old-age search engines as existed before the year 2000.");
        rankingParameters.put("urlcomps", "URL Components;a higher ranking level prefers documents with a short number of url components. The number of url components is the number of (sub-) domains plus the number of (sub-) path elements in the file path.");
        rankingParameters.put("urllength", "URL Length;a higher ranking level prefers documents with a short url (domain plus path)");
        rankingParameters.put("worddistance", "Word Distance;a higher ranking level prefers documents where the search words appear close together. This ranking parameter works like a NEAR operator in more-than-one word searches.");
        rankingParameters.put("wordsintext", "Words In Text;a higher ranking level prefers documents with a large number of words. Be aware that this is a compensation of the term frequency parameter.");
        rankingParameters.put("wordsintitle", "Words In Title;a higher ranking level prefers documents with a large number of words in the document title.");
        rankingParameters.put("urlcompintoplist", "URL Component Appears In Toplist;a higher ranking level prefers documents with words in the url path that match words in the toplist. The toplist is generated dynamically from the search results using a statistic of the most used words. The toplist is a top-10 list of the most used words in URLs and document titles.");
        rankingParameters.put("descrcompintoplist", "Description Comp. Appears In Toplist;a higher ranking level prefers documents with words in the document description that match words in the toplist. The toplist is generated dynamically from the search results using a statistic of the most used words. The toplist is a top-10 list of the most used words in URLs and document titles.");
        rankingParameters.put("prefer", "Application Of Prefer Pattern;a higher ranking level prefers documents where the url matches the prefer pattern given in a search request.");
        rankingParameters.put("citation", "Citation Rank;the more incoming links and the less outgoing links the better the ranking.");
    }
}

