/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.util.concurrent.Semaphore;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.peers.graphics.EncodedImage;
import net.yacy.peers.graphics.NetworkGraph;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class NetworkPicture {
    private static final ConcurrentLog log = new ConcurrentLog("NetworkPicture");
    private static final Semaphore sync = new Semaphore(1, true);
    private static long lastAccessSeconds = 0L;

    public static EncodedImage respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        boolean authorized = sb.adminAuthenticated(header) >= 2;
        long timeSeconds = System.currentTimeMillis() / 1000L;
        if (NetworkGraph.buffer != null && !authorized && timeSeconds - lastAccessSeconds < 2L) {
            if (log.isFine()) {
                log.fine("cache hit (1); authorized = " + authorized + ", timeSeconds - lastAccessSeconds = " + (timeSeconds - lastAccessSeconds));
            }
            return NetworkGraph.buffer;
        }
        if (NetworkGraph.buffer != null && sync.availablePermits() == 0) {
            return NetworkGraph.buffer;
        }
        sync.acquireUninterruptibly();
        if (NetworkGraph.buffer != null && !authorized && timeSeconds - lastAccessSeconds < 2L) {
            if (log.isFine()) {
                log.fine("cache hit (2); authorized = " + authorized + ", timeSeconds - lastAccessSeconds = " + (timeSeconds - lastAccessSeconds));
            }
            sync.release();
            return NetworkGraph.buffer;
        }
        int width = 1280;
        int height = 720;
        int passiveLimit = 1440;
        int potentialLimit = 1440;
        int maxCount = 9000;
        String bgcolor = Long.toHexString(0xFFFFFFL);
        boolean corona = true;
        int coronaangle = 0;
        long communicationTimeout = -1L;
        int cyc = 0;
        if (post != null) {
            width = post.getInt("width", width);
            height = post.getInt("height", height);
            passiveLimit = post.getInt("pal", passiveLimit);
            potentialLimit = post.getInt("pol", potentialLimit);
            maxCount = post.getInt("max", maxCount);
            corona = post.getBoolean("corona") || post.containsKey("coronaangle");
            coronaangle = corona ? post.getInt("coronaangle", 0) : -1;
            communicationTimeout = post.getLong("ct", -1L);
            bgcolor = post.get("bgcolor", bgcolor);
            cyc = post.getInt("cyc", 0);
        }
        if (width < 320) {
            width = 320;
        }
        if (width > 1920) {
            width = 1920;
        }
        if (height < 240) {
            height = 240;
        }
        if (height > 1280) {
            height = 1280;
        }
        if (!authorized) {
            width = Math.min(1280, width);
            height = Math.min(1280, height);
        }
        if (passiveLimit > 1000000) {
            passiveLimit = 1000000;
        }
        if (potentialLimit > 1000000) {
            potentialLimit = 1000000;
        }
        if (maxCount > 10000) {
            maxCount = 10000;
        }
        NetworkGraph.buffer = new EncodedImage(NetworkGraph.getNetworkPicture(sb.peers, width, height, passiveLimit, potentialLimit, maxCount, coronaangle, communicationTimeout, env.getConfig("network.unit.name", "unspecified"), env.getConfig("network.unit.description", "unspecified"), Long.parseLong(bgcolor, 16), cyc), "png", false);
        lastAccessSeconds = System.currentTimeMillis() / 1000L;
        sync.release();
        return NetworkGraph.buffer;
    }
}

