/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.protocol.ResponseHeader;
import net.yacy.kelondro.util.MapTools;
import net.yacy.peers.NewsDB;
import net.yacy.peers.PeerActions;
import net.yacy.peers.Protocol;
import net.yacy.peers.Seed;
import net.yacy.peers.operation.yacyVersion;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.server.servletProperties;

public class Network {
    private static final String STR_TABLE_LIST = "table_list_";

    public static serverObjects respond(RequestHeader requestHeader, serverObjects post, serverSwitch switchboard) {
        boolean iAmActive;
        String pathInfo;
        Switchboard sb = (Switchboard)switchboard;
        long start = System.currentTimeMillis();
        servletProperties prop = new servletProperties();
        prop.put("menu", post == null ? 2L : (post.get("menu", "").equals("embed") ? 0L : (post.get("menu", "").equals("simple") ? 1L : 2L)));
        if (sb.peers.mySeed() != null) {
            prop.put("menu_newpeer_peerhash", sb.peers.mySeed().hash);
        }
        prop.setLocalized(!(pathInfo = requestHeader.getPathInfo()).endsWith(".xml") && !pathInfo.endsWith(".json"));
        prop.putHTML("page_networkTitle", sb.getConfig("network.unit.description", "unspecified"));
        prop.putHTML("page_networkName", sb.getConfig("network.unit.name", "unspecified"));
        boolean overview = post == null || post.get("page", "0").equals("0");
        String mySeedType = sb.peers.mySeed().get("PeerType", "virgin");
        boolean bl = iAmActive = mySeedType.equals("senior") || mySeedType.equals("principal");
        if (overview) {
            long accActLinks = sb.peers.countActiveURL();
            long accActWords = sb.peers.countActiveRWI();
            long accPassLinks = sb.peers.countPassiveURL();
            long accPassWords = sb.peers.countPassiveRWI();
            long accPotLinks = sb.peers.countPotentialURL();
            long accPotWords = sb.peers.countPotentialRWI();
            int conCount = sb.peers.sizeConnected();
            int disconCount = sb.peers.sizeDisconnected();
            int potCount = sb.peers.sizePotential();
            long otherppm = sb.peers.countActivePPM();
            double otherqpm = sb.peers.countActiveQPM();
            long myppm = 0L;
            double myqph = 0.0;
            Seed seed = sb.peers.mySeed();
            if (sb.peers.mySeed() != null) {
                sb.updateMySeed();
                long LCount = seed.getLinkCount();
                long ICount = seed.getWordCount();
                long RCount = seed.getLong("RCount", 0L);
                prop.putHTML("table_my-name", seed.get("Name", "-"));
                prop.put("table_my-hash", seed.hash);
                prop.put("table_my-ssl", sb.peers.mySeed().getFlagSSLAvailable() ? 1L : 0L);
                if (seed.isVirgin()) {
                    prop.put("table_my-info", 0L);
                } else if (seed.isJunior()) {
                    prop.put("table_my-info", 1L);
                    accPotLinks += LCount;
                    accPotWords += ICount;
                } else if (seed.isSenior()) {
                    prop.put("table_my-info", 2L);
                    accActLinks += LCount;
                    accActWords += ICount;
                } else if (seed.isPrincipal()) {
                    prop.put("table_my-info", 3L);
                    accActLinks += LCount;
                    accActWords += ICount;
                }
                String port = seed.get("Port", "-");
                Set<String> ips = seed.getIPs();
                int ipsc = 0;
                for (String s : ips) {
                    prop.put("table_ips_" + ipsc + "_nodestate", seed.getFlagRootNode() ? 1L : 0L);
                    prop.put("table_ips_" + ipsc + "_c", 0L);
                    prop.putHTML("table_ips_" + ipsc + "_c_hash", seed.hash);
                    prop.putHTML("table_ips_" + ipsc + "_c_ip", s);
                    prop.putHTML("table_ips_" + ipsc + "_c_port", port);
                    prop.put("table_ips_" + ipsc++ + "_c_ipv6", s.indexOf(58) >= 0 ? 1L : 0L);
                }
                prop.put("table_ips", ipsc);
                prop.put("table_my-acceptcrawl", seed.getFlagAcceptRemoteCrawl() ? 1L : 0L);
                prop.put("table_my-dhtreceive", seed.getFlagAcceptRemoteIndex() ? 1L : 0L);
                prop.put("table_my-nodestate", seed.getFlagRootNode() ? 1L : 0L);
                myppm = Switchboard.currentPPM();
                myqph = 60.0 * (double)sb.averageQPM();
                prop.put("table_my-version", seed.get("Version", "-"));
                prop.put("table_my-utc", seed.get("UTC", "-"));
                prop.put("table_my-uptime", PeerActions.formatInterval(60000L * seed.getLong("Uptime", 0L)));
                prop.putNum("table_my-LCount", LCount);
                prop.putNum("table_my-ICount", ICount);
                prop.putNum("table_my-RCount", RCount);
                prop.putNum("table_my-sI", seed.getLong("sI", 0L));
                prop.putNum("table_my-sU", seed.getLong("sU", 0L));
                prop.putNum("table_my-rI", seed.getLong("rI", 0L));
                prop.putNum("table_my-rU", seed.getLong("rU", 0L));
                prop.putNum("table_my-ppm", myppm);
                prop.putNum("table_my-qph", (double)Math.round(100.0 * myqph) / 100.0);
                prop.putNum("table_my-qph-publocal", (double)Math.round(6000.0 * (double)sb.averageQPMPublicLocal()) / 100.0);
                prop.putNum("table_my-qph-pubremote", (double)Math.round(6000.0 * (double)sb.averageQPMGlobal()) / 100.0);
                prop.putNum("table_my-seeds", seed.getLong("SCount", 0L));
                prop.putNum("table_my-connects", seed.getFloat("CCount", 0.0f));
                prop.put("table_my-url", seed.get("seedURL", ""));
                prop.putHTML("table_my-location", ClientIdentification.generateLocation());
            }
            if (iAmActive) {
                ++conCount;
            } else if (mySeedType.equals("junior")) {
                ++potCount;
            }
            int activeLastMonth = sb.peers.sizeActiveSince(43200L);
            int activeLastWeek = sb.peers.sizeActiveSince(10080L);
            int activeLastDay = sb.peers.sizeActiveSince(1440L);
            int activeLastHour = sb.peers.sizeActiveSince(60L);
            int activeSwitch = activeLastHour <= conCount ? 0 : (activeLastDay <= activeLastHour ? 1 : (activeLastWeek <= activeLastDay ? 2 : (activeLastMonth <= activeLastWeek ? 3 : 4)));
            prop.putNum("table_active-switch", activeSwitch);
            prop.putNum("table_active-switch_last-month", activeLastMonth);
            prop.putNum("table_active-switch_last-week", activeLastWeek);
            prop.putNum("table_active-switch_last-day", activeLastDay);
            prop.putNum("table_active-switch_last-hour", activeLastHour);
            prop.putNum("table_active-count", conCount);
            prop.putNum("table_active-links", accActLinks);
            prop.putNum("table_active-words", accActWords);
            prop.putNum("table_passive-count", disconCount);
            prop.putNum("table_passive-links", accPassLinks);
            prop.putNum("table_passive-words", accPassWords);
            prop.putNum("table_potential-count", potCount);
            prop.putNum("table_potential-links", accPotLinks);
            prop.putNum("table_potential-words", accPotWords);
            prop.putNum("table_all-count", conCount + disconCount + potCount);
            prop.putNum("table_all-links", accActLinks + accPassLinks + accPotLinks);
            prop.putNum("table_all-words", accActWords + accPassWords + accPotWords);
            prop.putNum("table_gppm", otherppm + (iAmActive ? myppm : 0L));
            prop.putNum("table_gqph", (double)Math.round(6000.0 * otherqpm + 100.0 * (iAmActive ? myqph : 0.0)) / 100.0);
            prop.put("table", 2L);
            prop.put("page", 0L);
        } else if (post != null && post.getInt("page", 1) == 4) {
            prop.put("table", 4L);
            prop.put("page", 4L);
            if (sb.peers.mySeed() != null) {
                prop.put("table_my-hash", sb.peers.mySeed().hash);
                prop.put("table_my-ip", sb.peers.mySeed().getIPs().toString());
                prop.put("table_my-port", sb.peers.mySeed().getPort());
            }
            if (post.containsKey("addPeer")) {
                int authentication = sb.adminAuthenticated(requestHeader);
                if (authentication < 2) {
                    prop.authenticationRequired();
                    return prop;
                }
                ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
                String challengeIP = post.get("peerIP");
                String challengePort = post.get("peerPort");
                map.put("IP", challengeIP);
                map.put("Port", challengePort);
                Seed peer = post.get("peerHash") == null ? null : new Seed(post.get("peerHash"), map);
                sb.updateMySeed();
                Seed mySeed = sb.peers.mySeed();
                String challengeURLStr = peer.getPublicURL(challengeIP, false);
                try {
                    MultiProtocolURL challengeURL = new MultiProtocolURL(challengeURLStr);
                    Map<String, String> response = Protocol.hello(mySeed, sb.peers.peerActions, challengeURL, peer.hash);
                    if (response == null) {
                        Seed peerd = sb.peers.get(peer.hash);
                        if (peerd != null) {
                            peer = peerd;
                        }
                        sb.peers.peerActions.interfaceDeparture(peer, challengeIP);
                        prop.put("table_comment", 1L);
                        prop.put("table_comment_status", "publish: no response from peer '" + peer.getName() + "/" + post.get("peerHash") + "' from <a href=\"" + challengeURL + "\" target=\"_blank\">" + challengeURL + "</a>");
                    } else {
                        String yourtype = response.get("yourtype");
                        String yourip = response.get("yourip");
                        peer = sb.peers.getConnected(peer.hash);
                        if (peer == null) {
                            prop.put("table_comment", 1L);
                            prop.put("table_comment_status", "publish: disconnected peer 'UNKNOWN/" + post.get("peerHash") + "' from <a href=\"" + challengeURL + "\" target=\"_blank\">" + challengeURL + "</a>, yourtype = " + yourtype + ", yourip = " + yourip);
                        } else {
                            prop.put("table_comment", 2L);
                            prop.put("table_comment_status", "publish: handshaked " + peer.get("PeerType", "senior") + " peer '" + peer.getName() + "' at <a href=\"" + challengeURL + "\" target=\"_blank\">" + challengeURL + "</a>, yourtype = " + yourtype + ", yourip = " + yourip);
                            prop.putHTML("table_comment_details", peer.toString());
                        }
                    }
                }
                catch (MalformedURLException e) {
                    Seed peerd = sb.peers.get(peer.hash);
                    if (peerd != null) {
                        peer = peerd;
                    }
                    sb.peers.peerActions.interfaceDeparture(peer, challengeIP);
                    prop.put("table_comment", 1L);
                    prop.put("table_comment_status", "publish: malformed URL for peer '" + peer.getName() + "/" + post.get("peerHash") + "' : " + challengeURLStr);
                }
                prop.putHTML("table_peerHash", post.get("peerHash"));
                prop.putHTML("table_peerIP", post.get("peerIP"));
                prop.putHTML("table_peerPort", post.get("peerPort"));
            } else {
                prop.put("table_peerHash", "");
                prop.put("table_peerIP", "");
                prop.put("table_peerPort", "");
                prop.put("table_comment", 0L);
            }
        } else if (post != null && post.getInt("page", 1) == 5) {
            prop.put("page", 5L);
            prop.put("table", 5L);
        } else {
            int page = post == null ? 1 : post.getInt("page", 1);
            int maxCount = post == null ? 9000 : post.getInt("maxCount", 9000);
            int conCount = 0;
            if (sb.peers == null) {
                prop.put("table", 0L);
            } else {
                int size = 0;
                switch (page) {
                    case 1: {
                        size = sb.peers.sizeConnected();
                        break;
                    }
                    case 2: {
                        size = sb.peers.sizeDisconnected();
                        break;
                    }
                    case 3: {
                        size = sb.peers.sizePotential();
                        break;
                    }
                }
                if (size == 0) {
                    prop.put("table", 0L);
                } else {
                    if (iAmActive) {
                        sb.updateMySeed();
                        sb.peers.addConnected(sb.peers.mySeed());
                    }
                    HashSet<String> updatedProfile = new HashSet<String>();
                    HashMap<String, Map<String, String>> updatedWiki = new HashMap<String, Map<String, String>>();
                    HashMap<String, Map<String, String>> updatedBlog = new HashMap<String, Map<String, String>>();
                    HashMap<String, String> isCrawling = new HashMap<String, String>();
                    Iterator<NewsDB.Record> recordIterator = sb.peers.newsPool.recordIterator(0);
                    while (recordIterator.hasNext()) {
                        NewsDB.Record record = recordIterator.next();
                        if (record == null) continue;
                        if (record.category().equals("prfleupd")) {
                            updatedProfile.add(record.originator());
                            continue;
                        }
                        if (record.category().equals("wiki_upd")) {
                            updatedWiki.put(record.originator(), record.attributes());
                            continue;
                        }
                        if (record.category().equals("blog_add")) {
                            updatedBlog.put(record.originator(), record.attributes());
                            continue;
                        }
                        if (!record.category().equals("crwlstrt")) continue;
                        isCrawling.put(record.originator(), record.attributes().get("startURL"));
                    }
                    boolean dark = true;
                    boolean c = post != null && post.containsKey("ip");
                    boolean onlyIncomingDHT = post != null && post.containsKey("onlydhtin");
                    boolean onlyNode = post != null && post.containsKey("onlynode");
                    long onlyAgeOverDays = post == null ? 0L : post.getLong("onlyageoverdays", 0L);
                    long onlySizeLessDocs = post == null ? Long.MAX_VALUE : post.getLong("onlysizelessdocs", Long.MAX_VALUE);
                    Iterator<Seed> e = null;
                    boolean order = post != null && post.get("order", "down").equals("up");
                    String sort = post == null ? null : post.get("sort", null);
                    switch (page) {
                        case 1: {
                            e = sb.peers.seedsSortedConnected(order, sort == null ? "LCount" : sort);
                            break;
                        }
                        case 2: {
                            e = sb.peers.seedsSortedDisconnected(order, sort == null ? "LastSeen" : sort);
                            break;
                        }
                        case 3: {
                            e = sb.peers.seedsSortedPotential(order, sort == null ? "LastSeen" : sort);
                            break;
                        }
                    }
                    Pattern peerSearchPattern = null;
                    prop.put("regexerror", 0L);
                    prop.put("regexerror_wrongregex", (String)null);
                    if (post != null && post.containsKey("search")) {
                        try {
                            peerSearchPattern = Pattern.compile(post.get("match", ""), 2);
                        }
                        catch (PatternSyntaxException pse) {
                            prop.put("regexerror", 1L);
                            prop.putHTML("regexerror_wrongregex", pse.getPattern());
                        }
                    }
                    if (e != null) {
                        while (e.hasNext() && conCount < maxCount) {
                            Locale l;
                            String location;
                            Map wikiMap;
                            Set<String> ips;
                            Seed seed = e.next();
                            assert (seed != null);
                            if (seed == null || onlyIncomingDHT && !seed.getFlagAcceptRemoteIndex() || onlyNode && !seed.getFlagRootNode() || (long)seed.getAge() < onlyAgeOverDays || seed.getLinkCount() > onlySizeLessDocs) continue;
                            if (post != null && post.containsKey("search") && peerSearchPattern != null) {
                                boolean abort = true;
                                Matcher m = peerSearchPattern.matcher(seed.getName());
                                if (m.find()) {
                                    abort = false;
                                }
                                if ((m = peerSearchPattern.matcher(seed.hash)).find()) {
                                    abort = false;
                                }
                                if (abort) continue;
                            }
                            if ((ips = seed.getIPs()).isEmpty()) continue;
                            prop.put(STR_TABLE_LIST + conCount + "_updatedProfile", 0L);
                            prop.put(STR_TABLE_LIST + conCount + "_updatedWikiPage", 0L);
                            prop.put(STR_TABLE_LIST + conCount + "_updatedBlog", 0L);
                            prop.put(STR_TABLE_LIST + conCount + "_isCrawling", 0L);
                            String ip = ips.iterator().next();
                            if (conCount >= maxCount) break;
                            if (sb.peers != null && sb.peers.mySeed() != null && seed.hash != null && seed.hash.equals(sb.peers.mySeed().hash)) {
                                prop.put(STR_TABLE_LIST + conCount + "_dark", 2L);
                            } else {
                                prop.put(STR_TABLE_LIST + conCount + "_dark", dark ? 1 : 0);
                                boolean bl2 = dark = !dark;
                            }
                            if (updatedProfile.contains(seed.hash)) {
                                prop.put(STR_TABLE_LIST + conCount + "_updatedProfile", 1L);
                                prop.put(STR_TABLE_LIST + conCount + "_updatedProfile_hash", seed.hash);
                            }
                            if ((wikiMap = (Map)updatedWiki.get(seed.hash)) == null) {
                                prop.put(STR_TABLE_LIST + conCount + "_updatedWiki", 0L);
                            } else {
                                prop.put(STR_TABLE_LIST + conCount + "_updatedWiki", 1L);
                                prop.putHTML(STR_TABLE_LIST + conCount + "_updatedWiki_page", (String)wikiMap.get("page"));
                                prop.put(STR_TABLE_LIST + conCount + "_updatedWiki_address", seed.getPublicAddress(ip));
                            }
                            Map blogMap = (Map)updatedBlog.get(seed.hash);
                            if (blogMap == null) {
                                prop.put(STR_TABLE_LIST + conCount + "_updatedBlog", 0L);
                            } else {
                                prop.put(STR_TABLE_LIST + conCount + "_updatedBlog", 1L);
                                prop.putHTML(STR_TABLE_LIST + conCount + "_updatedBlog_page", (String)blogMap.get("page"));
                                prop.putHTML(STR_TABLE_LIST + conCount + "_updatedBlog_subject", (String)blogMap.get("subject"));
                                prop.put(STR_TABLE_LIST + conCount + "_updatedBlog_address", seed.getPublicAddress(ip));
                            }
                            int PPM = seed.getPPM();
                            double QPM = seed.getQPM();
                            String startURL = (String)isCrawling.get(seed.hash);
                            if (startURL != null && PPM >= 4) {
                                prop.put(STR_TABLE_LIST + conCount + "_isCrawling", 1L);
                                prop.put(STR_TABLE_LIST + conCount + "_isCrawling_page", startURL);
                            }
                            prop.put(STR_TABLE_LIST + conCount + "_hash", seed.hash);
                            String shortname = seed.get("Name", "deadlink");
                            if (shortname.length() > 20) {
                                shortname = shortname.substring(0, 20) + "...";
                            }
                            prop.putHTML(STR_TABLE_LIST + conCount + "_shortname", shortname);
                            prop.putHTML(STR_TABLE_LIST + conCount + "_fullname", seed.get("Name", "deadlink"));
                            prop.put(STR_TABLE_LIST + conCount + "_special", seed.getFlagRootNode() && !seed.getFlagAcceptRemoteIndex() ? 1L : 0L);
                            prop.put(STR_TABLE_LIST + conCount + "_ssl", seed.getFlagSSLAvailable() ? 1L : 0L);
                            prop.put(STR_TABLE_LIST + conCount + "_ssl_ip", ip);
                            prop.put(STR_TABLE_LIST + conCount + "_ssl_portssl", seed.get("PortSSL", "8443"));
                            String userAgent = null;
                            if (seed.hash != null && seed.hash.equals(sb.peers.mySeed().hash)) {
                                userAgent = ClientIdentification.yacyInternetCrawlerAgent.userAgent;
                                location = ClientIdentification.generateLocation();
                            } else {
                                userAgent = sb.peers.peerActions.getUserAgent(ip);
                                location = ClientIdentification.parseLocationInUserAgent(userAgent);
                            }
                            if (location.length() > 10) {
                                location = location.substring(0, 10);
                            }
                            if (location.length() == 0 && (l = Domains.getLocale(ip)) != null) {
                                location = l.toString();
                            }
                            prop.putHTML(STR_TABLE_LIST + conCount + "_location", location);
                            String port = seed.get("Port", "-");
                            int ipsc = 0;
                            for (String s : ips) {
                                prop.put(STR_TABLE_LIST + conCount + "_ips_" + ipsc + "_nodestate", seed.getFlagRootNode() ? 1L : 0L);
                                prop.put(STR_TABLE_LIST + conCount + "_ips_" + ipsc + "_c", c ? 1L : 0L);
                                prop.putHTML(STR_TABLE_LIST + conCount + "_ips_" + ipsc + "_c_hash", seed.hash);
                                prop.putHTML(STR_TABLE_LIST + conCount + "_ips_" + ipsc + "_c_ip", s);
                                prop.putHTML(STR_TABLE_LIST + conCount + "_ips_" + ipsc + "_c_port", port);
                                prop.put(STR_TABLE_LIST + conCount + "_ips_" + ipsc++ + "_c_ipv6", s.indexOf(58) >= 0 ? 1L : 0L);
                            }
                            prop.put(STR_TABLE_LIST + conCount + "_ips", ipsc);
                            prop.put(STR_TABLE_LIST + conCount + "_port", port);
                            prop.put(STR_TABLE_LIST + conCount + "_hash", seed.hash);
                            prop.put(STR_TABLE_LIST + conCount + "_age", seed.getAge());
                            prop.putNum(STR_TABLE_LIST + conCount + "_seeds", seed.getLong("SCount", 0L));
                            prop.putNum(STR_TABLE_LIST + conCount + "_connects", seed.getFloat("CCount", 0.0f));
                            if (c) {
                                prop.put(STR_TABLE_LIST + conCount + "_c", 1L);
                                prop.putHTML(STR_TABLE_LIST + conCount + "_c_userAgent", userAgent);
                            } else {
                                prop.put(STR_TABLE_LIST + conCount + "_c", 0L);
                            }
                            if (seed.isJunior()) {
                                prop.put(STR_TABLE_LIST + conCount + "_type", 0L);
                            } else if (seed.isSenior()) {
                                prop.put(STR_TABLE_LIST + conCount + "_type", 1L);
                            } else if (seed.isPrincipal()) {
                                prop.put(STR_TABLE_LIST + conCount + "_type", 2L);
                            }
                            prop.putHTML(STR_TABLE_LIST + conCount + "_type_url", seed.get("seedURL", "http://nowhere/"));
                            long lastseen = Math.abs((System.currentTimeMillis() - seed.getLastSeenUTC()) / 1000L / 60L);
                            if (page == 1 && lastseen > 720L) continue;
                            if (page == 2 || page == 1 && lastseen > 360L) {
                                prop.put(STR_TABLE_LIST + conCount + "_type_direct", 2L);
                            } else {
                                prop.put(STR_TABLE_LIST + conCount + "_type_direct", seed.getFlagDirectConnect() ? 1L : 0L);
                            }
                            if (page == 1) {
                                prop.put(STR_TABLE_LIST + conCount + "_acceptcrawl", seed.getFlagAcceptRemoteCrawl() ? 1L : 0L);
                                prop.put(STR_TABLE_LIST + conCount + "_dhtreceive", seed.getFlagAcceptRemoteIndex() ? 1L : 0L);
                            } else {
                                if (seed.getFlagAcceptRemoteCrawl()) {
                                    prop.put(STR_TABLE_LIST + conCount + "_acceptcrawl", 2L);
                                } else {
                                    prop.put(STR_TABLE_LIST + conCount + "_acceptcrawl", 0L);
                                }
                                if (seed.getFlagAcceptRemoteIndex()) {
                                    prop.put(STR_TABLE_LIST + conCount + "_dhtreceive", 2L);
                                } else {
                                    prop.put(STR_TABLE_LIST + conCount + "_dhtreceive", 0L);
                                }
                            }
                            if (seed.getFlagAcceptRemoteIndex()) {
                                prop.put(STR_TABLE_LIST + conCount + "_dhtreceive_peertags", "");
                            } else {
                                String peertags = MapTools.set2string(seed.getPeerTags(), ",", false);
                                prop.putHTML(STR_TABLE_LIST + conCount + "_dhtreceive_peertags", peertags == null || peertags.isEmpty() ? "no tags given" : "tags = " + peertags);
                            }
                            String[] yv = yacyVersion.combined2prettyVersion(seed.get("Version", "0.1"), shortname);
                            prop.putHTML(STR_TABLE_LIST + conCount + "_version", yv[0] + "/" + yv[1]);
                            prop.putNum(STR_TABLE_LIST + conCount + "_lastSeen", lastseen);
                            prop.put(STR_TABLE_LIST + conCount + "_utc", seed.get("UTC", "-"));
                            prop.putHTML(STR_TABLE_LIST + conCount + "_uptime", PeerActions.formatInterval(60000L * seed.getLong("Uptime", 0L)));
                            prop.putNum(STR_TABLE_LIST + conCount + "_LCount", seed.getLinkCount());
                            prop.putNum(STR_TABLE_LIST + conCount + "_ICount", seed.getWordCount());
                            prop.putNum(STR_TABLE_LIST + conCount + "_RCount", seed.getLong("RCount", 0L));
                            prop.putNum(STR_TABLE_LIST + conCount + "_sI", seed.getLong("sI", 0L));
                            prop.putNum(STR_TABLE_LIST + conCount + "_sU", seed.getLong("sU", 0L));
                            prop.putNum(STR_TABLE_LIST + conCount + "_rI", seed.getLong("rI", 0L));
                            prop.putNum(STR_TABLE_LIST + conCount + "_rU", seed.getLong("rU", 0L));
                            prop.putNum(STR_TABLE_LIST + conCount + "_ppm", PPM);
                            prop.putNum(STR_TABLE_LIST + conCount + "_qph", (double)Math.round(6000.0 * QPM) / 100.0);
                            ++conCount;
                        }
                    }
                    if (iAmActive) {
                        sb.peers.removeMySeed();
                    }
                    prop.put("table_list", conCount);
                    prop.put("table", 1L);
                    prop.putNum("table_num", conCount);
                    prop.putNum("table_total", page == 1 && iAmActive ? (long)(size + 1) : (long)size);
                    prop.put("table_c", c ? 1 : 0);
                }
            }
            prop.put("page", page);
            prop.put("table_page", page);
            prop.putHTML("table_searchpattern", post == null ? "" : post.get("match", ""));
            switch (page) {
                case 1: {
                    prop.putHTML("table_peertype", "senior/principal");
                    break;
                }
                case 2: {
                    prop.putHTML("table_peertype", "senior/principal");
                    break;
                }
                case 3: {
                    prop.putHTML("table_peertype", "junior");
                    break;
                }
            }
        }
        prop.putNum("table_rt", System.currentTimeMillis() - start);
        String path = requestHeader.getPathInfo();
        if (path != null && path.endsWith(".xml")) {
            ResponseHeader outgoingHeader = new ResponseHeader(200);
            outgoingHeader.put("Access-Control-Allow-Origin", "*");
            prop.setOutgoingHeader(outgoingHeader);
        }
        return prop;
    }
}

