/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.federate.solr.connector.RemoteSolrConnector;
import net.yacy.cora.federate.solr.connector.ShardSelection;
import net.yacy.cora.federate.solr.instance.RemoteInstance;
import net.yacy.cora.federate.solr.instance.ShardInstance;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.TransactionManager;
import net.yacy.kelondro.util.OS;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import org.apache.solr.common.SolrException;

public class IndexFederated_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        long fileSizeMax;
        int wordCacheMaxCount;
        serverObjects prop = new serverObjects();
        Switchboard sb = (Switchboard)env;
        if (post != null && post.containsKey("setrwi")) {
            TransactionManager.checkPostTransaction(header, post);
            boolean post_core_rwi = post.getBoolean("core.service.rwi");
            boolean previous_core_rwi = sb.index.connectedRWI() && env.getConfigBool("core.service.rwi.tmp", false);
            env.setConfig("core.service.rwi.tmp", post_core_rwi);
            if (previous_core_rwi && !post_core_rwi) {
                sb.index.disconnectRWI();
            }
            if (!previous_core_rwi && post_core_rwi) {
                try {
                    wordCacheMaxCount = (int)sb.getConfigLong("wordCacheMaxCount", 20000L);
                    fileSizeMax = OS.isWindows ? sb.getConfigLong("filesize.max.win", Integer.MAX_VALUE) : sb.getConfigLong("filesize.max.other", Integer.MAX_VALUE);
                    sb.index.connectRWI(wordCacheMaxCount, fileSizeMax);
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
        }
        if (post != null && post.containsKey("setcitation")) {
            TransactionManager.checkPostTransaction(header, post);
            boolean post_core_citation = post.getBoolean("core.service.citation.tmp");
            boolean previous_core_citation = sb.index.connectedCitation() && env.getConfigBool("core.service.citation.tmp", false);
            env.setConfig("core.service.citation.tmp", post_core_citation);
            if (previous_core_citation && !post_core_citation) {
                sb.index.disconnectCitation();
            }
            if (!previous_core_citation && post_core_citation) {
                try {
                    wordCacheMaxCount = (int)sb.getConfigLong("wordCacheMaxCount", 20000L);
                    fileSizeMax = OS.isWindows ? sb.getConfigLong("filesize.max.win", Integer.MAX_VALUE) : sb.getConfigLong("filesize.max.other", Integer.MAX_VALUE);
                    sb.index.connectCitation(wordCacheMaxCount, fileSizeMax);
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
            boolean webgraph = post.getBoolean("core.service.webgraph.tmp");
            sb.index.fulltext().setUseWebgraph(webgraph);
            env.setConfig("core.service.webgraph.tmp", webgraph);
        }
        if (post != null && post.containsKey("setsolr")) {
            block36: {
                TransactionManager.checkPostTransaction(header, post);
                boolean post_core_fulltext = post.getBoolean("core.service.fulltext");
                boolean previous_core_fulltext = sb.index.fulltext().connectedLocalSolr() && env.getConfigBool("core.service.fulltext", true);
                env.setConfig("core.service.fulltext", post_core_fulltext);
                if (previous_core_fulltext && !post_core_fulltext) {
                    sb.index.fulltext().disconnectLocalSolr();
                }
                if (!previous_core_fulltext && post_core_fulltext) {
                    try {
                        sb.index.fulltext().connectLocalSolr();
                    }
                    catch (IOException e) {
                        ConcurrentLog.logException(e);
                    }
                }
                boolean solrRemoteWasOn = sb.index.fulltext().connectedRemoteSolr() && env.getConfigBool("federated.service.solr.indexing.enabled", false);
                String solrurls = post.get("solr.indexing.url", env.getConfig("federated.service.solr.indexing.url", "http://127.0.0.1:8983/solr"));
                boolean solrRemoteIsOnAfterwards = post.getBoolean("solr.indexing.solrremote") & solrurls.length() > 0;
                env.setConfig("federated.service.solr.indexing.enabled", solrRemoteIsOnAfterwards);
                env.setConfig("federated.service.solr.indexing.authenticated.allowSelfSigned", post.getBoolean("federated.service.solr.indexing.authenticated.allowSelfSigned"));
                BufferedReader r = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(UTF8.getBytes(solrurls))));
                StringBuilder s = new StringBuilder();
                try {
                    String s0;
                    while ((s0 = r.readLine()) != null) {
                        if ((s0 = s0.trim()).length() <= 0) continue;
                        s.append(s0).append(',');
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (s.length() > 0) {
                    s.setLength(s.length() - 1);
                }
                solrurls = s.toString().trim();
                env.setConfig("federated.service.solr.indexing.url", solrurls);
                String shardMethodName = post.get("solr.indexing.sharding", env.getConfig("federated.service.solr.indexing.sharding", ShardSelection.Method.MODULO_HOST_MD5.name()));
                ShardSelection.Method shardMethod = ShardSelection.Method.valueOf(shardMethodName);
                env.setConfig("federated.service.solr.indexing.sharding", shardMethod.name());
                if (solrRemoteWasOn && !solrRemoteIsOnAfterwards) {
                    try {
                        sb.index.fulltext().disconnectRemoteSolr();
                    }
                    catch (Throwable e) {
                        ConcurrentLog.logException(e);
                    }
                }
                boolean writeEnabled = post.getBoolean("solr.indexing.solrremote.writeenabled");
                sb.setConfig("federated.service.solr.indexing.writeEnabled", writeEnabled);
                if (solrRemoteIsOnAfterwards) {
                    try {
                        if (solrRemoteWasOn) {
                            sb.index.fulltext().disconnectRemoteSolr();
                        }
                        boolean usesolr = sb.getConfigBool("federated.service.solr.indexing.enabled", false) & solrurls.length() > 0;
                        int solrtimeout = sb.getConfigInt("federated.service.solr.indexing.timeout", 10000);
                        boolean trustSelfSignedOnAuthenticatedServer = Switchboard.getSwitchboard().getConfigBool("federated.service.solr.indexing.authenticated.allowSelfSigned", false);
                        try {
                            if (usesolr) {
                                ArrayList<RemoteInstance> instances = RemoteInstance.getShardInstances(solrurls, null, null, solrtimeout, trustSelfSignedOnAuthenticatedServer);
                                sb.index.fulltext().connectRemoteSolr(instances, shardMethod, writeEnabled);
                                break block36;
                            }
                            sb.index.fulltext().disconnectRemoteSolr();
                        }
                        catch (Throwable e) {
                            ConcurrentLog.logException(e);
                            try {
                                sb.index.fulltext().disconnectRemoteSolr();
                            }
                            catch (Throwable ee) {
                                ConcurrentLog.logException(ee);
                            }
                        }
                    }
                    catch (SolrException e) {
                        ConcurrentLog.severe("IndexFederated_p", "change of solr connection failed", e);
                    }
                }
            }
            boolean lazy = post.getBoolean("solr.indexing.lazy");
            env.setConfig("federated.service.solr.indexing.lazy", lazy);
        }
        prop.put("transactionToken", TransactionManager.getTransactionToken(header));
        if (!sb.index.fulltext().connectedRemoteSolr()) {
            prop.put("table", 0L);
        } else {
            prop.put("table", 1L);
            RemoteSolrConnector solr = sb.index.fulltext().getDefaultRemoteSolrConnector();
            long[] size = new long[]{solr.getSize()};
            boolean toExternalAddress = !header.accessFromLocalhost();
            String externalHost = null;
            if (toExternalAddress) {
                externalHost = header.getServerName();
            }
            ArrayList<String> urls2 = ((ShardInstance)solr.getInstance()).getAdminInterfaces(toExternalAddress, externalHost);
            boolean dark = false;
            for (int i = 0; i < size.length; ++i) {
                prop.put("table_list_" + i + "_dark", dark ? 1L : 0L);
                dark = !dark;
                prop.put("table_list_" + i + "_url", urls2.get(i));
                prop.put("table_list_" + i + "_size", size[i]);
            }
            prop.put("table_list", size.length);
        }
        prop.put("core.service.fulltext.checked", env.getConfigBool("core.service.fulltext", true) ? 1L : 0L);
        prop.put("core.service.rwi.checked", env.getConfigBool("core.service.rwi.tmp", false) ? 1L : 0L);
        prop.put("core.service.citation.tmp.checked", env.getConfigBool("core.service.citation.tmp", false) ? 1L : 0L);
        prop.put("core.service.webgraph.tmp.checked", env.getConfigBool("core.service.webgraph.tmp", false) ? 1L : 0L);
        prop.put("solr.indexing.solrremote.checked", env.getConfigBool("federated.service.solr.indexing.enabled", false) ? 1L : 0L);
        prop.put("federated.service.solr.indexing.authenticated.allowSelfSigned.checked", env.getConfigBool("federated.service.solr.indexing.authenticated.allowSelfSigned", false));
        prop.put("solr.indexing.url", env.getConfig("federated.service.solr.indexing.url", "http://127.0.0.1:8983/solr").replace(",", "\n"));
        String thisShardingMethodName = env.getConfig("federated.service.solr.indexing.sharding", ShardSelection.Method.MODULO_HOST_MD5.name());
        int mc = 0;
        for (ShardSelection.Method method : ShardSelection.Method.values()) {
            prop.put("solr.indexing.sharding.methods_" + mc + "_method", method.name());
            prop.put("solr.indexing.sharding.methods_" + mc + "_description", method.description);
            prop.put("solr.indexing.sharding.methods_" + mc + "_selected", method.name().equals(thisShardingMethodName) ? 1L : 0L);
            ++mc;
        }
        prop.put("solr.indexing.sharding.methods", mc);
        prop.put("solr.indexing.solrremote.writeenabled.checked", env.getConfigBool("federated.service.solr.indexing.writeEnabled", true));
        prop.put("solr.indexing.lazy.checked", env.getConfigBool("federated.service.solr.indexing.lazy", true) ? 1L : 0L);
        return prop;
    }
}

