/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.regex.Pattern;
import net.yacy.cora.date.ISO8601Formatter;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.federate.solr.connector.AbstractSolrConnector;
import net.yacy.cora.federate.solr.connector.SolrConnector;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.sorting.ScoreMap;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.TransactionManager;
import net.yacy.search.Switchboard;
import net.yacy.search.query.QueryModifier;
import net.yacy.search.schema.CollectionSchema;
import net.yacy.search.schema.WebgraphSchema;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import org.apache.solr.common.SolrDocument;

public class IndexDeletion_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        boolean simulate;
        int count;
        String querydelete;
        String collectiondelete;
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        prop.put("transactionToken", TransactionManager.getTransactionToken(header));
        SolrConnector defaultConnector = sb.index.fulltext().getDefaultConnector();
        SolrConnector webgraphConnector = sb.index.fulltext().getWebgraphConnector();
        if (post == null || post.size() == 0) {
            defaultConnector.commit(false);
        }
        String schemaName = "collection1";
        if (post != null) {
            schemaName = post.get("core", schemaName);
        }
        String urldelete = post == null ? "" : post.get("urldelete", "");
        boolean urldelete_mm_subpath_checked = post == null ? true : post.get("urldelete-mm", "subpath").equals("subpath");
        prop.putHTML("urldelete", urldelete);
        prop.put("urldelete-mm-subpath-checked", urldelete_mm_subpath_checked ? 1L : 0L);
        prop.put("urldelete-mm-regexp-checked", urldelete_mm_subpath_checked ? 0L : 1L);
        prop.put("urldelete-active", 0L);
        int timedelete_number = post == null ? 14 : post.getInt("timedelete-number", 14);
        String timedelete_unit = post == null ? "day" : post.get("timedelete-unit", "day");
        boolean timedelete_source_loaddate_checked = post == null ? true : post.get("timedelete-source", "loaddate").equals("loaddate");
        for (int i = 1; i <= 90; ++i) {
            prop.put("timedelete-n-" + i, 0L);
        }
        prop.put("timedelete-n-" + timedelete_number, timedelete_number);
        prop.put("timedelete-u-year", timedelete_unit.equals("year") ? 1L : 0L);
        prop.put("timedelete-u-month", timedelete_unit.equals("month") ? 1L : 0L);
        prop.put("timedelete-u-day", timedelete_unit.equals("day") ? 1L : 0L);
        prop.put("timedelete-u-hour", timedelete_unit.equals("hour") ? 1L : 0L);
        prop.put("timedelete-source-loaddate-checked", timedelete_source_loaddate_checked ? 1L : 0L);
        prop.put("timedelete-source-lastmodified-checked", timedelete_source_loaddate_checked ? 0L : 1L);
        prop.put("timedelete-active", 0L);
        boolean collectiondelete_mode_unassigned_checked = post == null ? true : post.get("collectiondelete-mode", "unassigned").equals("unassigned");
        String string = collectiondelete = post == null ? "" : post.get("collectiondelete", "");
        if (post != null && post.containsKey("collectionlist")) {
            collectiondelete_mode_unassigned_checked = false;
            prop.put("collectiondelete-select", 1L);
            try {
                ScoreMap collectionMap = defaultConnector.getFacets("*:*", 1000, CollectionSchema.collection_sxt.getSolrFieldName()).get(CollectionSchema.collection_sxt.getSolrFieldName());
                Iterator i = collectionMap.iterator();
                int c = 0;
                while (i.hasNext()) {
                    String collection = (String)i.next();
                    prop.put("collectiondelete-select_list_" + c + "_collection-name", collection + "/" + collectionMap.get(collection));
                    prop.put("collectiondelete-select_list_" + c + "_collection-value", collection);
                    ++c;
                }
                prop.put("collectiondelete-select_list", c);
            }
            catch (IOException e1) {
                prop.put("collectiondelete-select", 0L);
            }
        } else {
            prop.put("collectiondelete-select", 0L);
        }
        prop.put("collectiondelete-mode-unassigned-checked", collectiondelete_mode_unassigned_checked ? 1L : 0L);
        prop.put("collectiondelete-mode-assigned-checked", collectiondelete_mode_unassigned_checked ? 0L : 1L);
        prop.putHTML("collectiondelete-select_collectiondelete", collectiondelete);
        prop.put("collectiondelete-active", 0L);
        prop.put("querydelete", "");
        String string2 = querydelete = post == null ? "" : post.get("querydelete", "");
        if (!querydelete.isEmpty() && !querydelete.contains(":")) {
            querydelete = CollectionSchema.text_t.getSolrFieldName() + ":" + querydelete;
        }
        prop.putHTML("querydelete", querydelete);
        prop.put("querydelete-active", 0L);
        int n = count = post == null ? -1 : post.getInt("count", -1);
        if (post != null && (post.containsKey("simulate-urldelete") || post.containsKey("engage-urldelete"))) {
            TransactionManager.checkPostTransaction(header, post);
            simulate = post.containsKey("simulate-urldelete");
            urldelete = urldelete.trim();
            if (urldelete_mm_subpath_checked) {
                String[] stubURLs;
                HashSet<String> ids = new HashSet<String>();
                for (String urlStub : stubURLs = urldelete.indexOf(10) > 0 || urldelete.indexOf(13) > 0 ? urldelete.split("[\\r\\n]+") : urldelete.split(Pattern.quote("|"))) {
                    if (urlStub == null || urlStub.length() == 0) continue;
                    int pos = urlStub.indexOf("://", 0);
                    if (pos == -1) {
                        urlStub = urlStub.startsWith("ftp") ? "ftp://" + urlStub : "http://" + urlStub;
                    }
                    try {
                        DigestURL u = new DigestURL(urlStub);
                        BlockingQueue<SolrDocument> dq = defaultConnector.concurrentDocumentsByQuery(CollectionSchema.host_s.getSolrFieldName() + ":\"" + u.getHost() + "\"", null, 0, 100000000, Long.MAX_VALUE, 100, 1, false, CollectionSchema.id.getSolrFieldName(), CollectionSchema.sku.getSolrFieldName());
                        try {
                            SolrDocument doc;
                            while ((doc = dq.take()) != AbstractSolrConnector.POISON_DOCUMENT) {
                                String url = (String)doc.getFieldValue(CollectionSchema.sku.getSolrFieldName());
                                if (!url.startsWith(urlStub)) continue;
                                ids.add((String)doc.getFieldValue(CollectionSchema.id.getSolrFieldName()));
                            }
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (simulate) {
                    count = ids.size();
                    prop.put("urldelete-active", count == 0 ? 2L : 1L);
                } else {
                    sb.remove(ids);
                    defaultConnector.commit(false);
                    ids.forEach(urlhash -> {
                        try {
                            sb.index.loadTimeIndex().remove(urlhash.getBytes());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                    sb.tables.recordAPICall(post, "IndexDeletion_p.html", "deletion", "deletion, docs matching with " + urldelete);
                    prop.put("urldelete-active", 2L);
                }
            } else {
                String regexquery = CollectionSchema.sku.getSolrFieldName() + ":/" + urldelete + "/";
                if (simulate) {
                    try {
                        count = (int)defaultConnector.getCountByQuery("{!cache=false}" + regexquery);
                    }
                    catch (IOException stubURLs) {
                        // empty catch block
                    }
                    prop.put("urldelete-active", count == 0 ? 2L : 1L);
                } else {
                    try {
                        defaultConnector.deleteByQuery(regexquery);
                        defaultConnector.commit(false);
                        try {
                            sb.index.loadTimeIndex().clear();
                        }
                        catch (IOException stubURLs) {
                            // empty catch block
                        }
                        sb.tables.recordAPICall(post, "IndexDeletion_p.html", "deletion", "deletion, regex match = " + urldelete);
                    }
                    catch (IOException stubURLs) {
                        // empty catch block
                    }
                    prop.put("urldelete-active", 2L);
                }
            }
            prop.put("urldelete-active_count", count);
        }
        if (post != null && (post.containsKey("simulate-timedelete") || post.containsKey("engage-timedelete"))) {
            TransactionManager.checkPostTransaction(header, post);
            simulate = post.containsKey("simulate-timedelete");
            Date deleteageDate = null;
            long t = IndexDeletion_p.timeParser(timedelete_number, timedelete_unit);
            if (t > 0L) {
                deleteageDate = new Date(t);
            }
            String collection1Query = (timedelete_source_loaddate_checked ? CollectionSchema.load_date_dt : CollectionSchema.last_modified).getSolrFieldName() + ":[* TO " + ISO8601Formatter.FORMATTER.format(deleteageDate) + "]";
            String webgraphQuery = (timedelete_source_loaddate_checked ? WebgraphSchema.load_date_dt : WebgraphSchema.last_modified).getSolrFieldName() + ":[* TO " + ISO8601Formatter.FORMATTER.format(deleteageDate) + "]";
            if (simulate) {
                try {
                    count = (int)defaultConnector.getCountByQuery(collection1Query);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                prop.put("timedelete-active", count == 0 ? 2L : 1L);
            } else {
                try {
                    defaultConnector.deleteByQuery(collection1Query);
                    defaultConnector.commit(false);
                    try {
                        sb.index.loadTimeIndex().clear();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (webgraphConnector != null) {
                        webgraphConnector.deleteByQuery(webgraphQuery);
                    }
                    sb.tables.recordAPICall(post, "IndexDeletion_p.html", "deletion", "deletion, docs older than " + timedelete_number + " " + timedelete_unit);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                prop.put("timedelete-active", 2L);
            }
            prop.put("timedelete-active_count", count);
        }
        if (post != null && (post.containsKey("simulate-collectiondelete") || post.containsKey("engage-collectiondelete"))) {
            String query2;
            TransactionManager.checkPostTransaction(header, post);
            simulate = post.containsKey("simulate-collectiondelete");
            collectiondelete = collectiondelete.replaceAll(" ", "").replaceAll(",", "|");
            String string3 = collectiondelete_mode_unassigned_checked ? "-" + CollectionSchema.collection_sxt + ":[* TO *]" : (query2 = collectiondelete.length() == 0 ? CollectionSchema.collection_sxt + ":\"\"" : QueryModifier.parseCollectionExpression(collectiondelete));
            if (simulate) {
                try {
                    count = (int)defaultConnector.getCountByQuery(query2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                prop.put("collectiondelete-active", count == 0 ? 2L : 1L);
            } else {
                try {
                    defaultConnector.deleteByQuery(query2);
                    defaultConnector.commit(false);
                    try {
                        sb.index.loadTimeIndex().clear();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    sb.tables.recordAPICall(post, "IndexDeletion_p.html", "deletion", "deletion, collection " + collectiondelete);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                prop.put("collectiondelete-active", 2L);
            }
            prop.put("collectiondelete-active_count", count);
        }
        if (post != null && (post.containsKey("simulate-querydelete") || post.containsKey("engage-querydelete"))) {
            SolrConnector connector;
            TransactionManager.checkPostTransaction(header, post);
            simulate = post.containsKey("simulate-querydelete");
            SolrConnector solrConnector = connector = schemaName.equals("collection1") ? defaultConnector : sb.index.fulltext().getWebgraphConnector();
            if (simulate) {
                try {
                    count = (int)connector.getCountByQuery(querydelete);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                prop.put("querydelete-active", count == 0 ? 2L : 1L);
            } else {
                try {
                    ConcurrentLog.info("IndexDeletion", "delete by query \"" + querydelete + "\", size before deletion = " + connector.getSize());
                    connector.deleteByQuery(querydelete);
                    connector.commit(false);
                    try {
                        sb.index.loadTimeIndex().clear();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ConcurrentLog.info("IndexDeletion", "delete by query \"" + querydelete + "\", size after commit = " + connector.getSize());
                    sb.tables.recordAPICall(post, "IndexDeletion_p.html", "deletion", "deletion, solr query, q = " + querydelete);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                prop.put("querydelete-active", 2L);
            }
            prop.put("querydelete-active_count", count);
        }
        prop.put("doccount", defaultConnector.getSize());
        prop.put("cores_0_name", "collection1");
        prop.put("cores_0_selected", "collection1".equals(schemaName) ? 1L : 0L);
        prop.put("cores_1_name", "webgraph");
        prop.put("cores_1_selected", "webgraph".equals(schemaName) ? 1L : 0L);
        prop.put("cores", 2L);
        return prop;
    }

    private static long timeParser(int number, String unit) {
        if ("year".equals(unit)) {
            return System.currentTimeMillis() - (long)number * 31536000000L;
        }
        if ("month".equals(unit)) {
            return System.currentTimeMillis() - (long)number * 2592000000L;
        }
        if ("day".equals(unit)) {
            return System.currentTimeMillis() - (long)number * 86400000L;
        }
        if ("hour".equals(unit)) {
            return System.currentTimeMillis() - (long)number * 3600000L;
        }
        if ("minute".equals(unit)) {
            return System.currentTimeMillis() - (long)number * 60000L;
        }
        return 0L;
    }
}

