/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.net.MalformedURLException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.CrawlSwitchboard;
import net.yacy.crawler.data.CrawlProfile;
import net.yacy.crawler.data.NoticedURL;
import net.yacy.crawler.retrieval.Request;
import net.yacy.peers.Seed;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import org.apache.http.conn.util.InetAddressUtils;

public class IndexCreateQueues_p {
    private static final DateTimeFormatter DAY_FORMATTER = DateTimeFormatter.ofPattern("uuuu/MM/dd", Locale.US).withZone(ZoneId.systemDefault());
    private static final int INVALID = 0;
    private static final int URL = 1;
    private static final int ANCHOR = 2;
    private static final int PROFILE = 3;
    private static final int DEPTH = 4;
    private static final int INITIATOR = 5;
    private static final int MODIFIED = 6;

    private static String daydate(Date date) {
        if (date == null) {
            return "";
        }
        return GenericFormatter.formatSafely(date.toInstant(), DAY_FORMATTER);
    }

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        int stackSize;
        String deletepattern;
        boolean embed;
        int sortByHost;
        int sortByCount;
        int urlsPerHost;
        NoticedURL.StackType stackType;
        serverObjects prop;
        Switchboard sb;
        block44: {
            sb = (Switchboard)env;
            prop = new serverObjects();
            stackType = NoticedURL.StackType.LOCAL;
            urlsPerHost = 3;
            sortByCount = 0;
            sortByHost = 0;
            embed = false;
            deletepattern = ".*";
            if (post != null) {
                stackType = NoticedURL.StackType.valueOf(post.get("stack", stackType.name()).toUpperCase());
                urlsPerHost = post.getInt("urlsPerHost", urlsPerHost);
                if (post.containsKey("embed")) {
                    embed = true;
                }
                if (post.containsKey("sort")) {
                    String countSort = post.get("sort");
                    if (countSort.equals("count")) {
                        sortByCount = 1;
                    }
                    if (countSort.equals("-count")) {
                        sortByCount = -1;
                    }
                    if (countSort.equals("host")) {
                        sortByHost = 1;
                    }
                    if (countSort.equals("-host")) {
                        sortByHost = -1;
                    }
                }
                if (post.containsKey("delete")) {
                    deletepattern = post.get("pattern", deletepattern).trim();
                    int option = post.getInt("option", 0);
                    if (".*".equals(deletepattern)) {
                        sb.crawlQueues.noticeURL.clear(stackType);
                        try {
                            sb.cleanProfiles();
                        }
                        catch (InterruptedException interruptedException) {}
                    } else if (option > 0) {
                        try {
                            Pattern compiledPattern = Pattern.compile(deletepattern);
                            if (option == 3) {
                                for (byte[] handle : sb.crawler.getActive()) {
                                    CrawlProfile entry2 = sb.crawler.getActive(handle);
                                    String name = entry2.name();
                                    if (CrawlSwitchboard.DEFAULT_PROFILES.contains(name) || !compiledPattern.matcher(name).find()) continue;
                                    sb.crawler.removeActive(entry2.handle().getBytes());
                                    sb.crawler.removePassive(entry2.handle().getBytes());
                                }
                                break block44;
                            }
                            int removedByHosts = 0;
                            if (option == 1 && deletepattern.startsWith(".*") && deletepattern.endsWith(".*")) {
                                HashSet<String> hosthashes = new HashSet<String>();
                                String hn = deletepattern.substring(2, deletepattern.length() - 2);
                                try {
                                    hosthashes.add(DigestURL.hosthash(hn, hn.startsWith("ftp") ? 21 : 80));
                                    hosthashes.add(DigestURL.hosthash(hn, 443));
                                    removedByHosts = sb.crawlQueues.removeHosts(hosthashes);
                                }
                                catch (MalformedURLException name) {
                                    // empty catch block
                                }
                            }
                            if (removedByHosts == 0) {
                                Iterator<Request> iter = sb.crawlQueues.noticeURL.iterator(stackType);
                                ArrayList<byte[]> removehashes = new ArrayList<byte[]>();
                                while (iter.hasNext()) {
                                    Request entry3 = iter.next();
                                    if (entry3 == null) continue;
                                    Object value = null;
                                    switch (option) {
                                        case 1: {
                                            value = entry3.url() == null ? null : entry3.url().toString();
                                            break;
                                        }
                                        case 2: {
                                            value = entry3.name();
                                            break;
                                        }
                                        case 4: {
                                            value = Integer.toString(entry3.depth());
                                            break;
                                        }
                                        case 5: {
                                            value = entry3.initiator() == null || entry3.initiator().length == 0 ? "proxy" : ASCII.String(entry3.initiator());
                                            break;
                                        }
                                        case 6: {
                                            value = IndexCreateQueues_p.daydate(entry3.appdate());
                                            break;
                                        }
                                        default: {
                                            value = null;
                                        }
                                    }
                                    if (value == null || !compiledPattern.matcher((CharSequence)value).matches()) continue;
                                    removehashes.add(entry3.url().hash());
                                }
                                ConcurrentLog.info("IndexCreateQueues_p", "created a remove list with " + removehashes.size() + " entries for pattern '" + deletepattern + "'");
                                for (byte[] b : removehashes) {
                                    sb.crawlQueues.noticeURL.removeByURLHash(b);
                                }
                            }
                        }
                        catch (PatternSyntaxException e) {
                            ConcurrentLog.logException(e);
                        }
                    }
                }
            }
        }
        if ((stackSize = sb.crawlQueues.noticeURL.stackSize(stackType)) == 0) {
            prop.put("crawler", "0");
        } else {
            prop.put("crawler", "1");
            prop.put("crawler_embed", embed ? 1L : 0L);
            prop.put("crawler_embed_deletepattern", deletepattern);
            prop.put("crawler_embed_queuename", stackType.name());
            Map hosts = sb.crawlQueues.noticeURL.getDomainStackHosts(stackType, sb.robots);
            prop.put("crawler_showtable_queuename", stackType.name());
            if (sortByCount == 0 && sortByHost == 0) {
                prop.put("crawler_showtable_sortedByCount", false);
                prop.put("crawler_showtable_sortedByCount_asc", true);
                prop.put("crawler_showtable_sortedByHost", false);
                prop.put("crawler_showtable_sortedByHost_asc", false);
            } else {
                if (sortByCount != 0) {
                    prop.put("crawler_showtable_sortedByHost", false);
                    prop.put("crawler_showtable_sortedByHost_asc", false);
                    prop.put("crawler_showtable_sortedByCount", true);
                    if (sortByCount < 0) {
                        Map hosts_sorted;
                        prop.put("crawler_showtable_sortedByCount_asc", false);
                        hosts = hosts_sorted = (Map)hosts.entrySet().stream().sorted((e1, e2) -> ((Integer[])e2.getValue())[0].compareTo(((Integer[])e1.getValue())[0])).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
                    } else {
                        Map hosts_sorted;
                        prop.put("crawler_showtable_sortedByCount_asc", true);
                        hosts = hosts_sorted = (Map)hosts.entrySet().stream().sorted((e1, e2) -> ((Integer[])e1.getValue())[0].compareTo(((Integer[])e2.getValue())[0])).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
                    }
                }
                if (sortByHost != 0) {
                    prop.put("crawler_showtable_sortedByCount", false);
                    prop.put("crawler_showtable_sortedByCount_asc", true);
                    prop.put("crawler_showtable_sortedByHost", true);
                    if (sortByHost < 0) {
                        prop.put("crawler_showtable_sortedByHost_asc", false);
                        TreeMap hosts_sorted = new TreeMap(Collections.reverseOrder());
                        hosts_sorted.putAll(hosts);
                        hosts = hosts_sorted;
                    } else {
                        prop.put("crawler_showtable_sortedByHost_asc", true);
                        TreeMap<String, Integer[]> hosts_sorted = new TreeMap<String, Integer[]>(hosts);
                        hosts = hosts_sorted;
                    }
                }
            }
            int hc = 0;
            for (Map.Entry<String, Integer[]> host : hosts.entrySet()) {
                String hostnameport = host.getKey();
                String hostname = Domains.stripToHostName(hostnameport);
                if (InetAddressUtils.isIPv6Address((String)hostname)) {
                    hostname = "[" + hostname + "]";
                }
                prop.putHTML("crawler_host_" + hc + "_hostnameport", hostnameport);
                prop.putHTML("crawler_host_" + hc + "_hostname", hostname);
                prop.put("crawler_host_" + hc + "_embed", embed ? 1L : 0L);
                prop.put("crawler_host_" + hc + "_urlsPerHost", urlsPerHost);
                prop.putHTML("crawler_host_" + hc + "_queuename", stackType.name());
                prop.put("crawler_host_" + hc + "_hostcount", host.getValue()[0].intValue());
                prop.put("crawler_host_" + hc + "_hostdelta", host.getValue()[1] == Integer.MIN_VALUE ? "not accessed" : Integer.toString(host.getValue()[1]));
                List<Request> domainStackReferences = sb.crawlQueues.noticeURL.getDomainStackReferences(stackType, hostname, urlsPerHost, 10000L);
                int count = 0;
                for (Request request : domainStackReferences) {
                    if (request == null) continue;
                    Seed initiator = sb.peers.getConnected(request.initiator() == null ? "" : ASCII.String(request.initiator()));
                    String profileHandle = request.profileHandle();
                    CrawlProfile profileEntry = profileHandle == null ? null : sb.crawler.getActive(profileHandle.getBytes());
                    String depthString = Integer.toString(request.depth());
                    while (depthString.length() < 4) {
                        depthString = "0" + depthString;
                    }
                    prop.putHTML("crawler_host_" + hc + "_list_" + count + "_initiator", initiator == null ? "proxy" : initiator.getName());
                    prop.put("crawler_host_" + hc + "_list_" + count + "_profile", profileEntry == null ? "unknown" : profileEntry.collectionName());
                    prop.putHTML("crawler_host_" + hc + "_list_" + count + "_depth", depthString);
                    prop.put("crawler_host_" + hc + "_list_" + count + "_modified", IndexCreateQueues_p.daydate(request.appdate()));
                    prop.putHTML("crawler_host_" + hc + "_list_" + count + "_anchor", request.name());
                    prop.putHTML("crawler_host_" + hc + "_list_" + count + "_url", request.url().toNormalform(true));
                    prop.put("crawler_host_" + hc + "_list_" + count + "_hash", request.url().hash());
                    ++count;
                }
                prop.putNum("crawler_host_" + hc + "_list", count);
                ++hc;
            }
            prop.put("crawler_host", hc);
        }
        prop.put("embed", embed ? 1L : 0L);
        prop.put("queuename", stackType.name().charAt(0) + stackType.name().substring(1).toLowerCase());
        prop.put("embed_queuename", stackType.name().charAt(0) + stackType.name().substring(1).toLowerCase());
        return prop;
    }
}

