/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import net.yacy.cora.protocol.RequestHeader;
import net.yacy.document.Parser;
import net.yacy.document.TextParser;
import net.yacy.document.parser.pdfParser;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class ConfigParser_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        serverObjects prop = new serverObjects();
        Switchboard sb = (Switchboard)env;
        if (post != null) {
            if (post.containsKey("parserSettings")) {
                post.remove("parserSettings");
                for (Parser parser : TextParser.parsers()) {
                    for (String ext : parser.supportedExtensions()) {
                        TextParser.grantExtension(ext, "on".equals(post.get("extension_" + ext, "")));
                    }
                    for (String mimeType : parser.supportedMimeTypes()) {
                        TextParser.grantMime(mimeType, "on".equals(post.get("mimename_" + mimeType, "")));
                    }
                }
                env.setConfig("parser.mime.deny", TextParser.getDenyMime());
                env.setConfig("parser.extensions.deny", TextParser.getDenyExtension());
            }
            if (post.containsKey("pdfSettings")) {
                env.setConfig("parser.pdf.individualpages", post.getBoolean("individualPages"));
                env.setConfig("parser.pdf.individualpages.key", post.get("individualPagePropertyname", "page"));
                pdfParser.individualPages = sb.getConfigBool("parser.pdf.individualpages", false);
                pdfParser.individualPagePropertyname = sb.getConfig("parser.pdf.individualpages.key", "page");
            }
        }
        int i = 0;
        for (Parser parser : TextParser.parsers()) {
            prop.put("parser_" + i + "_name", parser.getName());
            int extIdx = 0;
            for (String ext : parser.supportedExtensions()) {
                prop.put("parser_" + i + "_ext_" + extIdx + "_extension", ext);
                prop.put("parser_" + i + "_ext_" + extIdx + "_status", TextParser.supportsExtension(ext) == null ? 1L : 0L);
                ++extIdx;
            }
            prop.put("parser_" + i + "_ext", extIdx);
            int mimeIdx = 0;
            for (String mimeType : parser.supportedMimeTypes()) {
                prop.put("parser_" + i + "_mime_" + mimeIdx + "_mimetype", mimeType);
                prop.put("parser_" + i + "_mime_" + mimeIdx + "_status", TextParser.supportsMime(mimeType) == null ? 1L : 0L);
                ++mimeIdx;
            }
            prop.put("parser_" + i + "_mime", mimeIdx);
            ++i;
        }
        prop.put("parser", i);
        prop.put("individualPages", sb.getConfigBool("parser.pdf.individualpages", false));
        prop.put("individualPagePropertyname", sb.getConfig("parser.pdf.individualpages.key", "page"));
        return prop;
    }
}

