/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.data.TransactionManager;
import net.yacy.data.Translator;
import net.yacy.http.YaCyHttpServer;
import net.yacy.peers.OnePeerPingBusyThread;
import net.yacy.peers.Seed;
import net.yacy.search.Switchboard;
import net.yacy.server.http.HTTPDFileHandler;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.utils.translation.TranslatorXliff;
import net.yacy.utils.upnp.UPnP;
import net.yacy.utils.upnp.UPnPMappingType;

public class ConfigBasic {
    private static final int NEXTSTEP_FINISHED = 0;
    private static final int NEXTSTEP_PWD = 1;
    private static final int NEXTSTEP_PEERNAME = 2;
    private static final int NEXTSTEP_PEERPORT = 3;
    private static final int NEXTSTEP_RECONNECT = 4;

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) throws FileNotFoundException, IOException {
        boolean properPort;
        boolean reconnect;
        Seed oldSeed;
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        File langPath = new File(sb.getAppPath("locale.source", "locales").getAbsolutePath());
        String lang = env.getConfig("locale.language", "browser");
        int authentication = sb.adminAuthenticated(header);
        if (authentication < 2) {
            prop.authenticationRequired();
            return prop;
        }
        prop.put("transactionToken", TransactionManager.getTransactionToken(header));
        if (sb.peers.mySeed().isVirgin() || sb.peers.mySeed().isJunior()) {
            new OnePeerPingBusyThread(sb.yc).start();
        }
        String peerName = sb.peers.mySeed().getName();
        long port = env.getLocalPort();
        boolean ssl = env.getConfigBool("server.https", false);
        boolean upnp = false;
        if (post != null) {
            TransactionManager.checkPostTransaction(header, post);
            if (post.containsKey("set")) {
                sb.tables.recordAPICall(post, "ConfigBasic.html", "configuration", "basic settings");
            }
            if (post.containsKey("language") && !lang.equals(post.get("language", "default")) && new TranslatorXliff().changeLang(env, langPath, post.get("language", "default") + ".lng")) {
                prop.put("changedLanguage", "1");
            }
            if (post.getInt("port", 0) > 1023) {
                port = post.getLong("port", 8090L);
                ssl = post.getBoolean("withssl");
            }
            peerName = post.get("peername", "");
            if (post.containsKey("port")) {
                upnp = post.containsKey("enableUpnp");
                if (upnp && !sb.getConfigBool("upnp.enabled", false)) {
                    UPnP.addPortMappings();
                }
                sb.setConfig("upnp.enabled", upnp);
                if (!upnp) {
                    UPnP.deletePortMappings();
                }
            }
        }
        if (ssl) {
            prop.put("withsslenabled_sslport", env.getHttpServer().getSslPort());
        }
        if (peerName != null && peerName.length() > 0) {
            peerName = peerName.replace(' ', '-');
        }
        if ((oldSeed = sb.peers.lookupByName(peerName)) == null && !peerName.equals(sb.peers.mySeed().getName()) && Pattern.compile("[A-Za-z0-9\\-_]{3,80}").matcher(peerName).matches()) {
            sb.peers.setMyName(peerName);
            sb.peers.saveMySeed();
        }
        if ((long)env.getLocalPort() != port || env.getConfigBool("server.https", false) != ssl) {
            String host;
            YaCyHttpServer theServerCore = env.getHttpServer();
            env.setConfig("port", port);
            env.setConfig("server.https", ssl);
            reconnect = true;
            if (upnp) {
                UPnP.addPortMappings();
            }
            if ((host = header.getServerName()) == null) {
                host = Domains.myPublicLocalIP().getHostAddress();
            }
            prop.put("reconnect", "1");
            prop.put("reconnect_host", host);
            prop.put("nextStep_host", host);
            prop.put("reconnect_port", port);
            prop.put("nextStep_port", port);
            prop.put("reconnect_sslSupport", theServerCore.withSSL() ? "1" : "0");
            prop.put("nextStep_sslSupport", theServerCore.withSSL() ? "1" : "0");
            theServerCore.reconnect(2000);
        } else {
            reconnect = false;
            prop.put("reconnect", "0");
        }
        prop.put("setUseCase_switchError", 0L);
        prop.put("setUseCase_switchWarning", 0L);
        String networkName = sb.getConfig("network.unit.name", "");
        if (post != null && post.containsKey("usecase")) {
            boolean hasNonEmptyRemoteSolr;
            TransactionManager.checkPostTransaction(header, post);
            boolean bl = hasNonEmptyRemoteSolr = sb.index.fulltext().connectedRemoteSolr() && (sb.index.fulltext().collectionSize() > 0L || sb.index.fulltext().webgraphSize() > 0L);
            if ("freeworld".equals(post.get("usecase", "")) && !"freeworld".equals(networkName)) {
                if ("intranet".equals(networkName) && hasNonEmptyRemoteSolr) {
                    prop.put("setUseCase_switchError", 1L);
                } else {
                    if (hasNonEmptyRemoteSolr) {
                        prop.put("setUseCase_switchWarning", 2L);
                    }
                    sb.setConfig("core.service.rwi.tmp", true);
                    sb.switchNetwork("defaults/yacy.network.freeworld.unit");
                    sb.setConfig("allowDistributeIndex", true);
                    sb.setConfig("allowReceiveIndex", true);
                    sb.setConfig("allowReceiveIndex.search", true);
                    sb.setConfig("search.verify", "iffresh");
                    sb.setConfig("search.verify.delete", "true");
                }
            }
            if ("portal".equals(post.get("usecase", "")) && !"webportal".equals(networkName)) {
                if ("intranet".equals(networkName) && hasNonEmptyRemoteSolr) {
                    prop.put("setUseCase_switchError", 1L);
                } else {
                    if (hasNonEmptyRemoteSolr) {
                        prop.put("setUseCase_switchWarning", 2L);
                    }
                    sb.setConfig("core.service.rwi.tmp", false);
                    sb.switchNetwork("defaults/yacy.network.webportal.unit");
                    sb.setConfig("allowDistributeIndex", false);
                    sb.setConfig("allowReceiveIndex", false);
                    sb.setConfig("allowReceiveIndex.search", false);
                    sb.setConfig("search.verify", "ifexist");
                    sb.setConfig("search.verify.delete", "false");
                }
            }
            if ("intranet".equals(post.get("usecase", "")) && !"intranet".equals(networkName)) {
                if (hasNonEmptyRemoteSolr) {
                    prop.put("setUseCase_switchWarning", 1L);
                }
                sb.setConfig("core.service.rwi.tmp", false);
                sb.switchNetwork("defaults/yacy.network.intranet.unit");
                sb.setConfig("allowDistributeIndex", false);
                sb.setConfig("allowReceiveIndex", false);
                sb.setConfig("allowReceiveIndex.search", false);
                sb.setConfig("search.verify", "cacheonly");
                sb.setConfig("search.verify.delete", "false");
            }
        }
        if ("freeworld".equals(networkName = sb.getConfig("network.unit.name", ""))) {
            prop.put("setUseCase", 1L);
            prop.put("setUseCase_freeworldChecked", 1L);
        } else if ("webportal".equals(networkName)) {
            prop.put("setUseCase", 1L);
            prop.put("setUseCase_portalChecked", 1L);
        } else if ("intranet".equals(networkName)) {
            prop.put("setUseCase", 1L);
            prop.put("setUseCase_intranetChecked", 1L);
        } else {
            prop.put("setUseCase", 0L);
        }
        prop.put("setUseCase_port", port);
        boolean properPassword = sb.getConfig("adminAccountBase64MD5", "").length() > 0 || sb.getConfigBool("adminAccountForLocalhost", false);
        boolean properName = sb.peers.mySeed().getName().length() >= 3 && !Seed.isDefaultPeerName(sb.peers.mySeed().getName());
        boolean bl = properPort = sb.peers.mySeed().isSenior() || sb.peers.mySeed().isPrincipal();
        if (env.getConfig("defaultFiles", "").startsWith("ConfigBasic.html,")) {
            env.setConfig("defaultFiles", env.getConfig("defaultFiles", "").substring(17));
            env.setConfig("browserPopUpPage", "Status.html");
            HTTPDFileHandler.initDefaultPath();
        }
        prop.put("statusName", properName ? "1" : "0");
        prop.put("statusPort", properPort ? "1" : "0");
        if (reconnect) {
            prop.put("nextStep", 4L);
        } else if (!properName) {
            prop.put("nextStep", 2L);
        } else if (!properPassword) {
            prop.put("nextStep", 1L);
        } else if (!properPort) {
            prop.put("nextStep", 3L);
        } else {
            prop.put("nextStep", 0L);
        }
        boolean upnp_enabled = env.getConfigBool("upnp.enabled", false);
        prop.put("upnp", "1");
        prop.put("upnp_enabled", upnp_enabled ? "1" : "0");
        if (upnp_enabled) {
            prop.put("upnp_success", UPnP.getMappedPort(UPnPMappingType.HTTP) > 0 ? "2" : "1");
        } else {
            prop.put("upnp_success", "0");
        }
        prop.putHTML("defaultName", sb.peers.mySeed().getName());
        prop.put("defaultPort", env.getLocalPort());
        prop.put("withsslenabled", env.getConfigBool("server.https", false) ? 1L : 0L);
        lang = env.getConfig("locale.language", "default");
        prop.put("lang_browser", "0");
        prop.put("lang_de", "0");
        prop.put("lang_fr", "0");
        prop.put("lang_zh", "0");
        prop.put("lang_ru", "0");
        prop.put("lang_uk", "0");
        prop.put("lang_en", "0");
        prop.put("lang_ja", "0");
        prop.put("lang_el", "0");
        prop.put("lang_it", "0");
        prop.put("lang_es", "0");
        if ("default".equals(lang)) {
            prop.put("lang_en", "1");
        } else {
            prop.put("lang_" + lang, "1");
        }
        if (lang.equals("browser")) {
            List<String> l = Translator.activeTranslations();
            prop.put("active_zh", l.contains("zh") ? "2" : "1");
            prop.put("active_de", l.contains("de") ? "2" : "1");
            prop.put("active_fr", l.contains("fr") ? "2" : "1");
            prop.put("active_hi", l.contains("hi") ? "2" : "1");
            prop.put("active_ja", l.contains("ja") ? "2" : "1");
            prop.put("active_el", l.contains("el") ? "2" : "1");
            prop.put("active_it", l.contains("it") ? "2" : "1");
            prop.put("active_ru", l.contains("ru") ? "2" : "1");
            prop.put("active_uk", l.contains("uk") ? "2" : "1");
            prop.put("active_es", l.contains("es") ? "2" : "1");
            prop.put("active_en", "2");
        } else {
            prop.put("active_de", "0");
            prop.put("active_fr", "0");
            prop.put("active_hi", "0");
            prop.put("active_zh", "0");
            prop.put("active_ru", "0");
            prop.put("active_uk", "0");
            prop.put("active_en", "0");
            prop.put("active_ja", "0");
            prop.put("active_el", "0");
            prop.put("active_it", "0");
            prop.put("active_es", "0");
        }
        return prop;
    }
}

