/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.TransactionManager;
import net.yacy.data.UserDB;
import net.yacy.http.YaCyHttpServer;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class ConfigAccounts_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        serverObjects prop = new serverObjects();
        prop.put("transactionToken", TransactionManager.getTransactionToken(header));
        Switchboard sb = (Switchboard)env;
        UserDB.Entry entry2 = null;
        boolean localhostAccess = sb.getConfigBool("adminAccountForLocalhost", false);
        if (post != null && post.containsKey("setAccess")) {
            TransactionManager.checkPostTransaction(header, post);
            sb.setConfig("adminAccountAllPages", post.getBoolean("adminAccountAllPages"));
        }
        if (post != null && post.containsKey("setAdmin")) {
            TransactionManager.checkPostTransaction(header, post);
            localhostAccess = post.get("access", "").equals("localhost");
            String user = post.get("adminuser", "");
            String pw1 = post.get("adminpw1", "");
            UserDB.AccessRight[] pw2 = post.get("adminpw2", "");
            int inputerror = 0;
            if (user.length() > 0 && pw1.equals(pw2)) {
                String oldusername = env.getConfig("adminAccountUserName", user);
                env.setConfig("adminAccountBase64MD5", sb.encodeDigestAuth(user, pw1));
                env.setConfig("adminAccountUserName", user);
                YaCyHttpServer jhttpserver = sb.getHttpServer();
                if (!user.equals(oldusername)) {
                    jhttpserver.removeUser(oldusername);
                }
                jhttpserver.resetUser(user);
            } else if (!localhostAccess) {
                inputerror = user.isEmpty() ? 3 : 2;
                prop.put("error", inputerror);
            }
            if (inputerror == 0) {
                if (localhostAccess) {
                    sb.setConfig("adminAccountForLocalhost", true);
                } else {
                    sb.setConfig("adminAccountForLocalhost", false);
                    if (env.getConfig("adminAccountBase64MD5", "").startsWith("0000")) {
                        env.setConfig("adminAccountBase64MD5", "");
                    }
                }
            }
        }
        if (env.getConfig("adminAccountBase64MD5", "").isEmpty() && !env.getConfigBool("adminAccountForLocalhost", false)) {
            prop.put("passwordNotSetWarning", 1L);
        }
        prop.put("adminAccountAllPages.checked", sb.getConfigBool("adminAccountAllPages", false) ? 1L : 0L);
        prop.put("localhost.checked", localhostAccess ? 1L : 0L);
        prop.put("account.checked", localhostAccess ? 0L : 1L);
        prop.put("statusPassword", localhostAccess ? "0" : "1");
        prop.put("defaultUser", env.getConfig("adminAccountUserName", "admin"));
        prop.put("current_user", "newuser");
        prop.put("username", "");
        prop.put("firstname", "");
        prop.put("lastname", "");
        prop.put("address", "");
        prop.put("timelimit", "");
        prop.put("timeused", "");
        UserDB.AccessRight[] rights = UserDB.AccessRight.values();
        int c = 0;
        for (UserDB.AccessRight right : rights) {
            prop.put("rights_" + c + "_name", right.toString());
            prop.put("rights_" + c + "_friendlyName", right.getFriendlyName());
            prop.put("rights_" + c + "_set", "0");
            ++c;
        }
        prop.put("rights", c);
        prop.put("users", "0");
        if (sb.userDB == null) {
            return prop;
        }
        if (post != null) {
            if (post.containsKey("user") && !"newuser".equals(post.get("user"))) {
                TransactionManager.checkPostTransaction(header, post);
                if (post.containsKey("change_user")) {
                    entry2 = sb.userDB.getEntry(post.get("user"));
                    if (entry2 != null) {
                        prop.putHTML("current_user", post.get("user"));
                        prop.putHTML("username", post.get("user"));
                        prop.putHTML("firstname", entry2.getFirstName());
                        prop.putHTML("lastname", entry2.getLastName());
                        prop.putHTML("address", entry2.getAddress());
                        prop.put("timelimit", entry2.getTimeLimit());
                        prop.put("timeused", entry2.getTimeUsed());
                        int count = 0;
                        for (UserDB.AccessRight right : rights) {
                            prop.put("rights_" + count + "_set", entry2.hasRight(right) ? "1" : "0");
                            ++count;
                        }
                        prop.put("rights", count);
                    }
                } else if (post.containsKey("delete_user") && !"newuser".equals(post.get("user"))) {
                    sb.userDB.removeEntry(post.get("user"));
                }
            } else if (post.containsKey("change")) {
                TransactionManager.checkPostTransaction(header, post);
                prop.put("text", "0");
                prop.put("error", "0");
                String username = post.get("username");
                String pw1 = post.get("password");
                String pw2 = post.get("password2");
                if (pw1 == null || !pw1.equals(pw2)) {
                    prop.put("error", "2");
                    return prop;
                }
                if (username.equalsIgnoreCase(sb.getConfig("adminAccountUserName", "admin"))) {
                    prop.put("error", "4");
                    return prop;
                }
                String firstName = post.get("firstname");
                String lastName = post.get("lastname");
                String address = post.get("address");
                String timeLimit = post.get("timelimit");
                String timeUsed = post.get("timeused");
                EnumMap<UserDB.AccessRight, String> rightsSet = new EnumMap<UserDB.AccessRight, String>(UserDB.AccessRight.class);
                for (UserDB.AccessRight right : rights) {
                    rightsSet.put(right, post.containsKey(right.toString()) && "on".equals(post.get(right.toString())) ? "true" : "false");
                }
                HashMap<String, String> mem = new HashMap<String, String>();
                if ("newuser".equals(post.get("current_user"))) {
                    if (!"".equals(pw1)) {
                        mem.put("MD5_user:pwd", sb.encodeDigestAuth(username, pw1));
                    }
                    mem.put("firstName", firstName);
                    mem.put("lastName", lastName);
                    mem.put("address", address);
                    mem.put("timeLimit", timeLimit);
                    mem.put("timeUsed", timeUsed);
                    for (UserDB.AccessRight right : rights) {
                        mem.put(right.toString(), (String)rightsSet.get((Object)right));
                    }
                    try {
                        entry2 = sb.userDB.createEntry(username, mem);
                        sb.userDB.addEntry(entry2);
                        prop.putHTML("text_username", username);
                        prop.put("text", "1");
                    }
                    catch (IllegalArgumentException e) {
                        prop.put("error", "3");
                    }
                } else {
                    entry2 = sb.userDB.getEntry(username);
                    if (entry2 != null) {
                        try {
                            entry2.setProperty("MD5_user:pwd", sb.encodeDigestAuth(username, pw1));
                            entry2.setProperty("firstName", firstName);
                            entry2.setProperty("lastName", lastName);
                            entry2.setProperty("address", address);
                            entry2.setProperty("timeLimit", timeLimit);
                            entry2.setProperty("timeUsed", timeUsed);
                            for (UserDB.AccessRight right : rights) {
                                entry2.setProperty(right.toString(), (String)rightsSet.get((Object)right));
                            }
                        }
                        catch (Exception e) {
                            ConcurrentLog.logException(e);
                        }
                    } else {
                        prop.put("error", "1");
                    }
                    prop.putHTML("text_username", username);
                    prop.put("text", "2");
                }
                prop.putHTML("username", username);
                if (entry2 != null) {
                    prop.putHTML("current_user", entry2.getUserName());
                    prop.putHTML("username", entry2.getUserName());
                    prop.putHTML("firstname", entry2.getFirstName());
                    prop.putHTML("lastname", entry2.getLastName());
                    prop.putHTML("address", entry2.getAddress());
                    prop.put("timelimit", entry2.getTimeLimit());
                    prop.put("timeused", entry2.getTimeUsed());
                    int count = 0;
                    for (UserDB.AccessRight right : rights) {
                        prop.put("rights_" + count + "_set", entry2.hasRight(right) ? "1" : "0");
                        ++count;
                    }
                    prop.put("rights", count);
                }
            }
        }
        Iterator<UserDB.Entry> it = sb.userDB.iterator(true);
        int numUsers = 0;
        while (it.hasNext()) {
            entry2 = it.next();
            if (entry2 == null) continue;
            prop.putHTML("users_" + numUsers + "_user", entry2.getUserName());
            ++numUsers;
        }
        prop.put("users", numUsers);
        return prop;
    }
}

