/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.util.Iterator;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.data.UserDB;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class ConfigAccountList_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        serverObjects prop = new serverObjects();
        Switchboard sb = (Switchboard)env;
        if (sb.userDB == null) {
            prop.put("userlist", 0L);
            return prop;
        }
        Iterator<UserDB.Entry> it = sb.userDB.iterator(true);
        int numUsers = 0;
        while (it.hasNext()) {
            long used;
            UserDB.Entry entry2 = it.next();
            if (entry2 == null) continue;
            prop.putHTML("userlist_" + numUsers + "_username", entry2.getUserName());
            prop.putHTML("userlist_" + numUsers + "_lastname", entry2.getLastName());
            prop.putHTML("userlist_" + numUsers + "_firstname", entry2.getFirstName());
            prop.putHTML("userlist_" + numUsers + "_address", entry2.getAddress());
            if (entry2.getLastAccess() != null) {
                prop.put("userlist_" + numUsers + "_lastaccess", GenericFormatter.formatSafely(entry2.getLastAccess(), GenericFormatter.FORMAT_SIMPLE));
            } else {
                prop.put("userlist_" + numUsers + "_lastaccess", "never");
            }
            UserDB.AccessRight[] rights = UserDB.AccessRight.values();
            String rightStr = "";
            for (UserDB.AccessRight right : rights) {
                if (!entry2.hasRight(right)) continue;
                rightStr = rightStr.isEmpty() ? right.getFriendlyName() : rightStr + ", " + right.getFriendlyName();
            }
            prop.putHTML("userlist_" + numUsers + "_rights", rightStr);
            if (entry2.getTrafficLimit() != null) {
                long limit = entry2.getTrafficLimit();
                used = entry2.getTrafficSize();
                long percent = used * 100L / limit;
                prop.put("userlist_" + numUsers + "_time", percent);
            } else {
                prop.put("userlist_" + numUsers + "_time", "");
            }
            long percent = -1L;
            if (entry2.getTimeLimit() > 0L) {
                long limit = entry2.getTimeLimit();
                used = entry2.getTimeUsed();
                percent = used * 100L / limit;
                prop.put("userlist_" + numUsers + "_traffic", percent);
            } else {
                prop.put("userlist_" + numUsers + "_traffic", "");
            }
            ++numUsers;
        }
        prop.put("userlist", numUsers);
        return prop;
    }
}

