/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.document.id.Punycode;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.ListManager;
import net.yacy.document.parser.html.CharacterCoding;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.repository.Blacklist;
import net.yacy.repository.BlacklistHelper;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class Blacklist_p {
    private static final String EDIT = "edit_";
    private static final String DISABLED = "disabled_";
    private static final String BLACKLIST = "blackLists_";
    private static final String BLACKLIST_MOVE = "blackListsMove_";
    private static final String BLACKLIST_SHARED = "BlackLists.Shared";

    /*
     * WARNING - void declaration
     */
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        List<String> dirlist = FileUtils.getDirListing(ListManager.listsPath, "^.*\\.black$");
        String blacklistToUse = null;
        serverObjects prop = new serverObjects();
        if (post != null) {
            String action = post.get("action", "");
            if (post.containsKey("selectList") && (blacklistToUse = post.get("selectedListName")) != null && blacklistToUse.isEmpty()) {
                blacklistToUse = null;
            }
            if (post.containsKey("createNewList")) {
                blacklistToUse = post.get("newListName", "").trim();
                if (blacklistToUse.isEmpty()) {
                    prop.put("LOCATION", "Blacklist_p.html");
                    return prop;
                }
                if (!blacklistToUse.matches("^[\\p{L}\\d\\+\\-_]+[\\p{L}\\d\\+\\-_.]*(\\.black){0,1}$")) {
                    prop.put("error", 1L);
                    prop.putHTML("error_name", blacklistToUse);
                    blacklistToUse = null;
                } else {
                    if (!blacklistToUse.endsWith(".black")) {
                        blacklistToUse = blacklistToUse + ".black";
                    }
                    if (!dirlist.contains(blacklistToUse)) {
                        try {
                            File newFile = new File(ListManager.listsPath, blacklistToUse);
                            newFile.createNewFile();
                            for (Blacklist.BlacklistType supportedBlacklistType : Blacklist.BlacklistType.values()) {
                                ListManager.updateListSet((Object)((Object)supportedBlacklistType) + ".BlackLists", blacklistToUse);
                            }
                        }
                        catch (IOException newFile) {}
                    } else {
                        prop.put("error", 2L);
                        prop.putHTML("error_name", blacklistToUse);
                        blacklistToUse = null;
                    }
                    dirlist = FileUtils.getDirListing(ListManager.listsPath, "^.*\\.black$");
                }
            } else if (post.containsKey("deleteList")) {
                blacklistToUse = post.get("selectedListName");
                if (blacklistToUse == null || blacklistToUse.isEmpty()) {
                    prop.put("LOCATION", "Blacklist_p.html");
                    return prop;
                }
                Blacklist.BlacklistType[] blackListFile = new File(ListManager.listsPath, blacklistToUse);
                if (!blackListFile.delete()) {
                    ConcurrentLog.warn("Blacklist", "file " + blackListFile + " could not be deleted!");
                }
                for (Blacklist.BlacklistType supportedBlacklistType : Blacklist.BlacklistType.values()) {
                    ListManager.removeFromListSet((Object)((Object)supportedBlacklistType) + ".BlackLists", blacklistToUse);
                }
                ListManager.removeFromListSet(BLACKLIST_SHARED, blacklistToUse);
                blacklistToUse = null;
                dirlist = FileUtils.getDirListing(ListManager.listsPath, "^.*\\.black$");
            } else if (post.containsKey("activateList")) {
                blacklistToUse = post.get("selectedListName", "").trim();
                if (blacklistToUse == null || blacklistToUse.isEmpty()) {
                    prop.put("LOCATION", "Blacklist_p.html");
                    return prop;
                }
                for (Blacklist.BlacklistType supportedBlacklistType : Blacklist.BlacklistType.values()) {
                    if (post.containsKey("activateList4" + (Object)((Object)supportedBlacklistType))) {
                        ListManager.updateListSet((Object)((Object)supportedBlacklistType) + ".BlackLists", blacklistToUse);
                        continue;
                    }
                    ListManager.removeFromListSet((Object)((Object)supportedBlacklistType) + ".BlackLists", blacklistToUse);
                }
                Switchboard.urlBlacklist.clear();
                ListManager.reloadBlacklists();
            } else if (post.containsKey("shareList")) {
                blacklistToUse = post.get("selectedListName", "").trim();
                if (blacklistToUse == null || blacklistToUse.isEmpty()) {
                    prop.put("LOCATION", "Blacklist_p.html");
                    return prop;
                }
                if (ListManager.listSetContains(BLACKLIST_SHARED, blacklistToUse)) {
                    ListManager.removeFromListSet(BLACKLIST_SHARED, blacklistToUse);
                } else {
                    ListManager.updateListSet(BLACKLIST_SHARED, blacklistToUse);
                }
            } else if ("deleteBlacklistEntry".equals(action)) {
                blacklistToUse = post.get("currentBlacklist", "").trim();
                Object[] selectedBlacklistEntries = post.getAll("selectedEntry.*");
                ListManager.switchboard.tables.recordAPICall(post, "Blacklist_p.html", "configuration", "delete from blacklist '" + blacklistToUse + "': " + Arrays.toString(selectedBlacklistEntries));
                if (selectedBlacklistEntries.length > 0) {
                    String temp = null;
                    for (Object selectedBlacklistEntry : selectedBlacklistEntries) {
                        temp = BlacklistHelper.deleteBlacklistEntry(blacklistToUse, (String)selectedBlacklistEntry, header);
                        if (temp == null) continue;
                        prop.put("LOCATION", temp);
                        return prop;
                    }
                }
                Switchboard.urlBlacklist.clear();
                ListManager.reloadBlacklists();
            } else if (post.containsKey("addBlacklistEntry") || "addBlacklistEntry".equals(action)) {
                blacklistToUse = post.get("currentBlacklist", "").trim();
                String blentry = post.get("newEntry", "").trim();
                ListManager.switchboard.tables.recordAPICall(post, "Blacklist_p.html", "configuration", "add to blacklist '" + blacklistToUse + "': " + blentry);
                if (!BlacklistHelper.addBlacklistEntry(blacklistToUse, blentry)) {
                    prop.put("disabled_edit_addError", true);
                    prop.put("disabled_edit_addError_entry", blentry);
                }
                Switchboard.urlBlacklist.clear();
                ListManager.reloadBlacklists();
            } else if ("moveBlacklistEntry".equals(action)) {
                blacklistToUse = post.get("currentBlacklist", "").trim();
                String targetBlacklist = post.get("targetBlacklist");
                Object[] selectedBlacklistEntries = post.getAll("selectedEntry.*");
                ListManager.switchboard.tables.recordAPICall(post, "Blacklist_p.html", "configuration", "move from blacklist '" + blacklistToUse + "' to blacklist '" + targetBlacklist + "': " + Arrays.toString(selectedBlacklistEntries));
                if (selectedBlacklistEntries != null && selectedBlacklistEntries.length > 0 && targetBlacklist != null && blacklistToUse != null && !targetBlacklist.equals(blacklistToUse)) {
                    for (Object selectedBlacklistEntry : selectedBlacklistEntries) {
                        String temp = BlacklistHelper.deleteBlacklistEntry(blacklistToUse, (String)selectedBlacklistEntry, header);
                        if (temp != null) {
                            prop.put("LOCATION", temp);
                            return prop;
                        }
                        if (BlacklistHelper.addBlacklistEntry(targetBlacklist, (String)selectedBlacklistEntry)) continue;
                        prop.put("disabled_edit_moveError", true);
                        break;
                    }
                }
                Switchboard.urlBlacklist.clear();
                ListManager.reloadBlacklists();
            } else if ("editBlacklistEntry".equals(action)) {
                blacklistToUse = post.get("currentBlacklist", "").trim();
                Map<String, String> editedBlacklistEntries = post.getMatchingEntries("editedBlacklistEntry.*");
                if (editedBlacklistEntries.size() > 0) {
                    Map<String, String> selectedBlacklistEntries = post.getMatchingEntries("selectedBlacklistEntry.*");
                    if (selectedBlacklistEntries.size() != editedBlacklistEntries.size()) {
                        prop.put("LOCATION", "");
                        return prop;
                    }
                    String temp = null;
                    HashMap<String, Object> selected2EditedErrors = new HashMap<String, Object>();
                    for (Map.Entry<String, String> selectedEntry : selectedBlacklistEntries.entrySet()) {
                        String editedEntryValue = editedBlacklistEntries.get(selectedEntry.getKey().replace("selectedBlacklistEntry.", "editedBlacklistEntry."));
                        String string = Blacklist_p.prepareNormalizedEntry(editedEntryValue);
                        if (Blacklist_p.normalizeEntry(selectedEntry.getValue()).equals(string)) continue;
                        if (!BlacklistHelper.addBlacklistEntry(blacklistToUse, editedEntryValue)) {
                            selected2EditedErrors.put(selectedEntry.getValue(), editedEntryValue);
                            continue;
                        }
                        temp = BlacklistHelper.deleteBlacklistEntry(blacklistToUse, selectedEntry.getValue(), header);
                        if (temp == null) continue;
                        prop.put("LOCATION", temp);
                        return prop;
                    }
                    Switchboard.urlBlacklist.clear();
                    ListManager.reloadBlacklists();
                    if (selected2EditedErrors.isEmpty()) {
                        prop.putHTML("disabled_edit_currentBlacklist", blacklistToUse);
                    } else {
                        prop.put("disabled_edit_editError", true);
                        int maxDisplayedErrors = 10;
                        int i = 0;
                        for (Map.Entry entry2 : selected2EditedErrors.entrySet()) {
                            prop.put("disabled_edit_editList_" + i + "_item", CharacterCoding.unicode2html((String)entry2.getKey(), true));
                            prop.put("disabled_edit_editList_" + i + "_count", i);
                            if (i < 10) {
                                prop.put("disabled_edit_editError_list_" + i + "_item", CharacterCoding.unicode2html((String)entry2.getValue(), true));
                            }
                            ++i;
                        }
                        if (selected2EditedErrors.size() > 10) {
                            prop.put("disabled_edit_editError_hasMore", true);
                            prop.put("disabled_edit_editError_hasMore_more", selected2EditedErrors.size() - 10);
                        } else {
                            prop.put("disabled_edit_editError_hasMore", false);
                        }
                        prop.putHTML("disabled_edit_currentBlacklist", blacklistToUse);
                        prop.put("disabled_edit", "1");
                        prop.put("disabled_edit_editList", selected2EditedErrors.size());
                        prop.put("disabled_edit_editError_list", Math.min(10, selected2EditedErrors.size()));
                    }
                } else {
                    String[] selectedEntries = post.getAll("selectedEntry.*");
                    if (selectedEntries != null && selectedEntries.length > 0 && blacklistToUse != null) {
                        for (int i = 0; i < selectedEntries.length; ++i) {
                            prop.put("disabled_edit_editList_" + i + "_item", CharacterCoding.unicode2html(selectedEntries[i], true));
                            prop.put("disabled_edit_editList_" + i + "_count", i);
                        }
                        prop.putHTML("disabled_edit_currentBlacklist", blacklistToUse);
                        prop.put("disabled_edit", "1");
                        prop.put("disabled_edit_editList", selectedEntries.length);
                    }
                }
            } else if ("selectRange".equals(action)) {
                blacklistToUse = post.get("currentBlacklist");
            }
        }
        if (blacklistToUse == null && dirlist != null && !dirlist.isEmpty()) {
            blacklistToUse = dirlist.get(0);
        }
        if (blacklistToUse != null) {
            void var14_62;
            int entryCount = 0;
            String[] sortedlist = BlacklistHelper.blacklistToSortedArray(blacklistToUse);
            boolean dark = true;
            int offset = 0;
            int size = 50;
            int to = 50;
            if (post != null) {
                offset = post.getInt("offset", 0);
                size = post.getInt("size", 50);
                to = offset + size;
            }
            if (offset > sortedlist.length || offset < 0) {
                offset = 0;
            }
            if (to > sortedlist.length || size < 1) {
                to = sortedlist.length;
            }
            for (int j = offset; j < to; ++j) {
                String nextEntry = sortedlist[j];
                if (nextEntry.isEmpty() || nextEntry.charAt(0) == '#') continue;
                int n = nextEntry.indexOf(47, 0);
                if (n > 0) {
                    nextEntry = nextEntry.substring(0, n + 1) + MultiProtocolURL.unescapePath(nextEntry.substring(n + 1));
                }
                prop.put("disabled_edit_Itemlist_" + entryCount + "_dark", dark ? "1" : "0");
                dark = !dark;
                prop.put("disabled_edit_Itemlist_" + entryCount + "_item", CharacterCoding.unicode2html(nextEntry, true));
                prop.put("disabled_edit_Itemlist_" + entryCount + "_count", entryCount);
                ++entryCount;
            }
            prop.put("disabled_edit_Itemlist", entryCount);
            int[] navbar = new int[7];
            if (size > 0 && sortedlist.length > 0) {
                int start = offset - 3 * size;
                if (start < 0) {
                    start = 0;
                }
                for (entryCount = 0; entryCount < 7; ++entryCount) {
                    navbar[entryCount] = start > sortedlist.length ? -1 : start;
                    start += size;
                }
                navbar[0] = 0;
                if (navbar[6] < sortedlist.length - size) {
                    navbar[6] = sortedlist.length / size * size;
                }
            } else {
                navbar[0] = 0;
                navbar[1] = -1;
            }
            if (sortedlist.length > size && size > 0) {
                for (entryCount = 0; entryCount < 7 && navbar[entryCount] >= 0; ++entryCount) {
                    prop.put("disabled_edit_subListOffset_" + entryCount + "_fvalue", navbar[entryCount]);
                    int end = navbar[entryCount] + size - 1;
                    if (end > sortedlist.length) {
                        end = sortedlist.length;
                    }
                    prop.put("disabled_edit_subListOffset_" + entryCount + "_tvalue", end);
                    if (navbar[entryCount] != offset) continue;
                    prop.put("disabled_edit_subListOffset_" + entryCount + "_selected", 1L);
                }
            } else {
                prop.put("disabled_edit_subListOffset_0_fvalue", 1L);
                prop.put("disabled_edit_subListOffset_0_tvalue", sortedlist.length);
                prop.put("disabled_edit_subListOffset_" + entryCount + "_selected", 1L);
                ++entryCount;
            }
            prop.put("disabled_edit_subListOffset", entryCount);
            int[] sizes = new int[]{10, 25, 50, 100, 250, -1};
            boolean bl = false;
            while (var14_62 < sizes.length) {
                prop.put("disabled_edit_subListSize_" + (int)var14_62 + "_value", sizes[var14_62]);
                if (sizes[var14_62] == -1) {
                    prop.put("disabled_edit_subListSize_" + (int)var14_62 + "_text", "all");
                } else {
                    prop.put("disabled_edit_subListSize_" + (int)var14_62 + "_text", sizes[var14_62]);
                }
                if (sizes[var14_62] == size) {
                    prop.put("disabled_edit_subListSize_" + (int)var14_62 + "_selected", 1L);
                }
                ++var14_62;
            }
            prop.put("disabled_edit_subListSize", sizes.length);
        }
        int blacklistCount = 0;
        int blacklistMoveCount = 0;
        if (dirlist != null) {
            for (String element : dirlist) {
                prop.putXML("disabled_blackLists_" + blacklistCount + "_name", element);
                prop.put("disabled_blackLists_" + blacklistCount + "_selected", "0");
                if (element.equals(blacklistToUse)) {
                    prop.put("disabled_blackLists_" + blacklistCount + "_selected", "1");
                    for (int blTypes = 0; blTypes < Blacklist.BlacklistType.values().length; ++blTypes) {
                        prop.putXML("disabled_currentActiveFor_" + blTypes + "_blTypeName", Blacklist.BlacklistType.values()[blTypes].toString());
                        prop.put("disabled_currentActiveFor_" + blTypes + "_checked", ListManager.listSetContains((Object)((Object)Blacklist.BlacklistType.values()[blTypes]) + ".BlackLists", element) ? "0" : "1");
                    }
                    prop.put("disabled_currentActiveFor", Blacklist.BlacklistType.values().length);
                } else {
                    prop.putXML("disabled_edit_blackListsMove_" + blacklistMoveCount + "_name", element);
                    ++blacklistMoveCount;
                }
                if (ListManager.listSetContains(BLACKLIST_SHARED, element)) {
                    prop.put("disabled_blackLists_" + blacklistCount + "_shared", "1");
                } else {
                    prop.put("disabled_blackLists_" + blacklistCount + "_shared", "0");
                }
                int activeCount = 0;
                for (Blacklist.BlacklistType blacklistType : Blacklist.BlacklistType.values()) {
                    if (!ListManager.listSetContains((Object)((Object)blacklistType) + ".BlackLists", element)) continue;
                    prop.putHTML("disabled_blackLists_" + blacklistCount + "_active_" + activeCount + "_blTypeName", blacklistType.toString());
                    ++activeCount;
                }
                prop.put("disabled_blackLists_" + blacklistCount + "_active", activeCount);
                ++blacklistCount;
            }
        }
        prop.put("disabled_blackLists", blacklistCount);
        prop.put("disabled_edit_blackListsMove", blacklistMoveCount);
        prop.putXML("disabled_currentBlacklist", blacklistToUse == null ? "" : blacklistToUse);
        prop.putXML("disabled_edit_currentBlacklist", blacklistToUse == null ? "" : blacklistToUse);
        prop.put("disabled", blacklistToUse == null ? "1" : "0");
        return prop;
    }

    private static String prepareNormalizedEntry(String entry2) {
        return Blacklist_p.normalizeEntry(BlacklistHelper.prepareEntry(entry2));
    }

    private static String normalizeEntry(String entry2) {
        int slashPos = entry2.indexOf(47, 0);
        String host = entry2.substring(0, slashPos);
        try {
            host = Punycode.isBasic(host) ? host : MultiProtocolURL.toPunycode(host);
        }
        catch (Punycode.PunycodeException punycodeException) {
            // empty catch block
        }
        String path = MultiProtocolURL.escapePathPattern(entry2.substring(slashPos + 1));
        return host + "/" + path;
    }
}

