/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import net.yacy.cora.protocol.ConnectionInfo;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.search.Switchboard;
import net.yacy.server.serverAccessTracker;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.visualization.HexGridPlotter;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public class AccessPicture_p {
    private static int[] times = new int[]{60000, 50000, 40000, 30000, 20000, 10000, 1000};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RasterPlotter respond(RequestHeader header, serverObjects post, serverSwitch env) {
        int i;
        int h;
        int c;
        Switchboard sb = (Switchboard)env;
        String color_text = "AAAAAA";
        String color_back = "FFFFFF";
        String color_grid = "333333";
        String color_dot = "33CC33";
        String color_line = "555555";
        int width = 1024;
        int height = 576;
        int cellsize = 18;
        boolean corona = false;
        int coronaangle = 0;
        if (post != null) {
            width = post.getInt("width", 1024);
            height = post.getInt("height", 576);
            cellsize = post.getInt("cellsize", cellsize);
            color_text = post.get("colortext", color_text);
            color_back = post.get("colorback", color_back);
            color_grid = post.get("colorgrid", color_grid);
            color_dot = post.get("colordot", color_dot);
            color_line = post.get("colorline", color_line);
            corona = !post.containsKey("corona") || post.getBoolean("corona");
            int n = coronaangle = corona ? post.getInt("coronaangle", 0) : -1;
        }
        if (coronaangle < 0) {
            corona = false;
        }
        if (width < 32) {
            width = 32;
        }
        if (width > 10000) {
            width = 10000;
        }
        if (height < 24) {
            height = 24;
        }
        if (height > 10000) {
            height = 10000;
        }
        RasterPlotter.DrawMode drawMode = RasterPlotter.darkColor(color_back) ? RasterPlotter.DrawMode.MODE_ADD : RasterPlotter.DrawMode.MODE_SUB;
        HexGridPlotter picture = new HexGridPlotter(width, height, drawMode, color_back, cellsize);
        picture.drawGrid(color_grid);
        boolean gridLeft = false;
        int gridRight = picture.gridWidth() - 2;
        if ((gridRight & 1) == 0) {
            --gridRight;
        }
        int centerx = (picture.gridWidth() >> 1) - 1;
        int centery = picture.gridHeight() >> 1;
        long color_dot_l = Long.parseLong(color_dot, 16);
        long color_text_l = Long.parseLong(color_text, 16);
        long color_line_l = Long.parseLong(color_line, 16);
        long color_grid_l = Long.parseLong(color_grid, 16);
        picture.setColor(color_dot_l);
        picture.gridDot(centerx, centery, 5, true, 100);
        if (corona) {
            for (int i2 = 0; i2 < 6; ++i2) {
                picture.gridDot(centerx, centery, 50, i2 * 60 + coronaangle / 6, i2 * 60 + 30 + coronaangle / 6);
            }
        } else {
            picture.gridDot(centerx, centery, 50, false, 100);
        }
        picture.setColor(color_text_l);
        picture.gridPrint(centerx, centery, 5, "THIS YACY PEER", "\"" + sb.peers.myName().toUpperCase() + "\"", 0, 100);
        int verticalSlots = (picture.gridHeight() >> 1) - 1;
        String[] hosts = new String[verticalSlots];
        int[] time = new int[verticalSlots];
        int[] count = new int[verticalSlots];
        for (int i3 = 0; i3 < verticalSlots; ++i3) {
            hosts[i3] = null;
            time[i3] = 0;
            count[i3] = 0;
        }
        for (int time2 : times) {
            Iterator<String> i4 = serverAccessTracker.accessHosts();
            try {
                while (i4.hasNext()) {
                    String host = i4.next();
                    c = serverAccessTracker.latestAccessCount(host, time2);
                    if (c <= 0) continue;
                    h = Math.abs(host.hashCode()) % hosts.length;
                    hosts[h] = host;
                    count[h] = c;
                    time[h] = time2;
                }
            }
            catch (ConcurrentModificationException e) {
                ConcurrentLog.logException(e);
            }
        }
        for (i = 0; i < hosts.length; ++i) {
            if (hosts[i] == null) continue;
            picture.setColor(color_dot_l);
            picture.gridDot(0, i * 2 + 1, 7, false, 100);
            picture.gridDot(0, i * 2 + 1, 8, false, 100);
            picture.setColor(color_text_l);
            picture.gridPrint(0, i * 2 + 1, 8, hosts[i].toUpperCase(), "COUNT = " + count[i] + ", TIME > " + (time[i] >= 60000 ? time[i] / 60000 + " MINUTES" : time[i] / 1000 + " SECONDS"), -1, 100);
            if (corona) {
                picture.gridLine((centerx - 0) / 2 - 2, i * 2 + 1, 0, i * 2 + 1, color_line, 100, "AAAAAA", 100, 12, 11 - coronaangle / 30, 0, true);
                picture.gridLine(centerx, centery, (centerx - 0) / 2 - 2, i * 2 + 1, color_line, 100, "AAAAAA", 100, 12, 11 - coronaangle / 30, 0, true);
                continue;
            }
            picture.setColor(color_line_l);
            picture.gridLine(0, i * 2 + 1, (centerx - 0) / 2, i * 2 + 1);
            picture.gridLine(centerx, centery, (centerx - 0) / 2, i * 2 + 1);
        }
        for (i = 0; i < verticalSlots; ++i) {
            hosts[i] = null;
            time[i] = 0;
            count[i] = 0;
        }
        Set<ConnectionInfo> allConnections = ConnectionInfo.getAllConnections();
        c = 0;
        Set<ConnectionInfo> set = allConnections;
        synchronized (set) {
            for (ConnectionInfo conInfo : allConnections) {
                String host = conInfo.getTargetHost();
                h = Math.abs(host.hashCode()) % hosts.length;
                hosts[h] = host + " - " + conInfo.getCommand();
                count[h] = (int)conInfo.getUpbytes();
                time[h] = (int)conInfo.getLifetime();
            }
        }
        for (int i5 = 0; i5 < hosts.length; ++i5) {
            if (hosts[i5] == null) continue;
            picture.setColor(color_dot_l);
            picture.gridDot(gridRight, i5 * 2 + 1, 7, false, 100);
            picture.gridDot(gridRight, i5 * 2 + 1, 8, false, 100);
            picture.setColor(color_text_l);
            picture.gridPrint(gridRight, i5 * 2 + 1, 8, hosts[i5].toUpperCase(), count[i5] + " BYTES, " + time[i5] + " MS DUE", 1, 100);
            if (corona) {
                picture.gridLine(gridRight, i5 * 2 + 1, centerx + (gridRight - centerx) / 2 + 2, i5 * 2 + 1, color_line, 100, "AAAAAA", 100, 12, 11 - coronaangle / 30, 0, true);
                picture.gridLine(centerx, centery, centerx + (gridRight - centerx) / 2 + 2, i5 * 2 + 1, color_line, 100, "AAAAAA", 100, 12, coronaangle / 30, 0, true);
                continue;
            }
            picture.setColor(color_line_l);
            picture.gridLine(gridRight, i5 * 2 + 1, centerx + (gridRight - centerx) / 2, i5 * 2 + 1);
            picture.gridLine(centerx, centery, centerx + (gridRight - centerx) / 2, i5 * 2 + 1);
        }
        picture.setColor(color_text_l);
        PrintTool.print(picture, 2, 6, 0, "YACY NODE ACCESS GRID", -1, 100);
        PrintTool.print(picture, width - 2, 6, 0, "SNAPSHOT FROM " + new Date().toString().toUpperCase(), 1, 80);
        picture.setColor(color_grid_l);
        picture.gridLine(0, 0, centerx - 3, 0);
        picture.gridLine(0, 0, 0, picture.gridHeight() - 1);
        picture.gridLine(centerx - 3, 0, centerx - 3, picture.gridHeight() - 1);
        picture.setColor(color_dot_l);
        picture.gridLine(0, picture.gridHeight() - 1, centerx - 3, picture.gridHeight() - 1);
        picture.gridPrint(0, picture.gridHeight() - 1, 8, "", "INCOMING CONNECTIONS", -1, 80);
        picture.setColor(color_grid_l);
        picture.gridLine(centerx + 3, 0, gridRight, 0);
        picture.gridLine(centerx + 3, 0, centerx + 3, picture.gridHeight() - 1);
        picture.gridLine(gridRight, 0, gridRight, picture.gridHeight() - 1);
        picture.setColor(color_dot_l);
        picture.gridLine(centerx + 3, picture.gridHeight() - 1, gridRight, picture.gridHeight() - 1);
        picture.gridPrint(gridRight, picture.gridHeight() - 1, 8, "", "OUTGOING CONNECTIONS", 1, 80);
        return picture;
    }
}

