/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.gui.framework;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import javax.swing.text.JTextComponent;
import net.yacy.cora.util.ConcurrentLog;

public class Switchboard {
    private static boolean shallrun = true;
    private static Properties properties = new Properties();
    public static final ConcurrentLog log = new ConcurrentLog(Switchboard.class.getName());
    public static JTextComponent InfoBox = null;
    private static String InfoBoxMessage = "";
    private static long InfoBoxMessageUntil = 0L;

    public static void startInfoUpdater() {
        new InfoUpdater(2000L).start();
    }

    public static void addShutdownHook(Thread mainThread, Semaphore semaphore) {
        Runtime run = Runtime.getRuntime();
        run.addShutdownHook(new shutdownHookThread(mainThread, semaphore));
    }

    public static void info(String infoString, long infoTime) {
        InfoBoxMessage = infoString;
        InfoBoxMessageUntil = System.currentTimeMillis() + infoTime;
    }

    public static boolean shallrun() {
        return shallrun;
    }

    public static void shutdown() {
        if (InfoBox != null) {
            InfoBox.setText("waiting for shutdown process to complete ...");
        }
        shallrun = false;
    }

    public static void load(File propFile) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(propFile);
            properties.load(fis);
        }
        catch (FileNotFoundException e1) {
            log.info("error: file dispatcher.properties does not exist. Exit");
            System.exit(-1);
        }
        catch (IOException e1) {
            log.info("error: file dispatcher.properties cannot be readed. Exit");
            System.exit(-1);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    log.warn("Could not close input stream on file " + propFile);
                }
            }
        }
    }

    public static String get(String key) {
        return properties.getProperty(key);
    }

    public static String get(String key, String dflt) {
        return properties.getProperty(key, dflt);
    }

    public static int getInt(String key, int dflt) {
        if (!properties.containsKey(key)) {
            return dflt;
        }
        return Integer.parseInt(properties.getProperty(key));
    }

    public static boolean getBool(String key, boolean dflt) {
        if (!properties.containsKey(key)) {
            return dflt;
        }
        String s = properties.getProperty(key);
        return s.equals("true") || s.equals("1");
    }

    public static File getFile(String key) {
        String s = properties.getProperty(key);
        if (s == null) {
            return null;
        }
        return new File(s.replace("/", File.separator));
    }

    public static void set(String key, String value) {
        properties.setProperty(key, value);
    }

    public static void set(String key, int value) {
        properties.setProperty(key, Integer.toString(value));
    }

    public static void set(String key, boolean value) {
        properties.setProperty(key, value ? "true" : "false");
    }

    public static class shutdownHookThread
    extends Thread {
        private final Thread mainThread;
        private final Semaphore shutdownSemaphore;

        public shutdownHookThread(Thread mainThread, Semaphore semaphore) {
            super("Switchboard.shutdownHookThread");
            this.mainThread = mainThread;
            this.shutdownSemaphore = semaphore;
        }

        @Override
        public void run() {
            try {
                if (Switchboard.shallrun()) {
                    log.info("Shutdown via shutdown hook.");
                    log.info("Signaling shutdown to the switchboard.");
                    Switchboard.shutdown();
                    log.info("Waiting for GUI thread to finish.");
                    this.mainThread.interrupt();
                    if (this.mainThread.isAlive()) {
                        this.mainThread.join();
                    }
                    log.info("Waiting for main thread to finish. shutdownSemaphore.permits = " + this.shutdownSemaphore.availablePermits());
                    this.shutdownSemaphore.acquireUninterruptibly();
                    log.info("Shutdown Hook Terminated. Shutdown.");
                }
            }
            catch (Exception e) {
                log.info("Unexpected error. " + e.getClass().getName(), e);
            }
        }
    }

    public static class InfoUpdater
    extends Thread {
        long steptime;

        public InfoUpdater(long steptime) {
            super("Switchboard.InfoUpdater");
            this.steptime = steptime;
        }

        @Override
        public void run() {
            while (shallrun) {
                if (InfoBox != null && System.currentTimeMillis() < InfoBoxMessageUntil) {
                    InfoBox.setText(InfoBoxMessage);
                }
                try {
                    Thread.sleep(this.steptime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

