/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.gui.framework;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Properties;
import net.yacy.cora.util.ConcurrentLog;

public class Browser {
    public static final int systemMacOSC = 0;
    public static final int systemMacOSX = 1;
    public static final int systemUnix = 2;
    public static final int systemWindows = 3;
    public static final int systemUnknown = -1;
    public static final String blankTypeString = "____";
    public static final int systemOS;
    public static final boolean isMacArchitecture;
    public static final boolean isUnixFS;
    public static final boolean canExecUnix;
    public static final boolean isWindows;
    public static final boolean isWin32;
    public static int maxPathLength;

    public static void openBrowser(String url) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (IOException | URISyntaxException e) {
                Browser.openBrowserClassic(url);
            }
        } else {
            Browser.openBrowserClassic(url);
        }
    }

    public static void openBrowserClassic(String url) {
        block5: {
            try {
                if (systemOS == 1) {
                    Browser.openBrowserMac(url);
                    break block5;
                }
                if (systemOS == 2) {
                    Browser.openDefaultUnixBrowser(url);
                    break block5;
                }
                if (systemOS == 3) {
                    Browser.openBrowserWin(url);
                    break block5;
                }
                throw new RuntimeException("System unknown");
            }
            catch (Throwable e) {
                ConcurrentLog.warn("BROWSER", "Could not open browser : " + e.getMessage() != null ? e.getMessage() : e.toString());
            }
        }
    }

    private static void openBrowserMac(String url) throws Exception {
        Process p = Runtime.getRuntime().exec(new String[]{"/usr/bin/osascript", "-e", "open location \"" + url + "\""});
        p.waitFor();
        if (p.exitValue() != 0) {
            throw new RuntimeException("Mac Exec Error: " + Browser.errorResponse(p));
        }
    }

    private static void openDefaultUnixBrowser(String url) throws Exception {
        String cmd = "xdg-open " + url;
        Process p = Runtime.getRuntime().exec(cmd);
        p.waitFor();
        if (p.exitValue() != 0) {
            throw new RuntimeException("Unix Exec Error/xdg-open: " + Browser.errorResponse(p));
        }
    }

    private static void openBrowserWin(String url) throws Exception {
        String cmd = System.getProperty("os.name").contains("2000") ? "rundll32 url.dll,FileProtocolHandler " + url : "rundll32 url.dll,FileProtocolHandler \"" + url + "\"";
        Process p = Runtime.getRuntime().exec(cmd);
        p.waitFor();
        if (p.exitValue() != 0) {
            throw new RuntimeException("EXEC ERROR: " + Browser.errorResponse(p));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String errorResponse(Process p) {
        BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        String error = "";
        try {
            String line;
            while ((line = err.readLine()) != null) {
                error = line + "\n";
            }
            String string = error;
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            try {
                err.close();
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length > 0 && "-u".equals(args[0])) {
                Browser.openBrowser(args[1]);
            } else {
                System.out.println("Usage java " + Browser.class.getCanonicalName() + " -u [URL]");
            }
        }
        finally {
            ConcurrentLog.shutdown();
        }
        System.out.println("The End!");
    }

    static {
        maxPathLength = 65535;
        Properties sysprop = System.getProperties();
        String sysname = sysprop.getProperty("os.name", "").toLowerCase(Locale.ROOT);
        systemOS = sysname.startsWith("mac os x") ? 1 : (sysname.startsWith("mac os") ? 0 : (sysname.startsWith("windows") ? 3 : (sysname.startsWith("linux") || sysname.startsWith("unix") ? 2 : -1)));
        isMacArchitecture = systemOS == 0 || systemOS == 1;
        isUnixFS = systemOS == 1 || systemOS == 2;
        canExecUnix = isUnixFS || systemOS != 0 && systemOS != 3;
        isWindows = systemOS == 3;
        isWin32 = isWindows && System.getProperty("os.arch", "").contains("x86");
        maxPathLength = isWindows ? 255 : 65535;
    }
}

